#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL,
  `event_notification_message` text NOT NULL,
  `show_onwebsite` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `alumni_events_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `alumni_events_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `current_email` varchar(255) NOT NULL,
  `current_phone` varchar(255) NOT NULL,
  `occupation` text NOT NULL,
  `address` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `alumni_students_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `for_qr_attendance` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'present', 'label label-success', 'yes', 1, '2023-12-13 02:53:10', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'late_with_excuse', 'label label-warning text-dark', 'no', 0, '2023-12-13 02:51:03', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'late', 'label label-warning text-dark', 'yes', 1, '2023-12-13 02:51:09', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'absent', 'label label-danger', 'yes', 0, '2023-12-15 01:18:05', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'holiday', 'label label-info', 'yes', 0, '2023-12-14 07:57:13', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'half_day', 'label label-warning text-dark', 'yes', 1, '2023-12-15 01:18:37', '0000-00-00');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_id` int(11) NOT NULL,
  `member_id` int(11) DEFAULT NULL,
  `duereturn_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT 0,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `book_id` (`book_id`),
  KEY `member_id` (`member_id`),
  CONSTRAINT `book_issues_ibfk_1` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_ibfk_2` FOREIGN KEY (`member_id`) REFERENCES `libarary_members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=435 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'FUNDAMENTALS OF ENVIRONMENTAL CHEMISTRY', '0001', '978-1-4200-5267-1', 'Chemistry ', '', 'CRC Press', 'STANLEY E.MANAHAN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 02:42:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'WORD BOOK', '0002', '978-0-7166-0108-1', 'HISTORY ', '', 'WORLD BOOK ENCYCLOPEDIA', 'World book', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:17:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'PHILOSOPHY OF HISTORY', '0003', '81-307-0686', '', '', 'COSMOS PUBLICATIONS', 'GENESIS PUBLISHING PVT.LMD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:16:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'HEALTH EDUCATION $ BEHAVIOR', '1000', '1090-1981', 'HEALTH EDUCATION $ BEHAVIOR ', '', 'AN OFFICIAL PUBLISHER OF THE SOCIETY FOR PUBLIC HEALTH EDUCATION ', 'JOHN P.ALLEGRANTE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 03:48:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'THE CAMBRIDGE ENCYCLOPEDIA OF LANGUAGE', '1001', '978-0-521-51698-3', 'THE CAMBRIDGE ENCYCLOPEDIA OF LANGUAGE ', '', 'CAMBRIDGE UNIVERSITY PRESS ', 'DAVID CRYSTAL ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:16:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'COMPUTER NETWORK', '0004', '0-13-038488-7', 'COMPUTER', '', '', 'ANDREW S.TANENBAUM', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:15:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'MECHANICS OF MATERIALS', '0005', '13:978-1-111-13603-1', 'MECHANICS', '', 'GLOBAL ENGENEERING', 'JAMES M. GERE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:21:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'WORLD OF MUSIC', '1002', '0-382-18279-0', 'WORLD OF MUSIC ', '', 'SILVER BURDETT $ GINN', 'JANE BEETHOVEN ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:23:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'LIVINGSTONE AND THE EXPLORATION OF CENTRAL AFRICA', '0006', '978-1-44372-024-3', 'HISTORY', '', 'DAVID LIVINGSTONE', 'SIR H,H JOHNSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:25:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'NETWORKING COMPLETE', '0007', '81-7656-715-9', 'COMPUTER', '', 'BPB PUBLICATION', 'BPB PUBLICATIONS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:31:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'PEOPLE RAISING', '0008', '0-8024-6447-5', 'PRACTICAL GUIDE TO RAISING SUPPORT', '', 'MOODY PRESS CHICAGO', 'WILLIAM P DILLON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:38:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'CULTIVATING FREUD\'S GARDEN IN FRANCE', '1003', 'O-87668-995-O', 'CULTIVATING FREUD\'S GARDEN IN FRANCE', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'MARION MICHEL OLINER,PH.D', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:47:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'INFORMATION SYSTEMS DEVELOPMENT', '0009', '0-07-711417-5', 'MCGRAW-HILL EDUCATION(UK)', '', '', 'DAVID AVISON & GUY FITGERALD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:50:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'MATHEMATICS', '0010', '0-382-37005-8', 'MATHEMATICS', '', 'SILVER BURDETT GINN', 'FRANCIS FENNELL (PHD)', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:54:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'THE COUNSELLING PROCESS', '1004', '978-0-534-64032-3', 'THE COUNSELLING PROCESS', '', 'THOMSON BROOKS/COLE', 'ELIZABETH REYNOLDS WELFEL', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:55:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'THE PROJECT MANAGEMENT TOOL KIT', '0011', '978-81-203-3556-1', 'TIPS AND TECHNIQUES FOR GETTING JOBS', '', 'PRENTICE HALL OF INDIA', 'KENDRICK', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:59:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'COUNSELING ADULTS', '1005', 'O-8185-0502-8', 'COUNSELING ADULTS', '', 'BROOKS/COLE PUBLISHING COMPANY', 'WILLIAM H.VAN HOOSE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:01:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'COUNSELING DIVERSE POPULATIONS', '1006', '0-697-36185-3', 'COUNSELING DIVERSE POPULATION', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DONALD R.ATKINSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:07:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'THE PFEIFFER BOOK OF SUCCESSFUL CONFLICT MANAGEMENT TOOLS', '0012', '978-0-4701-9344-0-9000', 'PRESENTATION AND DISCUSSION RESOURCES', '', 'JOSSEY-BASS/PFEIFFER', 'JACK GORDON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:08:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'FUNDAMENTALS OF SOCIAL RESEARCH', '0013', '9966-9802-1-0', 'RESEARCH', '', 'EUREKA PUBLISHERS', 'MUTEA RUKWARU', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:10:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'A DICTIONARY OF ECONOMICS AND COMMERCE', '0014', '0-7121 06499', 'COMMERCE', '', 'PITMAN', 'J. L. HANSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:14:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'MANAGEMENT THEORY AND PRACTICE', '1007', '978-1-84480-095-7', 'MANAGEMENT THEORY AND PRACTICE', '', 'BOOK POWER/ELST', 'GERALD COLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:14:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'CHILD RIGHTS AND CHILD PROTECTION', '0015', '996636155-3', 'CHILD RIGHTS', '', 'LONGHORN', 'CATHERINE GICHUBA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:17:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'SYSTEM THEORY AND MANAGEMENT INFORMATION SYSTEMS SIMPLIFIED', '1008', '9966-28-886-4', 'COMPUTER SYSTEMS', '', 'SALEEMI PUBLICATIONS LTD', 'NISAR AHMAD SALEEMI', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:21:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'FUNDAMENTALS OF CORPORATE FINANCE', '1009', '13:978-0-07-299121-5', 'FINANCE', '', 'STEPHEN M.PATTERSON', 'STEPHEN A.ROSS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:29:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'SENSE AND NONSENSE ABOUT CRIME', '0016', '0-534-09120-2', 'A POLICY GUIDE', '', 'BROOKS/COLE PUBLISHING COMPANY', 'SAMUEL WALKER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:44:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'PERSONEL AND HUMAN RESOURCE MANAGEMENT', '0017', '978-0-82646-128-5', 'HUMAN RESOURCE MANAGEMENT', '', 'BOOK POWER', 'G.A COLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:44:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'COFFEE WITH PLEASURE', '1010', '1-55164-190-9', 'JUST JAVA AND WORLD TRADE', '', 'BLACK ROSE BOOKS', 'LAURE WARIDEL', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:48:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'MATHEMATICS', '0018', '0-395-53015-6', 'MATHEMATICS', '', 'HOUGHTON MIFFLIN', 'LELON R. CAPPS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:49:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CELEBRATE STORIES OF JEWISH HOLIDAYS', '0019', '0-439-43052-6', 'RELIGION', '', 'PETER CATALANOTTO', 'GILDA BERGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:53:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'MANAGERIAL ACCOUNTING', '1011', '978-0-470-33334-1', 'ACCOUNTING', '', 'WILEY PLUS', 'JAMES JIAMBALVO', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:55:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'MARKETING MANAGEMENT TEST AND CASES', '1012', '9-814-12621-7', 'MARKETING', '', 'JOHN WILEY AND SONS', 'DOUGLAS J.DALRYMPLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:59:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'STOLEN THUNDER', '0020', '0- 395-64368-6', 'NOVEL', '', 'HOUGHTON MIFFLIN COMPANY', 'SHIRLEY CLIMO', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:01:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'MICROECONOMICS', '1013', '0-07-2872207-1', 'BUSINESS', '', 'GARY BURKE', 'PAUL A.SAMUELSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:03:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'PUBLIC FINANCE', '0021', '978-93-259-6000-8', 'FINANCE', '', 'VIKAS PUBLISHING HOUSE PVT LTD', 'H L BHATIA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:04:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'EFFECTIVE SMALL BUSINESS MANAGEMENT', '0022', '978-0-13-615270-5', 'ENTERPRENUERSHIP', '', 'PEARSON EDUCATION LTD', 'NORMAN M. SCARBOROUGH', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:09:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'OPERATIONAL PROFITABILITY', '1014', '0-471-21473-6', 'BUSINESS', '', 'JOHN WILEY$ SONS,INC', 'ROBERT M.TOROK', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:09:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'STATE OF THE WORLD', '0023', '0-393-02638-8', 'HISTORY', '', 'WORLDWATCH INSTITUTE', 'LESTER R. BROWN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:12:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'MANAGING CASH FLOW', '0024', '0-471-22809-5', 'BUSINESS', '', 'JOHN WILEY &SONS', 'ROB REIDER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:14:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'UNDERSTANDING ECONOMICS', '1015', '0-676-39629-1', 'BUSINESS', '', 'RANDOM HOUSE,INC', 'DR. ALLEN W. SMITH ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:16:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'FIVE LITTLE PENGUINS SLIPPING ON THE ICE', '1016', '0-439-46577-X', 'NOVEL', '', 'SCHOLASTIC INC', 'STEVE METZGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:22:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'PSYCHOLOGY ANDROGYNY FURTHER CONSIDERATION', '0025', '0-87705--418-5', 'PSYCHOLOGY PERSONALITIES', '', 'HUMAN SCIENCES PRESS  ', 'GEORGIA BABLADELIS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:22:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'CHILDHOOD IN CONTEMPORARY', '0026', '26500 00000', 'NOVEL', '', 'GREGORY BATESON', 'MARGARET MEAD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:27:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'A GUIDE TO ACADEMIC WRITING', '1017', '9966-9925-0-2', 'A GUIDE TO ACADEMIC WRITING', '', 'ZAPF CHANCERY', 'C.B. PETER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:29:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'UNIVERSITY ECONOMICS', '0027', '', 'ECONOMICS', '', 'SOUTH ATLANTIC QUARTERLY', 'ARMEN A. ALCHIAN67-15730', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:32:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'ECONOMICS', '1018', '0-395-355526-6', 'BUSINESS', '', 'HOUGHTON MIFFLIN COMPANY BOSTON', 'RICHARD B. MCKENZIE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:34:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'INFORMATION TECHNOLOGY PROJECT MANAGEMENT', '0028', '978-1-133-62722-7', 'INFORMATION TECHNOLOGY', '', 'WWW.CENGAGE.COM', 'KATHY SCHWALBE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:40:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'STRATEGIC MANAGEMENT COMPETITIVENESS AND GLOBALIZATION', '1019', '0-324-11482-6', 'BUSINESS', '', 'THOMSON SOUTH-WESTERN', 'MICHAEL A. HITT', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:39:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'MICROSOFT EXCEL 2003', '0029', '0-07-283418-8', 'INFORMATION TECHNOLOGY', '', 'BRANDON NPRDIN', 'GLEN J. COULTHARD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:40:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'EVERETT ANDERSON 1.2.3', '1020', '0-8050-2310-0', 'NOVEL', '', 'HENRY HOLT AND COMPANY,INC', 'LUCILLE CLIFTON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:43:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'ENGLISH AT HAND', '1021', '0-944210-25-2', 'ENGLISH AT HAND', '', 'TOWNSEND PRESS', 'CHISTOPHER G. HAYES', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:48:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'IS THIS A HOUSE FOR HERMIT CRAB?', '0030', '0-395-73219-0', 'NOVEL', '', 'HOUGHTON MIFFLIN', 'MEGAN MC DONALD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:50:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'BLAST OFF', '0031', '0-7836 1676-7', 'NOVEL', '', 'BUCKLE DOWN PUBLISHING COMPANY', 'ROBERT LOUIS STEVENSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:54:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'HAR COURT', '0032', '0-15-306401-3', 'NOVEL', '', 'SEA HARBOR DRIVE', 'RICHARD F. ABRAHAMSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:59:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'GRADUATE SCHOOL GUIDE', '0033', '0-910635-39-0', 'GUIDE OF DOCTORAL,MASTERS,PROFESSIONALS DEGREES', '', 'MYLES RIDDER', 'MARI CASTROVILLA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:05:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'MIRROR MASK', '1022', '0-7475-8111-8', 'NOVEL', '', 'HARPER COLLINS PUBLISHERS', 'NEIL GAIMAN $ DAVE MCKEAN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:11:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'HOW THE EARTH WORKS', '0034', '0-89577-411-9', 'NOVEL', '', 'JOHN FARDON', 'READERS DIGEST', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:17:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'CELEBRATE STORIES OF THE JEWISH HOLIDAYS', '0035', '0-439-43052-6', 'RELIGION', '', 'MARIJKA', 'GILDA BERGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:21:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'SIX DINNER SID', '0036', '0-671-79613-5', 'NOVEL', '', 'SIMON & SCHUSTER INC', 'INGA MOORE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:24:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'MANAGEMENT A COMPETENCE-BASED APPROACH', '0037', '81-315-0204', 'COMMUNICATION', '', 'THOMSON SOUTH--WESTERN', 'HELLRIEGEL JACKSON SLOCUM', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:27:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'KENYA\'S ETHIC COMMUNITIES FOUNDATION OF THE NATION', '0038', '9966-97570-5', 'HISTORY', '', 'GATUNDU', 'WANNGUHU NGANGA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:40:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'AN INTRODUCTION OF PHONOLOGY', '0039', '0-582-29150-X', 'PHONOLOGY', '', 'LONGMAN', 'FRANCIS KATAMBA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:44:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'SHAKESPEAR LIVES', '0040', '13: 978-0-7607-7932-3', '', '', 'BARNES &NOBLE', 'S.SCHOENBAUM', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:46:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'FOUNDATION OF FINANCIAL MARKETS AND INSTITUTON', '0041', '978-81-317-0390-8', 'BUSSINESS', '', 'PEARSON EDUCATION & DORSING KINDERSLEY', 'FRANK J. FABOZZI', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:50:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'THE REAL WARN ON CRIME', '0042', '0-06-095165-6', 'NOVEL', '', 'HARPERCOLLINS PUBLISHERS', 'STEVEN R. DONZIGER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:53:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'DISABILITY DISCOURSE', '0043', '0-335-20222-5', 'NOVEL', '', 'BUCKINGHAM', 'MAIRIAN CORKER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:56:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'THE SOCIAL PSYCOLOGY OF DRUGS', '0044', '0-335-20618-2', 'NOVEL', '', 'RICHARD P. BAGOZZI', 'STEVE SUSSMAN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:04:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'MILLER ECONOMICS TODAY', '0045', '0-06-044494-0', 'ECONOMICS', '', 'HARPER,ROW,PUBLISHER,NEW YORK', 'DAVID FORGIONE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:11:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'STRATEGIC MANAGEMENT CONCEPTS,DECISONS,CASES', '0046', '0-256-03256-4', 'BUSSINESS', '', 'BUSINESS PUBLICATIONS', 'LESTER A. DIGMAN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:21:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'ENGLISH LANGUAGE TEACHING IN KENYA POLICY,TRAINING AND PRACTICE', '1023', '9966-854-40-1', 'LANGUAGE', '', 'MOI UNIVERSITY PRESS', 'PETER L.BARASA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:22:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'MICROECONOMICS', '0047', '13: 978-13-139263-2', 'ECONOMICS', '', 'COPYRIGHT', 'JEFFREY M.PERLOFF', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:25:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'TEACH ENGLISH', '1024', '0-521-49860-0', 'LANGUAGE', '', 'CAMBRIDGE UNIVERSITY PRESS', 'ADRIAN DOFF', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:25:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'TIMEWARP STORIES', '1025', '0-19-2781898', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'DENNIS PEPPER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:29:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'QUANTITATIVE METHODS FOR BUSINESS', '0048', '978-81-315-0308-9', 'BUSINESS', '', 'CENGAGE LEARNING PRODUCTS', 'DAVID R. ANDERSON', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:30:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'INSTRUCTIONAL LEADERSHIP', '1026', '0-205-35497-1', 'TEACHING', '', 'A PEARSON EDUCATION COMPANY', 'ANITA WOOLFOLK HOY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:32:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'BUSINESS STUDIES FOR SECONDARY SCHOOLS', '0049', '996625395-5', 'BUSINESS', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS LTD', 'GETTY WEKESA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:33:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'WRITE ON TARGET', '1027', '1-884183-39-5', 'NOVEL', '', 'ENGLEFIELD AND ARNOLD', 'YOLANDE F.GRIZINSKI,ED.D', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:36:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'INTRODUCTION TO INFORMATION SYSTEMS', '0050', '81-265-0866-3', 'COMPUER', '', 'COPYRIGHT 2007', 'R. KELLY RAINER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:37:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'BUILDING VOCABULARY SKILLS', '1028', '0-944210-12-0', 'BUILDING', '', 'TOWNSEND PRESS', 'SHERRIE L .NIST', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:39:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'THE WAR ON DRUGS', '0051', '0-87484-743-5', 'NOVEL', '', 'MAYFIELD COMPANY', 'DR. DAVE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:40:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'ADVANCING VOCABULARY SKILLS', '1029', '0-944210-14-7', 'LANGUANGE', '', 'TOWNSEND PRESS', 'SHERRIE L . NIST', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:42:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'THE PROFESSIONAL GEOGRAPHER', '0052', '0033-0124', 'NOVEL', '', 'DAVID ALEXANDER', 'JANET FRANKLIN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:42:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'ADVANCING VOCABULARY SKILLS', '1030', '0-944210-14-7', 'LANGUAGE', '', 'TOWNSEND PRESS', 'CAROLE MOHR', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:47:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'THE PROJECT PROPOSAL WRITING HANDBOOK', '0053', '9789966008510', 'PROJECT HAND BOOK', '', 'REPARED PUBLISHING DEPARTMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:49:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'STAYING SANE WHEN YOUR FAMILY COMES TO VISIT', '1031', '0-7382-1036-6', 'NOVEL', '', 'DA CAPO PRESS', 'PAM BRODOWSKY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:50:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'PRINCIPLES OF ECONOMICS', '1032', '978-0-07-128542', 'BUSINESS', '', 'MCGRAW-HILL', 'ROBERT H. FRANK', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:53:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'ESSENTIAL OF DEVELOPMENT PLANNING', '0054', '9966 47 165 0', 'GUIDE BOOK', '', 'PHOENIX PUBLISHED LTD', 'MOSES J. WEKESA ', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:54:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'FAMILY', '0055', '13: 978-0-7377-3742-2', 'FAMILY', '', 'ELIZABETH DES CHENES ', 'KAREN MILLER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:56:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'ACCOUNTING INFORMATION SYSTEMS', '1033', '978-0-07-122052-1', 'BUSINESS', '', 'MCGRAW-HILL', 'DR. ROBERT L.HURT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:58:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'MACROECONOMICS', '0056', '0-395-35527-3', 'ECONOMICS', '', 'HOUGHTON MIFFLIN COMPANY', 'FRANK STELLA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:00:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'ECONOMICS FOR EASTERN AFRICA', '1034', '0-05-97400-9', 'ECONOMICS', '', 'HEINEMANN', 'IAN LIVINGSTONE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:02:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'CORPORATE STRATEGY', '1035', '978-0-07-111107-2', 'BUSINESS', '', 'MCGRAW-HILL', 'DAVID J.COLLIS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:10:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'AMERICAN VIOLENCE$ PUBLIC POLICY', '1036', '0-300-03231-5', 'NOVEL', '', 'YALE UNIVERSITY PRESS', 'LYNN A.CURTIS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:13:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'DOING YOUR EARLY YEARS RESEARCH PROJECTS', '1037', '13:978-1-84920-520-7', 'RESEARCH', '', 'SAGE PUBLICATIONS', 'GUY ROBERTS-HOLMES', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:18:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'PRINCIPLES OF ECONOMICS', '0057', '978-0-07-17', 'ECONOMICS', '', 'FORDHAM UNIVERSITY', 'DOMINIC SALVATORE PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 07:57:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'HITT IRELAND HOSKISSON', '0058', '0-324-11482-6', 'ENTEPRENUERSHIP', '', 'COPYRIGHT BY SOUTH WESTERN THOMSON', 'MICHAEL A. HITT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:00:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'GUIDELINES FOR PREPARING PROPOSAL', '0059', '0-8191-3734-0', 'PROPOSAL GUIDE', '', 'UNIVERSITY PRESS OF AMERICA', 'JOHN H. BEHLING, PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:04:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'IMPROVING PERFORMANCE AND COMMITMENT IN THE WORKPLACE', '0060', '978-0-07-131811-2', 'ORGANIZATIONAL BEHAVIOR', '', 'MCGRAW-HILL/IRWIN', 'JASON A. CCOLQUIT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:07:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'MICROECONOMICS', '0061', '0-201-08048-6', 'ECONOMICS', '', 'WESLEY PUBLISHING COMPANY', 'ALLEN R. THOMPSON', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:13:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'PROJECT INFORMATION MANAGEMENT SYSTEM', '0062', '978-9966-21-395-2', 'PROJECT MANAGEMENT', '', 'PSI CONSULTANTS', 'GITONGA B. A.', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:15:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'MGMT', '0063', '13: 978-1-111-22131-7', 'MANAGEMENT', '', 'SOUTH-WESTERN,CENGAGE', 'CHUCK WILLIAMS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:18:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'CHILD DEVELOPMENT', '0064', '9966-01-045-0', 'NOVEL', '', 'FOCUS PUBLISHERS LTD', 'MARGARET KABIRU', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:30:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'NATIONAL DATA COLLECTION ON POLICE USE OF FORCE', '0065', '703-684-5300', 'NATIONAL DATA COLLECTION ON POLICE USE OF FORCE ', '', 'U.S DEPARTMEMT OF JUSTICE', 'JAN CHAIKEN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:33:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'DANGER DUTY AND DISILLUSION', 'OO66', '1-57766-041', 'NOVEL', '', 'WAVELAND PRESS, INC', 'JOAN C. BARKER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:35:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'PSYCHOLOGY OF CRIME & CRIMINAL JUSTICE', '0067', '0-88133-228-3', 'PSCHOLOGY OF CRIME AND CRIMINAL JUSTICE', '', 'WAVELAND PRESS', 'HANS TOCH', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:38:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'THE PRACTICE OF GROUP WORK', '0068', '0-231-03243-9', 'NOVEL', '', 'COLUMBIA UNIVERSITY PRESS', 'SERAPIO R. ZALBA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:40:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'NEW HELP FOR THE WOMAN', '0069', '0-553-34860-4', 'NOVEL', '', 'UNITED STATES AND CANADA', 'JEAN KIRKPATRICK, PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:43:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'RESILIENCY', '0070', '0-87101-350-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN -PUBLICATION DATA', 'ROBERTA R. GREENE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:47:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'PROPHET OF DEATH', '0071', '0-688-10584-X', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-N-PUBLICATION DATA', 'PETE EARLEY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:50:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'JUVENILE DELINQUENCY', '0072', '0-13-514431-0', 'MEASURING DELINQUENCY', '', 'PRENTICE-HALL', 'CURT R. BARTOL', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:47:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'PROJECT MANAGEMENT BOOK', '0073', '13:978-1-59869-635-6', 'PROJECT MANAGEMENT', '', 'F+W PUBLICATIONS', 'RICK A. MORRIS, PMP', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:54:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'CASES IN FINANCIAL MNAGEMENT', '0074', '13: 978-0-463805-7', 'FINANCIAL ACCOUNTING', '', 'TATA MCGRAW-HILL PUBLISHING COMPANY LTD', 'RAMESH BHAT', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:57:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'MICROECONOMICS', '0075', '0-07-254936-X', 'ECONOMICS', '', 'MCGRAW-HILL/IRWIN', 'DAVID C. COLANDER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:59:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'HEART TO HEART CARE GIVING', '0076', '0-934140-59-6', 'NOVEL', '', 'REDLEAF PRESS', 'E SANDY POWEL ', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 01:04:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'NEW VENTURE CREATION', '0077', '13: 978-0-538-48197-7', 'ENTERPRENEUR', '', 'SOUTH-WESTERN, CENGAGE LEARNING', 'KATHLEEN R. ALLEN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:47:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'ORGANIZATIONAL BEHAVIOR', '0078', '0-07-293147-7', 'HISTORY', '', 'MCGRAW-HILL/IRWIN', 'MARY ANN VON GLINOW', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:50:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'JUVENILE DELINGUENCE', '0079', '13: 978-0-298731-8', 'JUVENILE DELINGUENCE', '', 'PEARSON EDUCATION LTD', 'CLEMENS BARTOLLAS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:55:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'COMPLETE JOB-SEARCH HANDBOOK', '0080', '0-8050-0525-0', 'NOVEL', '', 'HOWARD FIGLER', 'HENRY HORT AND COMPANY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:58:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'PURCHASING SUPPLY MANAGEMENT', '0081', '13: 978-0-07-070660-6', 'SUPPLY CHAIN', '', 'TATA MSCGAW HILL EDUCATION PRIVATE', 'HAROLD E FEARON, PHD, CPM', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:01:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'THE PHYSICAL UNIVERSE', '0082', '13: 978-0-07-250979-3', 'PHYSICAL UNIVERSE', '', 'THE MCGRAW-HILL COMPANIES', 'ARTHUR BEISER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:04:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'CORPORATE FINANCE', '0083', '0-07-255592-0', 'FINANCE', '', 'MCGRAW-HILL HIGHER EDUCATION', 'STEPHEN A. ROSS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:12:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'WOMEN A FEMINIST PERSPECTIVE', '0084', '0-87484-422-3', 'NOVEL', '', 'MAYFIELD PUBLISHING COMPANY  ', 'JO FREEMAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:20:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'POLICE TECHOLOGY', '0085', '0-13-114957-1', 'POLICE TECHOLOGY', '', 'PEARSON HALL', 'RAYMOND E. FOSTER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:22:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'MIND IN THE MAKING', '0086', '978-0-06-173232-4', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ELLEN GALINSKY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:26:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'INTRODUCTIORY MICROECONOMICS', '0087', '0-87626-661-8', 'ECONOMICS', '', 'WINTHROP PUBLISHERS,INC', 'LAWRENCE G, HINES', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:29:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'ESSENTIALS OF ENTREPRENEURSHIP AND SMALL BUSINESS MANAGEMENT', '0088', '10 0-273-77873-7', 'ENTREPRENUERSHIP', '', 'PEARSON HORIZON EDITIONS', 'NORMAN M. SCARBOROUGH', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:34:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'GREEN INFRASTRUCTURE', '0089', '1-55963-558-4', 'AGRICUTURE', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'MARK A. BENNEDICT', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:38:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'BUSSINESS FINANCE SIMPLIFIED', '0090', '9966-28-814-7', 'FINANCE', '', 'SALEEMI PUBLICATION LTD', 'N.A.SALEEMI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:45:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'RETHINKING CRIME DEVIANCE THEORY', '0091', '0-86598-073', 'RETHINKING CRIME DEVIANCE THEORY', '', 'ROWMAN &ALLANHELD PUBLISHERS', 'FRANCIS T. CULLEN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:51:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'GENDERED JUSTICE', '0092', '978-0-7425-6644-6', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'VENESSA GARCIAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:55:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'BE YOUR OWN STRATEGY CONSULTSANT', '0093', '10: 1-86152-980-5', 'NOVEL', '', 'BRITISH LIBRARY CATALOGUING-IN-PUBLISHING', 'GRUNDY&BROWN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:06:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'POVERTY', '0094', '13: 978-0-7377-3747-9', 'NOVEL', '', 'CHRISTINE NASSO PUBLISHER', 'VIQI WAGNER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:06:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'MANAGING STRATEGIC CHANGE', '0095', '0-471-86559-1', 'NOVEL', '', 'JOHN WILEY &SONS, INC', 'NOEL M. TICHY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:12:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'TAKINGSIDES', '0096', '0-697-39144-2', 'NOVEL', '', 'THE MCGRAW COMPANIES', 'M.ETHAN KATSH', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:16:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'MANAGEMENT ORGANISATIONAL BEHAVIOR', '0097', '978-0-273-72408-7', 'MANAGEMENT ORGANISATIONAL BEHAVIOR', '', 'PRENTICE HALL', 'LAURIE J. MULLINS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:19:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'MARKETING MANAGEMENT', '0098', '13:978-0-13-135797-6', 'MARKETING', '', 'PEARSON PRENTICE HALL', 'PHILIP KOTLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:24:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'PRINCIPLES OF INSURANCE: LIFE HEALTH AND ANNUITIES', '0099', '1-57974-275-0', 'PRINCIPLES OF INSURANCE: LIFE HEALTH AND ANNUITIES', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'HARRIETT E JONES', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:27:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'PRINCIPLES OF AUDITING', '0100', '0-256-02568-1', 'PRINCIPLES OF AUDITING', '', 'LIBRARY OF CONGRESS CATALOG CARD', 'WATER B. MEIGS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:37:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'NATURAL HAZARDS, UNNATURAL DISASTERS', '0101', '978-0-8213-8050', 'NATURAL HAZARDS, UNNATURAL DISASTERS', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'KENNETH J. ARROW', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:42:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'SUPPLY CHAIN DEVELOPMENT FOR THE LEAN ENTERPRISE', '0102', '1-56327-218-0', 'SUPPLY CHAIN', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ROBIN COOPER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:46:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'MICROECONOMICS', '0103', '0-07-287561-5', 'ECONOMICS', '', 'MCGRAW-HILL IRWIN', 'STANELY L. BRUE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:50:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'ACCOUNTING FOR GOVERNMENT & NONPROFIT ENTITIES', '0104', '13: 978-0-07-310095-1', 'ACCOUNTING', '', 'MCGRAW-HILL HIGHER EDUCATION', 'EARL R. WILSON, PHD.CPA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:57:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'QUANTITAVE METHODS FOR INVESTMENT ANALYSIS', '0105', '0-935015-69-8', 'QUANTITAVE METHODS FOR INVESTMENT ANALYSIS', '', 'AIMR PUBLICATIONS', 'RICHAR A. DEFUSCO CFA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:06:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'A GUIDE TO ACADEMIC WRITING', '0106', '9966-9925-02', 'A GUIDE TO ACADEMIC WRITING ', '', 'ZAPF CHACERY', 'C.B. PETER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:14:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'PATTERNS REFLECTIONS', '0107', '0-205-26715-7', 'NOVEL', '', 'MACMILLAN PUBLISHING COMPANY', 'DOROTHY U. SEYLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:19:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'STRAGEGIC PLANNING', '0109', '13: 978-9-966201-22-5', 'STRAGEGIC PLANNING', '', 'EVANGEL PUBLISHING HOUSE', 'GUY S. SAFFOLD', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:24:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'GOVERNMENT AND NOT-FOR-PROFIT ACCOUNTING', '1038', '0-471-23009-X', 'ACCOUNTING', '', 'JOHN WILEY$SONS,INC', 'MICHAEL H .GRANOF', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:27:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'VICTIMOLOGY', '1039', '0-13-437286-7', 'CRIME ', '', 'PEARSON EDUCAION', 'JUDITH M SGARZI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:29:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'THE PSYCHOLOGY OF CRIMINAL CONDUCT', '1040', '0-87084-712-0', 'PSYCHOLOGY', '', 'ARDESON PUBLISHING', 'D. A. ANDREWS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:33:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'GENDER ISSUES IN THE TEACHING OF ENGLISH', '0110', '0-86709-306-2', 'GENDER ISSUES IN THE TEACHING OF ENGLISH', '', 'BOYNTON/COOK PUBLISHERS', 'NANCY MELLIN MC CRACKEN ', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:34:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'ACCOUNTING', '1041', '0-395-44639-2', 'ACCOUNTING', '', 'HOUGHTON MIFFLIN COMPANY', 'DONALD J .GUERRIERI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:35:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'TODAY\'S BEST NONFICTION', '0111', '0893-9373', 'NOVEL', '', 'SIMON AND SCHUSTER', 'JOE MCGINNISS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:37:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'ALCATRAZ\'46', '1042', '0-88339-296-8', 'NOVEL', '', 'LESWING PRESS', 'BERNARD PAUL COY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:38:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'RESEARCHING THEORIES OF CRIME AND DEVIANCE', '0112', '978-0-19-534086', 'RESEARCHING THEORIES OF CRIME AND DEVIANCE', '', 'OXFORD UNIVERSITY PRESS', 'CHARIS E KUBRIN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:40:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'RESEARCH METHODS IN CRIMINAL JUSTICE AND CRIMINOLOGY', '1043', '0-205-26313-5', 'RESEARCH METHODS', '', 'A VIACOM COMPANY', 'FRANK E. HAGAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:44:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'CRIME IS NOT THE PROBLEM', '0113', '0-19-513105-3', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'FRANKLIN E. ZIMRING', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:46:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'CAREERS IN CRIMINAL JUSTICE', '1044', '0-205-26260-0', 'CRIMINOLOGY', '', 'PEARSON EDUCATION COMPANY', 'W. RICHARD STEPHEN,JR', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:53:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'CRIMINAL JUSTICE', '1045', '0-205-20043-5', 'CRIMINOLOGY', '', 'ALLYN AND BACON', 'JOHN R . FULLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:54:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'MANAGEMENT ACCOUNTING', '1046', '0-7872-0315-7', 'ACCOUNTING', '', 'KENDALL/HUNT PUBLISHING COMPANY', 'IBRAHIM M.ALY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:57:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'THE ADOLESCENT DEVELOP AND CULTURE', '0114', '0-205-07304-2', 'NOVEL', '', 'COPYRIGHT', 'F. PHILIP RICE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:59:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'CORPORATE INFORMATION STRATEGY AND MANAGEMENT', '1047', '0-07-245665-5', 'INFORMATIONS', '', 'GEORGE  WERTHMAN', 'LYDA M.APPLEGATE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:00:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'AN ECONOMIC HISTORY OF KENYA', '0115', '9966-46-963-X', 'HISTORY', '', 'EAST AFRICAN EDUCATION PUBLISHER LTD', 'W.R. OCHIENG\"', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:03:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'UNDERSTANDING SEPTEMBER 11TH', '1048', '0-670-03582-3', 'CRIMINOLOGY', '', '  PENGUIN GROUP', ' MITCH FRANK', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:03:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'ESSENTIALS OF ACCOUNTING FOR GOVERNMENTAL NOT FOR PROFIT ORGANIZATIONS', '0116', '13: 978 -0-07-313096-5', 'ACCOUNTIG', '', 'MCGRAW-HILL HIGHER EDUCATION', 'COPLEY ENGSTORM', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:06:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'QUANTITATIVE TECHNIQUES FOR MANAGERIAL DECISIONS', '1049', '978-81-203-3297-3', 'BUSINESS', '', 'ASOKE K.GHOSH                             ', 'R.B.KHANNA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:07:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'COST ACCOUNTING', '0117', '13: 978-135558-3', 'ACCOUNTING', '', 'PEARSON INTERNATIONAL EDITION', 'CHARLES T. HORNGREN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:08:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'ESSENTIALS OF CORPORATE FINANCE', '1050', '0-07-251076-5', 'FINANCE', '', 'STEPHEN M.PATTERSON', 'STEPHEN A . ROSS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:11:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'JUVENILE DELINQUENCY', '0118', '0.471.89364.1', 'JUVENILE DELINQUENCY', '', 'JUVENILE DELINQUENCY', 'JOAN WILLENS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:14:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'E-MAIL RULES', '1051', '0-8144-7188-9', 'BUSINESS', '', 'AMACON', 'NANCY FLYNN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:14:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'CONTROLLER\'S GUIDE TO COSTING', '1052', '0-471-71394-5', 'BUSINESS', '', 'JOHN WILEY$SONS ,INC', 'STEVEN M.BRAGG', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:21:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'ATTACK OF THE TAGGER', '0119', '0-375-82352-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION', 'BRIAN BIGGS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:44:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'WITCHES AND MAGIC MAKERS', '0120', '0-679-88544-7', 'WITCHES AND MAGIC MAKERS', '', 'ALEX WILSON', 'DOUGLAS HILL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:46:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'PETAIL BUSINESS MANAGEMENT', '0121', '0-07-023232-0', 'PETAIL BUSINESS MANAGEMENT', '', 'MCGRAW-HILL BOOK COMPANY', 'GILLESPIE.HECHT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:51:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'THE GLOBAL EXECUTIVE  RECRUITERS', '0122', '0-7879-4139-5', 'THE GLOBAL EXECUTIVE  RECRUITERS ', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATIN DATA', 'NANCY GARRISON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:56:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'ETHICS AND PUBLIC SERVICE IN AFRICA', '0123', '9966-925-12-0', 'NOVEL', '', 'QUEST&INSIGHT PUBLISHERS', 'ERIC E. OTENYO', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:58:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'THE WAR OF THE WORLDS', '0124', '0-679-81047-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'MARY ANN EVANS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:01:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'CONTEMPORARY STATES AND SOCIETIES', '0125', '0-333-71519-5', 'NOVEL', '', 'ANTHONY BUTLER', 'ANTHONY BUTLER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:05:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (180, 'CRIME AND COMMUNITY', '0126', '1-8891487-52-3', 'CRIME AND COMMUNITY', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION', 'G. DAVID CURRY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:11:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (181, 'THE INVISIBLE ISLAND', '0127', '0-679-89457-8', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'RON ROY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:15:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (182, 'A HOUSE CALLED AWFUL END', '0128', '0-439-56960-5', 'NOVEL', '', 'AWFUL END', 'PHILIP ARDAGH', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:19:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (183, 'JACOB TWO-TWO AND THE DINOSAUR', '0129', '0-679-87042-3', 'NOVEL', '', 'RANDOM HOUSE', 'MORDECAI RICHLER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:22:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (184, 'THOROUGHBRED', '0130', '0-06-106482-3', 'NOVEL', '', 'HARPERCOLLINS PUBLISHERS', 'JOANNA CAMPBELL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:26:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (185, 'WHAT IF EVERY KNEW YOUR NAME', '0131', '0-385-73296-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION OF DATA', 'SARA JAMES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:30:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (186, 'TEN GIRLS WHO MADE A DIFFERENCE', '0132', '1-85792-776-1', 'NOVEL', '', 'CHRISTIAN FOCUS PUBLICATIONS', 'IRENE HOWAT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:32:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (187, 'THE BABY SITTERS CLUE', '0133', '0-590-42500-5', 'NOVEL', '', 'SCHOLASTIC INC', 'ANN M. MARTIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:35:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (188, 'SURF UP', '0134', '0-307-15982-5', 'NOVEL', '', 'WESTERN PUBLISHING COMPANY', 'MERCER MAYERS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:37:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (189, 'HAUNTED HOUSEFUL', '0135', '0-394-87041-7', 'NOVELS', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA 0-', 'JOHN KENDRICK BANGS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:42:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (190, 'MUROGI WA KAGOGO', '0136', '996625162-6', 'NOVEL', '', 'EAST AFRICAN EDUCATIONAL PUBLICATION', 'NGUGI WA THIONG\'O ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:44:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (191, 'BESTY ZANE', '0137', '0-440-41834-8', 'NOVEL', '', 'HOUGHTON MIFFLIN COMPANY', 'LYNDA DURRANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:46:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (192, 'TREASURE ISLAND', '0139', '0-679-80402-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'ROBERT LOUIS STEVESON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:49:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (193, 'POTANT BLACK', '0140', '0-439-42084-9', 'NOVEL', '', 'SCHOLASTIC  INC.', 'ANTHONY HOROWITZ ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:55:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (194, 'FELICITY\'S SUPRISE', '0141', '1-56247-011-6', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ALICE MARTIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:02:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (195, 'SARAH', '0142', '0-590-44744-0', 'NOVEL', '', 'SCHOLASTIC INC', 'ELINE MOORE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:04:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (196, 'NOW A MAJOR MOTION PICTURE', '0143', '0-06-0275510-3', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'GAIL CARSON LEVINE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:08:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (197, 'FINANCIAL MANAGEMENT', '0144', '9966-01-150-1', 'ACCOUNTING', '', 'FOCUS PUBLISHERS LTD', 'ROERT MUDIDA', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:25:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (198, 'MODERN ECONOMICS', '0145', '9966-882-74-2', 'ACCOUNTIING', '', 'FOCUS PUBLISHED', 'ROBERT MUDIDA', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:28:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (199, 'BUSINESS PLAN WRITING', '0146', '996696533-5', 'BUSINESS PLAN', '', 'REGINAL PARTNERSHIP FOR RESOURCE DEVELOPMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:31:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (200, 'ORGANIZTION THEORY AND DESIGN', '0147', '978-1-84480-990-5', 'HISTORY', '', 'LIBRARY CATALOGING IN PUBLICATION DATA', 'JONATHAN MURPHY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:34:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (201, 'MONITORING & EVALUATION HAND BOOK', '0148', '978-9966-008-12-1', 'MONITORING & EVALUATION HAND BOOK', '', 'PUBLISHING DEPARTMENT NAIROBI', 'JOHN CHIKATI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:36:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (202, 'CHILD RIGHTS AND CHILD PROTECTION', '0149', '978 9966 36 448 X', 'NOVEL', '', 'LONGHORN PUBLISHERS', 'MARY NDANI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:39:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (203, 'SMALL BUSINESS GROWTH', '0150', '0-471-70760-0', 'BUSINESS', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'STEVEN S. LITTLE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:42:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (204, 'MANAGEMENT INFORMATION SYSTEMS', '0151', '0-07-035823-0', 'MANAGEMENT INFORMATION SYSTEMS', '', 'LIBRARY OF CONGRESS CARD CARD CATALOG', 'DAVID KROENKE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:49:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (205, 'YOUR FORTUNE FORE CLOSURES', '0152', '0-89586-572-6', 'NOVEL', '', 'LIBRARY OF COGRESS CATALOGING IN PUBLICATION DATA', 'FREDY BUSH', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:55:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (206, 'HUMAN RESOURCE AND INDUSTRIAL RELATIONS', '0153', '9966-22-826-8', 'HUMAN RESOURCE', '', 'THE JOMO KENYATTA FOUNDATION', 'DR. BONIFACE M. SUBABU', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:58:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (207, 'CORRECTIONS A CONCISE INTRODUCTION', '0154', '1-57766-050-1', 'CORRECTIONS A CONCISE INTRODUCTION', '', 'WAVELAND PRESS,INC', 'JAMES F. QUIMN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:00:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (208, 'THE ECONOMICS OF REGULATION', '0155', '65-17686', 'ECONOMICS', '', 'LIBRARY OF THE CONGRESS CATALOGUE CARD', 'CHARLES F. PHILIPS, JR', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:04:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (209, 'PRINCIPLES OF ECONOMICS', '0156', '13: 978-0-07-319398-4', 'ECONOMICS', '', 'MCGRAW-HILL HIGHER EDUCATION', 'ROBERT H. FRANK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:08:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (210, 'FUNDAMENTALS OF CORPORATE FINANCE', '0157', '13:978-0-27377991-9', 'FINANCE', '', 'BRITISH LIBRARY CATALOGUING -IN-PUBLICATION DATA', 'JONATHAN BERK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:12:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (211, 'INTERNATIONAL BUSINESS', '0158', '13:978-0-273-77975-9', 'BUSINESS', '', 'PEARSON EDUCATION LIMITED', 'JOHN J. WILD', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:15:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (212, 'GLOBAL  ACTION FOR BLODIVERSITY', '0159', '1-85383-358-4', 'GLOBAL  ACTION FOR BLODIVERSITY', '', 'EARTHSCAN PUBLICATIONS LTD', 'TIMOTHY SWASON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:19:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (213, 'RESOLVING IDENTITY BASED CONFLICT', '0160', '0-7879-0996-3', 'RESOLVING IDENTITY BASED CONFLICT', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'JAY ROTHMAN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:22:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (214, 'A COMMUNITY OF WRITERS', '0161', '0-07-303181-X', 'A COMMUNITY OF WRITERS', '', 'MCGRAW HILL', 'PETER ELBOW', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:33:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (215, 'THE MILLY-MOLLY-MANDY', '0162', '0-7534-5332-0', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'JOYCE LANKESTR BRISLEY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:38:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (216, 'SADDLE CLUB HIGH HORSE', '0163', '0-553-48147-9', 'NOVEL', '', 'A BANTAM SKYLARK BOOK', 'BONNIE BRYANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:46:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (217, 'HOW MUCH IS THAT GUINEA PIG IN THE WINDOW', '0164', '0-590-90747-6', 'NOVEL', '', 'SCHOLASTIC INC.', 'JOANNE ROCKLIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:49:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (218, 'SQUANTO FRIEND OF THE PILGRIMS', '0165', '0-590-44055-1', 'NOVEL', '', 'SCHOLASTIC INC.', 'ROBERT BULLA ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:58:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (219, 'OUT OF THE DUST', '0166', '0-590-37125-8', 'NOVEL', '', 'SCHOLASTIC INC.', 'KAREN HESSE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:01:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (220, 'BUSINESS COMMUNICATION AND REPORT WRITING SIMPLIFIED', '0167', '9966-28-646-2', 'BUSINESS', '', 'SALEEMI PUBLICATION LTD', 'NISAR AHMAD SALEEMI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:04:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (221, 'BRIAN JACQUES', '0168', '0-399-24549-9', 'NOVEL', '', 'LIBRAY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DAVID ELLIOT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:09:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (222, 'DRAGON BREATH', '0169', '0-439-7545-3', 'NOVEL', '', 'SCHOSTIC INC.', 'E.D. BAKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:11:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (223, 'THE MACRO ECONOMY TODAY', '0170', '0-07-056169-9', 'ECONOMY', '', 'MCGRAW HILL,INC', 'MICHAEL M TANSEY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:13:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (224, 'THE SADDLE CLUB', '0171', '0-553-48625-X', 'NOVEL', '', 'A BANTAM SKYLARK BOOK', 'BONNIE BRYANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:16:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (225, 'ANIMORPHS', '0172', '0-590-76261-3', 'NOVEL', '', 'SCHOLASTIC INC', 'K.A.APPLEGATE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:20:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (226, 'HOW TO EAT FRIED WORMS', '0173', '0-440-44545-0', 'NOVEL', '', 'BANTAM DOUBLEDAY DELL BOOKS FOR YOUNG READERS', 'THOMAS ROCKWELL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:23:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (227, 'WRITING FOR SOCIAL SCIENTISTS', '0174', '13: 978-0-226-04132-2', 'WRITING FOR SOCIAL SCIENTISTS', '', 'THE UNIVERSITY OF CHICAGO PRESS', 'HOWARD S. BECKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:26:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (228, 'THE SECRET IDENTITY OF DEVON DELAN', '0175', '13: 978-1-4169-3503-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CONTROL NUMBER', 'LAUREN BARN HOLDT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:29:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (229, 'WRITING FOR SOCIAL SCIENTISTS', '0176', '13: 978-0-226-04132-2', 'WRITING FOR SOCIAL SCIENTISTS', '', 'THE UNIVERSITY OF CHICAGO PRESS', 'HORWAD S. BECKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:31:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (230, 'ONLY IN YOUR DREAMS', '0177', '0-316-01182-7', 'NOVEL', '', 'UNITED STATES OF AMERICA', 'CECILY VON ZIEGESTAR', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:34:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (231, 'PONY PALS', '0178', '0-439-21641-9', 'NOVEL', '', 'SCHOLASTIC INC.', 'JEANNE BETAN COURT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:36:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (232, 'ASTROSAURS BOOK ONE', '0179', '13: 978-0-689-87841-1', 'NOVEL', '', 'ALADDIN PAPERBACKS', 'STEVE COLE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:39:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (233, 'LETTERS FROM RIFKA', '0180', '0-14-036391-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'KAREN HESSE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:57:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (234, 'READER BEWARE YOU CHOOSE THE CHOOSE THE SCARE', '0181', '0-590-56645-8', 'NOVEL', '', 'SCHOLASTIC NC.', 'TICK TOCK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:10:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (235, 'NEVER NEVER', '0182', '0-15-205210-0', 'NOVEL', '', 'MAGIC CAPERT BOOKS', 'SHETTERLY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:12:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (236, 'HARDY BOYS', '0183', '0-671-74665-0', 'NOVEL', '', 'POCKET BOOKS', 'FRANKLIN W. DIXON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:14:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (237, 'TERTIUM ORGANUM', '0184', '0-671-74665-0-X', 'NOVEL', '', 'VINTAGE BOOK', 'P.D.OUSPENSIKY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:17:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (238, 'THE PRINCESS DIARIES', '0185', '0-380-81402-1', 'NOVEL', '', 'PRINCESS IN THE SPOTLIHGT', 'MEG CABOT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:20:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (239, 'I HEARD THE OWL CALL MY NAME', '0186', '0-440-34369-0', 'NOVEL', '', 'DELL PUBLISHING', 'MARGARET CRAVEN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:23:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (240, 'MARCIA THORNTON JONES', '0187', '13: 978-0-545-00148-9', 'NOVEL', '', 'SCHOLASTIC', 'JONES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:25:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (241, 'POLAR BEARS PAST BEDTIME', '0187', '0-679-88341-X', 'NOVEL', '', 'LIBARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'MARY POPE OSBORNE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:27:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (242, 'ANIMAL ARK', '0188', '0-439-68758-6', 'NOVEL', '', 'SCHOLASTIC INC', 'BAGLIO', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:30:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (243, 'WHERE THE RED FERN GROWS', '0189', '0-553-25585-1', 'NOVEL', '', 'BANTAM BOOKS', 'WILSON RAWLS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:34:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (244, 'BABY SITTERS', '0190', '0-590-44828-5', 'NOVEL', '', 'SCHOLASTIC INC', 'KAREN\'S TEA PARTY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:35:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (245, 'THE BABY SITTERS CLUB', '0191', '0-590-43660-0', 'NOVEL', '', 'SCHOLASTIC INC ', 'KRISTY AND THE SNOBS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:37:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (246, 'ON THE MARBLE CLIFFS', '0192', '0 14 00. 2985 0', 'NOVEL', '', 'PENGUIN BOOKS', 'ERNST JUNGER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:40:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (247, 'FOUNDING BROTHERS', '0193', '0-375-70524-4', 'NOVEL', '', 'VINTAGE', 'JOEPH J. ELLIS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:41:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (248, 'PASCAL', '0194', '0-439-16570-9', 'NOVEL', '', 'SCHOLASTIC INC', 'CHICAGO TRIBUNE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:47:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (249, 'PONY PALS', '0195', '0-590-54338-5', 'NOVEL', '', 'SCHOLASTIC INC', 'JEANNE BETANCOURT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:48:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (250, 'A SERIES OF UNFORTUNATE EVENTS', '0196', '0-06-44-768-3', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION', 'LEMONY SNICKET', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:52:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (251, 'ROBOTS', '0197', '0-439-43118-2', 'NOVEL', '', 'SCHOLASTIC INC', 'STEPHEN MUNZER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:54:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (252, 'LBD', '0198', '0-14-240662-7', 'NOVEL', '', 'PENGUIN GROUP', 'BOB WATTS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:57:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (253, 'WORDS OF STONE', '0199', '0-14-036601', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOING IN PUBLICATION DATA', 'KEVIN HENKES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:59:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (254, 'THE ADVENTURES OF UNCLE STINKY', '0200', '1-58246-145-7', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'CHLOE RAWLINS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 09:02:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (255, 'CASE STUDIES ON  EDUCATIONAL ADMINISTRATION', '0201', '1O:0-205-50907-X', 'EDUCATIONAL ADMINISTRATIONAL', '', 'PEARSON EDUCATIONAL INC.', 'THEODORE J. KOWALSKI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:18:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (256, 'EDUCATIONAL ADMINISTRATION', '1053', '0-13-352635-6', 'EDUCATION', '', 'MERRILL,AN IMPRINT OF PRENCTICE HALL', 'ROBERT E . KIRSCHMANN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:19:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (257, 'TOOLS FOR WRITING', '0202', '0-15-503800-1', 'TOOLS FOR WRITING', '', 'LIBRARY OF CONGRESS CATALOGUE', 'RITA SMILKSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:21:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (258, 'EDUCATIONAL LEADERSHIP AND MANAGEMENT', '1054', '978-0-7619-4052-4', 'EDUCATIONAL LEADERSHIP', '', 'SAGE PUBLICATIONS', 'TONY BUSH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:22:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (259, 'MIND BUILDER', '1055', '1-59158-376-4', 'NOVEL', '', 'TEACHER IDEAS PRESS', 'PAUL FLEISHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:26:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (260, 'THE PRINCIPALSHIP A REFLECTIVE PRACTICE PERSPECTIVE', '0203', '0-205-15585-5', 'THE PRINCIPALSHIP A REFLECTIVE PRACTICE PERSPECTIVE', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICTION DATA', 'THOMAS J. SEGIONVANNI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:27:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (261, 'DISTINCTION SCIENCE', '1056', '       978-9966-44-748-7', 'SCIENCE', '', 'KENYA LITERATURE BUREAU', 'CHARLES GICHUKI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:29:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (262, 'ESSENTIALS OF EDUCATIONAL STATISTICS', '0204', '9966-46-645-2', 'STATITICS', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS', 'HANIEL GATUMU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:30:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (263, 'FOUNDATIONS OF EARLY CHILDHOOD DEVELOPMENT AND EDUCATION AND CURRICUM DEVELOPMENT', '0205', '9966-01-131-5', 'FOUNDATIONS OF EARLY CHILDHOOD DEVELOPMENT AND EDUCATION AND CURRICUM DEVELOPMENT', '', 'FOCUS PUBLISHERS', 'MARGARET KABIRU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:35:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (264, 'THE PROJECT PROPOSAL WRITING HANDBOOK', '1057', '978-9966-00-851-0', 'PROJECT PROPOSAL', '', 'REPARED PUBLISHING DEPARTMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:36:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (265, 'PRIMARY TEACHER TRAINING', '0206', '81-8342-057-5', 'PRIMARY TEACHER TRAINING', '', 'CRESCENT PUBLISHING CORPORATION', 'AJOY CHATTERJEE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:38:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (266, 'SKILLS IN PERSON -CENTRED COUNSELLINGAND PSYCHOTHERAPY', '1058', '978-0-7619-6118-5', 'PSYCHOLOGY COUNSELLING', '', 'SAGE PUBLICATIONS', 'JANET TOLAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:40:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (267, 'ETHICAL LEADERSHIP AND DECISION MAKING IN EDUCATION', '1059', '978-0-415-87459-5', 'LAW', '', 'ROUTLEDGE', 'JOAN POLINER SHAPIRO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:42:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (268, 'COMMUNITY DEVELOPMENT', '1060', '978-9966-36-449-8', 'COMMUNITY DEVELOPMENT', '', 'LONGHORN PUBLISHERS', 'HUDSON M .O. ONG\'ANG\'A', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:46:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (269, 'VIS-A-VIS BEGIGING FRENCH', '0207', '0-07-365512-0', 'FRENCH', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'JUDITH A. MUYSKENS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:50:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (270, 'SCIENCE ACTIVITES', '1061', '   978-9966-36-459-5  ', 'SCIENCE', '', 'LONGHORN PUBLISHER', 'JANE N. NJUGUNA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:51:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (271, 'PEOPLE TOGETHER ADVENTURES IN TIME AND PLACE', '0208', '0-02-146557-6', 'NOVEL', '', 'MCGRAW HILL', 'MACMILLAN ', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:52:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (272, 'GROUNDWORK FOR BETTER VOCABULARY', '0209', '0-944210-74-0', '0-944210-74-0', '', 'TOWNSEND PRESS', 'BETH JOHNSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:55:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (273, 'ADMINISTRATION AND MANAGEMENT OF ECDE PROGRAMMES', '1062', '978 9966 36 451 X', 'ADMINISTRATION AND MANAGEMENT', '', 'LOGHORN PUBLISHER', 'NYAKWARA BEGI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:55:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (274, 'COMMUNITY DEVELOPMENT', '1063', '978 9966  36 449 8', 'COMMUNITY DEVELOPMENT', '', 'LONGHORN PUBLISHER', 'HUDSON M. O. ONG\'ANG\'A', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:57:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (275, 'HARCOURT BRACE  SIGNATURES', '0210', '0-15-306413-7', 'NOVEL', '', 'WILLIAM B. EERDAMANS PUBLISHING COMPANY', 'HARCOURT BRACE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:00:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (276, 'PHILOSOPHICAL,SOCIOLOGICAL AND HISTORICAL FOUNDATIONS OF ECDE', '1064', '9966 36425 -0', 'HISTORICAL DEVELOPMENT OF ECDE', '', 'LONGHORN PUBLISHER', 'MICHAEL KARANJA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:01:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (277, 'SOCIOLOGY', '0211', '0-495-09344-0', 'SOCIOLOGY', '', 'LIRARY  OF CONGRESS IN PUBLICATION DATA', 'RODNEY STARK', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:07:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (278, 'FUNDAMENTAL OF FINANCIAL MANAGEMENT', '1065', '978-81-203-3897-5', 'FINACIAL MANAGEMENT', '', ' ASOKE K.GHOSH', 'JAMES C.VAN HORNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:07:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (279, 'PRINCIPLES OF RISK MANAGEMENT AND INSURANCE', '1066', '978-81-317-2584-9', 'MANAGEMENT AND INSURANCE', '', 'PEARSON', 'GEORGE E.REJDA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:12:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (280, 'SOCIAL PSYCHOLOGY', '0212', '0-321-02435-4', 'SOCIAL PSYCHOLOGY', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'ELLIOT ARONSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:12:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (281, 'CASE STUDIES IN FINANCE', '1067', '978-0-07-338245-6', 'MANAGING FOR CORPORATE VALUE CREATION', '', 'UNIVERSIY OF VIRGINIA', 'ROBERT F.BURNER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:17:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (282, 'SOCIOLOGY', '0213', '13: 978-0-495-76396-3', 'SOCIOLOGY', '', 'CENGAGE LEARNING', 'ROBERT J. BRYM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:19:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (283, 'FINANCIAL MANAGEMENT', '1068', '978-81--259-3714-2', 'BANKING FINANCE', '', 'VIKAS PUBLISHING HOUSE PVT LTD', 'I M PANDEY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:20:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (284, 'DIMENSIONS OF HUMAN BEHAVIOR', '0214', '978-1-4129-8879-7', 'DIMENSIONS OF HUMAN BEHAVIOR', '', 'LIBRARYOF CONGRESS CATALOGING IN PUBLICATION DATA', 'ELIZABETH D. HUTCHISON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:23:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (285, 'FUNDAMENTAL OF FINANCIAL MANAGEMENT', '1069', '978-81-315-0002-6', 'FINANCIAL MANAGEMENT', '', 'CENGAGE LEARNING', 'BRIGHAM $ HOUSTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:25:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (286, 'SOCIOLOGY', '0215', '978-81-265-2517-1', 'SOCIOLOGY', '', 'POLITY PRESS', 'PHILIP W. SUTTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:26:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (287, 'SOCIOLOGY', '1070', '978-81-317-0385-4', 'SOCIOLOGY', '', 'PEARSON', 'JOHN J. MACIONIS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:28:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (288, 'PUBLIC RELATIONS', '0216', '0-06-501106-6', 'PUBLIC RELATION', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION DATA', 'WILCOX NOLTE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:29:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (289, 'MANAGEMENT INFORMATION SYTEMS', '1071', '978-0-13-609368-8', 'INFORMATION SYSTEMS', '', 'PEARSON', 'KENNETH C. LAUDON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:34:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (290, 'TESOL QUATERLY', '0217', '0-939791-48-X', 'TESOL QUATERLY', '', 'TESOL PUBLICATIONS', 'SANDRA SIBERSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:37:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (291, 'GIDDENS SOCIOLOGY', '1072', '978-81-265-2517-1', 'SOCIOLOGY', '', 'WILEY', 'PHILIP W. SUTTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:39:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (292, 'THEORY AND EXPERIENCE', '0218', '0-395-12658-4', 'THEORY AND EXPERIENCE ', '', 'LIBRARY OF CONGRESS CATALOG ', 'RODNEY W. NAPIER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:44:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (293, 'LABOR ECONOMICS', '1073', '978-0-393-97952-7', 'ECONOMICS', '', 'NORTONEBOOKS.COM', 'DEREK LAING', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:45:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (294, 'OLIVER NORTH', '0219', '080542551-9', 'NOVEL', '', 'BROADMAN& HOLMAN PUBLISHERS', 'JAMES BRADLY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:49:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (295, 'ORGANIZATIONAL BEHAVIOR', '1074', '0-07-287387-6', 'ORGANIZATIONAL BEHAVIOR', '', 'MCGRAW-HILL IRWIN', 'FRED LUTHANS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:49:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (296, 'DEVIANCE AND DEVIANTS', '0220', '1-891487-27-2', 'DEVIANCE AND DEVIANTS', '', 'LIBRARY OF CONGRESS IN PUBLICATION DATA', 'PATRICIA GAGNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:51:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (297, 'SERVICE MANAGEMENT FOR COMPETITIVE ADVANTAGE', '1075', '0-07-021217-1', 'SERVICE MANAGEMENT', '', 'MCGRAW -HILL,INC', 'JAMES A. FITZSIMMONS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:52:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (298, 'ORGANISATIONAL PSYCHOLOGY', '0221', '0-13-641332-3', 'PSYCHOLOGY', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'RICHARD S. LAZARUS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:53:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (299, 'MANAGEMENT INFORMATION SYSTEMS', '1076', '978-1-84480-172-5', 'INFORMATION MANAGEMENT', '', 'BOOKPOWER', 'TERRY LUCEY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:56:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (300, 'GRAMMARTICALLY CORRECT', '0222', '13: 978 -1-58297-331-9', 'GRAMMARTICALLY CORRECT', '', 'CATALOGING IN PUBLICATION', 'CINCINNATI, OHIO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:58:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (301, 'FINANCIAL AND INSTITUTIONS', '1077', '978-81-315-0979-1', 'FINANCE', '', 'CENGAGE LEARNING', 'JEFF MADURA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:58:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (302, 'FINANCIAL MANAGEMENT', '0223', '13: 978-81-315-0491-8', 'FINANCIAL MANAGEMENT', '', 'CENGAGE LEARNING', 'EUGENE F. BRIGHAM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:00:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (303, 'THE ECONOMICS OF MICROFINANCE', '1078', '978 0262 513982', 'ECONOMICS', '', 'THE MIT PRESS', 'BEATRIZ ARMENDARIZ', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:02:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (304, 'ACADEMIC COMMUNICATION SKILLS', '0224', '999 846 10 8', 'COMMUNICATION SKILLS', '', 'NARIOBI UNIVERSITY PRESS', 'PETER BINT', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:03:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (305, 'LOSER', '1079', '978-0-06-054074-6', 'NOVEL', '', 'JOANNA COTLER BOOKS', 'JERRY SPINELLI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:05:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (306, 'ECHOES OF TIME', '0225', '0-02-136740-X', 'ECHOES OF TIME', '', 'MACMILLAN PUBLISHING COMPANY', 'CARL B. SMITH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:05:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (307, 'ISLAND BOUND', '1080', '0-380-73174-6', 'NOVEL', '', 'GREENWILLOW BOOK', 'BETTY LEVIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:08:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (308, 'ATTACK OF THE TAGGER', '1081', '0-375-82352-2', 'NOVEL', '', 'BRIAN BIGGS', 'WENDELIN VAN DRAANEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:11:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (309, 'GIGER BREAD', '0226', '0-689-86020-X', 'NOVEL', '', 'LIBRARY OF CONGRESS', 'RACHEAL COLN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:13:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (310, 'THE LONG WINTER', '1082', '0-590-30094-6', 'NOVEL', '', 'SCHOLASTIC INC', 'LAURA INGALLS WILDER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:13:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (311, 'THE DAYDREAM', '0227', '0-06-440576-1', 'NOVEL', '', 'A DIVISION OF HARPERCOLLINS PUBLISHES', 'ANTHONY BROWNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:16:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (312, 'STEP-MOTHERHOOD HOW TO SURVIVE WITHOUT FEELING FRUSTRATED LEFT OUT,OR WICKED', '1083', '0-8129-1145-8', 'SOCIOLOGY', '', 'CIMES BOOKS', 'CHERIE BURNS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:21:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (313, 'BABU ALIPOFUFUKA', '1084', '9966-22-180-8', 'RIWAYA', '', 'JOMO KENYATTA FOUNDATION', 'SAID A. MOHAMED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:21:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (314, 'JICHO LA NDANI', '0228', '978 99666 49 752 8', 'KISWAHILI', '', 'SASA SEMA PUBLICATIONS', 'SAID A. MOHAMED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:20:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (315, 'THE CAMEL CLUB', '1085', '0-446-57738-3', 'NOVEL', '', 'COLUMBUS ROSE', 'DAVID BALDACCI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:22:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (316, 'DINOSAUR TIME', '0229', '0-0644037-0', 'NOVEL', '', 'LIBRARY OF CONGRESS PUBLICATION', 'PEGGY PARISH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:24:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (317, 'TEACHERS PET', '1086', '0-590-47618-1', 'NOVEL', '', 'SCHOLASTIC INC', 'TERRANCE DICKS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:24:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (318, 'BREAK THROUGH THE LANGUAGE BARRIER', '1087', '0039-8322', 'LITERACY', '', 'AMERICAN LANGUAGE ACADEMY', 'SANDRA SILBERSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:29:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (319, 'HENNER\'S LYDIA', '1088', '0-8361-9093', 'NOVEL', '', 'NEWBERY MEDAL WINNER', 'MARGUERITE DE ANGELI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:32:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (320, 'WRITE ON TARGET', '1089', '1-884183-39-5', 'WRITING', '', 'ENGLEFIELD$ARNOLD PUBLISHING', 'YOLANDE F. GRIZINSIKI ED.D', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:35:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (321, 'THE BEADED MOCCASINS', '1090', '0-440-41591-8', 'NOVEL', '', 'A YEARLING BOOK', 'LYNDA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:37:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (322, 'PRAISE FOR EAGER', '1091', '0-553-48795-7', 'NOVEL', '', 'A YEARLING BOOK', 'HELEN FOX', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:39:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (323, 'AMNESTY', '1092', '1-55583-276-8', 'NOVEL', '', 'ALYSON PUBLICATIONS', 'LOUISE A. BLUM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:42:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (324, 'GEORGE WASHINTON', '0230 ', '0-7660-5000-9', 'NOVEL', '', 'ENSSLOW PUBLISHERS INC', 'STEPHEN FEINSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:46:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (325, 'THE CELESTINE PROPHECY', '1093', '0-446-51862-X', 'THEOLOGY', '', 'AUDIOBOOKS', 'JAMES REDFIELD', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:46:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (326, 'MIDNIGHT FOR CHARLIE BONE', '0231', '0-439-48839-7', 'NOVEL', '', 'SCHOLASTIC INC.', 'JENNY NIMMO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:48:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (327, 'SPEAK WITH CONFIDENCE', '1094', '0-07-140805-3', 'LANGUAGE', '', 'MCGRAW-HILL CO', 'DIANNA BOOHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:49:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (328, 'JASON KYLA', '0232', '0-7868-3653-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DANA DAVIDSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:50:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (329, 'SONS OF THE DARK', '1095', '0-78688188133-1', 'NOVEL', '', 'HYPERRION', 'KYLE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:53:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (330, 'THE MASTERS', '0233', '684-71897-9', 'NOVEL', '', 'C.P. SHOW', 'C.P. SHOW', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:53:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (331, 'POCKET WRITER\'S COMPANION', '1096', '0-321-28826-2', 'NOVEL', '', 'PEARSON LONGMAN', 'CHRIS M. ANSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:56:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (332, 'LEARNING ANOTHER LNGUAGE THROUGH ACTIONS', '0234', '1-56018-494-9', 'LEARNING ANOTHER LNGUAGE THROUGH ACTIONS', '', 'SKY OAKS PRODUCTIONS', 'JAMES J. ASHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:56:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (333, 'GIRLS ON FILM', '1097', '0-316-73475-6', 'NOVEL', '', 'LITTLE BROWN AND COMPANY', 'ZOEY DEAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:58:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (334, 'HOW TO SAVE YOUR TALL', '0235', '978-0-375-83755-5', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION OF DATA', 'MARY HANSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:59:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (335, 'GAIL CARSON LEVINE', '1098', '0-06-055886-5', '', '', 'AVONBOOKS', 'ELLA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:01:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (336, 'PREP', '0236', '0-525-47135-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION IN DATA', 'JAKE COBURN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:02:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (337, 'MIRACLES ON MAPLE HILL', '1099', '0-590-43145-5', 'NOVEL', '', 'SCHOLASTIC', 'VIRGINIA SORENSEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:03:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (338, 'AFRICA DISCOVERS HER PAST', '0237', '19 412275 1', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'J.D. FAGE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:04:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (339, 'A COMMUNICATIVE APPROACH', '1100', '0-07-365516-3', 'COMMUNICATION', '', 'MCGRAW HILLS', 'TERRELL', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:09:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (340, 'WALT DISNEY WINNIE THE POOH AND HIS FREINDS', '0238', '1-57082-968-3', 'NOVEL', '', 'RANDOM HOUSE', 'RANDOM HOUSE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:09:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (341, 'MIRACLE ON MAPLE HILL', '0239', '0-590-43145-5', 'NOVEL', '', 'SCHOLASTIC INC.', 'VIRGINIA SORENSEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:41:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (342, 'GAIL CARSON LEVINE', '0240', '0-06-055886-5', 'NOVEL', '', 'LIBRARY OF CONRESS CATALOGING IN PUBLICATION DATA', 'ELLA ECHANTED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:51:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (343, 'GIRLS ON FILM', '0241', '0-316-73475-6', 'NOVEL', '', 'STREET PRODUCTIONS', 'ZOEY DEAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:55:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (344, 'KONTAKTE A COMMUNICATIVE APPROACH', '0242', '0-07-365516-3', 'NOVEL', '', 'MCGRAW -HILL HIGHER EDUCATION', 'TERRELL TSCHIRNER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:58:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (345, 'SONS OF THE DARK', '0243', '078688183-1', 'NOVEL', '', 'HYPERRION', 'LYNNE EWING', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:59:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (346, 'THE DARKNESS OF A LEAF', '0244', '0-312-14308-7', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'CAROLINE STICKLAND', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:02:37', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (347, 'PHYSICAL EDUCATION FOR PRIMARY SCHOOLS', '0245', '978-9966-46-249-X', 'PHYSICAL EDUCATION', '', 'EAST AFRICA EDUCATIONA PUBLISHERS', 'JERIM OTIENO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:04:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (348, 'PHYSICAL EDUCATION TEACHERS GUIDE FOR FORM FOUR', '0246', '9966-22-452-1', 'PHYSICAL EDUCATION', '', 'THE JOMO KENYATTA FOUNDATION', 'JANET KAMENJU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:07:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (349, 'ZIGBY CAMPS OUT', '0247', '978-0-00-783805-9', 'NOVEL', '', 'HAPERCOLLINS PUBLISHERS LMD', 'BRIAN PATERSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:09:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (350, 'FREEDOM AND AFTER', '1101', '9966 46 974 5', 'FREEDOM', '', 'EAST AFRICAN EDUCATIONAL PUBLISHER', 'TOM MBOYA', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:21:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (351, 'READING MASTERY', '1102', '0-07-569326-7', 'NOVEL', '', 'MC GRAW HILL', 'ELAINE C. BRUNER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:24:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (352, 'STUDYING THE NOVEL', '1103', '978-0-340-98513-7', 'NOVEL', '', 'BLOOMS BURRY', 'JEREMY HAWTHORN', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:26:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (353, 'THEMES IN KENYAN HISTORY', '1104', '9966-46-578-2', 'KENYAN HISTORY', '', 'EAST AFRICAN EDUCATIONAL PUBLISHER', 'WILLIAM R. OCHIENG', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:29:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (354, 'MICROSOFT VISUAL BASIC FOR APPLICATIONS', '1105', '0-07-283616-4', 'TECHNOLOGY MICROSOFT', '', 'TECHNOLOGY EDUCATION', 'ALAN I REA', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:32:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (355, 'WOMAN THOU ART LOOSED', '1106', '1-56043-100-8', 'NOVEL', '', 'TREASURE HOUSE', 'T.D . JAKES', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:34:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (356, 'CHILDREN\'S RIGHTS', '1107', '9966 34278-8', 'HUMAN RIGHTS', '', 'MACMILLAN KENYA', 'ISSA TOURE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:36:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (357, 'NELSON MANDELA', '1108', '978-1-86200-763-5', 'HISTORY', '', 'CHRISTINA SCOTT', 'CHRISTINA SCOTT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:39:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (358, 'A HISTORY OF AFRICA', '1109', '9966-25358-0', 'HISTORY', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS', 'ASSA OKOTH', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:42:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (359, 'SHAKESPEAR', '1110', '0-500-26021-4', 'HISTORY', '', 'THAMES AND HUDSON', 'F.E. HALLIDAY', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:45:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (360, 'THERE IS A GOD HOW THE WORLD\'S MOST NOTORIOUS ATHEIST CHANGED HIS MIND', '1111', '978-0-06-133529-7', 'THEOLOGY', '', 'HARPER COLLINS PUBLISHER', 'ATHONY FLEW', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:49:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (361, 'MY HOPE OF PEACE', '1112', '978-1-4165-9219-8', 'POLITICAL SCIENCE', '', 'FREE PRESS', 'JEHAN SADAT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:51:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (362, 'THE ARCHAELOGY WORKBOOK', '1113', '0-8122-6625-6', 'HISTORY', '', 'UNIVERSITY OF PENNSYLVANIA PRESS', 'STEVE DANIELS', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:54:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (363, 'PUBLICATION MANUAL', '1114', '1-55798-241-4', 'PSYCHOLOGY', '', 'AMERICAN PSYCHOLOGICAL ASSOCIATION', 'WASHINGTON DC', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:57:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (364, 'THE ARCHAEOLOGY WORKBOOK', '1115', '0-8622-6625-6', 'HISTORY', '', 'UNIVERSITY OF PEVVSYLVANIA PRESS', 'NICHOLAS DAVID', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:00:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (365, 'MAN FROM MACHAKOS', '1116', '9966-22-563-3', 'NOVEL', '', 'THE JOMO KENYATTA FOUNDATION', 'DAVID G. MAILLU', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:06:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (366, 'ROMAN PEOPLE', '1117', '0-7674-1707-0', 'HISTORY OF ROMAN PEOPLE', '', 'MAYFIELD PUBLISHING COMPANY', 'ROBERT B. KEBRIC', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:09:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (367, 'PICTURES FOR LANGUAGE LEARNING', '1118', '0-521-35800-0', 'LANGUAGE', '', 'CAMBRIDGE UNIVERSITY PRESS', 'ANDREW WRIGHT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:11:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (368, 'GOING WITHIN', '1119', '0-553-05367-1', 'PSYCHOLOGY', '', 'BANTAM BOOKS', 'SHIRLEY MACLAINE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:14:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (369, 'THE BLACK AMERICANS', '1120', '0-690-04419-4', 'HISTORY OF BLACK AMERICAN', '', 'HARPERCOLLINS PUBLISHER', 'MILTON MELTZER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:16:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (370, 'THE PSALMS OF THE JERUSALEM BIBLE', '1121', '0-385-690-9', 'THEOLOGY', '', 'DISION OF DOUBLEDAY$COMPANY', 'ROB COBUZIO', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:22:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (371, 'KEEP IN STEP WITH THE SPIRIT', '1122', '0-8007-5235-X', 'THEOLOGY', '', 'POWER BOOKS', 'J.I.PACKER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:27:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (372, 'HOT FLASHES FROM HEAVEN', '1123', '978-0-7369-2031-5', 'SOCIOLOGY', '', 'HARVEST HOUSE PUBLISHERS', 'RONNA SNYDER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:30:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (373, 'PRAYER$EVANGELISM', '1124', '73-91552', 'THEOLOGY', '', 'CAMBRIDGE UNIVERSITY PRESS', 'HELEN S. SHOEMAKER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:34:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (374, 'ST.BENEDICT HERO OF THE HILLS', '1125', '0-89870-767-6', 'THEOLOGY', '', 'FARRAR STRAUS AND GIROUX', 'IGNATIUS', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:36:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (375, 'WORLD BOOK', '1126', '978-0-7166-0108-1', 'WORLD EXPLORE', '', 'WORLDBOOK INC', 'SCOTT FETZER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:41:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (376, 'THE SURPRISE PARTY', '1127', '0671-73561-6', 'NOVEL', '', 'POCKET BOOKS', 'R. L.STINE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:44:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (377, 'THIS PRESENT DARKNESS', '1128', '0-89107-390-6', 'NOVEL', '', 'CROSSWAY BOOKS', 'FRANK E. PERETTI', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:46:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (378, 'SALEM WITCH', '1129', '978-0-7534-1327-2', 'NOVEL', '', 'KINGFISHER', 'PATRICIA HERMES', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 10:07:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (379, 'MILESTONES OF SCIENCE', '1130', '0-7922 7906-9', 'POLITICAL SCIENCE', '', 'NATIONAL GEOGRAPHIC', 'CURT SUPLEE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 10:10:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (380, 'DIAL L FOR LOSER', '0248', '978-0-316-11504-9', 'NOVEL', '', 'LITTLE BROWN COMPANY', 'LISI HARRISON', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:29:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (381, 'JERRY FALWELL', '0249', '0-8407-5172-9', 'NOVEL', '', 'THOMAS NELSON PUBLISHERS', 'GELARD STROBER', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:33:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (382, 'AN INTRODUCTION TO AFRICAN HISTORY', '0250', '10: 9966-846-15-8', 'HISTORY', '', 'UNIVERSITY OF NAIROBI PRESS', 'MATHIAS A OGUTU', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:37:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (383, 'RESPONSIVE HEART', '0251', '1-57683-181-7', 'NOVEL', '', 'NAV PRESS1', 'RYANN COOLEY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:40:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (384, 'AMERICAN INDIAN POLICY IN THE TWENTIETH CENTURY', '0252', '0-8061-1897-0', 'NOVEL ', '', 'UNIVERSITY OF OKLAHOMA PRESS', 'VINE DELORIA', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:45:37', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (385, 'BULLY FOR YOU TEDDY ROOSEVELT', '0253', '0-439-14913-4', 'NOVEL', '', 'SCHOLASTIC INC', 'MIKE WINNER', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:48:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (386, 'WORLD BOOK', '0254', '978-0-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:54:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (387, 'WORLD BOOK', '0255', '978-0-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY ', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:59:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (388, 'WORLD BOOK', '0256', '978-7166 -0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:02:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (389, 'WORLD BOOK', '0257', '978-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:06:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (390, 'FUNDAMENTALS OF COUNSELING', '0258', '0-395-17580-1', 'FUNDAMENTALS OF COUNSELING', '', 'HOUNGTON MIFFLIN COMPANY', 'SHERTZER/STONE', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:06:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (391, 'HARCOUT BRACE SIGNATURES', '0259', '0-15-306401-3', 'NOVEL', '', 'HARCOUT BRACE COMPANY', 'ROGER C. FARR', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:10:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (392, 'EARLY JUDAISM AND ITS MODERN INTERPRETERS', '0260', '0-89130-921', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'SHAGE J. D. COHEN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:44:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (393, 'THE PHARAOHS OF ANCIENT EGYPT', '0261', '0-394-84699-0', 'NOVEL', '', 'LANDMARK BOOKS', 'ELIZABETH ANNE PAYNE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:50:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (394, 'H.NORMAN WRIGHT', '0262', '0-89081-816-9', 'NOVEL', '', 'HARVEST HOUSE PUBLISHERS', 'LLYOD OGILVILE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:53:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (395, 'BUSINESS LAW', '1131', '978-0-07-014685-3', 'BUSINESS', '', 'MCGRAW HILL', 'SATISH B MATHUR', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:54:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (396, 'THE ENDURING CHURCH', '0263', '0-377-00306-9', 'THE ENDURING CHURCH', '', 'FREIND PRESS', 'GAIL V. COULSON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:55:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (397, 'VISUAL ILLUSIONS', '1132', '978-0-7858-2173-1', 'NOVEL', '', 'CHARTWELL BOOKS', 'CHARTWELL BOOKS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:59:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (398, 'COMPANY LAW', '1133', '9966-01-137-4', 'LAW', '', 'FOCUS PUBISHERS', 'JOHN JOSEPH OGOLA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:01:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (399, 'DARUBINI YA KISWAHILI', '1134', '9966-47-246-0', 'EDUCATION', '', 'PHOENIX', 'J .HABWE ', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:03:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (400, 'EXPERIENCING THE WORLD RELIGIONS', '0264', '978-0-07-353564-7', 'EXPERIENCING THE WORLD RELIGIONS', '', 'MC GRAW HILL PUBLISHERS', 'MOLLOY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:03:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (401, 'BEDFORD BIBLIOGRAPHY FOR TEACHERS OF WRITING', '1135', '0-312-11556-3', 'TEACHING', '', 'BEDFORD BOOKS', 'PATRICIA BIZELL', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:05:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (402, 'INTRODUCTION TO COUNSELING', '0265', '0-697-06070-5', 'COUNSELING', '', 'BROWN COMPANY PUBLISHERS', 'GARY S. BELKIN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:06:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (403, 'THE PRACTICE OF WRITING', '1136', '0-312-63546-X', 'TEACHING', '', 'ST MARTINS PRESS', 'ROBERT SCHOLES', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:08:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (404, 'ESSAYS FROM CONTEMPORARY CULTURE', '0266', '0-15-505302-7', 'ESSAYS FROM CONTEMPORARY CULTURE', '', 'HARCOURT BRACE COLLEGE PUBLISHERS', 'KATHERINE ANNE ACKLEY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:09:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (405, 'THE NEXT ARCHAEOLOGY WORKBOOK', '0267', '0-8122-1293-2', 'ARCHAEOLOGY', '', 'UNIVERSITY OF PENNSYLYVANIA PRESS', 'STEVE DANIELS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:11:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (406, 'BORDERLINES', '1137', '0-415-91114-1', 'HISTORY', '', 'NEW FETER LANE', 'BILLIE MELMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:12:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (407, 'LEADERSHIP,LOVE,$AGGREGATION', '1138', '0-15-149348-0', 'PSYCHOLOGY', '', 'DAVIS ALLISON', 'ALLISON DAVIS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:15:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (408, 'GENERAL PSYCHOLOGY AND PERSONALITY DEVELOPMENT', '1139', '9966-01-119-6', 'PSYCHOLOGY', '', 'FOCUS', 'MARGARET KABIRU', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:17:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (409, 'VOICES FROM WOUNDED KNEE', '1140', '0-914838-02-4', 'HISTORY', '', 'AKWESASNE NOTES', 'VINE DELORIA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:19:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (410, 'CHRISTIANITY', '1141', '978-0-719-57526-6', 'THEOLOGY', '', 'HODDER EDUCATION', 'CLAIRE CLINTON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:22:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (411, 'AN INTERGRATED APPROACH TO PEER COUNSELING', '0268', '978-9966-20-266-6', 'COUNSELING', '', 'EVANGEL PUBLISHING HOUSE', 'LUCY W. KANG\'ORI', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:24:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (412, 'THE LAST OF THE GIANTS', '1142', '0-8007-9192-4', 'NOVEL', '', 'CHOOSEN  BOOOKS', 'GEORGE OTIS,JR', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:24:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (413, 'COMMON CULTURE', '1143', '0-13-182545-3', 'TEACHING', '', 'PEARSON', 'MICHAEL PETRACCA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:26:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (414, 'THE QUALITY OF LIFE VALUATION SOCIAL RESEARCH', '0269', '0-8039-9587-3', 'THE QUALITY OF LIFE VALUATION SOCIAL RESEARCH', '', 'SAGE PUBLICATIONS', 'RAMKRISHNA MUKHERJEE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:27:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (415, 'PRACTICAL DIVINITY', '1144', '0-637-33326-1', 'THEOLOGY', '', 'ABINGDON PRESS', 'THOMAS A.LANGFORD', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:29:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (416, 'THE KALAHARI TYPING SCHOOL FOR MEN', '0270', '1-4000-3180-X', 'NOVEL', '', 'A DIVISION OF RANDOM HOUSE INC', 'ALEXANDER MC CALL SMITH', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:31:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (417, 'THEOLOGY IN THE CONTEXT OF SCIENCE', '1145', '978-0-300-16456-5', 'THEOLOGY', '', 'YALE UNIVERSITY PRESS', 'JOHN POLKINGHORNE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:31:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (418, 'THE MAKING OF MIND', '1146', '0-674-54327-7', 'PSYCHOLOGY', '', 'HARVARD UNIVERSITY PRESS', 'A.R. LURIA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:33:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (419, 'COMMUNITY CAPACITY BUILDING AND EMPORMENT', '0271', '996606007-3', 'COMMUNITY CAPACITY BUILDING AND EMPORMENT', '', 'PSI CONSULTANTS', 'GITONGA .B.A', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:34:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (420, 'NEW MOVEMENTS', '1147', '0-281-02929-6', 'THEOLOGY', '', 'SPCK HOLY TRINITY CHURCH', 'ALAN THOMSON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:35:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (421, 'INVESTIGATING THE SOCIAL WOLRD', '0272', '1-4129-2734', 'INVESTIGATING THE SOCIAL WOLRD', '', 'SAGE PUBLICATION', 'RUSSELL K. SCHUTT', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:37:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (422, 'THE BIRTH OF LIVING GOD', '1148', '0-226-72102-7', 'THEOLOGY', '', 'UNIVERSITY OF CHICAGO PRESS', 'ANA-MARIA RIZZUTO', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:38:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (423, 'CHRISTIAN ETHICS IN THE AFRICAN CONTEXT', '1149', '9966-768-62-9', 'THEOLOGY', '', 'UZIMA', 'HANS HASELBARTH', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:41:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (424, 'CHICKEN SOUP FOR THE COLLEGE SOUL', '1150', '1-55874-702-8', 'LIFE OF COLLEGE', '', 'HEALTH COMMUNICATIONS INC', 'JACK CANFIELD', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:44:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (425, 'THE COUNSELING PSYCHOLOGIST', '0273', '79409-2051', 'COUNSELING', '', 'SAGE PUBLICATION', 'P.PAUL HEPPNER', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:45:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (426, 'MOTHERLESS DAUGHTERS', '0274', '13 978-0-7382-1026-1', 'NOVEL', '', 'DA CAPO PRESS BOOKS', 'KIRKUS REVIEWS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:49:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (427, 'SYSTEM THEOORY AND MANAGEMENT INFORMATION SYSTEMS SIMPLIFIED', '0275', '9966-28-886-4', 'ICT', '', 'SALEEMI PUBLICATION LTD', 'N.A.SALEEMI', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:55:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (428, 'OBJECT-ORIENTED SYSTEMS ANALYSIS AND DESIGN', '0276', '978-007712536-3', 'ICT', '', 'MCGRAW-HILL EDUCATION', 'SIMON BENNETT STEVE MCROBB AND RAY FARMER', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:01:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (429, 'BETWEEN INNER SPACE AND OUTER SPACE', '0277', '0-19-850254-0', 'BETWEEN INNER SPACE AND OUTER SPACE', '', 'UNITED STATE BY OXFORD UNIVERSITY JOHN D.BARROW', 'JOHN D.BARROW', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:12:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (430, 'STUDY GUIDE TO ACCOMPANY THE PHYSICAL UNIVERSE', '0278', '0-07-228415-3', 'STUDY GUIDE TO ACCOMPANY THE PHYSICAL UNIVERSE', '', 'JP LENNEY', 'STEVEN D.CAREY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:18:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (431, 'THEORY AND PRACTICE OF COUNSELLING AND PSYCHOTHERAPY', '0279', '978-1-4462-9556-4', 'THEORY AND PRACTICE OF COUNSELLING AND PSYCHOTHERAPY', '', 'RICHARD NELSON -JONES', 'RICHARD NELSON-JONES', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:28:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (432, 'BLACKS IN SCIENCE AND MEDICINE', '0280', '0-891-16-665-3', 'BLACKS IN SCIENCE AND MEDICINE', '', 'HEMISPHERE PUBLISHING CORPORATION', 'VIVIAN OVELTON SAMMONS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:41:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (433, 'APPLYING UML AND PATTERNS', '0281', '0-13-148906-2', 'APPLYING UML AND PATTERNS', '', 'PRENTICE HALL PTR', 'CRAIG LAWARMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 05:33:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (434, 'THE BEDFORD BIBLIOGRAPHY', '0282', '0-312-40501-4', 'BIBLIOGRAPHY', '', 'BRUCE HERZBERG', 'DEAN G. PEERMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 05:51:26', NULL);


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 1, '2025-12-15 04:31:07');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 1, '2025-12-15 04:30:58');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'admission', 0, '2021-01-18 23:48:11');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (4, 'complain', 1, '2025-01-29 04:57:25');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (5, 'contact_us', 0, '2021-01-18 23:48:15');


#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'CBET', 'no', '2025-12-12 11:03:47', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'NITA', 'no', '2025-12-12 11:03:54', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'RPL', 'no', '2025-12-12 11:04:06', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'KASNEB', 'no', '2025-12-12 11:04:14', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'KNEC', 'no', '2025-12-12 11:04:20', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'SHORT COURSE', 'no', '2025-12-12 11:04:31', NULL);


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>principal', '.................................<br>admin', 'sampletc121.png', 2, 1, 360, 400, 480, 810, 1, 230, '2019-12-21 10:14:34', '0000-00-00');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `student_id`, `create_staff_id`, `create_student_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'staff', 1, NULL, NULL, NULL, 0, '2025-09-15 13:55:02', NULL);


#
# TABLE STRUCTURE FOR: class_section_times
#

DROP TABLE IF EXISTS `class_section_times`;

CREATE TABLE `class_section_times` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `class_section_times_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1136 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (393, 372, 27, 'no', '2025-12-13 09:37:44', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (401, 373, 29, 'no', '2025-12-13 09:39:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (409, 375, 23, 'no', '2025-12-13 09:44:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (413, 376, 21, 'no', '2025-12-13 09:47:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (416, 377, 15, 'no', '2025-12-13 09:48:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (422, 378, 15, 'no', '2025-12-13 09:50:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (448, 379, 29, 'no', '2025-12-13 09:54:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (453, 380, 18, 'no', '2025-12-13 10:04:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (464, 381, 21, 'no', '2025-12-13 10:05:13', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (473, 382, 21, 'no', '2025-12-13 10:05:52', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (477, 383, 15, 'no', '2025-12-13 10:06:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (489, 384, 15, 'no', '2025-12-13 10:08:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (506, 385, 28, 'no', '2025-12-13 10:09:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (513, 386, 21, 'no', '2025-12-13 10:10:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (519, 387, 17, 'no', '2025-12-13 10:10:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (531, 388, 21, 'no', '2025-12-13 10:11:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (541, 389, 22, 'no', '2025-12-13 10:12:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (554, 390, 29, 'no', '2025-12-13 10:14:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (558, 391, 17, 'no', '2025-12-13 10:15:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (583, 393, 18, 'no', '2025-12-13 10:16:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (604, 395, 15, 'no', '2025-12-13 10:18:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (649, 399, 15, 'no', '2025-12-13 10:20:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (658, 400, 15, 'no', '2025-12-13 10:21:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (667, 401, 15, 'no', '2025-12-13 10:21:49', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (679, 402, 15, 'no', '2025-12-13 10:22:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (703, 404, 15, 'no', '2025-12-13 10:25:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (712, 405, 15, 'no', '2025-12-13 10:25:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (728, 406, 23, 'no', '2025-12-13 10:27:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (766, 410, 15, 'no', '2025-12-13 10:30:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (809, 414, 18, 'no', '2025-12-13 10:32:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (820, 415, 17, 'no', '2025-12-13 10:33:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (837, 416, 27, 'no', '2025-12-13 10:35:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (845, 417, 21, 'no', '2025-12-13 10:36:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (850, 418, 16, 'no', '2025-12-13 10:41:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (858, 419, 15, 'no', '2025-12-13 10:42:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (867, 420, 15, 'no', '2025-12-13 10:42:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (877, 421, 16, 'no', '2025-12-13 10:43:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (888, 422, 15, 'no', '2025-12-13 10:44:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (907, 423, 23, 'no', '2025-12-13 10:45:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (909, 424, 15, 'no', '2025-12-13 10:45:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (920, 425, 17, 'no', '2025-12-13 10:46:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (927, 426, 15, 'no', '2025-12-13 10:47:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (944, 427, 28, 'no', '2025-12-13 10:47:53', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (951, 428, 21, 'no', '2025-12-13 10:48:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (960, 429, 21, 'no', '2025-12-13 10:49:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (972, 430, 27, 'no', '2025-12-13 10:51:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (976, 431, 15, 'no', '2025-12-13 10:56:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (988, 432, 15, 'no', '2025-12-13 10:57:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1000, 433, 15, 'no', '2025-12-13 11:04:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1012, 434, 15, 'no', '2025-12-13 11:05:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1027, 435, 18, 'no', '2025-12-13 11:06:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1046, 436, 29, 'no', '2025-12-13 11:08:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1075, 371, 29, 'no', '2025-12-14 08:25:44', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1080, 440, 18, 'no', '2025-12-14 12:36:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1081, 445, 27, 'no', '2025-12-14 12:39:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1082, 446, 27, 'no', '2025-12-14 12:41:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1083, 447, 28, 'no', '2025-12-14 13:28:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1084, 448, 28, 'no', '2025-12-14 13:28:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1085, 449, 28, 'no', '2025-12-14 13:29:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1087, 441, 21, 'no', '2025-12-14 13:32:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1088, 450, 29, 'no', '2025-12-15 02:44:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1089, 451, 29, 'no', '2025-12-15 02:45:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1090, 452, 29, 'no', '2025-12-15 02:46:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1091, 453, 29, 'no', '2025-12-15 02:47:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1092, 454, 29, 'no', '2025-12-15 02:48:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1093, 455, 28, 'no', '2025-12-15 02:55:12', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1094, 456, 29, 'no', '2025-12-15 02:55:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1095, 457, 21, 'no', '2025-12-15 02:55:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1096, 458, 27, 'no', '2025-12-15 02:56:53', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1097, 459, 16, 'no', '2025-12-15 03:26:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1098, 460, 17, 'no', '2025-12-15 03:42:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1099, 461, 15, 'no', '2025-12-15 03:45:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1100, 462, 23, 'no', '2025-12-15 03:51:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1101, 463, 15, 'no', '2025-12-15 03:52:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1102, 409, 29, 'no', '2025-12-15 04:54:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1103, 374, 29, 'no', '2025-12-15 04:58:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1104, 464, 21, 'no', '2025-12-15 05:48:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1105, 465, 22, 'no', '2025-12-15 05:49:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1106, 466, 15, 'no', '2025-12-15 05:50:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1107, 467, 16, 'no', '2025-12-15 05:51:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1108, 468, 23, 'no', '2025-12-15 06:16:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1109, 469, 22, 'no', '2025-12-15 06:17:49', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1110, 470, 23, 'no', '2025-12-15 06:18:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1111, 471, 21, 'no', '2025-12-15 06:19:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1112, 472, 22, 'no', '2025-12-15 06:24:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1114, 474, 23, 'no', '2025-12-15 06:34:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1115, 475, 15, 'no', '2025-12-15 06:42:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1116, 476, 15, 'no', '2025-12-15 06:46:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1117, 477, 16, 'no', '2025-12-15 07:07:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1118, 478, 16, 'no', '2025-12-15 07:09:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1119, 479, 16, 'no', '2025-12-15 07:13:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1120, 480, 28, 'no', '2025-12-16 03:05:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1121, 481, 28, 'no', '2025-12-16 03:06:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1122, 482, 28, 'no', '2025-12-16 03:06:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1123, 483, 29, 'no', '2025-12-16 03:21:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1124, 484, 21, 'no', '2025-12-16 03:24:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1125, 485, 22, 'no', '2025-12-16 03:27:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1126, 486, 22, 'no', '2025-12-16 03:30:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1127, 487, 23, 'no', '2025-12-16 03:35:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1128, 488, 15, 'no', '2025-12-16 03:41:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1129, 489, 16, 'no', '2025-12-16 03:44:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1130, 490, 17, 'no', '2025-12-16 03:48:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1132, 492, 17, 'no', '2025-12-16 03:55:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1133, 493, 17, 'no', '2025-12-16 03:56:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1134, 494, 17, 'no', '2025-12-16 03:56:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1135, 495, 17, 'no', '2025-12-16 03:57:24', NULL);


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `class_teacher_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_4` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=496 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (371, 'DIPLOMA IN CIVIL ENGINEERING S23', 'no', '2025-12-16 03:20:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (372, 'DIPLOMA IN QUANTITY SURVEY J23', 'no', '2025-12-16 03:20:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (373, 'CERTIFICATE IN BUILDING TECHNOLOGY S23', 'no', '2025-12-16 03:19:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (374, 'ARTISAN IN PLUMBING S23', 'no', '2025-12-15 04:58:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (375, 'PLUMBING TECHNOLOGY LEVEL 4 S24', 'no', '2025-12-15 03:56:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (376, 'PLUMBING TECHNOLOGY LEVEL 5 J24', 'no', '2025-12-15 03:43:52', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (377, 'BUILDING TECHNICIAN LEVEL 5 J25', 'no', '2025-12-15 03:55:53', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (378, 'BUILDING TECHNICIAN LEVEL 6 J25', 'no', '2025-12-15 03:41:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (379, 'ARTISAN IN AUTOMOTIVE ENGINEERING S23', 'no', '2025-12-16 03:15:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (380, 'AUTOMOTIVE TECHNOLOGY LEVEL 4 J26', 'no', '2025-12-15 03:55:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (381, 'AUTOMOTIVE TECHNOLOGY LEVEL 5 J24', 'no', '2025-12-15 03:55:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (382, 'AUTOMOTIVE TECHNOLOGY LEVEL 6 J24', 'no', '2025-12-15 03:54:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (383, 'AUTO MECHANICS G3', 'no', '2025-12-13 10:16:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (384, 'AGRICULTURAL EXTENSION LEVEL 6', 'no', '2025-12-13 10:08:02', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (385, 'DIPLOMA IN GENERAL AGRICULTURE M23', 'no', '2025-12-16 03:19:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (386, 'SUSTAINABLE AGRI FOR RURAL LEVEL 5 J24', 'no', '2025-12-15 03:50:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (387, 'FOOD AND BEVERAGE PRODUCTION LEVEL 6 S25', 'no', '2025-12-15 03:53:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (388, 'FOOD AND BEVERAGE PRODUCTION LEVEL 5 J24', 'no', '2025-12-15 03:53:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (389, 'BAKING TECHNOLOGY LEVEL 5 M24', 'no', '2025-12-15 03:51:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (390, 'FOOD AND BEVERAGE PRODUCTION G3 S23', 'no', '2025-12-16 04:09:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (391, 'FOOD AND BEVERAGE PRODUCTION G2 S25', 'no', '2025-12-16 04:10:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (393, 'AUTO MECHANICS G2', 'no', '2025-12-13 10:16:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (395, 'WELDING AND FABRICATION G3', 'no', '2025-12-13 10:18:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (399, 'FASHION DESIGN LEVEL 5', 'no', '2025-12-13 10:20:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (400, 'FASHION DESIGN LEVEL 4 J25', 'no', '2025-12-15 03:52:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (401, 'FASHION DESIGN G3', 'no', '2025-12-13 10:21:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (402, 'FASHION DESIGN G2', 'no', '2025-12-13 10:22:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (404, 'BEAUTY TERAPHY LEVEL 6 J25', 'no', '2025-12-15 03:47:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (405, 'BEAUTY TERAPHY LEVEL 5 J25', 'no', '2025-12-15 03:29:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (406, 'BEAUTY THERAPY LEVEL 4 S24', 'no', '2025-12-15 03:30:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (409, 'BEAUTY THERAPY G3', 'no', '2025-12-15 03:28:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (410, 'HAIRDRESSING LEVEL 4 J25', 'no', '2025-12-15 03:26:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (414, 'HAIRDRESSING G2', 'no', '2025-12-13 10:32:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (415, 'HAIRDRESSING G3 S25', 'no', '2025-12-15 03:49:38', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (416, 'DIPLOMA IN BANKING AND FINANCE J23', 'no', '2025-12-16 03:18:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (417, 'BANKING AND FINANCE LEVEL 6 J24', 'no', '2025-12-15 03:50:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (418, 'BUSINESS MANAGEMENT LEVEL 6 M25', 'no', '2025-12-15 03:49:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (419, 'BUSINESS MANAGEMENT LEVEL 5 J25', 'no', '2025-12-15 03:49:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (420, 'OFFICE ADMINISTRATOR LEVEL 5 J25', 'no', '2025-12-15 03:48:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (421, 'DIPLOMA IN ICT M25', 'no', '2025-12-16 03:18:13', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (422, 'COMPUTER AND MOBILE PHONE REPAIR LEVEL 4 J25', 'no', '2025-12-15 03:48:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (423, 'ICT TECHNICIAN LEVEL 6 S24', 'no', '2025-12-15 03:48:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (424, 'ICT TECHNICIAN LEVEL 5 J25', 'no', '2025-12-15 03:47:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (425, 'ICT TECHNICIAN LEVEL 4 S25', 'no', '2025-12-15 03:47:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (426, 'ELECTRICAL INSTALLATION LEVEL 6 J25', 'no', '2025-12-15 03:46:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (427, 'CERTIFICATE IN ELECTRICAL ENGINEERING M23', 'no', '2025-12-16 03:18:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (428, 'ELECTRICAL INSTALLATION LEVEL 5 J24', 'no', '2025-12-15 03:46:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (429, 'ELECTRICAL INSTALLATION LEVEL 4 J24', 'no', '2025-12-15 03:45:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (430, 'COMPUTER PACKAGES J23', 'no', '2025-12-16 03:17:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (431, 'MOBILE PHONE REPAIR J25', 'no', '2025-12-16 03:17:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (432, 'CAKE BAKING AND DECORATION J25', 'no', '2025-12-16 03:16:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (433, 'CCTV INSTALLATION AND MANAGEMENT J25', 'no', '2025-12-15 02:57:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (434, 'GRAPHIC DESIGN J25', 'no', '2025-12-15 02:54:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (435, 'WEBSITE  DEVELOPMENT J26', 'no', '2025-12-15 03:52:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (436, 'CERTIFICATE IN CATERING AND ACCOMODATION S23', 'no', '2025-12-15 02:53:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (440, 'CERTIFIED PUBLIC ACCOUNTANT J23', 'no', '2025-12-15 02:53:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (441, 'ICT TECHNICIAN LEVEL 5 J23', 'no', '2025-12-15 02:52:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (445, 'CERTIFICATE IN ICT J23', 'no', '2025-12-15 02:52:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (446, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING J23', 'no', '2025-12-15 02:52:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (447, 'DIPLOMA IN PROJECT MANAGEMENT M23', 'no', '2025-12-15 02:51:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (448, 'DIPLOMA IN FASHION DESIGN S23', 'no', '2025-12-15 02:51:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (449, 'BAKING TECHNOLOGY M23', 'no', '2025-12-15 02:51:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (450, 'DIPLOMA IN CATERING AND ACCOMODATION S23', 'no', '2025-12-16 03:16:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (451, 'CERTIFICATE IN SECRETARIAL STUDIES S23', 'no', '2025-12-15 02:50:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (452, 'CERTIFICATE  IN BUSINESS MANAGEMENT S23', 'no', '2025-12-15 02:50:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (453, 'ARTISAN FOOD AND BEVERAGE S23', 'no', '2025-12-15 02:47:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (454, 'ARTISAN IN AUTOMOTIVE  ENGINEERING S23', 'no', '2025-12-15 02:50:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (455, 'GRAPHIC DESIGN M23', 'no', '2025-12-15 02:55:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (456, 'GRAPHIC DESIGN S23', 'no', '2025-12-15 02:55:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (457, 'GRAPHIC DESIGN J24', 'no', '2025-12-15 02:55:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (458, 'GRAPHIC DESIGN J23', 'no', '2025-12-15 02:56:53', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (459, 'HAIRDRESSING LEVEL 4 M25', 'no', '2025-12-15 03:26:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (460, 'BUILDING TECHNICIAN LEVEL 6 S25', 'no', '2025-12-15 03:42:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (461, 'PLUMBING TECHNOLOGY LEVEL 4 J25', 'no', '2025-12-15 03:45:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (462, 'SUSTAINABLE AGRI FOR RURAL LEVEL 5 S24', 'no', '2025-12-15 03:51:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (463, 'BANKING AND FINANCE LEVEL 6 J25', 'no', '2025-12-15 03:52:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (464, 'BEAUTY THERAPY G3 J24', 'no', '2025-12-15 05:48:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (465, 'BEAUTY THERAPY G3 M24', 'no', '2025-12-15 05:49:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (466, 'BEAUTY THERAPY G3 J25', 'no', '2025-12-15 05:50:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (467, 'HAIRDRESSING G3 M25', 'no', '2025-12-15 05:51:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (468, 'MASONRY LEVEL4 S24', 'no', '2025-12-15 06:16:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (469, 'ICT TECHNICIAN LEVEL5 M24', 'no', '2025-12-15 06:17:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (470, 'ELECTRICAL INSTALLATION LEVEL6 S24', 'no', '2025-12-15 06:18:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (471, 'ICT TECHNICIAN LEVEL 5 J24', 'no', '2025-12-15 06:19:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (472, 'ARTISAN IN FASHION AND DESIGN M24', 'no', '2025-12-16 03:15:44', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (474, 'ICT TECHNICIAN LEVEL 5 S24', 'no', '2025-12-15 06:34:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (475, 'WELDING LEVEL 4 J25', 'no', '2025-12-15 06:42:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (476, 'ELECTRICAL INSTALLATION LEVEL 4 J25', 'no', '2025-12-15 06:46:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (477, 'EIECTRICAL INSTALLATION GRADE 3 M25', 'no', '2025-12-15 07:07:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (478, 'BAKING TECHNOLOGY LEVEL 4 M25', 'no', '2025-12-15 07:09:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (479, 'ICT TECHNICIAN LEVEL 5 M25', 'no', '2025-12-15 07:13:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (480, 'ARTISAN IN PLUMBING M23', 'no', '2025-12-16 03:05:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (481, 'HAIR BEAUTY M23', 'no', '2025-12-16 03:06:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (482, 'COMPUTER PACKAGES M23', 'no', '2025-12-16 03:06:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (483, 'COMPUTER PACKAGES S23', 'no', '2025-12-16 03:21:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (484, 'COMPUTER PACKAGES J24', 'no', '2025-12-16 03:24:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (485, 'COMPUTER PACKAGES M24', 'no', '2025-12-16 03:27:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (486, 'AUTOMOTIVE TECHNICIAN LEVEL 6 M24', 'no', '2025-12-16 03:30:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (487, 'COMPUTER PACKAGES S24', 'no', '2025-12-16 03:35:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (488, 'COMPUTER PACKAGES J25', 'no', '2025-12-16 03:41:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (489, 'COMPUTER PACKAGES M25', 'no', '2025-12-16 03:44:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (490, 'COMPUTER PACKAGES S25', 'no', '2025-12-16 03:48:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (492, 'BEAUTY THERAPY LEVEL 5 S25', 'no', '2025-12-16 03:55:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (493, 'HAIRDRESSING LEVEL 5 S25', 'no', '2025-12-16 03:56:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (494, 'COMPUTER AND MOBILE PHONE REPAIR LEVEL 4 S25', 'no', '2025-12-16 03:56:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (495, 'ICT TECHNICIAN LEVEL 6 S25', 'no', '2025-12-16 03:57:24', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(255) NOT NULL,
  `source` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, 'Academic', 'PUBLIC', 'ERICK', '', '', '2025-01-10', 'NOISE FROM THE CHRISTIAN UNION INSTRUMENTS', 'REDUCTION OF THE INSTRUMENTS VOLUMES', 'KEN', '', NULL);


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Academic', '', '2025-01-10 02:21:06');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (2, 'Finance', '', '2025-01-10 02:21:16');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (3, 'External', '', '2025-01-10 02:21:26');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (4, 'Environment', '', '2025-01-10 02:21:47');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (5, 'Security', '', '2025-01-10 02:21:56');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (6, 'Staff', '', '2025-01-10 02:22:06');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (7, 'Other', '', '2025-01-10 02:22:18');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) DEFAULT NULL,
  `file` varchar(250) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `class_id` (`class_id`),
  KEY `cls_sec_id` (`cls_sec_id`),
  CONSTRAINT `contents_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_3` FOREIGN KEY (`cls_sec_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `base_price` varchar(10) NOT NULL DEFAULT '1',
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (1, 'AED', 'AED', 'AEDf', '1', 0, '2022-12-30 01:19:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (2, 'AFN', 'AFN', 'Ø‹', '1', 0, '2022-12-30 01:19:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (3, 'ALL', 'ALL', 'ALL', '1', 0, '2022-12-30 01:19:22');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (4, 'AMD', 'AMD', 'AMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (5, 'ANG', 'ANG', 'ANG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (6, 'AOA', 'AOA', 'AOA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (7, 'ARS', 'ARS', 'ARS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (8, 'AUD', 'AUD', 'AUD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (9, 'AWG', 'AWG', 'AWG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (10, 'AZN', 'AZN', 'AZN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (11, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (12, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (13, 'BDT', 'BDT', 'BDT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (14, 'BGN', 'BGN', 'BGN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (15, 'BHD', 'BHD', 'BHD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (16, 'BIF', 'BIF', 'BIF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (17, 'BMD', 'BMD', 'BMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (18, 'BND', 'BND', 'BND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (19, 'BOB', 'BOB', 'BOB', '1', 0, '2022-12-30 01:19:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (20, 'BOV', 'BOV', 'BOV', '1', 0, '2022-12-30 01:19:38');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (21, 'BRL', 'BRL', 'BRL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (22, 'BSD', 'BSD', 'BSD', '1', 0, '2022-12-30 01:19:40');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (23, 'BTN', 'BTN', 'BTN', '1', 0, '2022-12-30 01:19:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (24, 'BWP', 'BWP', 'BWP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (25, 'BYN', 'BYN', 'BYN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (26, 'BYR', 'BYR', 'BYR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (27, 'BZD', 'BZD', 'BZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (28, 'CAD', 'CAD', 'CAD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (29, 'CDF', 'CDF', 'CDF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (30, 'CHE', 'CHE', 'CHE', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (31, 'CHF', 'CHF', 'CHF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (32, 'CHW', 'CHW', 'CHW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (33, 'CLF', 'CLF', 'CLF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (34, 'CLP', 'CLP', 'CLP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (35, 'CNY', 'CNY', 'CNY', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (36, 'COP', 'COP', 'COP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (37, 'COU', 'COU', 'COU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (38, 'CRC', 'CRC', 'CRC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (39, 'CUC', 'CUC', 'CUC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (40, 'CUP', 'CUP', 'CUP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (41, 'CVE', 'CVE', 'CVE', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (42, 'CZK', 'CZK', 'CZK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (43, 'DJF', 'DJF', 'DJF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (44, 'DKK', 'DKK', 'DKK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (45, 'DOP', 'DOP', 'DOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (46, 'DZD', 'DZD', 'DZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (47, 'EGP', 'EGP', 'EGP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (48, 'ERN', 'ERN', 'ERN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (49, 'ETB', 'ETB', 'ETB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (50, 'EUR', 'EUR', 'â‚¬', '1', 0, '2022-12-30 01:20:25');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (51, 'FJD', 'FJD', 'FJD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (52, 'FKP', 'FKP', 'FKP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (53, 'GBP', 'GBP', 'Â£', '1', 0, '2022-12-30 01:20:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (54, 'GEL', 'GEL', 'GEL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (55, 'GHS', 'GHS', 'GHS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (56, 'GIP', 'GIP', 'GIP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (57, 'GMD', 'GMD', 'GMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (58, 'GNF', 'GNF', 'GNF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (59, 'GTQ', 'GTQ', 'GTQ', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (60, 'GYD', 'GYD', 'GYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (61, 'HKD', 'HKD', 'HKD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (62, 'HNL', 'HNL', 'HNL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (63, 'HRK', 'HRK', 'HRK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (64, 'HTG', 'HTG', 'HTG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (65, 'HUF', 'HUF', 'HUF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (66, 'IDR', 'IDR', 'IDR', '1', 0, '2022-12-30 01:20:34');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (67, 'ILS', 'ILS', 'ILS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (68, 'INR', 'INR', 'â‚¹', '1', 0, '2022-12-30 01:20:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (69, 'IQD', 'IQD', 'IQD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (70, 'IRR', 'IRR', 'IRR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (71, 'ISK', 'ISK', 'ISK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (72, 'JMD', 'JMD', 'JMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (73, 'JOD', 'JOD', 'JOD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (74, 'JPY', 'JPY', 'JPY', '1', 0, '2022-12-30 01:19:56');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (75, 'KES', 'KES', 'KES', '1', 1, '2025-01-09 06:19:03');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (76, 'KGS', 'KGS', 'KGS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (77, 'KHR', 'KHR', 'KHR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (78, 'KMF', 'KMF', 'KMF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (79, 'KPW', 'KPW', 'KPW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (80, 'KRW', 'KRW', 'KRW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (81, 'KWD', 'KWD', 'KWD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (82, 'KYD', 'KYD', 'KYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (83, 'KZT', 'KZT', 'KZT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (84, 'LAK', 'LAK', 'LAK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (85, 'LBP', 'LBP', 'LBP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (86, 'LKR', 'LKR', 'LKR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (87, 'LRD', 'LRD', 'LRD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (88, 'LSL', 'LSL', 'LSL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (89, 'LYD', 'LYD', 'LYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (90, 'MAD', 'MAD', 'MAD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (91, 'MDL', 'MDL', 'MDL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (92, 'MGA', 'MGA', 'MGA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (93, 'MKD', 'MKD', 'MKD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (94, 'MMK', 'MMK', 'MMK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (95, 'MNT', 'MNT', 'MNT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (96, 'MOP', 'MOP', 'MOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (97, 'MRO', 'MRO', 'MRO', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (98, 'MUR', 'MUR', 'MUR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (99, 'MVR', 'MVR', 'MVR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (100, 'MWK', 'MWK', 'MWK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (101, 'MXN', 'MXN', 'MXN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (102, 'MXV', 'MXV', 'MXV', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (103, 'MYR', 'MYR', 'MYR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (104, 'MZN', 'MZN', 'MZN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (105, 'NAD', 'NAD', 'NAD', '1', 0, '2022-07-30 05:32:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (106, 'NGN', 'NGN', 'NGN', '1', 0, '2022-12-30 01:20:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (107, 'NIO', 'NIO', 'NIO', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (108, 'NOK', 'NOK', 'NOK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (109, 'NPR', 'NPR', 'NPR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (110, 'NZD', 'NZD', 'NZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (111, 'OMR', 'OMR', 'OMR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (112, 'PAB', 'PAB', 'PAB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (113, 'PEN', 'PEN', 'PEN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (114, 'PGK', 'PGK', 'PGK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (115, 'PHP', 'PHP', 'PHP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (116, 'PKR', 'PKR', 'PKR', '1', 0, '2022-12-30 01:20:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (117, 'PLN', 'PLN', 'PLN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (118, 'PYG', 'PYG', 'PYG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (119, 'QAR', 'QAR', 'QAR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (120, 'RON', 'RON', 'RON', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (121, 'RSD', 'RSD', 'RSD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (122, 'RUB', 'RUB', 'RUB', '1', 0, '2022-12-30 01:20:16');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (123, 'RWF', 'RWF', 'RWF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (124, 'SAR', 'SAR', 'SAR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (125, 'SBD', 'SBD', 'SBD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (126, 'SCR', 'SCR', 'SCR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (127, 'SDG', 'SDG', 'SDG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (128, 'SEK', 'SEK', 'SEK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (129, 'SGD', 'SGD', 'SGD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (130, 'SHP', 'SHP', 'SHP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (131, 'SLL', 'SLL', 'SLL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (132, 'SOS', 'SOS', 'SOS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (133, 'SRD', 'SRD', 'SRD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (134, 'SSP', 'SSP', 'SSP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (135, 'STD', 'STD', 'STD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (136, 'SVC', 'SVC', 'SVC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (137, 'SYP', 'SYP', 'SYP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (138, 'SZL', 'SZL', 'SZL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (139, 'THB', 'THB', 'THB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (140, 'TJS', 'TJS', 'TJS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (141, 'TMT', 'TMT', 'TMT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (142, 'TND', 'TND', 'TND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (143, 'TOP', 'TOP', 'TOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (144, 'TRY', 'TRY', 'TRY', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (145, 'TTD', 'TTD', 'TTD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (146, 'TWD', 'TWD', 'TWD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (147, 'TZS', 'TZS', 'TZS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (148, 'UAH', 'UAH', 'UAH', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (149, 'UGX', 'UGX', 'UGX', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (150, 'USD', 'USD', '$', '1', 1, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (151, 'USN', 'USN', 'USN', '1', 0, '2022-12-30 01:20:03');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (152, 'UYI', 'UYI', 'UYI', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (153, 'UYU', 'UYU', 'UYU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (154, 'UZS', 'UZS', 'UZS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (155, 'VEF', 'VEF', 'VEF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (156, 'VND', 'VND', 'VND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (157, 'VUV', 'VUV', 'VUV', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (158, 'WST', 'WST', 'WST', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (159, 'XAF', 'XAF', 'XAF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (160, 'XAG', 'XAG', 'XAG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (161, 'XAU', 'XAU', 'XAU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (162, 'XBA', 'XBA', 'XBA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (163, 'XBB', 'XBB', 'XBB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (164, 'XBC', 'XBC', 'XBC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (165, 'XBD', 'XBD', 'XBD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (166, 'XCD', 'XCD', 'XCD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (167, 'XDR', 'XDR', 'XDR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (168, 'XOF', 'XOF', 'XOF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (169, 'XPD', 'XPD', 'XPD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (170, 'XPF', 'XPF', 'XPF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (171, 'XPT', 'XPT', 'XPT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (172, 'XSU', 'XSU', 'XSU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (173, 'XTS', 'XTS', 'XTS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (174, 'XUA', 'XUA', 'XUA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (175, 'XXX', 'XXX', 'XXX', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (176, 'YER', 'YER', 'YER', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (177, 'ZAR', 'ZAR', 'ZAR', '1', 0, '2022-12-30 01:20:07');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (178, 'ZMW', 'ZMW', 'ZMW', '1', 0, '2022-07-30 03:34:00');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (179, 'ZWL', 'ZWL', 'ZWL', '1', 0, '2022-07-22 06:55:15');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` text DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_belong_to` (`belong_to`),
  KEY `idx_type` (`type`),
  KEY `idx_visible_on_table` (`visible_on_table`),
  KEY `idx_weight` (`weight`),
  FULLTEXT KEY `idx_field_values` (`field_values`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: daily_assignment
#

DROP TABLE IF EXISTS `daily_assignment`;

CREATE TABLE `daily_assignment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `evaluation_date` date DEFAULT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  CONSTRAINT `daily_assignment_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_2` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_3` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'ADMINISTRATION', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'FINANCE', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'SECURITY', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (4, 'SUPPORT ', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (5, 'ACADEMIC', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (6, 'HOSTEL', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (7, 'ICT', 'yes');


#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: email_attachments
#

DROP TABLE IF EXISTS `email_attachments`;

CREATE TABLE `email_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `directory` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `attachment_name` varchar(200) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_attachments` (`id`, `message_id`, `directory`, `attachment`, `attachment_name`, `created_at`) VALUES (1, 18, 'uploads/communicate/email_attachments/', '1765889148605.jpeg', 'FARMLET LOGO.jpeg', '2025-12-16 07:45:51');
INSERT INTO `email_attachments` (`id`, `message_id`, `directory`, `attachment`, `attachment_name`, `created_at`) VALUES (2, 19, 'uploads/communicate/email_template_images/', '1765960627988.jpg', 'pamoja_All roads.jpg', '2025-12-17 03:42:02');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `api_key`, `api_secret`, `region`, `is_active`, `created_at`) VALUES (1, 'smtp', 'mail.pamojatechnical.ac.ke', '587', 'info@pamojatechnical.ac.ke', 'Letting_8845', 'tls', 'true', '', '', '', 'yes', '2025-12-16 07:41:16');


#
# TABLE STRUCTURE FOR: email_template
#

DROP TABLE IF EXISTS `email_template`;

CREATE TABLE `email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_template` (`id`, `title`, `message`, `created_at`) VALUES (1, 'ADMISSIONS', '<p>Admissions for the January 2026 intake at Pamoja Technical  College  are now open. Apply online via https://mis.pamojattc.ac.ke/online_admission<br>\r\n.</p>', '2025-12-17');


#
# TABLE STRUCTURE FOR: email_template_attachment
#

DROP TABLE IF EXISTS `email_template_attachment`;

CREATE TABLE `email_template_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_template_id` int(11) NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `attachment_name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_template_attachment` (`id`, `email_template_id`, `attachment`, `attachment_name`) VALUES (1, 1, '1765960627988.jpg', 'pamoja_All roads.jpg');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` text NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `assigned` (`assigned`),
  KEY `enquiry_ibfk_4` (`class_id`),
  CONSTRAINT `enquiry_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_3` FOREIGN KEY (`assigned`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_4` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (1, 'STUDENTS ORIENTATION', '', '2025-02-14 00:00:00', '2025-02-14 00:00:00', 'task', '#000', '1', 7, 'no');


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_students`;

CREATE TABLE `exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` int(6) DEFAULT NULL,
  `teacher_remark` text DEFAULT NULL,
  `rank` int(20) NOT NULL DEFAULT 0,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=348 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_subjects`;

CREATE TABLE `exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(10) NOT NULL,
  `date_from` date NOT NULL,
  `time_from` time NOT NULL,
  `duration` varchar(50) NOT NULL,
  `room_no` varchar(100) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT 0.00,
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=455 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 823, '2025-02-11', '11:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 824, '2025-02-13', '09:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (8, 1, 825, '2025-02-13', '12:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (12, 27, 826, '2025-02-10', '01:30:00', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (13, 27, 828, '2025-02-12', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (14, 27, 827, '2025-02-12', '10:00:00', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (15, 27, 468, '2025-02-24', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:06:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (16, 24, 806, '2025-02-10', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (17, 24, 807, '2025-02-14', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (18, 24, 812, '2025-02-10', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (21, 36, 442, '2025-02-14', '08:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:50:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (25, 36, 392, '2025-02-10', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:54:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (26, 33, 439, '2025-02-13', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (28, 33, 397, '2025-02-14', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (31, 33, 381, '2025-02-12', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (32, 33, 375, '2025-02-13', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (33, 42, 439, '2025-02-13', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (37, 42, 364, '2025-02-12', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (38, 42, 397, '2025-02-21', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (39, 42, 445, '2025-02-12', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (40, 42, 444, '2025-02-20', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (41, 39, 403, '2025-02-12', '01:30:00', '01', 'C-WASH', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:00:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (42, 45, 520, '2025-02-12', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (43, 45, 538, '2025-02-13', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (46, 45, 532, '2025-02-12', '01:30:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (47, 45, 558, '2025-02-14', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (49, 48, 522, '2025-02-13', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (51, 48, 520, '2025-02-12', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (52, 48, 525, '2025-02-21', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (54, 51, 17, '2025-02-14', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (59, 54, 335, '2025-02-13', '10:30:00', '01', 'KI', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (60, 54, 331, '2025-02-11', '08:00:00', '01', 'KI', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (61, 54, 324, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (62, 54, 321, '2025-02-10', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (63, 54, 318, '2025-02-11', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (64, 54, 322, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (67, 57, 419, '2025-02-14', '08:00:00', '01', 'E WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (68, 57, 407, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (74, 60, 49, '2025-02-21', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (75, 60, 53, '2025-02-14', '01:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (77, 63, 127, '2025-02-11', '03:35:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (83, 66, 472, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (84, 66, 490, '2025-02-12', '08:00:00', '01', 'E WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (87, 75, 51, '2025-02-13', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (94, 75, 45, '2025-02-11', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (97, 78, 76, '2025-02-13', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (100, 78, 45, '2025-02-11', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (104, 70, 297, '2025-02-14', '01:30:00', '01', 'AUT WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (105, 70, 264, '2025-02-13', '10:30:00', '01', '2FL H4', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (107, 70, 313, '2025-02-12', '03:35:00', '01', 'AUT WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (109, 84, 50, '2025-02-11', '08:00:00', '01', 'PL WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (111, 84, 76, '2025-02-13', '01:35:00', '01', 'PL WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (118, 72, 257, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (119, 72, 261, '2025-02-10', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (120, 72, 264, '2025-02-13', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (121, 72, 266, '2025-02-14', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 07:57:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (122, 72, 220, '2025-02-13', '03:35:00', '01', 'TD RM', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (123, 63, 781, '2025-02-06', '10:19:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (124, 63, 782, '2025-02-08', '10:19:05', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (128, 81, 104, '2025-02-06', '12:26:48', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (130, 81, 107, '2025-02-06', '12:35:07', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (134, 81, 108, '2025-02-28', '12:44:35', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 05:03:56', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (136, 69, 240, '2025-02-06', '13:55:19', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (138, 69, 837, '2025-02-28', '14:14:53', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (141, 69, 41, '2025-02-28', '14:15:43', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (142, 69, 834, '2025-02-28', '14:15:45', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (143, 69, 174, '2025-02-28', '14:21:03', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (156, 18, 620, '2025-02-28', '15:38:25', '1', 'LAB1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (157, 15, 521, '2025-02-28', '15:51:33', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (160, 15, 523, '2025-02-28', '15:54:11', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (163, 15, 625, '2025-02-28', '15:57:54', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (166, 30, 375, '2025-02-28', '16:41:51', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (167, 30, 397, '2025-02-28', '16:43:33', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (170, 6, 84, '2025-02-28', '16:59:31', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (171, 6, 104, '2025-02-28', '16:59:33', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (172, 6, 107, '2025-02-28', '16:59:35', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (174, 6, 319, '2025-02-28', '16:59:39', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (176, 4, 771, '2025-02-28', '17:13:38', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (177, 4, 750, '2025-02-28', '17:13:40', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (178, 4, 748, '2025-02-28', '17:13:42', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (179, 4, 747, '2025-02-28', '17:13:44', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (180, 4, 744, '2025-02-28', '17:13:46', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (181, 4, 753, '2025-02-28', '17:13:49', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (182, 4, 745, '2025-02-28', '17:13:51', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (183, 4, 746, '2025-02-28', '17:13:53', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (184, 4, 752, '2025-02-28', '17:14:00', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (185, 4, 749, '2025-02-28', '17:14:03', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (186, 4, 742, '2025-02-28', '17:14:06', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (187, 4, 741, '2025-02-28', '17:14:09', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (188, 4, 743, '2025-02-28', '17:14:13', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (190, 87, 763, '2025-02-28', '17:21:53', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (191, 87, 754, '2025-02-28', '17:21:56', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (192, 87, 756, '2025-02-28', '17:21:58', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (193, 87, 762, '2025-02-28', '17:22:00', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (194, 87, 741, '2025-02-28', '17:22:03', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (195, 87, 758, '2025-02-28', '17:22:05', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (196, 89, 793, '2025-02-28', '17:40:43', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (197, 89, 790, '2025-02-28', '17:40:45', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (199, 89, 792, '2025-02-28', '17:40:49', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (200, 89, 791, '2025-02-28', '17:40:56', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (201, 89, 789, '2025-02-28', '17:40:58', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (202, 89, 787, '2025-02-28', '17:41:02', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (203, 89, 788, '2025-02-28', '17:41:06', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (204, 89, 838, '2025-02-28', '17:41:08', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (205, 93, 818, '2025-03-03', '15:20:41', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (206, 93, 817, '2025-03-03', '15:20:45', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (207, 93, 815, '2025-03-05', '15:20:49', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (208, 93, 819, '2025-03-06', '15:20:53', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (209, 66, 313, '2025-02-12', '03:35:00', '01', '2fl h4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 02:36:41', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (210, 72, 849, '2025-02-14', '01:30:00', '01', 'AUT WSH', '30.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:01:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (211, 72, 240, '2025-02-11', '08:00:00', '01', 'AUT WSH', '30.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:01:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (212, 57, 415, '2025-02-12', '03:30:00', '1', '2\\FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 08:02:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (216, 2, 823, '2025-03-20', '11:45:08', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (219, 2, 825, '2025-03-20', '11:47:24', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (220, 2, 824, '2025-03-13', '11:48:25', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (221, 5, 751, '2025-03-12', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (222, 5, 741, '2025-03-13', '09:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (223, 5, 748, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (224, 5, 744, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (225, 5, 753, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (226, 5, 745, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (227, 5, 746, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (228, 5, 752, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (229, 5, 749, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (230, 5, 750, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (231, 5, 743, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (232, 5, 747, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (233, 5, 742, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (239, 16, 620, '2025-03-14', '11:54:21', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (240, 16, 524, '2025-03-21', '11:00:23', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (241, 16, 523, '2025-03-17', '08:30:27', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (242, 16, 740, '2025-03-19', '13:54:30', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (243, 88, 756, '2025-03-12', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (244, 88, 758, '2025-03-13', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (246, 88, 754, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (247, 88, 755, '2025-03-18', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (248, 88, 757, '2025-03-19', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (253, 82, 107, '2025-03-21', '08:30:00', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (256, 82, 108, '2025-03-18', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (258, 82, 237, '2025-03-21', '10:30:25', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 06:48:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (262, 76, 69, '2025-03-19', '08:30:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:30:02', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (265, 76, 51, '2025-03-19', '13:38:15', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (274, 73, 837, '2025-03-21', '14:30:00', '2', 'H4', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (278, 46, 520, '2025-03-20', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (280, 46, 522, '2025-03-19', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (281, 46, 525, '2025-03-20', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (282, 94, 818, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (283, 94, 819, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (284, 94, 817, '2025-03-14', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (288, 44, 832, '2025-03-20', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (291, 44, 399, '2025-03-18', '02:00:00', '2', 'MASSAGE ROOM', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (292, 44, 375, '2025-03-19', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (293, 44, 397, '2025-03-19', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (294, 37, 766, '2025-03-17', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (297, 37, 399, '2025-03-18', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (299, 37, 398, '2025-03-19', '03:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (302, 37, 375, '2025-03-21', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (303, 90, 790, '2025-03-13', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (304, 90, 793, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (305, 90, 788, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (306, 90, 787, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (307, 90, 789, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (308, 90, 791, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (309, 90, 792, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (315, 25, 484, '2025-03-20', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (316, 25, 482, '2025-03-21', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (317, 25, 826, '2025-03-20', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (321, 19, 623, '2025-03-20', '08:30:11', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (325, 19, 620, '2025-03-21', '10:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (328, 7, 107, '2025-03-14', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (331, 7, 108, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (333, 7, 104, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (336, 58, 127, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (339, 58, 90, '2025-03-18', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (342, 79, 50, '2025-03-18', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (346, 79, 51, '2025-03-20', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (352, 64, 781, '2025-03-15', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (353, 64, 771, '2025-03-17', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (354, 64, 782, '2025-03-19', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (355, 73, 849, '2025-03-18', '10:00:00', '2', 'WSHP', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (359, 34, 381, '2025-03-13', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (362, 34, 375, '2025-03-18', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (363, 34, 832, '2025-03-19', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (364, 34, 397, '2025-03-19', '09:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (367, 49, 520, '2025-03-20', '08:00:00', '2', 'WKSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (368, 49, 522, '2025-03-21', '08:00:00', '2', 'WSPHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (369, 49, 525, '2025-03-17', '08:00:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (373, 85, 141, '2025-03-19', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (376, 85, 51, '2025-03-20', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (377, 85, 45, '2025-03-20', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (383, 28, 807, '2025-03-17', '02:00:00', '2', 'HF1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (384, 28, 806, '2025-03-20', '02:00:00', '2', 'GF', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (385, 28, 812, '2025-03-21', '02:00:00', '2', 'GF', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (386, 19, 651, '2025-03-18', '10:00:00', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:27:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (387, 101, 800, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (388, 101, 801, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (389, 101, 803, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (390, 101, 802, '2025-03-21', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (393, 31, 381, '2025-03-19', '12:30:00', '2', 'BODY MASSAGE', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (394, 31, 375, '2025-03-20', '01:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (395, 31, 397, '2025-03-21', '03:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (396, 31, 832, '2025-03-21', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (402, 61, 53, '2025-03-18', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (403, 61, 49, '2025-03-20', '02:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (406, 104, 350, '2025-03-27', '11:17:17', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (408, 104, 107, '2025-03-27', '11:17:21', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (410, 104, 108, '2025-03-27', '11:17:25', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (416, 105, 107, '2025-03-27', '11:21:42', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (417, 105, 108, '2025-03-27', '11:21:42', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (418, 105, 104, '2025-03-27', '11:21:43', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (424, 52, 17, '2025-03-18', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (425, 52, 820, '2025-03-19', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (428, 106, 381, '2025-02-10', '08:00:00', '01', 'BEATY WORKSHOP', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (429, 106, 397, '2025-03-11', '08:00:00', '01', 'BEATU WORKSHOP', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (434, 70, 769, '2025-02-10', '14:00:00', '01', 'WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (435, 70, 295, '2025-02-11', '14:30:00', '01', 'TDR', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (436, 67, 41, '2025-03-11', '08:00:00', '2.0', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (437, 58, 41, '2025-03-14', '14:00:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 04:34:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (438, 67, 707, '2025-03-11', '08:00:00', '2.0', 'TDR', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (439, 67, 329, '2025-03-11', '10:30:00', '2.0', 'E.WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (440, 67, 90, '2025-03-11', '01:30:00', '2.0', 'E.WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (441, 82, 768, '2025-03-21', '14:00:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 06:48:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (442, 108, 165, '2025-03-11', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (443, 108, 174, '2025-03-14', '10:30:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (444, 108, 171, '2025-03-15', '01:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (445, 108, 240, '2025-03-17', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (451, 107, 832, '2025-03-18', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (452, 107, 397, '2025-03-19', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (453, 107, 377, '2025-03-20', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (454, 107, 375, '2025-03-20', '14:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `exam_group_class_batch_exams`;

CREATE TABLE `exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(250) DEFAULT NULL,
  `passing_percentage` float(10,2) DEFAULT NULL,
  `session_id` int(10) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `exam_group_id` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(1) NOT NULL DEFAULT 1,
  `is_publish` int(1) DEFAULT 0,
  `is_rank_generated` int(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_ibfk_2` (`session_id`),
  CONSTRAINT `exam_group_class_batch_exams_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exams_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'CDACC FORMATIVE EXAM BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 1, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-22 06:23:20', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'CDACC SUMMATIVE EXAM BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:11:12', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'CDACC PRACTICAL ASSESSMENT BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:11:22', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'CAT-DCE/S/23', '50.00', 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-12-14 10:08:53', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'END TERM-DCE/S/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:50:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'CDACC FORMATIVE EXAM BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 17:21:28', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'CDACC SUMATTIVE  EXAM BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 17:21:44', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'CDACC PRACTICAL ASSESSMENT BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 17:22:00', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'MS WORD', NULL, 20, NULL, NULL, 3, 1, 0, 0, 'Microsoft Word Examination', 1, '2025-02-21 12:59:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'COMMUNICATION SKILLS', NULL, 20, NULL, NULL, 3, 1, 1, 1, 'COMM SKILLS', 1, '2025-02-21 14:45:39', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'MS EXCEL', NULL, 20, NULL, NULL, 3, 1, 1, 0, 'Microsoft Excel', 1, '2025-02-21 14:17:40', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'CDACC FORMATIVE EXAM CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:13:54', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'CDACC SUMMATIVE EXAM CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam\r\n', 1, '2025-02-28 01:14:38', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'CDACC PRACTICAL ASSESSMENT CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:23:38', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'CDACC FORMATIVE EXAM ITECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:14:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'CDACC SUMMATIVE EXAM ITECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:15:31', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'CDACC PRACTICAL ASSESSMENT ITECH 5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:23:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'CDACC FORMATIVE EXAM ITECH6 /S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:37:32', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'CDACC SUMMATIVE EXAM ITECH6/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:37:47', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'CDACC PRACTICAL ASSESSMENT ITECH6 /S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-28 01:38:06', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'CDACC FORMATIVE EXAM ADM5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:16:13', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'CDACC SUMMATIVE EXAM BM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:16:29', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'CDACC PRACTICAL ASSESSMENTBM5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:21:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'CDACC FORMATIVE EXAM BM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 17:20:31', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'CDACC SUMMATIVE EXAM ADM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:19:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'CDACC PRACTICAL ASSESSMENT ADM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:21:17', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'CDACC FORMATIVE EXAM BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:16:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CDACC SUMMATIVE EXAM BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-03-24 09:46:02', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'CDACC PRACTICAL ASSESSMENT BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:20:54', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'CDACC FORMATIVE EXAM BT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:17:04', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'CDACC SUMMATIVE EXAM BT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam\r\n', 1, '2025-02-28 01:17:42', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'CDACC PRACTICAL ASSESSMENT BT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 07:55:12', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'CDAAC FORMATIVE EXAM BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 06:20:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'CDACC SUMMATIVE EXAm BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:17:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'CDACC PRACTICAL ASSESSMENT BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:20:03', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'CDACC FORMATIVE EXAM HBT M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:17:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'CDAAC SUMMATIVE EXAM HBT/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:19:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'CDACC PRACTICAL ASSESSMENT HBT/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:19:42', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'CDACC FORMATIVE EXAM BT6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:11', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'CDACC PRACTICAL ASSESSMENT BT6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:19:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'CDACC SUMMATIVE EXAM BT6/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-28 01:18:45', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'CDACC FORMATIVE EXAM FDT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'CDACC SUMMATIVE EXAM FDT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:19', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'CDACC PRACTICAL ASSESSMENT FDT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'CDACC FORMATIVE EXAM FDT4/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'CDACC SUMMATIVE EXAM FDT4 /25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:27:18', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'CDACC PRACTICAL ASSESSMENT FDT4 /J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'CDACC FORMATIVE EXAM SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:19:53', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'CDACC SUMMATIVE EXAM SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:34', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'CDACC PRACTICAL ASSESSMENT SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:16:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'CDACC FORMATIVE EXAM BAKE4/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:03', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'CDACC FORMATIVE EXAM BAKE4/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'CDACC PRACTICAL ASSESSMENT BAKE4/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:09', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'CDACC FORMATIVE EXAM EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:27:04', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'CDACC SUMMATIVE EXAM EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:21:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'CDACC PRACTICAL ASSESSMENT EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:16', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'CDACC FORMATIVE EXAM AGR.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:21:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'CDACC SUMMATIVE EXAM AGRI.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:26:16', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'CDACC PRACTICAL ASSESSMENT AGRI.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:17:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'CDACC FORMATIVE EXAM WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:17', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'CDACC SUMMATIVE EXAM WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:23:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'CDACC PRACTICAL ASSESSMENT WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'CDACC FORMATIVE EXAM EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'CDACC SUMMATIVE EXAM EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:22:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'CDACC PRACTICAL ASSESSMENT EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:15:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'CDACC FORMATIVE EXAM AUTO6/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:02', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'CDACC SUMMATIVE EXAM AUTO6/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:24:08', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'CDACC PRACTICAL ASSESSMENT AUTO6/MS24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:17:21', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'CDACC FORMATIVE EXAM AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'CDACC SUMMATIVE EXAM AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:26:45', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'CDACC PRACTICAL ASSESSMENT AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:40', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'CDACC FORMATIVE EXAM PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:26', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'CDACC SUMMATIVE EXAM PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:23:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'CDACC PRACTICAL ASSESSMENT PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'CDACC FORMATIVE EXAM PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:24:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'CDACC SUMMATIVE EXAM PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:24:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'CDACC PRACTICAL ASSESSMENT PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'CDACC FORMATIVE EXAM BTECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:25:19', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'CDACC SUMMATIVE EXAM BTECH5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:25:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'CDACC PRACTICAL ASSESSMENT BTECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:13:07', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'CDACC FORMATIVE EXAM PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:25:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'CDACC SUMMATIVE EXAM PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:15:56', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'CDACC PRACTICAL ASSESSMENT PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:13:21', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'CAT-CBTS23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:20', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'END TERM-CBTS23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:52', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'CAT-CEEM23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:30', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'END TERM-CEEM23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:41', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'CAT CAE-J-23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:53', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'END TERM CAE-J-23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:50:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'CAT-CCA/S/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 07:13:06', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'END TERM EXAM-CCA/S23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 07:13:24', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'CDACC FORMATIVE EXAM AUTO 6/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:34:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'CDACC SUMMATIVE EXAM BAKE4/M/24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:35:57', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'CDACC SUMMATIVE EXAM ADM5/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:36:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'CDACC FORMATIVE EXAM- HD4/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:39:52', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'CDACC SUMMATIVE EXAM-HD4/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:39:36', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'CAT-DPM/M/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:22', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'ENDTERM-DPM/M/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:13', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'END TERM- BTG3/J/25', NULL, 20, NULL, NULL, 4, 1, 1, 0, '', 1, '2025-03-24 09:54:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'END TERM- BTG3/J/25', NULL, 20, NULL, NULL, 4, 1, 1, 0, '', 1, '2025-03-24 09:54:48', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'CDACC FORMATIVE EXAM- BTECH6/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-27 04:12:01', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'CDACC SUMMATIVE-BTECH6/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-27 04:12:35', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'CDAAC FORMATIVE EXAM BT4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-03-27 05:06:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'CDAAC SUMMATIVE EXAM BT4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-03-27 05:06:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'AUTO6\\S\\24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-05-06 07:00:16', NULL);


#
# TABLE STRUCTURE FOR: exam_group_exam_connections
#

DROP TABLE IF EXISTS `exam_group_exam_connections`;

CREATE TABLE `exam_group_exam_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `exam_weightage` float(10,2) DEFAULT 0.00,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  CONSTRAINT `exam_group_exam_connections_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_connections_ibfk_2` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_exam_results
#

DROP TABLE IF EXISTS `exam_group_exam_results`;

CREATE TABLE `exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) DEFAULT NULL,
  `exam_group_student_id` int(11) DEFAULT NULL,
  `attendence` varchar(10) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  CONSTRAINT `exam_group_exam_results_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_subject_id`) REFERENCES `exam_group_class_batch_exam_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_2` FOREIGN KEY (`exam_group_student_id`) REFERENCES `exam_group_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_3` FOREIGN KEY (`exam_group_class_batch_exam_student_id`) REFERENCES `exam_group_class_batch_exam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=569 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_students
#

DROP TABLE IF EXISTS `exam_group_students`;

CREATE TABLE `exam_group_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `student_session_id` int(10) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_students_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_groups
#

DROP TABLE IF EXISTS `exam_groups`;

CREATE TABLE `exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `exam_type` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'TVET-CDACC', 'coll_grade_system', 'The student is either Master, Competent or not yet competent.', 0, '2025-12-14 09:04:14', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'KNEC', 'average_passing', 'Exam results used for the registration of KNEC exam', 0, '2025-12-14 09:04:29', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'COMPUTER PACKAGES', 'coll_grade_system', 'College Based', 0, '2025-02-28 06:20:22', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'NITA EXAMS', 'coll_grade_system', '', 0, '2025-03-24 09:54:07', NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `teacher_subject_id` int(11) DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int(11) DEFAULT NULL,
  `passing_marks` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`),
  KEY `session_id` (`session_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `exam_schedules_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_schedules_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sesion_id` (`sesion_id`),
  CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`sesion_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'LECTURERS SALARIES', 'PTTC/F/E/SA/001', 'yes', 'no', '2025-01-27 06:37:23', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'MONTHLY OPERATIONS', 'PTTC/F/E/MO/001', 'yes', 'no', '2025-02-19 04:16:07', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'WAGES', 'PTTC/F/E/WAG/001', 'yes', 'no', '2025-01-27 06:40:19', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'STAFF SUBSITIARY AND TRAVEL', 'PTTC/F/E/SST/001', 'yes', 'no', '2025-01-27 06:41:12', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 'GENERATOR FUEL', 'PTTC/F/E/FU/001', 'yes', 'no', '2025-01-27 06:41:56', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 'REPAIRS', 'PTTC/F/E/R/001\r\n', 'yes', 'no', '2025-01-27 06:45:42', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 'SECURITY', 'PTTC/F/E/SEC/001', 'yes', 'no', '2025-01-27 06:45:56', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 'CONSULTANCY', 'PTTC/F/E/CO/001', 'yes', 'no', '2025-01-27 06:46:50', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 'LEGAL FEES', 'PTTC/F/E/LE/001', 'yes', 'no', '2025-01-27 06:47:06', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (10, 'BANK CHARGES', 'PTTC/F/E/BK/001', 'yes', 'no', '2025-01-27 06:47:19', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (11, 'LICENCES', 'PTTC/F/E/LC/001', 'yes', 'no', '2025-01-27 06:47:36', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (12, 'STATIONERY', 'PTTC/F/E/STA/001', 'yes', 'no', '2025-01-27 06:47:54', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (13, 'TELEPHONE AND POSTAGE', 'PTTC/F/E/TP/001', 'yes', 'no', '2025-01-27 06:48:18', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (14, 'RENT AND RATES PROVISION', 'PTTC/F/E/RR/001', 'yes', 'no', '2025-01-27 06:48:36', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (15, 'ADVERTISEMENT', 'PTTC/F/E/ADV/001', 'yes', 'no', '2025-01-27 06:48:53', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (16, 'TAXATION', 'PTTC/F/E/TAX/001', 'yes', 'no', '2025-01-27 06:49:08', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (17, 'STUDENT WELFARE', 'PTTC/F/E/SW/001', 'yes', 'no', '2025-02-19 04:16:43', NULL);


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 1, 'LECTURERS SALARIES', '', '2025-01-31', '149500.00', NULL, '', 'yes', 'no', '2025-02-19 04:14:58', NULL);


#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (2, 'TUITION FEE YEAR 1 SEMESTER 1', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:32:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (3, 'ADMISSION FEE', 0, 'Payable once for all long courses', 'no', '2025-01-26 10:39:46');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (4, 'JANUARY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:28');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (5, 'COMPUTER PACKAGES', 0, 'Applicable to all computer students', 'no', '2025-01-26 03:29:52');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (6, 'CCTV MANAGEMENT COURSE', 0, 'Payment for the short course ', 'no', '2025-01-26 10:41:15');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (7, 'MOBILE PHONE REPAIR', 0, 'Payment for the short course ', 'no', '2025-01-26 10:41:33');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (8, 'CAKE BAKING  ', 0, 'Payment for the short course', 'no', '2025-01-26 10:43:57');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (9, 'GRAPHIC DESIGN', 0, 'Payment for the short course ', 'no', '2025-01-26 10:42:07');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (10, 'PHOTOGRAPHY', 0, 'Payment for the short course ', 'no', '2025-01-26 10:42:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (11, 'ELECTRONIC REPAIR (RADIO AND TV)', 0, 'Payment for the short course ', 'no', '2025-01-26 10:43:00');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (12, 'COMPUTER AIDED DESIGN', 0, 'Payment for the short course ', 'no', '2025-01-26 10:43:26');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (13, 'FEBRUARY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (14, 'MARCH HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:56');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (15, 'APRIL HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:11');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (16, 'MAY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (17, 'JUNE HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:34');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (18, 'JULY HOSTEL FEEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:00');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (19, 'AUGUST HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:18');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (20, 'SEPTEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:31');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (21, 'OCTOBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (22, 'NOVEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:58');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (23, 'DECEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:52:14');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (24, 'TUITION FEE YEAR 1 SEMESTER 2', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:32:40');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (25, 'TUITION FEE YEAR 1 SEMESTER 3', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:32:55');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (26, 'TUITION FEE YEAR 2 SEMESTER 1', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:05');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (27, 'TUITION FEE YEAR 2 SEMESTER 2', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:14');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (28, 'TUITION FEE YEAR 3 SEMESTER 1', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:23');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (29, 'TUITION FEE YEAR 3 SEMESTER 2', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:32');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (30, 'TUITION FEE YEAR 3 SEMESTER 3', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:40');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (31, 'TUITION FEE YEAR 2 SEMESTER 3', 0, 'Payable once per term for all regular courses', 'no', '2025-12-12 10:33:50');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (32, 'Balance Master', 1, NULL, 'no', '2025-12-14 09:12:25');


#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `fee_groups_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `fine_type` varchar(50) NOT NULL DEFAULT 'none',
  `due_date` date DEFAULT NULL,
  `fine_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `fine_amount` float(10,2) NOT NULL DEFAULT 0.00,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_groups_feetype_ibfk_1` FOREIGN KEY (`fee_session_group_id`) REFERENCES `fee_session_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_2` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_3` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (1, 1, 3, 1, 20, '1500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-23 02:14:46');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (2, 2, 2, 2, 20, '16000.00', 'none', '2025-03-13', '0.00', '0.00', 'no', '2025-01-23 02:15:11');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (3, 3, 5, 3, 20, '3500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-27 06:30:50');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (4, 4, 4, 12, 20, '3500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:44:39');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (5, 5, 6, 4, 20, '25000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:45:07');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (6, 6, 7, 6, 20, '30000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:45:41');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (7, 7, 8, 7, 20, '20000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:46:09');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (8, 8, 10, 9, 20, '25000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:46:37');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (9, 9, 11, 10, 20, '30000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:47:20');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (10, 10, 12, 11, 20, '20000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:48:18');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (23, 11, 13, 13, 20, '3500.00', 'none', '2025-02-10', '0.00', '0.00', 'no', '2025-01-27 07:54:00');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (24, 12, 14, 15, 20, '3500.00', 'none', '2025-03-10', '0.00', '0.00', 'no', '2025-01-27 07:54:21');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (25, 13, 15, 15, 20, '3500.00', 'none', '2025-04-10', '0.00', '0.00', 'no', '2025-01-27 07:54:46');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (26, 14, 16, 16, 20, '3500.00', 'none', '2025-05-10', '0.00', '0.00', 'no', '2025-01-27 07:55:17');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (27, 15, 17, 17, 20, '3500.00', 'none', '2025-06-10', '0.00', '0.00', 'no', '2025-01-27 07:55:52');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (28, 16, 18, 18, 20, '3500.00', 'none', '2025-07-10', '0.00', '0.00', 'no', '2025-01-27 07:56:18');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (29, 17, 19, 19, 20, '3500.00', 'none', '2025-08-10', '0.00', '0.00', 'no', '2025-01-27 07:56:44');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (30, 18, 20, 20, 20, '3500.00', 'none', '2025-09-10', '0.00', '0.00', 'no', '2025-01-27 07:57:15');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (31, 19, 21, 21, 20, '3500.00', 'none', '2025-10-10', '0.00', '0.00', 'no', '2025-01-27 07:58:00');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (32, 20, 22, 22, 20, '3500.00', 'none', '2025-11-10', '0.00', '0.00', 'no', '2025-01-27 07:58:31');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (33, 21, 23, 23, 20, '3500.00', 'none', '2025-12-10', '0.00', '0.00', 'no', '2025-01-27 07:58:59');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (34, 22, 24, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:09:47');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (35, 23, 25, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:10:14');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (36, 24, 26, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:10:46');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (37, 25, 27, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:11:02');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (38, 26, 28, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:11:21');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (39, 27, 30, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:11:39');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (40, 28, 31, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:12:19');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (41, 29, 29, 2, 20, '16000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-12-01 04:13:05');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (42, 30, 2, 2, 18, '14000.00', 'none', '2023-03-03', '0.00', '0.00', 'no', '2025-12-14 08:00:35');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (43, 31, 3, 1, 18, '1500.00', 'none', '2023-02-01', '0.00', '0.00', 'no', '2025-12-14 08:01:20');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (44, 32, 24, 2, 18, '14000.00', 'none', '2023-03-01', '0.00', '0.00', 'no', '2025-12-14 08:10:01');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (45, 33, 25, 2, 18, '14000.00', 'none', '2023-06-01', '0.00', '0.00', 'no', '2025-12-14 08:11:01');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (47, 35, 3, 1, 29, '1500.00', 'none', '2023-09-09', '0.00', '0.00', 'no', '2025-12-14 08:17:24');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (48, 36, 2, 2, 29, '14000.00', 'none', '2023-10-05', '0.00', '0.00', 'no', '2025-12-14 08:18:53');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (49, 37, 20, 20, 29, '3500.00', 'none', '2023-10-10', '0.00', '0.00', 'no', '2025-12-14 08:19:50');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (50, 38, 21, 21, 29, '3500.00', 'none', '2023-10-10', '0.00', '0.00', 'no', '2025-12-14 08:20:36');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (51, 39, 22, 22, 29, '3500.00', 'none', '2023-11-10', '0.00', '0.00', 'no', '2025-12-14 08:21:48');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (52, 40, 5, 3, 29, '3500.00', 'none', '2023-12-01', '0.00', '0.00', 'no', '2025-12-14 08:23:07');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (53, 41, 32, 24, 29, NULL, 'none', '2026-02-12', '0.00', '0.00', 'no', '2025-12-14 09:12:25');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (54, 42, 24, 2, 30, '14000.00', 'none', '2024-02-01', '0.00', '0.00', 'no', '2025-12-14 09:22:40');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (55, 43, 4, 12, 30, '3500.00', 'none', '2025-02-01', '0.00', '0.00', 'no', '2025-12-14 09:23:50');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (56, 44, 13, 13, 30, '3500.00', 'none', '2024-02-10', '0.00', '0.00', 'no', '2025-12-14 09:24:52');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (57, 45, 32, 24, 30, NULL, 'none', '2026-02-12', '0.00', '0.00', 'no', '2025-12-14 10:17:58');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (58, 46, 5, 3, 18, '3500.00', 'none', '2023-01-30', '0.00', '0.00', 'no', '2025-12-16 08:07:28');


#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_session_groups_ibfk_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_session_groups_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (1, 3, 20, 'no', '2025-01-23 02:14:46');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (2, 2, 20, 'no', '2025-01-23 02:15:11');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (3, 5, 20, 'no', '2025-01-26 03:32:09');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (4, 4, 20, 'no', '2025-01-26 10:44:39');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (5, 6, 20, 'no', '2025-01-26 10:45:07');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (6, 7, 20, 'no', '2025-01-26 10:45:41');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (7, 8, 20, 'no', '2025-01-26 10:46:09');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (8, 10, 20, 'no', '2025-01-26 10:46:37');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (9, 11, 20, 'no', '2025-01-26 10:47:20');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (10, 12, 20, 'no', '2025-01-26 10:48:18');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (11, 13, 20, 'no', '2025-01-27 07:54:00');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (12, 14, 20, 'no', '2025-01-27 07:54:21');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (13, 15, 20, 'no', '2025-01-27 07:54:46');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (14, 16, 20, 'no', '2025-01-27 07:55:17');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (15, 17, 20, 'no', '2025-01-27 07:55:52');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (16, 18, 20, 'no', '2025-01-27 07:56:18');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (17, 19, 20, 'no', '2025-01-27 07:56:44');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (18, 20, 20, 'no', '2025-01-27 07:57:15');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (19, 21, 20, 'no', '2025-01-27 07:58:00');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (20, 22, 20, 'no', '2025-01-27 07:58:31');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (21, 23, 20, 'no', '2025-01-27 07:58:59');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (22, 24, 20, 'no', '2025-12-01 04:09:47');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (23, 25, 20, 'no', '2025-12-01 04:10:14');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (24, 26, 20, 'no', '2025-12-01 04:10:46');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (25, 27, 20, 'no', '2025-12-01 04:11:02');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (26, 28, 20, 'no', '2025-12-01 04:11:21');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (27, 30, 20, 'no', '2025-12-01 04:11:39');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (28, 31, 20, 'no', '2025-12-01 04:12:19');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (29, 29, 20, 'no', '2025-12-01 04:13:05');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (30, 2, 18, 'no', '2025-12-14 07:58:03');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (31, 3, 18, 'no', '2025-12-14 08:01:20');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (32, 24, 18, 'no', '2025-12-14 08:08:55');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (33, 25, 18, 'no', '2025-12-14 08:11:01');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (35, 3, 29, 'no', '2025-12-14 08:17:24');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (36, 2, 29, 'no', '2025-12-14 08:18:53');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (37, 20, 29, 'no', '2025-12-14 08:19:50');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (38, 21, 29, 'no', '2025-12-14 08:20:36');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (39, 22, 29, 'no', '2025-12-14 08:21:48');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (40, 5, 29, 'no', '2025-12-14 08:23:07');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (41, 32, 29, 'no', '2025-12-14 09:12:25');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (42, 24, 30, 'no', '2025-12-14 09:22:40');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (43, 4, 30, 'no', '2025-12-14 09:23:50');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (44, 13, 30, 'no', '2025-12-14 09:24:52');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (45, 32, 30, 'no', '2025-12-14 10:17:58');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (46, 5, 18, 'no', '2025-12-16 08:07:28');


#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `feemasters_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_2` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `percentage` float(10,2) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fees_discounts_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reminder_type` varchar(10) DEFAULT NULL,
  `day` int(2) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'before', 2, 1, '2025-01-10 12:56:19', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'before', 5, 0, '2020-02-28 08:38:36', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'after', 2, 1, '2025-01-10 12:55:48', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'after', 5, 0, '2020-02-28 08:38:44', NULL);


#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `feecategory_id` int(11) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (1, 0, NULL, 'ADMISSION FEE', 'PTTC/F/ADM/001', 'no', 'Payable once by students taking long courses.', '2025-01-23 02:11:56', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 0, NULL, 'TUITION FEES', 'PTTC/F/TF/001', 'no', 'Payable per semester by students taking long courses.', '2025-11-26 05:08:08', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (3, 0, NULL, 'COMPUTER PACKAGES', 'PTTC/F/CP/001', 'no', 'All computer packages students', '2025-01-26 10:28:55', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (4, 0, NULL, 'CCTV MANAGEMENT FEE', 'PTTC/F/CCTV/001', 'no', 'Payment for the short course', '2025-01-26 10:30:01', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (6, 0, NULL, 'MOBILE PHONE REPAIR', 'PTTC/F/MPR/001', 'no', 'Payment for a short course ', '2025-01-26 10:32:09', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (7, 0, NULL, 'CAKE BAKING', 'PTTC/F/CB/001', 'no', 'Payment for the short course ', '2025-01-26 10:33:09', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (8, 0, NULL, 'GRAPHIC DESIGN', 'PTTC/F/GD/001', 'no', 'Payment for the short course ', '2025-01-26 10:34:30', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (9, 0, NULL, 'PHOTOGRAPHY', 'PTTC/F/P/001', 'no', 'Payment for the short course ', '2025-01-26 10:34:58', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (10, 0, NULL, 'ELECTRONIC REPAIR (TV & RADIO)', 'PTTC/F/ER/001', 'no', 'Payment for the short course ', '2025-01-26 10:35:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (11, 0, NULL, 'COMPUTER AIDED DESIGN ', 'PTTC/F/CADD/001', 'no', 'Payment for the short course ', '2025-01-26 10:36:34', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (12, 0, NULL, 'JANUARY HOSTEL FEE', 'PTTC/F/H/001', 'no', 'Payment for hostel rooms', '2025-01-27 06:19:20', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (13, 0, NULL, 'FEBRUARY HOSTEL FEE', 'PTTC/F/H/002', 'no', '', '2025-01-27 06:19:47', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (14, 0, NULL, 'MARCH HOSTEL FEE', 'PTTC/F/H/003', 'no', '', '2025-01-27 06:20:39', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (15, 0, NULL, 'APRIL HOSTEL FEE', 'PTTC/F/H/004', 'no', '', '2025-01-27 06:20:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (16, 0, NULL, 'MAY HOSTEL FEE', 'PTTC/F/H/005', 'no', '', '2025-01-27 06:21:12', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (17, 0, NULL, 'JUNE HOSTEL FEE', 'PTTC/F/H/006', 'no', '', '2025-01-27 06:21:31', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (18, 0, NULL, 'JULY HOSTEL FEE', 'PTTC/F/H/007', 'no', '', '2025-01-27 06:21:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (19, 0, NULL, 'AUGUST HOSTEL FEE', 'PTTC/F/H/008', 'no', '', '2025-01-27 06:22:10', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (20, 0, NULL, 'SEPTEMBER HOSTEL FEE', 'PTTC/F/H/009', 'no', '', '2025-01-27 06:22:34', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (21, 0, NULL, 'OCTOBER HOSTEL FEE', 'PTTC/F/H/010', 'no', '', '2025-01-27 06:22:59', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (22, 0, NULL, 'NOVEMBER HOSTEL FEE', 'PTTC/F/H/011', 'no', '', '2025-01-27 06:23:19', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (23, 0, NULL, 'DECEMBER HOSTEL FEE', 'PTTC/F/H/012', 'no', '', '2025-01-27 06:23:42', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (24, 1, NULL, 'Previous Session Balance', 'Previous Session Balance', 'no', NULL, '2025-12-14 09:12:25', NULL);


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text DEFAULT NULL,
  `file_mime` text DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_mime` text DEFAULT NULL,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `filetypes` (`id`, `file_extension`, `file_mime`, `file_size`, `image_extension`, `image_mime`, `image_size`, `created_at`) VALUES (1, 'pdf, zip, jpg, jpeg, png, txt, 7z, gif, csv, docx, mp3, mp4, accdb, odt, ods, ppt, pptx, xlsx, wmv, jfif, apk, ppt, bmp, jpe, mdb, rar, xls, svg', 'application/pdf, image/zip, image/jpg, image/png, image/jpeg, text/plain, application/x-zip-compressed, application/zip, image/gif, text/csv, application/vnd.openxmlformats-officedocument.wordprocessingml.document, audio/mpeg, application/msaccess, application/vnd.oasis.opendocument.text, application/vnd.oasis.opendocument.spreadsheet, application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, video/x-ms-wmv, video/mp4, image/jpeg, application/vnd.android.package-archive, application/x-msdownload, application/vnd.ms-powerpoint, image/bmp, image/jpeg, application/msaccess, application/vnd.ms-excel, image/svg+xml', 100048576, 'jfif, png, jpe, jpeg, jpg, bmp, gif, svg', 'image/jpeg, image/png, image/jpeg, image/jpeg, image/bmp, image/gif, image/x-ms-bmp, image/svg+xml', 10048576, '2021-01-30 08:03:03');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `followup_by` (`followup_by`),
  CONSTRAINT `follow_up_ibfk_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follow_up_ibfk_2` FOREIGN KEY (`followup_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` text NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` text DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` text DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `front_cms_menu_items_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `front_cms_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 4, 0, NULL, 'no', '2019-12-02 17:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Complain', 2, 0, NULL, NULL, NULL, 'complain', 3, 0, NULL, 'no', '2019-12-02 17:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 1, 'Online Admission', 0, 0, NULL, NULL, 'https://www.pamojatechnical.ac.ke', 'online-admission', 2, 0, NULL, 'no', '2025-12-16 10:55:20');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` text NOT NULL,
  `ext_url_link` text NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 10:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 10:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` text DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keyword` text DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>home page</p>', '0000-00-00', 1, NULL, 'no', '2019-12-02 10:23:47');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>[form-builder:complain]</p>', '0000-00-00', 1, NULL, 'no', '2019-11-13 05:16:36');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 10:46:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<section class=\"contact\">\r\n<div class=\"container\">\r\n<div class=\"row\">\r\n<h2 class=\"col-md-12 col-sm-12\">Send In Your Query</h2>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/pin.svg\" />\r\n<h3>Our Location</h3>\r\n\r\n<p>350 Fifth Avenue, 34th floor New York NY 10118-3299 USA</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/phone.svg\" />\r\n<h3>CALL US</h3>\r\n\r\n<p>E-mail : info@abcschool.com</p>\r\n\r\n<p>Mobile : +91-9009987654</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/clock.svg\" />\r\n<h3>Working Hours</h3>\r\n\r\n<p>Mon-Fri : 9 am to 5 pm</p>\r\n\r\n<p>Sat : 9 am to 3 pm</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-12 col-sm-12\">\r\n<div class=\"mapWrapper fullwidth\"><iframe frameborder=\"0\" height=\"500\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://maps.google.com/maps?f=q&source=s_q&hl=EN&q=time+square&aq=&sll=40.716558,-73.931122&sspn=0.40438,1.056747&ie=UTF8&rq=1&ev=p&split=1&radius=33.22&hq=time+square&hnear=&ll=37.061753,-95.677185&spn=0.438347,0.769043&z=9&output=embed\" width=\"100%\"></iframe></div>\r\n</div>', '0000-00-00', 0, NULL, 'no', '2019-05-04 11:46:41');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` text DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `feature_image` text NOT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` text NOT NULL,
  `whatsapp_url` varchar(255) NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` text DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `cookie_consent` varchar(255) NOT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `whatsapp_url`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `cookie_consent`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, 1, 1, './uploads/school_content/logo/', '', '', '[\"complain\"]', 'https://wa.me/+254768166450', 'https://www.facebook.com/share/1BWie7Gnct/', '', '', '', '', '', '', '', 'JANUARY 2026 INTAKE ONGOING!', 'Pamoja Technical Training College uses cookies to improve your browsing experience, analyze website traffic, and support our online services. By clicking “Accept”, you consent to the use of cookies on this website.', './uploads/school_content/logo/', '2025-12-17 03:42:49');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_admission_id` int(11) DEFAULT NULL,
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `online_admission_id` (`online_admission_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_admission_id`) REFERENCES `online_admissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int(11) DEFAULT NULL,
  `posted_data` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: grades
#

DROP TABLE IF EXISTS `grades`;

CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_type` varchar(250) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'coll_grade_system', 'MASTERY', '1.0', '100.00', '80.00', 'A student is competent if the score is 80% -100%', 'no', '2025-02-13 04:05:48', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'coll_grade_system', 'COMPETENT', '2.0', '79.00', '50.00', 'A student is competent if the score is between 50%-79%', 'no', '2025-02-13 04:07:28', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'coll_grade_system', 'NOT YET COMPETENT', '3.0', '49.00', '1.00', 'The student is not yet competent if the score is 1%-49%', 'no', '2025-02-13 04:08:45', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'school_grade_system', 'DISTINTION', '1.0', '100.00', '80.00', 'DISTINCTION', 'no', '2025-02-20 06:35:12', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'school_grade_system', 'CREDIT', '3.0', '79.00', '60.00', 'CREDIT', 'no', '2025-03-03 06:10:52', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'school_grade_system', 'PASS', '5.0', '59.00', '40.00', 'PASS', 'no', '2025-02-20 06:36:01', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'school_grade_system', 'FAIL', '8.0', '39.00', '1.00', 'FAIL', 'no', '2025-02-20 06:36:28', NULL);


#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(10) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `create_date` date NOT NULL,
  `evaluation_date` date DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  KEY `subject_id` (`subject_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `homework_ibfk_1` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_5` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_6` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_7` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_8` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `homework_id` (`homework_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `homework_evaluation_ibfk_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `intake` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, '5TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:17:29', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, '4TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:18:11', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, '5TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:18:10', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, '5TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:18:28', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, '4TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:18:37', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, '4TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:18:57', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, '6TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:19:07', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, '6TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:19:30', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (12, '6TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:19:56', NULL);


#
# TABLE STRUCTURE FOR: hostel_rooms
#

DROP TABLE IF EXISTS `hostel_rooms`;

CREATE TABLE `hostel_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_id` int(11) DEFAULT NULL,
  `room_type_id` int(11) DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int(11) DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hostel_id` (`hostel_id`),
  KEY `room_type_id` (`room_type_id`),
  CONSTRAINT `hostel_rooms_ibfk_1` FOREIGN KEY (`hostel_id`) REFERENCES `hostel` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hostel_rooms_ibfk_2` FOREIGN KEY (`room_type_id`) REFERENCES `room_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (2, 5, 1, '401NORTH', 1, '3500.00', NULL, 'Self contained with washroom and sink.', '2025-01-10 10:28:05');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (3, 4, 1, '501NORTH', 1, '3500.00', NULL, 'WATER,SOCKETS,WASHROOM,SINK', '2025-01-10 10:28:15');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (4, 12, 1, '601NORTH', 1, '3500.00', NULL, 'WATER,SANITATION,SINK', '2025-01-10 10:28:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (5, 5, 1, '402NORTH', 1, '3500.00', NULL, 'SINK, HOTSHOWER,WIFI.WASHROOM', '2025-01-10 10:29:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (6, 5, 1, '403NORTH', 1, '3500.00', NULL, 'SINK,WIFI,WASHROOM,HOTSHOWER', '2025-01-10 10:31:48');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (7, 5, 1, '404NORTH', 1, '3500.00', NULL, 'SINK,WIFI,WASHROOM,HOTSHOWER', '2025-01-10 10:32:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (8, 5, 1, '405NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:58');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (9, 5, 1, '406NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:37');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (10, 5, 1, '407NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:46');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (11, 5, 1, '408 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:42:57');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (12, 5, 1, '409 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:44:09');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (13, 5, 1, '410NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:57:13');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (14, 5, 1, '411NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (15, 5, 1, '412 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:49:55');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (16, 9, 1, '413EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:56:53');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (17, 9, 1, '414 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:54:10');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (18, 9, 1, '415 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:59:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (19, 9, 1, '416 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:01:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (20, 9, 1, '417 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:02:49');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (21, 9, 1, '418 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:03:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (22, 9, 1, '418 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:05:00');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (23, 8, 1, '419SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:13:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (24, 8, 1, '420 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:13:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (25, 8, 1, '421SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:14:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (26, 8, 1, '422 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:15:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (27, 8, 1, '423 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:16:11');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (28, 8, 1, '424 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:17:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (29, 8, 1, '425 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:18:36');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (30, 8, 1, '426 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:19:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (31, 8, 1, '427 SOUTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:27:08');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (32, 4, 1, '501 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:31:41');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (33, 4, 1, '502 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:34:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (34, 4, 1, '503 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:35:08');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (35, 4, 1, '504 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:37:29');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (36, 4, 1, '505 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:38:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (37, 4, 1, '506 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:42:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (38, 4, 1, '507 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:43:20');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (39, 4, 1, '508 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:44:54');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (40, 4, 1, '509 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:46:33');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (41, 4, 1, '510 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:49:36');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (42, 4, 1, '511 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:51:09');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (44, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (45, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (46, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (47, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:31');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (48, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:31');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (49, 4, 1, '513 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:56:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (50, 7, 1, '514 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:57:17');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (51, 7, 1, '515 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:58:53');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (52, 7, 1, '516 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:00:27');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (53, 7, 1, '517 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:01:14');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (54, 7, 1, '518 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:03:14');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (55, 6, 1, '519 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 13:59:38');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (56, 6, 1, '520 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:01:55');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (57, 6, 1, '521 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:02:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (58, 6, 1, '522 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:03:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (59, 6, 1, '523 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:05:06');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (60, 6, 1, '524 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:06:01');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (61, 6, 1, '525 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:06:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (62, 6, 1, '526 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:07:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (63, 6, 1, '527 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:08:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (64, 12, 1, '602 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:01:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (65, 12, 1, '603 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom ', '2025-01-11 03:02:46');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (66, 12, 1, '604 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:03:43');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (67, 12, 1, '605 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:04:48');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (68, 12, 1, '606 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:06:10');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (69, 12, 1, '607 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:07:39');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (70, 12, 1, '608 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:16:41');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (71, 12, 1, '609 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:18:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (72, 12, 1, '610 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:19:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (73, 12, 1, '611 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:28:37');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (74, 12, 1, '612 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:33:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (75, 12, 1, '613 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:35:20');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (76, 12, 1, '614 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:36:34');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (77, 12, 1, '615 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:37:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (78, 11, 1, '616 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:38:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (79, 11, 1, '616 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:43:01');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (80, 11, 1, '617 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:44:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (81, 11, 1, '618 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:45:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (82, 10, 1, '619 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:46:25');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (83, 10, 1, '620 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:47:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (84, 10, 1, '621 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:48:03');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (85, 10, 1, '622 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:49:07');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (86, 10, 1, '623 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:50:11');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (87, 10, 1, '624 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:50:45');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (88, 10, 1, '625 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:51:27');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (89, 10, 1, '626 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:52:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (90, 10, 1, '627 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:53:20');


#
# TABLE STRUCTURE FOR: id_card
#

DROP TABLE IF EXISTS `id_card`;

CREATE TABLE `id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `enable_vertical_card` int(11) NOT NULL DEFAULT 0,
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_barcode` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (1, 'Sample Student Identity Card Horizontal', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 0, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);
INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (2, 'Sample Student Identity Card Vertical', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 1, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `documents` varchar(255) DEFAULT NULL,
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `income_head_id` (`income_head_id`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`income_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'DINING', 'From dining sales', 'yes', 'no', '2025-12-13 13:57:40', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'MAWINGU MAST', 'Monthly rent payment', 'yes', 'no', '2025-01-30 02:59:38', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'MTANDAO MAST', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:00:17', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'WAVEX OFFICE', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:00:45', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 'SAFARICOM K LTD', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:01:35', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 'A TO Z GRAHICS', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:02:16', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 'SUNDRY INCOME', 'Seasonal income', 'yes', 'no', '2025-01-30 03:02:50', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 'MARTIN MARK', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:03:21', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 'JITEGEMEA', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:03:57', NULL);


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `item_store_id` (`item_store_id`),
  KEY `item_supplier_id` (`item_supplier_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_2` FOREIGN KEY (`item_store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_3` FOREIGN KEY (`item_supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (1, 1, NULL, NULL, 'NAIL POLISH', '150', NULL, '', 0, NULL, '2025-02-11 03:54:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (2, 1, NULL, NULL, 'TOP COAT POLISH 1', '150', NULL, '', 0, NULL, '2025-02-11 03:58:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (3, 1, NULL, NULL, 'BASE COAT POLISH 1', '500', NULL, '', 0, NULL, '2025-02-11 04:08:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (4, 1, NULL, NULL, 'NAIL ART 1', '150', NULL, '', 0, NULL, '2025-02-11 04:10:45', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (5, 1, NULL, NULL, 'GEL POLISH 4 COLOURS', '500', NULL, '', 0, NULL, '2025-02-11 04:14:34', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (6, 1, NULL, NULL, 'BASE GEL 1 COLOUR', '500', NULL, '', 0, NULL, '2025-02-11 04:16:45', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (7, 1, NULL, NULL, 'TOP JEL 1 COLOUR', '500', NULL, '', 0, NULL, '2025-02-11 04:21:13', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (8, 1, NULL, NULL, 'PRIMER GEL 1', '500', NULL, '', 0, NULL, '2025-02-11 04:25:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (9, 1, NULL, NULL, 'NAIL ART BRUSHES 1 SET', '500', NULL, '', 0, NULL, '2025-02-11 04:26:17', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (10, 1, NULL, NULL, 'HENNAH 1 TUBE', '200', NULL, '', 0, NULL, '2025-02-11 04:26:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (11, 1, NULL, NULL, 'EAR DOTS 6 PCS', '600', NULL, '', 0, NULL, '2025-02-11 04:28:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (12, 1, NULL, NULL, 'NAIL TIPS 6 PCS', '600', NULL, '', 0, NULL, '2025-02-11 04:28:37', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (13, 1, NULL, NULL, 'WAX AND WAX STRIPS', '1500', NULL, '', 0, NULL, '2025-02-11 04:29:16', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (14, 1, NULL, NULL, 'APRICAT SCRUB 500 GMS', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:43:35', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (15, 1, NULL, NULL, 'ACETONE REMOVER 1L', '500', NULL, '', 0, NULL, '2025-02-11 04:44:35', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (16, 1, NULL, NULL, 'COTTON WOOL', '200', NULL, '', 0, NULL, '2025-02-11 04:45:10', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (17, 1, NULL, NULL, 'YDD NAIL GLUE', '400', NULL, '', 0, NULL, '2025-02-11 04:45:41', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (18, 1, NULL, NULL, 'NAIL FILE', '100', NULL, '', 0, NULL, '2025-02-11 04:46:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (19, 1, NULL, NULL, 'NAIL BUFFER', '100', NULL, '', 0, NULL, '2025-02-11 04:46:52', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (20, 1, NULL, NULL, 'HAIR FOOD', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:47:42', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (21, 1, NULL, NULL, 'STYLISHING GEL', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:48:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (22, 1, NULL, NULL, 'BRAIDS', '5 SHORT', NULL, '', 0, NULL, '2025-02-11 04:49:25', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (23, 1, NULL, NULL, 'NEUTROLIZING SHAMPOO', '500ML', NULL, '', 0, NULL, '2025-02-11 04:50:24', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (24, 1, NULL, NULL, 'CHEMICAL RELAX', '500GM', NULL, '', 0, NULL, '2025-02-11 04:51:12', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (25, 1, NULL, NULL, 'ROLYS TREATMENT', '500ML', NULL, '', 0, NULL, '2025-02-11 04:52:16', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (26, 1, NULL, NULL, 'THREAD AND NEDDLE', '100', NULL, '', 0, NULL, '2025-02-11 04:57:06', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (27, 2, NULL, NULL, 'EXUK USB MOUSE', '10', NULL, '', 0, NULL, '2025-02-11 07:52:21', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (28, 2, NULL, NULL, 'EXUK USB KEYBOARDS', '10', NULL, '', 0, NULL, '2025-02-11 07:54:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (29, 2, NULL, NULL, 'POWER EXTENSION', '3', NULL, '', 0, NULL, '2025-02-11 07:56:50', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (30, 2, NULL, NULL, 'DUSTING MINI TOWELS', '10', NULL, '', 0, NULL, '2025-02-11 07:57:42', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (31, 2, NULL, NULL, 'WHITEBOARD', '1', NULL, '', 0, NULL, '2025-02-11 07:58:50', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (32, 2, NULL, NULL, 'RAM MEMORIES PC3 4GB', '10', NULL, '', 0, NULL, '2025-02-11 07:59:48', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (33, 2, NULL, NULL, 'LASERPOINTER PEN', '1', NULL, '', 0, NULL, '2025-02-11 08:00:31', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (34, 3, NULL, NULL, 'SOCKETS 2DOUBLE AND 3 SINGLE', '450', NULL, '', 0, NULL, '2025-02-11 08:13:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (35, 3, NULL, NULL, 'SWITCHES', '350', NULL, '', 0, NULL, '2025-02-11 08:14:12', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (36, 3, NULL, NULL, 'CABLE CLIPS', '150', NULL, '', 0, NULL, '2025-02-11 08:14:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (37, 3, NULL, NULL, 'TAPE', '150', NULL, '', 0, NULL, '2025-02-11 08:15:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (38, 3, NULL, NULL, 'MCB', '900', NULL, '', 0, NULL, '2025-02-11 08:15:24', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (39, 3, NULL, NULL, 'BULBS', '1000', NULL, '', 0, NULL, '2025-02-11 08:17:33', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (40, 3, NULL, NULL, 'BULBHOLDERS', '10PCS', NULL, '', 0, NULL, '2025-02-11 08:26:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (41, 3, NULL, NULL, 'PATRICES BOX 3DOUBLE AND 10 SINGLES', '13', NULL, '', 0, NULL, '2025-02-11 08:27:56', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (42, 3, NULL, NULL, 'PLIERS', '4', NULL, '', 0, NULL, '2025-02-11 08:28:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (43, 3, NULL, NULL, 'LONGNOSE', '2', NULL, '', 0, NULL, '2025-02-11 08:29:01', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (44, 3, NULL, NULL, 'SCREWDRIVER', '4', NULL, '', 0, NULL, '2025-02-11 08:29:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (45, 3, NULL, NULL, 'SPARE PHONES', '2', NULL, '', 0, NULL, '2025-02-11 08:30:22', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (46, 3, NULL, NULL, 'THINNER', '1', NULL, '', 0, NULL, '2025-02-11 08:31:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (47, 3, NULL, NULL, 'TESTER', '5', NULL, '', 0, NULL, '2025-02-11 08:31:23', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (48, 7, NULL, NULL, 'EPOXY STEEL GLUE', '2', NULL, '', 0, NULL, '2025-02-11 08:55:11', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (49, 7, NULL, NULL, 'ANTI VIBRATIONG GLOVES', '2', NULL, '', 0, NULL, '2025-02-11 08:55:49', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (50, 7, NULL, NULL, 'WORKSHOP SAFETY BOOTS', '1', NULL, '', 0, NULL, '2025-02-11 08:58:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (51, 7, NULL, NULL, 'HELMET(HARD HAT)', '1', NULL, '', 0, NULL, '2025-02-11 08:59:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (52, 4, NULL, NULL, 'DOUBLE JOINTS YT', '100', NULL, '', 0, NULL, '2025-02-12 00:07:54', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (53, 4, NULL, NULL, 'UNION', '100', NULL, '', 0, NULL, '2025-02-12 00:08:15', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (54, 4, NULL, NULL, 'ELBOW', '100', NULL, '', 0, NULL, '2025-02-12 00:08:33', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (55, 4, NULL, NULL, 'COLD WATER PPR PIPES', '350', NULL, '', 0, NULL, '2025-02-12 00:09:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (56, 4, NULL, NULL, 'G.I PIPE', '350', NULL, '', 0, NULL, '2025-02-12 00:13:04', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (57, 4, NULL, NULL, 'THREADED JOINTS', '100', NULL, '', 0, NULL, '2025-02-12 00:17:00', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (58, 5, NULL, NULL, 'TAPE MEASURE', '300', NULL, '', 0, NULL, '2025-02-12 00:38:11', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (59, 5, NULL, NULL, 'ROPES', '80', NULL, '', 0, NULL, '2025-02-12 00:38:51', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (60, 5, NULL, NULL, 'BUILDING SQUARE', '350', NULL, '', 0, NULL, '2025-02-12 00:39:18', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (61, 5, NULL, NULL, 'SPIRIT LEVEL', '450', NULL, '', 0, NULL, '2025-02-12 00:40:01', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (62, 5, NULL, NULL, 'WATER LEVEL', '2000', NULL, '', 0, NULL, '2025-02-12 00:40:52', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (63, 5, NULL, NULL, 'LIME', '800', NULL, '', 0, NULL, '2025-02-12 00:41:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (64, 5, NULL, NULL, 'TROWELS', '200', NULL, '', 0, NULL, '2025-02-12 00:42:16', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (65, 5, NULL, NULL, 'STEEL PLATE', '350', NULL, '', 0, NULL, '2025-02-12 00:42:52', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (66, 5, NULL, NULL, 'TIMBER', '300', NULL, '', 0, NULL, '2025-02-12 00:49:41', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (67, 5, NULL, NULL, 'MASON HAMMER', '250', NULL, '', 0, NULL, '2025-02-12 00:50:07', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (68, 5, NULL, NULL, 'CHAINS', '200', NULL, '', 0, NULL, '2025-02-12 00:50:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (69, 5, NULL, NULL, 'NAILS', '100', NULL, '', 0, NULL, '2025-02-12 00:53:14', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (70, 5, NULL, NULL, 'PLUMB BOB', '300', NULL, '', 0, NULL, '2025-02-12 00:53:37', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (71, 5, NULL, NULL, 'D.P.M', '150', NULL, '', 0, NULL, '2025-02-12 00:53:59', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (72, 5, NULL, NULL, 'HARD CORE', '700', NULL, '', 0, NULL, '2025-02-12 00:54:21', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (73, 13, NULL, NULL, 'dust coats', '10', NULL, '', 0, NULL, '2025-02-14 07:23:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (74, 8, NULL, NULL, 'TETRON MATERIAL', '1 ROLL', NULL, '', 0, NULL, '2025-02-19 07:41:13', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (75, 12, NULL, NULL, 'MARGARINE', '2KG', NULL, '', 0, NULL, '2025-02-26 02:52:57', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (76, 12, NULL, NULL, 'SUGAR 2KG', '2KG', NULL, '', 0, NULL, '2025-02-26 02:53:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (77, 12, NULL, NULL, 'COOKING OIL', '1LTR', NULL, '', 0, NULL, '2025-02-26 02:53:57', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (78, 12, NULL, NULL, 'FLOUR', '4KG', NULL, '', 0, NULL, '2025-02-26 02:54:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (79, 12, NULL, NULL, 'BAKING POWDER', '50G', NULL, '', 0, NULL, '2025-02-26 02:55:20', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (80, 12, NULL, NULL, 'DARK CHOCOLATE', '500G', NULL, '', 0, NULL, '2025-02-26 02:56:06', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (81, 12, NULL, NULL, 'PRISTINE', '1LTR', NULL, '', 0, NULL, '2025-02-26 02:57:00', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (82, 12, NULL, NULL, 'EGGS', '1CRATE', NULL, '', 0, NULL, '2025-02-26 02:57:55', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (83, 12, NULL, NULL, 'ICING SUGAR', '3KG', NULL, '', 0, NULL, '2025-02-26 02:58:59', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (84, 12, NULL, NULL, 'GELATIN', '200G', NULL, '', 0, NULL, '2025-02-26 03:15:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (85, 12, NULL, NULL, 'GLUCOSE SYRUP', '500G', NULL, '', 0, NULL, '2025-02-26 03:15:38', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (86, 12, NULL, NULL, 'CMC', '100G', NULL, '', 0, NULL, '2025-02-26 03:16:02', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (87, 12, NULL, NULL, 'CLEAR FLAVOUR', '1PKT', NULL, '', 0, NULL, '2025-02-26 03:16:44', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (88, 12, NULL, NULL, 'SAUSAGES', '5PCS', NULL, '', 0, NULL, '2025-02-26 03:17:18', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (89, 12, NULL, NULL, 'BICARBONATE', '50G', NULL, '', 0, NULL, '2025-02-26 08:31:58', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (90, 12, NULL, NULL, 'HARD BRUSH', '1PC', NULL, '', 0, NULL, '2025-02-26 08:32:34', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (91, 12, NULL, NULL, 'MOPS', '3PCS', NULL, '', 0, NULL, '2025-02-26 08:33:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (92, 12, NULL, NULL, 'MOP BUCKET', '2PC', NULL, '', 0, NULL, '2025-02-26 08:33:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (93, 12, NULL, NULL, 'BUCKETS', '3PC', NULL, '', 0, NULL, '2025-02-26 08:34:11', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (94, 12, NULL, NULL, 'DUSTPAN AND BRUSH', '1PC', NULL, '', 0, NULL, '2025-02-26 08:34:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (95, 12, NULL, NULL, 'CLEANING CLOTH', '4PCS', NULL, '', 0, NULL, '2025-02-26 08:35:19', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (96, 12, NULL, NULL, 'YELLOW DUSTER', '1PC', NULL, '', 0, NULL, '2025-02-26 08:35:51', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (97, 12, NULL, NULL, 'DETERGENTS', '500ML', NULL, '', 0, NULL, '2025-02-26 08:36:32', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (98, 12, NULL, NULL, 'NEWSPAPER', '1PC', NULL, '', 0, NULL, '2025-02-26 08:37:08', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (99, 12, NULL, NULL, 'WINDOW CLEANSER', '500ML', NULL, '', 0, NULL, '2025-02-26 08:37:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (100, 12, NULL, NULL, 'BASINS', '3', NULL, '', 0, NULL, '2025-02-26 08:38:17', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (101, 12, NULL, NULL, 'FABRIC CONDITIONER', '500ML', NULL, '', 0, NULL, '2025-02-26 08:38:49', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (102, 12, NULL, NULL, 'PEGS', '1PKT', NULL, '', 0, NULL, '2025-02-26 08:39:19', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (103, 12, NULL, NULL, 'SOFT BRUSH', 'IPC', NULL, '', 0, NULL, '2025-02-26 08:39:56', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (104, 13, NULL, NULL, 'BOX FILES', '20', NULL, '', 0, NULL, '2025-06-13 02:36:35', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (105, 13, NULL, NULL, 'WHITE BOARD MAKER', '24', NULL, '', 0, NULL, '2025-09-17 02:26:42', NULL);


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (1, 'COSMETOLOGY', 'yes', '', '2025-02-11 03:47:03', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 'ICT', 'yes', '', '2025-02-11 03:47:08', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (3, 'ELECTRICAL', 'yes', '', '2025-02-11 03:47:22', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (4, 'PLUMBING', 'yes', '', '2025-02-11 03:47:29', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (5, 'MASONRY', 'yes', '', '2025-02-11 03:47:37', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (6, 'CARPENTRY', 'yes', '', '2025-02-11 03:47:46', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (7, 'AUTOMOTIVE', 'yes', '', '2025-02-11 03:47:54', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (8, 'FASHION DESIGN', 'yes', '', '2025-02-11 03:48:06', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (9, 'STATIONERY', 'yes', '', '2025-02-11 03:48:19', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (10, 'AGRICULTURE', 'yes', '', '2025-02-11 03:48:26', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (11, 'HOSTEL', 'yes', '', '2025-02-11 03:48:35', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (12, 'HOSPITALITY', 'yes', '', '2025-02-11 03:48:52', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (13, 'OFFICE ADMINISTRATOR', 'yes', '', '2025-02-11 03:49:06', NULL);


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` int(11) NOT NULL,
  `issue_by` int(11) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `issue_by` (`issue_by`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_4` FOREIGN KEY (`issue_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (1, '2', 4, 1, '2025-02-04', '2025-02-19', 1, 1, 1, '', 0, '2025-02-19 03:36:08', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (2, '2', 8, 6, '2025-02-11', '2025-02-12', 1, 1, 1, '', 1, '2025-02-11 04:00:38', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (3, '2', 5, 6, '2025-02-17', '0000-00-00', 13, 73, 1, '', 1, '2025-02-17 01:04:38', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (4, '2', 10, 6, '2025-02-17', '0000-00-00', 13, 73, 1, '', 1, '2025-02-17 03:02:40', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (5, '2', 9, 6, '2025-02-17', '0000-00-00', 13, 73, 1, '', 1, '2025-02-17 03:03:25', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (6, '2', 11, 6, '2025-02-14', '0000-00-00', 13, 73, 1, '', 1, '2025-02-17 03:04:26', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (7, '2', 12, 6, '2025-02-18', '0000-00-00', 2, 27, 10, '', 1, '2025-02-18 07:26:33', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (8, '2', 12, 6, '2025-02-18', '0000-00-00', 2, 28, 10, '', 1, '2025-02-18 07:27:06', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (9, '2', 12, 6, '2025-02-18', '0000-00-00', 2, 29, 3, '', 1, '2025-02-18 07:27:41', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (10, '2', 12, 6, '2025-02-18', '0000-00-00', 2, 32, 10, '', 1, '2025-02-18 07:29:17', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (11, '2', 12, 6, '2025-02-18', '0000-00-00', 2, 33, 1, '', 1, '2025-02-18 07:31:15', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (12, '2', 12, 6, '2025-02-18', '0000-00-00', 13, 73, 1, '', 1, '2025-02-18 07:33:16', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (13, '2', 8, 6, '2025-02-18', '0000-00-00', 13, 73, 1, '', 1, '2025-02-18 07:34:53', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (14, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 34, 5, '', 1, '2025-02-18 08:09:08', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (15, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 35, 8, '', 1, '2025-02-18 08:09:51', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (16, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 36, 1, '', 1, '2025-02-18 08:12:18', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (17, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 37, 3, '', 1, '2025-02-18 08:13:21', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (18, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 38, 3, '', 1, '2025-02-18 08:14:28', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (19, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 39, 12, '', 1, '2025-02-18 08:15:30', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (20, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 40, 10, '', 1, '2025-02-18 08:16:16', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (21, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 41, 13, '', 1, '2025-02-18 08:17:44', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (22, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 42, 4, '', 1, '2025-02-18 08:20:41', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (23, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 43, 2, '', 1, '2025-02-18 08:21:27', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (24, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 44, 4, '', 1, '2025-02-18 08:22:04', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (25, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 45, 2, '', 1, '2025-02-18 08:22:59', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (26, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 46, 1, '', 1, '2025-02-18 08:24:00', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (27, '2', 5, 6, '2025-02-18', '0000-00-00', 3, 47, 5, '', 1, '2025-02-18 08:24:47', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (28, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 2, 1, '', 1, '2025-02-19 07:00:41', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (29, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 3, 1, '', 1, '2025-02-19 07:01:39', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (30, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 4, 1, '', 1, '2025-02-19 07:20:33', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (31, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 5, 4, '', 1, '2025-02-19 07:21:11', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (32, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 6, 1, '', 1, '2025-02-19 07:21:44', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (33, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 7, 1, '', 1, '2025-02-19 07:22:18', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (34, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 8, 1, '', 1, '2025-02-19 07:22:52', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (35, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 9, 1, '', 1, '2025-02-19 07:23:23', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (36, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 10, 1, '', 1, '2025-02-19 07:24:05', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (37, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 11, 6, '', 1, '2025-02-19 07:26:03', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (38, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 12, 6, '', 1, '2025-02-19 07:26:33', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (39, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 13, 1, '', 1, '2025-02-19 07:27:07', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (40, '2', 4, 6, '2025-02-18', '0000-00-00', 1, 14, 1, '', 1, '2025-02-19 07:28:16', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (41, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 15, 1, '', 1, '2025-02-19 07:29:02', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (42, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 16, 1, '', 1, '2025-02-19 07:32:26', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (43, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 17, 1, '', 1, '2025-02-19 07:33:04', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (44, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 18, 1, '', 1, '2025-02-19 07:33:57', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (45, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 19, 1, '', 1, '2025-02-19 07:34:30', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (46, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 20, 1, '', 1, '2025-02-19 07:35:49', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (47, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 21, 1, '', 1, '2025-02-19 07:36:22', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (48, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 22, 5, '', 1, '2025-02-19 07:36:52', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (49, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 23, 1, '', 1, '2025-02-19 07:37:24', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (50, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 24, 1, '', 1, '2025-02-19 07:37:55', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (51, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 25, 1, '', 1, '2025-02-19 07:39:30', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (52, '2', 8, 6, '2025-02-18', '0000-00-00', 1, 26, 1, '', 1, '2025-02-19 07:40:15', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (53, '2', 17, 6, '2025-02-18', '0000-00-00', 8, 74, 1, '', 1, '2025-02-19 07:47:03', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (54, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 52, 1, '', 1, '2025-02-19 08:04:20', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (55, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 53, 16, '', 1, '2025-02-19 08:05:06', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (56, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 54, 16, '', 1, '2025-02-19 08:05:44', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (57, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 55, 2, '', 1, '2025-02-19 08:06:30', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (58, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 56, 2, '', 1, '2025-02-19 08:06:52', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (59, '2', 10, 6, '2025-02-17', '0000-00-00', 4, 57, 8, '', 1, '2025-02-19 08:07:27', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (60, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 58, 3, '', 1, '2025-02-19 08:08:07', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (61, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 59, 3, '', 1, '2025-02-19 08:08:32', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (62, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 60, 3, '', 1, '2025-02-19 08:09:02', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (63, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 61, 3, '', 1, '2025-02-19 08:09:30', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (64, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 62, 1, '', 1, '2025-02-19 08:10:11', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (65, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 63, 2, '', 1, '2025-02-19 08:10:37', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (66, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 64, 6, '', 1, '2025-02-19 08:11:10', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (67, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 65, 3, '', 1, '2025-02-19 08:11:43', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (68, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 66, 2, '', 1, '2025-02-19 08:12:23', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (69, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 67, 2, '', 1, '2025-02-19 08:12:51', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (70, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 68, 2, '', 1, '2025-02-19 08:13:25', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (71, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 69, 3, '', 1, '2025-02-19 08:14:14', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (72, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 70, 3, '', 1, '2025-02-19 08:14:52', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (73, '2', 10, 6, '2025-02-17', '0000-00-00', 5, 71, 2, '', 1, '2025-02-19 08:15:22', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (74, '2', 7, 6, '2025-02-20', '0000-00-00', 13, 73, 1, '', 1, '2025-02-20 06:30:08', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (75, '2', 17, 6, '2025-02-20', '0000-00-00', 13, 73, 1, '', 1, '2025-02-20 06:36:45', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (76, '2', 4, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:42:39', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (77, '2', 5, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:43:08', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (78, '2', 13, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:47:51', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (79, '2', 12, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:48:24', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (80, '2', 9, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:48:57', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (81, '2', 30, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:51:00', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (82, '2', 10, 6, '2025-06-13', '0000-00-00', 13, 104, 1, '', 1, '2025-06-13 02:53:19', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (83, '2', 21, 6, '2025-06-20', '0000-00-00', 13, 104, 1, '', 1, '2025-06-20 01:18:08', 'no');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (1, 1, 1, 1, '+', 3, '450.00', '2025-02-04', NULL, '', 'yes', '2025-02-11 03:55:21');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (2, 2, 1, 1, '+', 1, '150.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 03:58:49');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (3, 3, 1, 1, '+', 1, '150.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 04:10:14');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (4, 4, 1, 1, '+', 1, '150.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 04:13:33');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (5, 5, 1, 1, '+', 4, '2000.00', '2025-02-11', NULL, '', 'yes', '2025-02-11 04:15:33');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (6, 6, 1, 1, '+', 1, '500.00', '2025-02-11', NULL, '', 'yes', '2025-02-11 04:17:52');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (8, 7, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:07:53');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (9, 8, 1, NULL, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:08:27');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (10, 9, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:09:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (11, 10, 1, 1, '+', 1, '200.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:09:54');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (12, 11, 1, 1, '+', 6, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:10:50');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (13, 12, 1, 1, '+', 6, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:11:31');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (14, 13, 1, 1, '+', 1, '1500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:12:09');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (15, 14, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:12:52');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (16, 15, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:13:32');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (17, 16, 1, 1, '+', 1, '200.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:14:09');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (18, 17, 1, 1, '+', 1, '400.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:14:45');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (19, 18, 1, 1, '+', 1, '100.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:15:30');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (20, 19, 1, 1, '+', 1, '100.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:16:15');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (21, 20, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:16:57');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (22, 21, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:17:34');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (23, 22, 1, NULL, '+', 5, '350.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:18:19');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (24, 23, 1, 1, '+', 1, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:18:58');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (25, 24, 1, 1, '+', 1, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:19:41');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (26, 25, 1, 1, '+', 1, '700.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:20:41');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (27, 26, 1, 1, '+', 1, '100.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 05:21:18');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (28, 27, 1, 2, '+', 10, '8000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 07:53:59');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (29, 28, 1, 2, '+', 10, '10000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 07:55:57');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (30, 29, 1, 2, '+', 3, '2400.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:01:51');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (31, 30, 1, 2, '+', 10, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:02:40');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (32, 31, 1, 2, '+', 1, '5000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:03:16');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (33, 32, 1, 2, '+', 10, '15000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:04:03');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (34, 33, 1, 2, '+', 1, '3000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:04:52');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (35, 34, 1, 3, '+', 5, '450.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:36:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (36, 35, 1, 3, '+', 8, '350.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:36:39');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (37, 36, 1, 3, '+', 1, '150.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:37:17');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (38, 37, 1, 3, '+', 3, '150.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:37:49');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (39, 38, 1, 3, '+', 3, '900.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:39:16');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (40, 39, 1, 3, '+', 12, '1000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:40:02');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (41, 40, 1, 3, '+', 10, '1000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:41:29');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (42, 41, 1, 3, '+', 13, '810.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:42:45');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (43, 42, 1, 3, '+', 4, '800.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:43:48');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (44, 43, 1, 3, '+', 2, '400.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:44:53');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (45, 44, 1, 3, '+', 4, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:45:48');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (46, 45, 1, 3, '+', 2, '18000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:48:02');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (47, 46, 1, 3, '+', 1, '250.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:48:48');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (48, 47, 1, NULL, '+', 5, '250.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 08:49:34');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (49, 48, 1, 7, '+', 2, '1000.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 09:00:33');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (50, 49, 1, 7, '+', 2, '700.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 09:01:18');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (51, 50, 1, 7, '+', 1, '3500.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 09:02:12');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (52, 51, 1, 7, '+', 1, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-11 09:03:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (53, 52, 1, 4, '+', 1, '1000.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:17:48');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (54, 53, 1, 4, '+', 16, '1600.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:22:56');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (55, 54, 1, 4, '+', 16, '1600.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:23:46');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (56, 55, 1, 4, '+', 2, '700.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:25:24');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (57, 56, 1, 4, '+', 2, '700.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:27:13');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (58, 57, 1, 4, '+', 8, '800.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:28:08');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (59, 58, 1, NULL, '+', 3, '900.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:43:31');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (60, 59, 1, 5, '+', 3, '240.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:44:12');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (61, 60, 1, 5, '+', 3, '1050.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:44:53');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (62, 61, 1, 5, '+', 3, '1350.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:45:31');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (63, 62, 1, 5, '+', 1, '2000.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:46:23');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (64, 63, 1, 5, '+', 2, '800.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:47:01');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (65, 64, 1, 5, '+', 6, '1200.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:48:08');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (66, 65, 1, 5, '+', 3, '1050.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:48:46');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (67, 66, 1, 5, '+', 2, '600.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:57:15');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (68, 67, 1, 5, '+', 2, '500.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:57:55');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (69, 68, 1, 5, '+', 2, '400.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:58:30');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (70, 69, 1, 5, '+', 3, '300.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 00:59:40');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (71, 70, 1, 5, '+', 3, '900.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 01:00:30');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (72, 71, 1, 5, '+', 2, '300.00', '2025-02-10', NULL, '', 'yes', '2025-02-12 01:01:18');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (73, 73, 1, 13, '+', 10, '10000.00', '2025-02-10', NULL, '', 'yes', '2025-02-14 07:26:39');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (74, 74, 1, 8, '+', 1, '2800.00', '2025-02-19', NULL, '', 'yes', '2025-02-19 07:42:36');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (75, 75, 1, 12, '+', 2, '760.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:44:40');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (76, 76, 1, 12, '+', 2, '340.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:45:22');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (77, 77, 1, NULL, '+', 1, '350.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:45:56');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (78, 78, 1, 12, '+', 4, '380.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:46:35');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (79, 79, 1, 12, '+', 50, '60.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:47:07');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (80, 80, 1, 12, '+', 500, '400.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:47:46');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (81, 81, 1, 12, '+', 1, '640.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:48:19');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (82, 82, 1, 12, '+', 1, '480.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:49:22');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (83, 83, 1, 12, '+', 3, '840.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:50:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (84, 84, 1, 12, '+', 200, '150.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:50:42');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (85, 85, 1, 12, '+', 500, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:51:28');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (86, 86, 1, 12, '+', 100, '100.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:52:09');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (87, 87, 1, 12, '+', 1, '150.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:52:54');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (88, 88, 1, 12, '+', 5, '190.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:53:33');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (89, 89, 1, 12, '+', 50, '60.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:56:23');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (90, 90, 1, 12, '+', 1, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:58:12');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (91, 91, 1, 12, '+', 3, '300.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 08:58:53');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (92, 92, 1, 12, '+', 2, '500.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:01:24');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (93, 93, 1, 12, '+', 3, '450.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:02:03');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (94, 94, 1, 12, '+', 1, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:03:21');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (95, 95, 1, 12, '+', 4, '150.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:04:38');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (96, 96, 1, 12, '+', 1, '150.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:05:16');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (97, 97, 1, 12, '+', 500, '150.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:06:20');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (98, 98, 1, 12, '+', 1, '50.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:07:00');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (99, 99, 1, 12, '+', 500, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:07:38');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (100, 100, 1, 12, '+', 3, '300.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:08:20');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (101, 100, 1, 12, '+', 3, '300.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:09:05');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (102, 101, 1, 12, '+', 500, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:09:48');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (103, 102, 1, 12, '+', 1, '50.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:10:27');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (104, 103, 1, 12, '+', 1, '250.00', '2025-02-25', NULL, '', 'yes', '2025-02-26 09:11:45');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (105, 104, 1, 13, '+', 20, '5000.00', '2025-06-12', NULL, '', 'yes', '2025-06-13 02:41:11');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `store_id`, `symbol`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (106, 105, 1, 13, '+', 24, '2400.00', '2025-09-16', NULL, '', 'yes', '2025-09-17 02:29:31');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'COSMETOLOGY', 'PTTC/I/COS/001', '', '2025-02-11 03:33:53');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'ICT', 'PTTC/I/ICT/001', '', '2025-02-11 03:34:24');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (3, 'ELECTRICAL', 'PTTC/I/ELT/001', '', '2025-02-11 03:36:31');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (4, 'PLUMBING', 'PTTC/I/PL/001', '', '2025-02-11 03:37:13');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (5, 'MASONSRY', 'PTTC/I/MSN/001', '', '2025-02-11 03:37:30');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (6, 'CARPENTRY', 'PTTC/I/CARP/001', '', '2025-02-11 03:38:09');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (7, 'AUTOMOTIVE', 'PTTC/I/AUT/001', '', '2025-02-11 03:38:34');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (8, 'FASHION DESIGN', 'PTTC/I/FSH/OO1', '', '2025-02-11 03:40:26');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (9, 'STATIONERY', 'PTTC/I/PL/001', '', '2025-02-11 03:41:23');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (10, 'AGRICULTURE', 'PTTC/I/AGR/OO1', '', '2025-02-11 03:41:46');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (11, 'HOSTEL', 'PTTC/I/HO/001', '', '2025-02-11 03:42:17');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (12, 'HOSPITALITY', 'PTTC/I/HOSP/001', '', '2025-02-11 03:42:47');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (13, 'OFFICE ADMINISTRATOR', 'PTTC/I/ADM/001', '', '2025-02-11 03:43:52');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'GENERAL SUPPLIER', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_rtl` int(1) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 0, 'no', 'no', '2019-11-20 06:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 0, 'no', 'no', '2019-11-20 06:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 0, 'no', 'no', '2019-11-20 06:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 0, 'no', 'no', '2019-11-20 06:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 0, 'no', 'no', '2019-11-20 06:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 0, 'no', 'no', '2019-11-20 06:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 0, 'no', 'no', '2021-01-23 02:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 0, 'no', 'no', '2019-11-20 07:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 0, 'no', 'no', '2019-11-20 07:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 0, 'no', 'no', '2019-11-20 06:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 0, 'no', 'no', '2019-11-20 07:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 0, 'no', 'no', '2019-11-20 07:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 0, 'no', 'no', '2019-11-20 07:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 0, 'no', 'no', '2019-11-20 07:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 0, 'no', 'no', '2019-11-20 07:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 0, 'no', 'no', '2019-11-20 07:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'it', 0, 'no', 'no', '2021-01-23 02:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 0, 'no', 'no', '2019-11-20 07:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 0, 'no', 'no', '2019-11-20 06:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 0, 'no', 'no', '2019-11-20 06:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 0, 'no', 'no', '2019-11-20 07:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 0, 'no', 'no', '2019-11-20 06:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'lk ', 0, 'no', 'no', '2021-01-23 02:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 0, 'no', 'no', '2019-11-20 07:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 0, 'no', 'no', '2019-12-03 06:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 0, 'no', 'no', '2019-11-20 06:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 0, 'no', 'no', '2019-11-20 06:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 0, 'no', 'no', '2019-11-20 07:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 0, 'no', 'no', '2019-11-20 06:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 0, 'no', 'no', '2019-11-20 07:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 0, 'no', 'no', '2019-11-20 06:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 0, 'no', 'no', '2019-11-20 23:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 0, 'no', 'no', '2019-11-20 07:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 0, 'no', 'no', '2019-11-20 07:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 0, 'no', 'no', '2020-06-14 23:25:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'Kurdish', 'ku', 'iq', 0, 'no', 'no', '2020-12-20 19:15:31', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'Lao', 'lo', 'la', 0, 'no', 'no', '2020-12-20 19:15:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'Croatia', 'hr', 'hr', 0, 'no', 'no', '2022-06-07 07:48:21', '0000-00-00');


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: lesson
#

DROP TABLE IF EXISTS `lesson`;

CREATE TABLE `lesson` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `subject_group_class_sections_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `subject_group_class_sections_id` (`subject_group_class_sections_id`),
  CONSTRAINT `lesson_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_2` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_3` FOREIGN KEY (`subject_group_class_sections_id`) REFERENCES `subject_group_class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1833 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: lesson_plan_forum
#

DROP TABLE IF EXISTS `lesson_plan_forum`;

CREATE TABLE `lesson_plan_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject_syllabus_id` int(11) NOT NULL,
  `type` varchar(20) NOT NULL COMMENT 'staff,student',
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `message` text NOT NULL,
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject_syllabus_id` (`subject_syllabus_id`),
  KEY `student_id` (`student_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `lesson_plan_forum_ibfk_1` FOREIGN KEY (`subject_syllabus_id`) REFERENCES `subject_syllabus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: libarary_members
#

DROP TABLE IF EXISTS `libarary_members`;

CREATE TABLE `libarary_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `library_card_no` varchar(50) DEFAULT NULL,
  `member_type` varchar(50) DEFAULT NULL,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (1, 'PTTC/LIB/STD/001', 'student', 243, 'no', '2025-02-06 01:33:51');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (2, 'PTTC/LIB/STD/002', 'student', 254, 'no', '2025-02-06 01:34:04');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (3, 'PTTC/LIB/STD/003', 'student', 257, 'no', '2025-02-06 01:34:16');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (4, 'PTTC/LIB/STD/004', 'student', 258, 'no', '2025-02-06 01:34:31');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (5, 'PTTC/LIB/STD/005', 'student', 259, 'no', '2025-02-06 01:34:45');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (6, 'PTTC/LIB/STD/006', 'student', 229, 'no', '2025-02-06 01:35:31');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (7, 'PTTC/LIB/STD/007', 'student', 159, 'no', '2025-02-06 01:36:19');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (8, 'PTTC/LIB/STD/008', 'student', 188, 'no', '2025-02-06 01:36:30');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (9, 'PTTC/LIB/STD/009', 'student', 261, 'no', '2025-02-06 01:37:01');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (10, 'PTTC/LIB/STD/0010', 'student', 233, 'no', '2025-02-06 01:37:26');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (11, 'PTTC/LIB/STD/0011', 'student', 154, 'no', '2025-02-06 01:37:51');
INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES (12, 'PTTC/LIB/STD/0012', 'student', 245, 'no', '2025-02-06 01:38:05');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `platform` varchar(50) DEFAULT NULL,
  `agent` varchar(50) DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11258 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.34', 'Windows 10', 'Firefox 133.0', '2025-01-08 13:25:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.34', 'Windows 10', 'Firefox 133.0', '2025-01-08 16:28:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.58', 'Windows 10', 'Firefox 133.0', '2025-01-08 17:06:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.58', 'Windows 10', 'Firefox 133.0', '2025-01-08 17:07:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.58', 'Windows 10', 'Firefox 133.0', '2025-01-08 17:07:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.58', 'Windows 10', 'Firefox 133.0', '2025-01-08 17:13:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-09 08:14:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-09 08:16:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-09 08:17:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.211', 'Windows 10', 'Firefox 133.0', '2025-01-09 15:16:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'Record updated On settings id 1', '1', 1, 'Update', '154.159.252.211', 'Windows 10', 'Firefox 133.0', '2025-01-09 15:17:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On  staff designation id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:14:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On  staff designation id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:14:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On  staff designation id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:14:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated On  staff designation id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:14:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On  staff designation id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:14:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'New Record inserted On  staff designation id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:15:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'New Record inserted On  staff designation id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:15:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On  staff designation id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:15:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On  staff designation id 8', '8', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:15:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'New Record inserted On  staff designation id 9', '9', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:16:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On  staff designation id 10', '10', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On  staff designation id 11', '11', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:16:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On  staff designation id 12', '12', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:16:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On  staff designation id 13', '13', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On department id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:17:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On department id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:17:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'New Record inserted On department id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:17:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On department id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:17:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On department id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:17:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'New Record inserted On department id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:18:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On department id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:18:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On staff id 2', '2', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:21:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record updated On roles id 2', '2', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:25:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On sections id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:29:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On sections id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:29:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'Record updated On sections id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:30:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record updated On sections id 2', '2', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:30:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On sections id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:31:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:32:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:33:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'New Record inserted On subject groups id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:33:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On subject groups id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:33:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'New Record inserted On subject groups id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:33:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On subjects id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:35:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'New Record inserted On subjects id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:35:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'New Record inserted On subjects id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:35:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'New Record inserted On subjects id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:36:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'New Record inserted On subjects id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:36:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'New Record inserted On subjects id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:36:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On subjects id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:37:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:43:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On subject groups id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:44:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On subject groups id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:44:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted On sections id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:47:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On sections id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:47:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On subject groups id 8', '8', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:47:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record deleted On sections id 1', '1', 1, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:48:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'Record deleted On sections id 2', '2', 1, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:48:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'Record deleted On sections id 3', '3', 1, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:48:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On sections id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:49:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'Record updated On sections id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:49:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On sections id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:49:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On sections id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:49:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'Record deleted On sections id 7', '7', 1, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:50:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On subject groups id 9', '9', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:51:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record updated On classes id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:52:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 03:54:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On  categories id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:05:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On  categories id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:05:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On school houses id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:06:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On school houses id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:06:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On students id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On  student session id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On users id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On users id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'Record updated On students id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On  school houses id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:12:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'Record updated On  school houses id 2', '2', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:13:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On school houses id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:13:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On school houses id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:13:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'New Record inserted On school houses id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:13:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'Record updated On students id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:14:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On  student session id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:14:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'New Record inserted On visitors purpose id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:20:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'New Record inserted On visitors purpose id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:20:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On visitors purpose id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:20:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On  complaint_type id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:21:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On  complaint_type id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:21:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On  complaint_type id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:21:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On  complaint_type id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:21:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On  complaint_type id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:21:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On  complaint_type id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:22:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On  complaint_type id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:22:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On source id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:22:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On source id 2', '2', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:22:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On source id 3', '3', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:22:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'New Record inserted On source id 4', '4', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:23:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On source id 5', '5', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:23:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On source id 6', '6', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:23:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On source id 7', '7', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:23:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On  enquiry id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:25:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted On  visitors  id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:26:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On  Complain id 1', '1', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:29:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:34:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:41:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'Record updated On  permission student id 24', '24', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:43:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'Record updated On permission group id 28', '28', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:43:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'Record updated On permission group id 27', '27', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:43:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'Record updated On permission group id 28', '28', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:44:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'Record updated On  permission student id 12', '12', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:44:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'Record updated On  permission student id 19', '19', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:45:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record updated On  permission student id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:45:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated On permission group id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated On permission group id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record updated On  permission student id 8', '8', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record updated On  permission student id 11', '11', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record updated On  permission student id 12', '12', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record updated On  permission student id 13', '13', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:46:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated On  permission student id 14', '14', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record updated On  permission student id 15', '15', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record updated On  permission student id 16', '16', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record updated On  permission student id 17', '17', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'Record updated On  permission student id 19', '19', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record updated On  permission student id 23', '23', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record updated On  permission student id 20', '20', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record updated On  permission student id 24', '24', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'Record updated On  permission student id 25', '25', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:47:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record updated On  permission student id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:48:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'Record updated On permission group id 27', '27', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 04:48:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'Record updated On sections id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:19:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record updated On sections id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'Record updated On sections id 6', '6', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:20:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On sections id 8', '8', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:20:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'New Record inserted On sections id 9', '9', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:21:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On sections id 10', '10', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:22:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'New Record inserted On sections id 11', '11', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:22:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'New Record inserted On sections id 12', '12', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:23:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'New Record inserted On sections id 13', '13', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:24:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record updated On classes id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:30:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record updated On classes id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:32:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record updated On classes id 6', '6', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record updated On classes id 7', '7', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:33:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record updated On classes id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:34:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'Record updated On classes id 2', '2', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:34:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On subject groups id 10', '10', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:35:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'New Record inserted On subject groups id 11', '11', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:36:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'New Record inserted On subject groups id 12', '12', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:36:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'New Record inserted On subject groups id 13', '13', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:36:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'New Record inserted On subject groups id 14', '14', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:37:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On subject groups id 15', '15', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:37:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On subject groups id 16', '16', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:37:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'New Record inserted On subject groups id 17', '17', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:38:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'New Record inserted On subject groups id 18', '18', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:39:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On subject groups id 19', '19', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:41:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'New Record inserted On subject groups id 20', '20', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:41:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On subject groups id 21', '21', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'New Record inserted On subject groups id 22', '22', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:42:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On subject groups id 23', '23', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:42:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On subject groups id 24', '24', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:43:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On subject groups id 25', '25', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:43:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On subject groups id 26', '26', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:43:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On subject groups id 27', '27', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:43:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On subject groups id 28', '28', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:44:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On subject groups id 29', '29', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:44:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On subject groups id 30', '30', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:44:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'Record updated On staff id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:54:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'Record updated On staff id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:57:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'Record updated On staff id 3', '3', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 05:57:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:13:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:13:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:13:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:14:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:14:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:14:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:14:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'Record updated On staff id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:19:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record updated On staff id 6', '6', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:24:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:27:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record updated On staff id 6', '6', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:29:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'Record updated On staff id 6', '6', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:29:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:31:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:33:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:47:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:49:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:50:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:51:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:54:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:55:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:56:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:56:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:56:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:56:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'Record updated On staff id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:58:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'Record updated On staff id 5', '5', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:58:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'Record updated On staff id 5', '5', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 06:59:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On subjects id 8', '8', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:03:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On subjects id 9', '9', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:11:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On subjects id 10', '10', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:12:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'New Record inserted On subjects id 11', '11', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:13:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On subjects id 12', '12', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:15:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On subjects id 13', '13', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:16:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On subjects id 14', '14', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:16:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'New Record inserted On subjects id 15', '15', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:16:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'New Record inserted On subjects id 16', '16', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:19:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On subjects id 17', '17', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:20:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On subjects id 18', '18', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:21:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record updated On staff id 7', '7', 1, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:22:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On subjects id 19', '19', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:24:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On subjects id 20', '20', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:24:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On subjects id 21', '21', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:25:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'New Record inserted On subjects id 22', '22', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:26:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On subjects id 23', '23', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:26:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On subjects id 24', '24', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:27:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On subjects id 25', '25', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:28:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'New Record inserted On subjects id 26', '26', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:30:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On subjects id 27', '27', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 07:32:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On subjects id 28', '28', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 07:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'New Record inserted On subjects id 29', '29', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:09:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On subjects id 30', '30', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:10:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On subjects id 31', '31', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On subjects id 32', '32', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:13:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On subjects id 33', '33', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:14:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On subjects id 34', '34', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'New Record inserted On subjects id 35', '35', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'New Record inserted On subjects id 36', '36', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:16:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On subjects id 37', '37', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:17:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'New Record inserted On subjects id 38', '38', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:18:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On subjects id 39', '39', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:19:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'New Record inserted On subjects id 40', '40', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:19:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On subjects id 41', '41', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:20:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On subject groups id 31', '31', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On subjects id 42', '42', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:20:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On subject groups id 32', '32', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On subject groups id 33', '33', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On subjects id 43', '43', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On subjects id 44', '44', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'New Record inserted On subject groups id 34', '34', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On subject groups id 35', '35', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:21:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'New Record inserted On subject groups id 36', '36', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:22:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On subjects id 45', '45', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:22:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On subject groups id 37', '37', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:22:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On subject groups id 38', '38', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:22:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On subjects id 46', '46', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:22:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On subject groups id 39', '39', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:23:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On subject groups id 40', '40', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:23:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On subject groups id 41', '41', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:23:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'New Record inserted On subject groups id 42', '42', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:23:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On subject groups id 43', '43', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:23:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On subjects id 47', '47', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:24:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On subject groups id 44', '44', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:24:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'New Record inserted On subject groups id 45', '45', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:24:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'New Record inserted On subjects id 48', '48', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:24:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'New Record inserted On subjects id 49', '49', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:25:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'New Record inserted On subjects id 50', '50', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:25:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'New Record inserted On subjects id 51', '51', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:26:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On subject groups id 46', '46', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:26:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'New Record inserted On subject groups id 47', '47', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:26:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On subject groups id 48', '48', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:26:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'New Record inserted On subject groups id 49', '49', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:26:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'New Record inserted On subject groups id 50', '50', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:27:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On subject groups id 51', '51', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:27:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On subject groups id 52', '52', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:27:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On subject groups id 53', '53', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:27:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'New Record inserted On subject groups id 54', '54', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:28:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'New Record inserted On subject groups id 55', '55', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:29:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On subject groups id 56', '56', 1, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 08:29:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On staff id 5', '5', 5, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:41:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On subjects id 52', '52', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:42:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On subjects id 53', '53', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:42:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'New Record inserted On subjects id 54', '54', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:43:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On subjects id 55', '55', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:43:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'New Record inserted On subjects id 56', '56', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:43:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'New Record inserted On subjects id 57', '57', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:44:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On subjects id 58', '58', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:44:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'New Record inserted On subjects id 59', '59', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:44:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On subjects id 60', '60', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:45:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'New Record inserted On subjects id 61', '61', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:45:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'New Record inserted On subjects id 62', '62', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:46:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On subjects id 63', '63', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:46:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'New Record inserted On subjects id 64', '64', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:47:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On subjects id 65', '65', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:48:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On subjects id 66', '66', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:48:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'New Record inserted On subjects id 67', '67', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:49:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On subjects id 68', '68', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:50:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On subjects id 69', '69', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'New Record inserted On subjects id 70', '70', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:51:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'New Record inserted On subjects id 71', '71', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 09:52:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'New Record inserted On subjects id 72', '72', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:52:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'New Record inserted On subjects id 73', '73', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:52:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'New Record inserted On subjects id 74', '74', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:53:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'New Record inserted On subjects id 75', '75', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 09:53:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'New Record inserted On subjects id 76', '76', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:53:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'New Record inserted On subjects id 77', '77', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:54:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'New Record inserted On subjects id 78', '78', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 09:54:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record updated On staff id 2', '2', 1, 'Update', '154.159.252.214', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 09:55:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'Record updated On staff id 2', '2', 1, 'Update', '154.159.252.214', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 09:55:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'New Record inserted On subjects id 79', '79', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:55:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On subjects id 80', '80', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:55:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On subjects id 81', '81', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:55:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On subjects id 82', '82', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 09:56:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'New Record inserted On subjects id 83', '83', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:56:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'Record updated On staff id 2', '2', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:57:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'New Record inserted On subjects id 84', '84', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:57:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record updated On staff id 2', '2', 0, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:58:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On subjects id 85', '85', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:58:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On subjects id 86', '86', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'New Record inserted On subjects id 87', '87', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:59:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On subjects id 88', '88', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 09:59:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On subjects id 89', '89', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:00:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'New Record inserted On subjects id 90', '90', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:00:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'New Record inserted On subjects id 91', '91', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:00:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'New Record inserted On subject groups id 57', '57', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:01:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'New Record inserted On subject groups id 58', '58', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:01:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'New Record inserted On subjects id 92', '92', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:01:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'New Record inserted On subject groups id 59', '59', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:01:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'New Record inserted On subjects id 93', '93', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:01:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On subjects id 94', '94', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On subjects id 95', '95', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:02:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On subject groups id 60', '60', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On subjects id 96', '96', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'New Record inserted On subject groups id 61', '61', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On subject groups id 62', '62', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'New Record inserted On subjects id 97', '97', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:02:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'New Record inserted On subjects id 98', '98', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:03:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On subject groups id 63', '63', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:03:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On subjects id 99', '99', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:03:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On subject groups id 64', '64', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:03:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On subjects id 100', '100', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:04:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'New Record inserted On subjects id 101', '101', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:04:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'New Record inserted On subject groups id 65', '65', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:04:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'New Record inserted On subjects id 102', '102', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:04:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On subject groups id 66', '66', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:04:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'New Record inserted On subjects id 103', '103', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:04:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'New Record inserted On subject groups id 67', '67', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'New Record inserted On subject groups id 68', '68', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'New Record inserted On subjects id 104', '104', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On subject groups id 69', '69', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On subject groups id 70', '70', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'New Record inserted On subjects id 105', '105', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:05:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'New Record inserted On subject groups id 71', '71', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'New Record inserted On subjects id 106', '106', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'New Record inserted On subject groups id 72', '72', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'New Record inserted On subjects id 107', '107', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'New Record inserted On subject groups id 73', '73', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'New Record inserted On subject groups id 74', '74', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:06:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'New Record inserted On subjects id 108', '108', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On subject groups id 75', '75', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'New Record inserted On subjects id 109', '109', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'New Record inserted On subject groups id 76', '76', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'New Record inserted On subject groups id 77', '77', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'New Record inserted On subjects id 110', '110', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:07:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On subject groups id 78', '78', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:08:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'New Record inserted On subject groups id 79', '79', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'New Record inserted On subjects id 111', '111', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:08:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On subjects id 112', '112', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On subjects id 113', '113', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:09:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'New Record inserted On subject groups id 80', '80', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:09:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted On subjects id 114', '114', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:09:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'New Record inserted On subject groups id 81', '81', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:09:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'New Record inserted On subject groups id 82', '82', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:09:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'New Record inserted On subject groups id 83', '83', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:10:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'New Record inserted On subject groups id 84', '84', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:10:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'New Record inserted On subject groups id 85', '85', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:11:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'New Record inserted On subject groups id 86', '86', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'New Record inserted On subject groups id 87', '87', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:11:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'New Record inserted On subjects id 115', '115', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:11:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'New Record inserted On subjects id 116', '116', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:11:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On subject groups id 88', '88', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'New Record inserted On subject groups id 89', '89', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'New Record inserted On subjects id 117', '117', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'New Record inserted On subjects id 118', '118', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'New Record inserted On subject groups id 90', '90', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'New Record inserted On subject groups id 91', '91', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'New Record inserted On subjects id 119', '119', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:12:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'New Record inserted On subject groups id 92', '92', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On subjects id 120', '120', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'New Record inserted On subject groups id 93', '93', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'New Record inserted On subjects id 121', '121', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'New Record inserted On subject groups id 94', '94', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'New Record inserted On subject groups id 95', '95', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'New Record inserted On subjects id 122', '122', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On subjects id 123', '123', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:13:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'New Record inserted On subject groups id 96', '96', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:14:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'New Record inserted On subject groups id 97', '97', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:14:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'New Record inserted On subject groups id 98', '98', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:14:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'New Record inserted On subject groups id 99', '99', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:14:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'Record updated On sections id 11', '11', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:15:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'New Record inserted On subjects id 124', '124', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:15:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'New Record inserted On subjects id 125', '125', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:16:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'New Record inserted On subjects id 126', '126', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:16:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'New Record inserted On subject groups id 100', '100', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:16:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'New Record inserted On subjects id 127', '127', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:16:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'New Record inserted On subjects id 128', '128', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:17:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'New Record inserted On subject groups id 101', '101', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:17:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'New Record inserted On subject groups id 102', '102', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:17:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On subjects id 129', '129', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:17:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'New Record inserted On subjects id 130', '130', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:18:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'New Record inserted On subjects id 131', '131', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:18:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'New Record inserted On subjects id 132', '132', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:18:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On subject groups id 103', '103', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:19:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'New Record inserted On subjects id 133', '133', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:19:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'New Record inserted On subject groups id 104', '104', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:19:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On subjects id 134', '134', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:19:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'New Record inserted On subjects id 135', '135', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'New Record inserted On subjects id 136', '136', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:20:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted On subjects id 137', '137', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:20:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On subjects id 138', '138', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:20:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On subjects id 139', '139', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:21:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'New Record inserted On subjects id 140', '140', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:21:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On subjects id 141', '141', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:21:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'Record updated On staff id 8', '8', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:22:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'New Record inserted On subjects id 142', '142', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'New Record inserted On subjects id 143', '143', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:24:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'Record updated On staff id 8', '8', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:25:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'Record updated On staff id 8', '8', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:25:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'New Record inserted On subjects id 144', '144', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:25:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On subjects id 145', '145', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:26:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'New Record inserted On subjects id 146', '146', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:26:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'New Record inserted On subjects id 147', '147', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:27:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record inserted On subjects id 148', '148', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:27:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'New Record inserted On subjects id 149', '149', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:28:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'New Record inserted On subjects id 150', '150', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:28:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'New Record inserted On subjects id 151', '151', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:28:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'New Record inserted On subjects id 152', '152', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:29:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'New Record inserted On subjects id 153', '153', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:30:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On subjects id 154', '154', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'New Record inserted On subjects id 155', '155', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:31:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On subjects id 156', '156', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'New Record inserted On subject groups id 105', '105', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'New Record inserted On subjects id 157', '157', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'New Record inserted On subjects id 158', '158', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'New Record inserted On subject groups id 106', '106', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'New Record inserted On subject groups id 107', '107', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:32:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'New Record inserted On subjects id 159', '159', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:33:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'New Record inserted On subjects id 160', '160', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:33:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'Record updated On staff id 8', '8', 0, 'Update', '102.215.15.120', 'Android', 'Chrome 130.0.6723.58', '2025-01-10 10:33:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'New Record inserted On subjects id 161', '161', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:33:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On subjects id 162', '162', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:34:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'New Record inserted On subjects id 163', '163', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:34:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'New Record inserted On subjects id 164', '164', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:34:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'New Record inserted On subjects id 165', '165', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On subject groups id 108', '108', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'New Record inserted On subject groups id 109', '109', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'New Record inserted On subjects id 166', '166', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'New Record inserted On subject groups id 110', '110', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On subjects id 167', '167', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:35:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'New Record inserted On subject groups id 111', '111', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On subjects id 168', '168', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'New Record inserted On subjects id 169', '169', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:35:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'New Record inserted On subject groups id 112', '112', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'New Record inserted On subjects id 170', '170', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On subjects id 171', '171', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'New Record inserted On subject groups id 113', '113', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'New Record inserted On subject groups id 114', '114', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'New Record inserted On subject groups id 115', '115', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'New Record inserted On subjects id 172', '172', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:36:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'New Record inserted On subject groups id 116', '116', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On subjects id 173', '173', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'New Record inserted On subject groups id 117', '117', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'New Record inserted On subjects id 174', '174', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'New Record inserted On subject groups id 118', '118', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'New Record inserted On subjects id 175', '175', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'New Record inserted On subjects id 176', '176', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'New Record inserted On subject groups id 119', '119', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'New Record inserted On subjects id 177', '177', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:37:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'New Record inserted On subjects id 178', '178', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:38:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'New Record inserted On subjects id 179', '179', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:38:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'New Record inserted On subject groups id 120', '120', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:38:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'New Record inserted On subject groups id 121', '121', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:38:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'New Record inserted On subject groups id 122', '122', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:38:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'New Record inserted On subjects id 180', '180', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:41:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On subjects id 181', '181', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:43:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'New Record inserted On subject groups id 123', '123', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:44:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'New Record inserted On subject groups id 124', '124', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:44:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'New Record inserted On subject groups id 125', '125', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:44:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'New Record inserted On subject groups id 126', '126', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:44:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'New Record inserted On subjects id 182', '182', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:44:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'New Record inserted On subject groups id 127', '127', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:44:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'New Record inserted On subjects id 183', '183', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:45:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'New Record inserted On subject groups id 128', '128', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:45:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'New Record inserted On subject groups id 129', '129', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:45:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On subject groups id 130', '130', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'New Record inserted On subjects id 184', '184', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'New Record inserted On subject groups id 131', '131', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'New Record inserted On subject groups id 132', '132', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'New Record inserted On subject groups id 133', '133', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'New Record inserted On subject groups id 134', '134', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:46:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'New Record inserted On subjects id 185', '185', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:47:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'New Record inserted On subjects id 186', '186', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:47:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'New Record inserted On subject groups id 135', '135', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:48:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'New Record inserted On subjects id 187', '187', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:48:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record inserted On subject groups id 136', '136', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:49:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'New Record inserted On subjects id 188', '188', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:49:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'New Record inserted On subjects id 189', '189', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:49:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'New Record inserted On subjects id 190', '190', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:49:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'New Record inserted On subjects id 191', '191', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'New Record inserted On subjects id 192', '192', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:50:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On subjects id 193', '193', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:51:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On staff id 4', '4', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:51:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'Record updated On staff id 4', '4', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:51:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On subjects id 194', '194', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:51:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On subjects id 195', '195', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:52:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'New Record inserted On subjects id 196', '196', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:52:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'New Record inserted On subjects id 197', '197', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:52:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On subjects id 198', '198', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:53:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'New Record inserted On subjects id 199', '199', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:54:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On subjects id 200', '200', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:54:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'New Record inserted On subjects id 201', '201', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:54:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'New Record inserted On hostel id 1', '1', 4, 'Insert', '141.0.13.54', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 10:54:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'New Record inserted On subjects id 202', '202', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:55:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'New Record inserted On hostel id 2', '2', 4, 'Insert', '141.0.13.54', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 10:55:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'New Record inserted On subjects id 203', '203', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'New Record inserted On room types id 1', '1', 4, 'Insert', '141.0.13.54', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 10:56:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'New Record inserted On subjects id 204', '204', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 10:56:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'New Record inserted On subjects id 205', '205', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:57:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'New Record inserted On subjects id 206', '206', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:57:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On subjects id 207', '207', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:57:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'New Record inserted On subjects id 208', '208', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:58:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'New Record inserted On subjects id 209', '209', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'New Record inserted On subjects id 210', '210', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:58:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On subjects id 211', '211', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:58:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'New Record inserted On subjects id 212', '212', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:59:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'New Record inserted On subjects id 213', '213', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:59:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'New Record inserted On subjects id 214', '214', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 10:59:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'New Record inserted On subjects id 215', '215', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:00:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'New Record inserted On subject groups id 137', '137', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:00:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'New Record inserted On subjects id 216', '216', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:00:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'New Record inserted On subject groups id 138', '138', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:00:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On subjects id 217', '217', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:00:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'New Record inserted On subjects id 218', '218', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On subject groups id 139', '139', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'New Record inserted On subjects id 219', '219', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On subject groups id 140', '140', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'New Record inserted On subjects id 220', '220', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'New Record inserted On subject groups id 141', '141', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'New Record inserted On subjects id 221', '221', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:01:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On subjects id 222', '222', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:02:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'New Record inserted On subjects id 223', '223', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'New Record inserted On subject groups id 142', '142', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'New Record inserted On subjects id 224', '224', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'New Record inserted On subject groups id 143', '143', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'New Record inserted On subject groups id 144', '144', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'New Record inserted On subjects id 225', '225', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'New Record inserted On subject groups id 145', '145', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'New Record inserted On subjects id 226', '226', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:03:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'New Record inserted On subjects id 227', '227', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:03:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'New Record inserted On subjects id 228', '228', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:03:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'New Record inserted On subject groups id 146', '146', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:03:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'New Record inserted On subjects id 229', '229', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:03:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'New Record inserted On subject groups id 147', '147', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'New Record inserted On subject groups id 148', '148', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'New Record inserted On subjects id 230', '230', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'New Record inserted On subjects id 231', '231', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'New Record inserted On subjects id 232', '232', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:04:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'New Record inserted On subjects id 233', '233', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'New Record inserted On subject groups id 149', '149', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:04:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'New Record inserted On subject groups id 150', '150', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'New Record inserted On subjects id 234', '234', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'New Record inserted On subject groups id 151', '151', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'New Record inserted On subjects id 235', '235', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On subjects id 236', '236', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'New Record inserted On subject groups id 152', '152', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'New Record inserted On subject groups id 153', '153', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'New Record inserted On subject groups id 154', '154', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'New Record inserted On subjects id 237', '237', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:05:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'New Record inserted On subject groups id 155', '155', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:06:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On subject groups id 156', '156', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:06:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'New Record inserted On subjects id 238', '238', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:07:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'New Record inserted On subjects id 239', '239', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:07:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'New Record inserted On subjects id 240', '240', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:07:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On subjects id 241', '241', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:07:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'New Record inserted On subject groups id 157', '157', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'New Record inserted On subjects id 242', '242', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'New Record inserted On subjects id 243', '243', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'New Record inserted On subject groups id 158', '158', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'New Record inserted On subject groups id 159', '159', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'New Record inserted On subjects id 244', '244', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'New Record inserted On subjects id 245', '245', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:08:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'New Record inserted On subjects id 246', '246', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:08:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'New Record inserted On subjects id 247', '247', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:09:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'New Record inserted On subjects id 248', '248', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:09:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On subject groups id 160', '160', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:09:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'New Record inserted On subjects id 249', '249', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:09:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'New Record inserted On subjects id 250', '250', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'New Record inserted On subject groups id 161', '161', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'New Record inserted On subjects id 251', '251', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'New Record inserted On subject groups id 162', '162', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On subject groups id 163', '163', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'New Record inserted On subjects id 252', '252', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:10:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'New Record inserted On subjects id 253', '253', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'New Record inserted On subject groups id 164', '164', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:11:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'New Record inserted On subjects id 254', '254', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:11:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'New Record inserted On subject groups id 165', '165', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:11:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'New Record inserted On subject groups id 166', '166', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:11:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'New Record inserted On subject groups id 167', '167', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On subject groups id 168', '168', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:12:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On subject groups id 169', '169', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:12:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On subject groups id 170', '170', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:13:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'New Record inserted On subjects id 255', '255', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:13:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On subject groups id 171', '171', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:13:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record inserted On subjects id 256', '256', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:14:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On subjects id 257', '257', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:14:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On subjects id 258', '258', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:14:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On subjects id 259', '259', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:14:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'New Record inserted On subject groups id 172', '172', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:14:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On subject groups id 173', '173', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'New Record inserted On subjects id 260', '260', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On subjects id 261', '261', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On subject groups id 174', '174', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On subjects id 262', '262', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'New Record inserted On subject groups id 175', '175', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:15:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On subject groups id 176', '176', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:16:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'New Record inserted On subjects id 263', '263', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:16:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'New Record inserted On subject groups id 177', '177', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:16:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'New Record inserted On subjects id 264', '264', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'New Record inserted On subjects id 265', '265', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:17:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'New Record inserted On subjects id 266', '266', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:17:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On subjects id 267', '267', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'New Record inserted On subjects id 268', '268', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:18:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'New Record inserted On subjects id 269', '269', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:19:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On subjects id 270', '270', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:19:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'Record updated On staff id 5', '5', 5, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:19:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On subjects id 271', '271', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:19:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'Record updated On permission group id 8', '8', 1, 'Update', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 11:20:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'New Record inserted On subjects id 272', '272', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:20:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'New Record inserted On subjects id 273', '273', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:21:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'New Record inserted On subjects id 274', '274', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:21:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On subjects id 275', '275', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:21:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On subjects id 276', '276', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:21:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On subjects id 277', '277', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:22:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'New Record inserted On subjects id 278', '278', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:22:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On subjects id 279', '279', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:22:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'New Record inserted On subjects id 280', '280', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:23:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On subjects id 281', '281', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:23:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'New Record inserted On subjects id 282', '282', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:23:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On subjects id 283', '283', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:23:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'New Record inserted On subject groups id 178', '178', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:24:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'New Record inserted On subjects id 284', '284', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:24:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'New Record inserted On subjects id 285', '285', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:24:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'New Record inserted On subjects id 286', '286', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:24:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'New Record inserted On subjects id 287', '287', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:24:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'New Record inserted On subjects id 288', '288', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:24:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'New Record inserted On subjects id 289', '289', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:25:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'New Record inserted On subjects id 290', '290', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:25:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'New Record inserted On subjects id 291', '291', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:26:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On subjects id 292', '292', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:26:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'New Record inserted On subjects id 293', '293', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:26:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'New Record inserted On subjects id 294', '294', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:26:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted On subject groups id 179', '179', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'New Record inserted On subject groups id 180', '180', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'New Record inserted On subjects id 295', '295', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'New Record inserted On subject groups id 181', '181', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On subjects id 296', '296', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:27:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On subject groups id 182', '182', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On subjects id 297', '297', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:27:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'New Record inserted On subjects id 298', '298', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:28:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'New Record inserted On subject groups id 183', '183', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:28:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'New Record inserted On subjects id 299', '299', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:28:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'New Record inserted On subject groups id 184', '184', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'New Record inserted On subjects id 300', '300', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On subject groups id 185', '185', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'New Record inserted On subjects id 301', '301', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'New Record inserted On subject groups id 186', '186', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'New Record inserted On subjects id 302', '302', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'New Record inserted On subject groups id 187', '187', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:29:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'New Record inserted On subjects id 303', '303', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:30:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On subject groups id 188', '188', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:30:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'New Record inserted On subjects id 304', '304', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:30:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On subjects id 305', '305', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:30:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On subject groups id 189', '189', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:30:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On subject groups id 190', '190', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:30:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'New Record inserted On subjects id 306', '306', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:31:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On subjects id 307', '307', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:31:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'New Record inserted On subjects id 308', '308', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:31:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'New Record inserted On subjects id 309', '309', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:31:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On subjects id 310', '310', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:32:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On subjects id 311', '311', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:32:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On subjects id 312', '312', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:32:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'New Record inserted On subjects id 313', '313', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'New Record inserted On subject groups id 191', '191', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:33:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'New Record inserted On subjects id 314', '314', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:33:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On subject groups id 192', '192', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'New Record inserted On subject groups id 193', '193', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:33:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On subjects id 315', '315', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:33:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'New Record inserted On subject groups id 194', '194', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'New Record inserted On subject groups id 195', '195', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On subject groups id 196', '196', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On subjects id 316', '316', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On subjects id 317', '317', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On subjects id 318', '318', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'New Record inserted On subjects id 319', '319', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:34:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'New Record inserted On subject groups id 197', '197', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:35:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'New Record inserted On subject groups id 198', '198', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:35:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'New Record inserted On subjects id 320', '320', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:35:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'New Record inserted On subjects id 321', '321', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:35:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On subject groups id 199', '199', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:35:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On subject groups id 200', '200', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'New Record inserted On subjects id 322', '322', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'New Record inserted On subject groups id 201', '201', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On subjects id 323', '323', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On subject groups id 202', '202', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On subject groups id 203', '203', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:36:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'New Record inserted On subjects id 324', '324', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'New Record inserted On subjects id 325', '325', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On subject groups id 204', '204', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On subject groups id 205', '205', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'New Record inserted On subjects id 326', '326', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'New Record inserted On subjects id 327', '327', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:37:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'New Record inserted On subjects id 328', '328', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:38:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On subject groups id 206', '206', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:38:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'New Record inserted On subjects id 329', '329', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:39:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On subject groups id 207', '207', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:39:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'New Record inserted On subject groups id 208', '208', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:39:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'New Record inserted On subject groups id 209', '209', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:39:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'New Record inserted On subjects id 330', '330', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:39:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'New Record inserted On subjects id 331', '331', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:40:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'New Record inserted On subject groups id 210', '210', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:40:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'New Record inserted On subjects id 332', '332', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:40:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On subjects id 333', '333', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'New Record inserted On subjects id 334', '334', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:42:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'New Record inserted On subjects id 335', '335', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:42:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On subject groups id 211', '211', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:42:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'New Record inserted On subject groups id 212', '212', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:43:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'New Record inserted On subject groups id 213', '213', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:43:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On subject groups id 214', '214', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'New Record inserted On subject groups id 215', '215', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'New Record inserted On subjects id 336', '336', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:44:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'New Record inserted On subject groups id 216', '216', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'New Record inserted On subject groups id 217', '217', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'New Record inserted On subject groups id 218', '218', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'New Record inserted On subject groups id 219', '219', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:44:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'New Record inserted On subjects id 337', '337', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:45:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'New Record inserted On subject groups id 220', '220', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:45:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'New Record inserted On subject groups id 221', '221', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:45:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record inserted On subjects id 338', '338', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:45:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'New Record inserted On subject groups id 222', '222', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:45:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'New Record inserted On subject groups id 223', '223', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:46:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'New Record inserted On subjects id 339', '339', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:46:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'New Record inserted On subject groups id 224', '224', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:46:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'New Record inserted On subject groups id 225', '225', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:46:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'New Record inserted On subject groups id 226', '226', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:46:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'New Record inserted On subject groups id 227', '227', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:47:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'New Record inserted On subjects id 340', '340', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:47:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'New Record inserted On subject groups id 228', '228', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:47:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'New Record inserted On subjects id 341', '341', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:47:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'New Record inserted On subjects id 342', '342', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:47:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'New Record inserted On subject groups id 229', '229', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:48:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'New Record inserted On subject groups id 230', '230', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:48:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'New Record inserted On subject groups id 231', '231', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:48:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'New Record inserted On subject groups id 232', '232', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:48:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On subject groups id 233', '233', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:49:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'New Record inserted On subjects id 343', '343', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:49:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'New Record inserted On subjects id 344', '344', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:50:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On subject groups id 234', '234', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:51:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'New Record inserted On subjects id 345', '345', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:51:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'New Record inserted On subject groups id 235', '235', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:51:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'New Record inserted On subjects id 346', '346', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:51:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'New Record inserted On subjects id 347', '347', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:52:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'New Record inserted On subject groups id 236', '236', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'New Record inserted On subjects id 348', '348', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'New Record inserted On subject groups id 237', '237', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'New Record inserted On subject groups id 238', '238', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'New Record inserted On subjects id 349', '349', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On subject groups id 239', '239', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:52:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'New Record inserted On subjects id 350', '350', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:53:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On subject groups id 240', '240', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:53:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'New Record inserted On subjects id 351', '351', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 11:53:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On subject groups id 241', '241', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:53:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'New Record inserted On subjects id 352', '352', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:53:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'New Record inserted On subjects id 353', '353', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:54:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On subjects id 354', '354', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:54:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On subject groups id 242', '242', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:55:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'New Record inserted On subjects id 355', '355', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:55:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On subject groups id 243', '243', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:55:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'New Record inserted On subject groups id 244', '244', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On subjects id 356', '356', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On subjects id 357', '357', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:56:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On subjects id 358', '358', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:56:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'New Record inserted On subjects id 359', '359', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:56:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'New Record inserted On subject groups id 245', '245', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record inserted On subject groups id 246', '246', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On subject groups id 247', '247', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On subjects id 360', '360', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On subject groups id 248', '248', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'New Record inserted On subject groups id 249', '249', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:57:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On subjects id 361', '361', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:58:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On subjects id 362', '362', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:58:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'New Record inserted On subjects id 363', '363', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:59:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On subjects id 364', '364', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'New Record inserted On subjects id 365', '365', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:59:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On subjects id 366', '366', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 11:59:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On subjects id 367', '367', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:00:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On subjects id 368', '368', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:00:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'New Record inserted On subjects id 369', '369', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:00:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'New Record inserted On subjects id 370', '370', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:00:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On subjects id 371', '371', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:01:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'New Record inserted On subjects id 372', '372', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:01:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On subjects id 373', '373', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:02:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'New Record inserted On subjects id 374', '374', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:02:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'New Record inserted On subjects id 375', '375', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:02:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'New Record inserted On subjects id 376', '376', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On subjects id 377', '377', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:02:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'New Record inserted On subjects id 378', '378', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:02:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On subjects id 379', '379', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:03:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'New Record inserted On subjects id 380', '380', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:03:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'New Record inserted On subjects id 381', '381', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:03:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'New Record inserted On subjects id 382', '382', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:03:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On subjects id 383', '383', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'New Record inserted On subjects id 384', '384', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:04:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'New Record inserted On subjects id 385', '385', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:04:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'New Record inserted On subjects id 386', '386', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:05:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'New Record inserted On subjects id 387', '387', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:05:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On subjects id 388', '388', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'New Record inserted On subjects id 389', '389', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:05:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'New Record inserted On subjects id 390', '390', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:06:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On subjects id 391', '391', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:07:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On subjects id 392', '392', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:07:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'New Record inserted On subjects id 393', '393', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:08:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'New Record inserted On subjects id 394', '394', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:08:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On subjects id 395', '395', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:08:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'New Record inserted On subjects id 396', '396', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:09:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'Record deleted On hostel id 1', '1', 2, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:10:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'Record deleted On hostel id 2', '2', 2, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:10:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'Record updated On  room types id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On room types id 2', '2', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:11:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'New Record inserted On subjects id 397', '397', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:12:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'New Record inserted On hostel id 3', '3', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:12:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'New Record inserted On subjects id 398', '398', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:13:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'New Record inserted On subjects id 399', '399', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:13:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'New Record inserted On subjects id 400', '400', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:14:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'New Record inserted On subjects id 401', '401', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:14:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'New Record inserted On subjects id 402', '402', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:14:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'New Record inserted On hostel rooms id 1', '1', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:14:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'New Record inserted On subjects id 403', '403', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:15:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On subjects id 404', '404', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:15:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'New Record inserted On hostel id 4', '4', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:17:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'New Record inserted On hostel id 5', '5', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:17:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'New Record inserted On hostel id 6', '6', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:18:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'Record updated On  hostel id 5', '5', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:18:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'New Record inserted On hostel id 7', '7', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:18:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On hostel id 8', '8', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:18:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'New Record inserted On hostel id 9', '9', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:18:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'New Record inserted On hostel id 10', '10', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:19:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'Record deleted On hostel id 3', '3', 2, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:19:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On hostel id 11', '11', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:19:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'New Record inserted On hostel id 12', '12', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:19:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On hostel rooms id 2', '2', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:21:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'New Record inserted On subjects id 405', '405', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:21:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'New Record inserted On hostel rooms id 3', '3', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:21:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On subjects id 406', '406', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:22:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'Record updated On  hostel rooms id 3', '3', 1, 'Update', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:22:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'New Record inserted On subjects id 407', '407', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:22:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On subjects id 408', '408', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:23:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'Record updated On  hostel rooms id 2', '2', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:23:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On subjects id 409', '409', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:23:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'New Record inserted On subjects id 410', '410', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:24:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On subjects id 411', '411', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'Record updated On staff id 5', '5', 5, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:24:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'New Record inserted On subjects id 412', '412', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:24:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'Record updated On  hostel rooms id 2', '2', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:24:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'New Record inserted On subjects id 413', '413', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:25:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On hostel rooms id 4', '4', 1, 'Insert', '102.0.13.114', 'Windows 10', 'Firefox 133.0', '2025-01-10 12:25:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'Record updated On  hostel rooms id 3', '3', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:25:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'New Record inserted On subjects id 414', '414', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:25:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'New Record inserted On subjects id 415', '415', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:25:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record updated On  hostel rooms id 2', '2', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:25:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'New Record inserted On subjects id 416', '416', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:25:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'Record updated On  hostel rooms id 3', '3', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:26:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'New Record inserted On subjects id 417', '417', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:26:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On subjects id 418', '418', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:26:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'New Record inserted On subjects id 419', '419', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'Record updated On  hostel rooms id 3', '3', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On subjects id 420', '420', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'Record updated On  hostel rooms id 4', '4', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On subjects id 421', '421', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On subjects id 422', '422', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:27:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'Record updated On  hostel rooms id 2', '2', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'Record updated On  hostel rooms id 3', '3', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'Record updated On  hostel rooms id 4', '4', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On subjects id 423', '423', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:28:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'New Record inserted On subjects id 424', '424', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On subjects id 425', '425', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On subjects id 426', '426', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:28:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On subjects id 427', '427', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:29:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On subjects id 428', '428', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'New Record inserted On hostel rooms id 5', '5', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:29:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On subjects id 429', '429', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:30:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'New Record inserted On subjects id 430', '430', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:30:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'New Record inserted On subjects id 431', '431', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:30:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'New Record inserted On subjects id 432', '432', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:30:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On subjects id 433', '433', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:30:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'New Record inserted On subjects id 434', '434', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:31:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On subjects id 435', '435', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:31:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On hostel rooms id 6', '6', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:31:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On subjects id 436', '436', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'New Record inserted On subjects id 437', '437', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On hostel rooms id 7', '7', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'New Record inserted On subjects id 438', '438', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'New Record inserted On subjects id 439', '439', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'New Record inserted On subjects id 440', '440', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:32:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'New Record inserted On subjects id 441', '441', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:32:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'New Record inserted On subjects id 442', '442', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:33:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'New Record inserted On subjects id 443', '443', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:33:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'New Record inserted On subjects id 444', '444', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:33:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'New Record inserted On subjects id 445', '445', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:33:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'New Record inserted On subjects id 446', '446', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:34:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'New Record inserted On subjects id 447', '447', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:34:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'New Record inserted On subjects id 448', '448', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:34:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'New Record inserted On subjects id 449', '449', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'New Record inserted On subjects id 450', '450', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On subjects id 451', '451', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:35:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'New Record inserted On subjects id 452', '452', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:35:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On subjects id 453', '453', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'New Record inserted On subjects id 454', '454', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On subject groups id 250', '250', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'New Record inserted On subjects id 455', '455', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:36:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'New Record inserted On subject groups id 251', '251', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'New Record inserted On subjects id 456', '456', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'New Record inserted On subject groups id 252', '252', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:36:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'New Record inserted On subject groups id 253', '253', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On subjects id 457', '457', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'New Record inserted On subject groups id 254', '254', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On subjects id 458', '458', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'New Record inserted On subjects id 459', '459', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:37:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On subjects id 460', '460', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On subject groups id 255', '255', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:37:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'New Record inserted On subject groups id 256', '256', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On subjects id 461', '461', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:38:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On subjects id 462', '462', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:38:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On subjects id 463', '463', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:38:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On subjects id 464', '464', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:39:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'New Record inserted On subjects id 465', '465', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:39:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On subject groups id 257', '257', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'New Record inserted On hostel rooms id 8', '8', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:39:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On subject groups id 258', '258', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:39:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'New Record inserted On subjects id 466', '466', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'New Record inserted On subjects id 467', '467', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:40:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On subject groups id 259', '259', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'New Record inserted On subject groups id 260', '260', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On subjects id 468', '468', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'New Record inserted On subjects id 469', '469', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'New Record inserted On hostel rooms id 9', '9', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:40:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'New Record inserted On subject groups id 261', '261', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:40:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'New Record inserted On subjects id 470', '470', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'New Record inserted On subject groups id 262', '262', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'New Record inserted On subjects id 471', '471', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'New Record inserted On subject groups id 263', '263', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On subjects id 472', '472', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'New Record inserted On subject groups id 264', '264', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'New Record inserted On subjects id 473', '473', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:41:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'New Record inserted On subjects id 474', '474', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'New Record inserted On subject groups id 265', '265', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:41:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'New Record inserted On hostel rooms id 10', '10', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:42:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'New Record inserted On subjects id 475', '475', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'New Record inserted On subjects id 476', '476', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'New Record inserted On subject groups id 266', '266', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'New Record inserted On subject groups id 267', '267', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'New Record inserted On subjects id 477', '477', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'New Record inserted On subjects id 478', '478', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'New Record inserted On hostel rooms id 11', '11', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'New Record inserted On subject groups id 268', '268', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'New Record inserted On subject groups id 269', '269', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'New Record inserted On subjects id 479', '479', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'New Record inserted On subject groups id 270', '270', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'New Record inserted On subjects id 480', '480', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'New Record inserted On subject groups id 271', '271', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'New Record inserted On subjects id 481', '481', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'New Record inserted On subjects id 482', '482', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'New Record inserted On hostel rooms id 12', '12', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:44:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'New Record inserted On subjects id 483', '483', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:44:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'New Record inserted On subjects id 484', '484', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:44:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'New Record inserted On subjects id 485', '485', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:44:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'New Record inserted On subjects id 486', '486', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:44:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'New Record inserted On subjects id 487', '487', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:45:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'New Record inserted On subjects id 488', '488', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:45:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'New Record inserted On subjects id 489', '489', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:45:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'New Record inserted On subjects id 490', '490', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:45:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'New Record inserted On subjects id 491', '491', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:46:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'New Record inserted On subjects id 492', '492', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:47:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'New Record inserted On subjects id 493', '493', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:47:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'New Record inserted On hostel rooms id 13', '13', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:47:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On subjects id 494', '494', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:47:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'New Record inserted On subjects id 495', '495', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:48:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On hostel rooms id 14', '14', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:48:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'New Record inserted On subjects id 496', '496', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:49:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'New Record inserted On subjects id 497', '497', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:49:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'New Record inserted On hostel rooms id 15', '15', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:49:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'New Record inserted On subjects id 498', '498', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:50:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'New Record inserted On subjects id 499', '499', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:50:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'New Record inserted On hostel rooms id 16', '16', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:51:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'New Record inserted On subjects id 500', '500', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:52:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On subjects id 501', '501', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:53:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'New Record inserted On subject groups id 272', '272', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:54:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'New Record inserted On subjects id 502', '502', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:54:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'New Record inserted On hostel rooms id 17', '17', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:54:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'New Record inserted On subjects id 503', '503', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:54:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'New Record inserted On subject groups id 273', '273', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:54:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'New Record inserted On subjects id 504', '504', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:54:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'New Record inserted On subjects id 505', '505', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'New Record inserted On subject groups id 274', '274', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'New Record inserted On subjects id 506', '506', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On subjects id 507', '507', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'New Record inserted On subjects id 508', '508', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On subjects id 509', '509', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:55:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'New Record inserted On subjects id 510', '510', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:56:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'New Record inserted On subjects id 511', '511', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:56:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'New Record inserted On subjects id 512', '512', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:56:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On subjects id 513', '513', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:56:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'New Record inserted On subjects id 514', '514', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:56:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'Record updated On  hostel rooms id 16', '16', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:56:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'Record updated On  hostel rooms id 13', '13', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:57:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On subjects id 515', '515', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 12:57:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'New Record inserted On subjects id 516', '516', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:57:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On subjects id 517', '517', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:58:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'New Record inserted On subjects id 518', '518', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:58:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On subjects id 519', '519', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:58:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'New Record inserted On subject groups id 275', '275', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:58:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'New Record inserted On subject groups id 276', '276', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:58:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'New Record inserted On subjects id 520', '520', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:59:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'New Record inserted On subject groups id 277', '277', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:59:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'New Record inserted On subject groups id 278', '278', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:59:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'New Record inserted On subject groups id 279', '279', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:59:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'New Record inserted On hostel rooms id 18', '18', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 12:59:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On subjects id 521', '521', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 12:59:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'New Record inserted On subjects id 522', '522', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:00:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'New Record inserted On subjects id 523', '523', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:00:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'New Record inserted On subjects id 524', '524', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:00:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'New Record inserted On subjects id 525', '525', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:00:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'New Record inserted On subject groups id 280', '280', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'New Record inserted On subject groups id 281', '281', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'New Record inserted On subjects id 526', '526', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'New Record inserted On subject groups id 282', '282', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'New Record inserted On subject groups id 283', '283', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'New Record inserted On subject groups id 284', '284', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'New Record inserted On subjects id 527', '527', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On hostel rooms id 19', '19', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:01:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'New Record inserted On subjects id 528', '528', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On subject groups id 285', '285', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:01:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'New Record inserted On subject groups id 286', '286', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:02:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'New Record inserted On hostel rooms id 20', '20', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:02:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'New Record inserted On subject groups id 287', '287', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:02:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On subject groups id 288', '288', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'New Record inserted On subjects id 529', '529', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'New Record inserted On subject groups id 289', '289', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'New Record inserted On subjects id 530', '530', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'New Record inserted On subject groups id 290', '290', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'New Record inserted On hostel rooms id 21', '21', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:03:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'New Record inserted On subject groups id 291', '291', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:03:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'New Record inserted On subject groups id 292', '292', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:04:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'New Record inserted On subject groups id 293', '293', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'New Record inserted On subjects id 531', '531', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:04:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'New Record inserted On subject groups id 294', '294', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:04:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'New Record inserted On hostel rooms id 22', '22', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:05:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'New Record inserted On subjects id 532', '532', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:05:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'New Record inserted On subjects id 533', '533', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'New Record inserted On subjects id 534', '534', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'New Record inserted On subjects id 535', '535', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:06:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'New Record inserted On subjects id 536', '536', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:06:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'New Record inserted On subjects id 537', '537', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:07:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'New Record inserted On subjects id 538', '538', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:07:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On subjects id 539', '539', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:07:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'New Record inserted On subjects id 540', '540', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:08:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'New Record inserted On subjects id 541', '541', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:08:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'New Record inserted On subjects id 542', '542', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:08:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:09:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'New Record inserted On subjects id 543', '543', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:10:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On subjects id 544', '544', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:10:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'New Record inserted On subjects id 545', '545', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:10:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On subjects id 546', '546', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:10:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:11:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On subjects id 547', '547', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:11:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'New Record inserted On subjects id 548', '548', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:11:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'New Record inserted On subjects id 549', '549', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:11:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'New Record inserted On hostel rooms id 23', '23', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:11:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'New Record inserted On subjects id 550', '550', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'New Record inserted On subjects id 551', '551', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:12:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'Record updated On  hostel rooms id 14', '14', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'New Record inserted On subjects id 552', '552', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'New Record inserted On subjects id 553', '553', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'Record updated On  hostel rooms id 9', '9', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'Record updated On  hostel rooms id 10', '10', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'New Record inserted On subjects id 554', '554', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'Record updated On  hostel rooms id 8', '8', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:12:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'New Record inserted On subjects id 555', '555', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'Record updated On  hostel rooms id 23', '23', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'New Record inserted On subjects id 556', '556', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'New Record inserted On hostel rooms id 24', '24', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:13:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'New Record inserted On subjects id 557', '557', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:13:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'New Record inserted On subjects id 558', '558', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'New Record inserted On subjects id 559', '559', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'New Record inserted On subject groups id 295', '295', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:13:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'New Record inserted On subjects id 560', '560', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:14:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On hostel rooms id 25', '25', 4, 'Insert', '141.0.13.163', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:14:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'New Record inserted On subjects id 561', '561', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:14:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'New Record inserted On subjects id 562', '562', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:14:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'New Record inserted On subjects id 563', '563', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:14:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'New Record inserted On subjects id 564', '564', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'New Record inserted On subjects id 565', '565', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On hostel rooms id 26', '26', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:15:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'New Record inserted On subjects id 566', '566', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On subjects id 567', '567', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'New Record inserted On subjects id 568', '568', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On subjects id 569', '569', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:15:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'New Record inserted On hostel rooms id 27', '27', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:16:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'New Record inserted On subjects id 570', '570', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:16:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'New Record inserted On subjects id 571', '571', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On subjects id 572', '572', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:16:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'New Record inserted On subjects id 573', '573', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On subjects id 574', '574', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:17:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'New Record inserted On subjects id 575', '575', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:17:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'New Record inserted On hostel rooms id 28', '28', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:17:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'New Record inserted On subjects id 576', '576', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:17:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On subjects id 577', '577', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:17:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'New Record inserted On subjects id 578', '578', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:18:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'New Record inserted On subjects id 579', '579', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:18:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'New Record inserted On hostel rooms id 29', '29', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:18:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On subjects id 580', '580', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:18:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'New Record inserted On subjects id 581', '581', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:18:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On subjects id 582', '582', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'New Record inserted On hostel rooms id 30', '30', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:19:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'New Record inserted On subjects id 583', '583', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:19:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'New Record inserted On subjects id 584', '584', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:19:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'New Record inserted On subjects id 585', '585', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:19:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'New Record inserted On subjects id 586', '586', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:19:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'New Record inserted On subjects id 587', '587', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:20:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'New Record inserted On subjects id 588', '588', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:20:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'New Record inserted On subjects id 589', '589', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:20:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On subjects id 590', '590', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:20:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'New Record inserted On subjects id 591', '591', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:21:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'Record deleted On subjects id 589', '589', 2, 'Delete', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'New Record inserted On subjects id 592', '592', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:22:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'New Record inserted On subjects id 593', '593', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:22:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'New Record inserted On subjects id 594', '594', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:22:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'New Record inserted On subjects id 595', '595', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:23:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'New Record inserted On subjects id 596', '596', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:23:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'New Record inserted On subjects id 597', '597', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:23:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'New Record inserted On subjects id 598', '598', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:24:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'New Record inserted On subjects id 599', '599', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:24:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'New Record inserted On subjects id 600', '600', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:25:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'New Record inserted On subjects id 601', '601', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:25:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'New Record inserted On subjects id 602', '602', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:25:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'New Record inserted On subjects id 603', '603', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:26:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'New Record inserted On subjects id 604', '604', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:26:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'New Record inserted On subjects id 605', '605', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:26:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'New Record inserted On hostel rooms id 31', '31', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:27:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'New Record inserted On subjects id 606', '606', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:27:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'New Record inserted On subjects id 607', '607', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'New Record inserted On subjects id 608', '608', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:28:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'New Record inserted On subjects id 609', '609', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:28:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'New Record inserted On subjects id 610', '610', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:28:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'New Record inserted On subjects id 611', '611', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:28:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'New Record inserted On subjects id 612', '612', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:28:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'New Record inserted On subjects id 613', '613', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:29:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'Record updated On subjects id 597', '597', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:29:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'New Record inserted On subjects id 614', '614', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:30:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'New Record inserted On subjects id 615', '615', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:30:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'New Record inserted On subjects id 616', '616', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:31:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On subjects id 617', '617', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:31:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'New Record inserted On hostel rooms id 32', '32', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:31:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'New Record inserted On subjects id 618', '618', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:31:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'New Record inserted On subjects id 619', '619', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:32:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'New Record inserted On subjects id 620', '620', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:32:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'New Record inserted On subjects id 621', '621', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:32:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'New Record inserted On subjects id 622', '622', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:32:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'New Record inserted On subjects id 623', '623', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:33:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'New Record inserted On subjects id 624', '624', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:33:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'New Record inserted On subjects id 625', '625', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:33:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'New Record inserted On subjects id 626', '626', 2, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:33:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'New Record inserted On hostel rooms id 33', '33', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:34:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'New Record inserted On subjects id 627', '627', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:35:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'New Record inserted On hostel rooms id 34', '34', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:35:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'New Record inserted On subjects id 628', '628', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:35:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'New Record inserted On subjects id 629', '629', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:35:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'New Record inserted On subjects id 630', '630', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:36:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'New Record inserted On subjects id 631', '631', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:36:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'New Record inserted On subjects id 632', '632', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'New Record inserted On subjects id 633', '633', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:36:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'New Record inserted On subjects id 634', '634', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:37:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'New Record inserted On hostel rooms id 35', '35', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:37:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'New Record inserted On subjects id 635', '635', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:37:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'New Record inserted On subjects id 636', '636', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:37:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'New Record inserted On subjects id 637', '637', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:38:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'New Record inserted On subjects id 638', '638', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:38:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On hostel rooms id 36', '36', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'New Record inserted On subjects id 639', '639', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:38:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'New Record inserted On subjects id 640', '640', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:39:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'New Record inserted On subjects id 641', '641', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:39:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'New Record inserted On subjects id 642', '642', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:39:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'New Record inserted On subjects id 643', '643', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'New Record inserted On subjects id 644', '644', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:40:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'New Record inserted On subjects id 645', '645', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:40:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'New Record inserted On subjects id 646', '646', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'New Record inserted On subjects id 647', '647', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:40:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'New Record inserted On subjects id 648', '648', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:40:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'New Record inserted On subjects id 649', '649', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'New Record inserted On subjects id 650', '650', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:41:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'New Record inserted On subjects id 651', '651', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:41:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'New Record inserted On hostel rooms id 37', '37', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:42:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'New Record inserted On subjects id 652', '652', 5, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:42:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'New Record inserted On subjects id 653', '653', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:42:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'New Record inserted On subjects id 654', '654', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:42:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'New Record inserted On hostel rooms id 38', '38', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:43:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'New Record inserted On subjects id 655', '655', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:43:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'New Record inserted On subjects id 656', '656', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:44:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'New Record inserted On subjects id 657', '657', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:44:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'New Record inserted On subjects id 658', '658', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:44:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'New Record inserted On hostel rooms id 39', '39', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:44:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'New Record inserted On subjects id 659', '659', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'New Record inserted On hostel rooms id 40', '40', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:46:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'New Record inserted On subjects id 660', '660', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'New Record inserted On subjects id 661', '661', 6, 'Insert', '102.215.15.120', 'Android', 'Chrome 131.0.0.0', '2025-01-10 13:46:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'New Record inserted On subjects id 662', '662', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:46:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1224, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1225, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1226, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1227, 'New Record inserted On subjects id 663', '663', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1228, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1229, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1230, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1231, 'New Record inserted On subjects id 664', '664', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1232, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:47:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1233, 'New Record inserted On subjects id 665', '665', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:48:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1234, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:48:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1235, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:48:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1236, 'New Record inserted On subjects id 666', '666', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:48:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1237, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:48:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1238, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1239, 'New Record inserted On subjects id 667', '667', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1240, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1241, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1242, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1243, 'New Record inserted On subjects id 668', '668', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1244, 'New Record inserted On hostel rooms id 41', '41', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:49:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1245, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1246, 'New Record inserted On subjects id 669', '669', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:49:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1247, 'New Record inserted On subjects id 670', '670', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:50:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1248, 'New Record inserted On subjects id 671', '671', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:50:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1249, 'New Record inserted On hostel rooms id 42', '42', 4, 'Insert', '82.145.222.200', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:51:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1250, 'New Record inserted On subjects id 672', '672', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:51:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1251, 'New Record inserted On subjects id 673', '673', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:51:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1252, 'New Record inserted On subjects id 674', '674', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:52:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1253, 'New Record inserted On subjects id 675', '675', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:52:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1254, 'New Record inserted On subjects id 676', '676', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:53:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1255, 'New Record inserted On hostel rooms id 43', '43', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1256, 'New Record inserted On hostel rooms id 44', '44', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1257, 'New Record inserted On hostel rooms id 45', '45', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1258, 'New Record inserted On hostel rooms id 46', '46', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1259, 'New Record inserted On hostel rooms id 47', '47', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1260, 'New Record inserted On hostel rooms id 48', '48', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:53:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1261, 'New Record inserted On subjects id 677', '677', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:53:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1262, 'New Record inserted On subjects id 678', '678', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:54:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1263, 'New Record inserted On subjects id 679', '679', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:54:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1264, 'New Record inserted On subjects id 680', '680', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:55:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1265, 'New Record inserted On subjects id 681', '681', 7, 'Insert', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:55:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1266, 'New Record inserted On hostel rooms id 49', '49', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:56:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1267, 'New Record inserted On hostel rooms id 50', '50', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:57:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1268, 'New Record inserted On hostel rooms id 51', '51', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 13:58:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1269, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:59:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1270, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:59:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1271, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-10 13:59:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1272, 'New Record inserted On hostel rooms id 52', '52', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 14:00:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1273, 'New Record inserted On hostel rooms id 53', '53', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 14:01:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1274, 'New Record inserted On hostel rooms id 54', '54', 4, 'Insert', '141.0.13.152', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 14:03:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1275, 'Record deleted On hostel rooms id 43', '43', 2, 'Delete', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 14:07:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1276, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:06:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1277, 'Record updated On settings id 1', '1', 2, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:07:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1278, 'Record updated On permission group id 8', '8', 2, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:09:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1279, 'New Record inserted On  subject timetable id 1', '1', 1, 'Insert', '154.159.252.18', 'Windows 10', 'Firefox 133.0', '2025-01-10 15:17:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1280, 'Record updated On staff id 7', '7', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:56:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1281, 'Record updated On staff id 7', '7', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:56:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1282, 'Record updated On staff id 5', '5', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:56:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1283, 'Record updated On staff id 5', '5', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:56:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1284, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1285, 'Record updated On staff id 4', '4', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1286, 'Record updated On staff id 7', '7', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:58:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1287, 'Record updated On staff id 7', '7', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 15:58:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1288, 'New Record inserted On hostel rooms id 55', '55', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 15:59:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1289, 'New Record inserted On hostel rooms id 56', '56', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:01:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1290, 'New Record inserted On hostel rooms id 57', '57', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:02:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1291, 'New Record inserted On hostel rooms id 58', '58', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:03:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1292, 'New Record inserted On hostel rooms id 59', '59', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:05:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1293, 'New Record inserted On hostel rooms id 60', '60', 4, 'Insert', '141.0.12.28', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:06:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1294, 'New Record inserted On hostel rooms id 61', '61', 4, 'Insert', '141.0.12.71', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1295, 'New Record inserted On hostel rooms id 62', '62', 4, 'Insert', '141.0.12.71', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:07:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1296, 'New Record inserted On hostel rooms id 63', '63', 4, 'Insert', '141.0.12.71', 'Android', 'Opera 87.1.2254.75427', '2025-01-10 16:08:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1297, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 16:10:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1298, 'Record updated On settings id 1', '1', 1, 'Update', '102.215.15.120', 'Linux', 'Chrome 131.0.0.0', '2025-01-10 16:10:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1299, 'Record updated On staff id 4', '4', 2, 'Update', '102.215.15.120', 'Windows 10', 'Chrome 131.0.0.0', '2025-01-11 04:36:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1300, 'Record updated On staff id 4', '4', 2, 'Update', '102.215.15.120'