#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL,
  `event_notification_message` text NOT NULL,
  `show_onwebsite` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `alumni_events_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `alumni_events_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `current_email` varchar(255) NOT NULL,
  `current_phone` varchar(255) NOT NULL,
  `occupation` text NOT NULL,
  `address` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `alumni_students_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `for_qr_attendance` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'present', 'label label-success', 'yes', 1, '2023-12-13 02:53:10', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'late_with_excuse', 'label label-warning text-dark', 'no', 0, '2023-12-13 02:51:03', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'late', 'label label-warning text-dark', 'yes', 1, '2023-12-13 02:51:09', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'absent', 'label label-danger', 'yes', 0, '2023-12-15 01:18:05', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'holiday', 'label label-info', 'yes', 0, '2023-12-14 07:57:13', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'half_day', 'label label-warning text-dark', 'yes', 1, '2023-12-15 01:18:37', '0000-00-00');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_id` int(11) NOT NULL,
  `member_id` int(11) DEFAULT NULL,
  `duereturn_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT 0,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `book_id` (`book_id`),
  KEY `member_id` (`member_id`),
  CONSTRAINT `book_issues_ibfk_1` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_ibfk_2` FOREIGN KEY (`member_id`) REFERENCES `libarary_members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=435 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'FUNDAMENTALS OF ENVIRONMENTAL CHEMISTRY', '0001', '978-1-4200-5267-1', 'Chemistry ', '', 'CRC Press', 'STANLEY E.MANAHAN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 02:42:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'WORD BOOK', '0002', '978-0-7166-0108-1', 'HISTORY ', '', 'WORLD BOOK ENCYCLOPEDIA', 'World book', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:17:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'PHILOSOPHY OF HISTORY', '0003', '81-307-0686', '', '', 'COSMOS PUBLICATIONS', 'GENESIS PUBLISHING PVT.LMD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:16:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'HEALTH EDUCATION $ BEHAVIOR', '1000', '1090-1981', 'HEALTH EDUCATION $ BEHAVIOR ', '', 'AN OFFICIAL PUBLISHER OF THE SOCIETY FOR PUBLIC HEALTH EDUCATION ', 'JOHN P.ALLEGRANTE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 03:48:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'THE CAMBRIDGE ENCYCLOPEDIA OF LANGUAGE', '1001', '978-0-521-51698-3', 'THE CAMBRIDGE ENCYCLOPEDIA OF LANGUAGE ', '', 'CAMBRIDGE UNIVERSITY PRESS ', 'DAVID CRYSTAL ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:16:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'COMPUTER NETWORK', '0004', '0-13-038488-7', 'COMPUTER', '', '', 'ANDREW S.TANENBAUM', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:15:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'MECHANICS OF MATERIALS', '0005', '13:978-1-111-13603-1', 'MECHANICS', '', 'GLOBAL ENGENEERING', 'JAMES M. GERE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:21:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'WORLD OF MUSIC', '1002', '0-382-18279-0', 'WORLD OF MUSIC ', '', 'SILVER BURDETT $ GINN', 'JANE BEETHOVEN ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:23:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'LIVINGSTONE AND THE EXPLORATION OF CENTRAL AFRICA', '0006', '978-1-44372-024-3', 'HISTORY', '', 'DAVID LIVINGSTONE', 'SIR H,H JOHNSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:25:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'NETWORKING COMPLETE', '0007', '81-7656-715-9', 'COMPUTER', '', 'BPB PUBLICATION', 'BPB PUBLICATIONS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:31:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'PEOPLE RAISING', '0008', '0-8024-6447-5', 'PRACTICAL GUIDE TO RAISING SUPPORT', '', 'MOODY PRESS CHICAGO', 'WILLIAM P DILLON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:38:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'CULTIVATING FREUD\'S GARDEN IN FRANCE', '1003', 'O-87668-995-O', 'CULTIVATING FREUD\'S GARDEN IN FRANCE', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'MARION MICHEL OLINER,PH.D', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:47:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'INFORMATION SYSTEMS DEVELOPMENT', '0009', '0-07-711417-5', 'MCGRAW-HILL EDUCATION(UK)', '', '', 'DAVID AVISON & GUY FITGERALD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:50:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'MATHEMATICS', '0010', '0-382-37005-8', 'MATHEMATICS', '', 'SILVER BURDETT GINN', 'FRANCIS FENNELL (PHD)', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:54:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'THE COUNSELLING PROCESS', '1004', '978-0-534-64032-3', 'THE COUNSELLING PROCESS', '', 'THOMSON BROOKS/COLE', 'ELIZABETH REYNOLDS WELFEL', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:55:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'THE PROJECT MANAGEMENT TOOL KIT', '0011', '978-81-203-3556-1', 'TIPS AND TECHNIQUES FOR GETTING JOBS', '', 'PRENTICE HALL OF INDIA', 'KENDRICK', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 04:59:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'COUNSELING ADULTS', '1005', 'O-8185-0502-8', 'COUNSELING ADULTS', '', 'BROOKS/COLE PUBLISHING COMPANY', 'WILLIAM H.VAN HOOSE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:01:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'COUNSELING DIVERSE POPULATIONS', '1006', '0-697-36185-3', 'COUNSELING DIVERSE POPULATION', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DONALD R.ATKINSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:07:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'THE PFEIFFER BOOK OF SUCCESSFUL CONFLICT MANAGEMENT TOOLS', '0012', '978-0-4701-9344-0-9000', 'PRESENTATION AND DISCUSSION RESOURCES', '', 'JOSSEY-BASS/PFEIFFER', 'JACK GORDON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:08:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'FUNDAMENTALS OF SOCIAL RESEARCH', '0013', '9966-9802-1-0', 'RESEARCH', '', 'EUREKA PUBLISHERS', 'MUTEA RUKWARU', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:10:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'A DICTIONARY OF ECONOMICS AND COMMERCE', '0014', '0-7121 06499', 'COMMERCE', '', 'PITMAN', 'J. L. HANSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:14:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'MANAGEMENT THEORY AND PRACTICE', '1007', '978-1-84480-095-7', 'MANAGEMENT THEORY AND PRACTICE', '', 'BOOK POWER/ELST', 'GERALD COLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:14:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'CHILD RIGHTS AND CHILD PROTECTION', '0015', '996636155-3', 'CHILD RIGHTS', '', 'LONGHORN', 'CATHERINE GICHUBA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:17:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'SYSTEM THEORY AND MANAGEMENT INFORMATION SYSTEMS SIMPLIFIED', '1008', '9966-28-886-4', 'COMPUTER SYSTEMS', '', 'SALEEMI PUBLICATIONS LTD', 'NISAR AHMAD SALEEMI', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:21:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'FUNDAMENTALS OF CORPORATE FINANCE', '1009', '13:978-0-07-299121-5', 'FINANCE', '', 'STEPHEN M.PATTERSON', 'STEPHEN A.ROSS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:29:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'SENSE AND NONSENSE ABOUT CRIME', '0016', '0-534-09120-2', 'A POLICY GUIDE', '', 'BROOKS/COLE PUBLISHING COMPANY', 'SAMUEL WALKER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:44:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'PERSONEL AND HUMAN RESOURCE MANAGEMENT', '0017', '978-0-82646-128-5', 'HUMAN RESOURCE MANAGEMENT', '', 'BOOK POWER', 'G.A COLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:44:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'COFFEE WITH PLEASURE', '1010', '1-55164-190-9', 'JUST JAVA AND WORLD TRADE', '', 'BLACK ROSE BOOKS', 'LAURE WARIDEL', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:48:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'MATHEMATICS', '0018', '0-395-53015-6', 'MATHEMATICS', '', 'HOUGHTON MIFFLIN', 'LELON R. CAPPS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:49:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CELEBRATE STORIES OF JEWISH HOLIDAYS', '0019', '0-439-43052-6', 'RELIGION', '', 'PETER CATALANOTTO', 'GILDA BERGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:53:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'MANAGERIAL ACCOUNTING', '1011', '978-0-470-33334-1', 'ACCOUNTING', '', 'WILEY PLUS', 'JAMES JIAMBALVO', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:55:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'MARKETING MANAGEMENT TEST AND CASES', '1012', '9-814-12621-7', 'MARKETING', '', 'JOHN WILEY AND SONS', 'DOUGLAS J.DALRYMPLE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 05:59:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'STOLEN THUNDER', '0020', '0- 395-64368-6', 'NOVEL', '', 'HOUGHTON MIFFLIN COMPANY', 'SHIRLEY CLIMO', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:01:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'MICROECONOMICS', '1013', '0-07-2872207-1', 'BUSINESS', '', 'GARY BURKE', 'PAUL A.SAMUELSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:03:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'PUBLIC FINANCE', '0021', '978-93-259-6000-8', 'FINANCE', '', 'VIKAS PUBLISHING HOUSE PVT LTD', 'H L BHATIA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:04:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'EFFECTIVE SMALL BUSINESS MANAGEMENT', '0022', '978-0-13-615270-5', 'ENTERPRENUERSHIP', '', 'PEARSON EDUCATION LTD', 'NORMAN M. SCARBOROUGH', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:09:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'OPERATIONAL PROFITABILITY', '1014', '0-471-21473-6', 'BUSINESS', '', 'JOHN WILEY$ SONS,INC', 'ROBERT M.TOROK', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:09:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'STATE OF THE WORLD', '0023', '0-393-02638-8', 'HISTORY', '', 'WORLDWATCH INSTITUTE', 'LESTER R. BROWN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:12:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'MANAGING CASH FLOW', '0024', '0-471-22809-5', 'BUSINESS', '', 'JOHN WILEY &SONS', 'ROB REIDER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:14:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'UNDERSTANDING ECONOMICS', '1015', '0-676-39629-1', 'BUSINESS', '', 'RANDOM HOUSE,INC', 'DR. ALLEN W. SMITH ', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:16:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'FIVE LITTLE PENGUINS SLIPPING ON THE ICE', '1016', '0-439-46577-X', 'NOVEL', '', 'SCHOLASTIC INC', 'STEVE METZGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:22:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'PSYCHOLOGY ANDROGYNY FURTHER CONSIDERATION', '0025', '0-87705--418-5', 'PSYCHOLOGY PERSONALITIES', '', 'HUMAN SCIENCES PRESS  ', 'GEORGIA BABLADELIS', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:22:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'CHILDHOOD IN CONTEMPORARY', '0026', '26500 00000', 'NOVEL', '', 'GREGORY BATESON', 'MARGARET MEAD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:27:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'A GUIDE TO ACADEMIC WRITING', '1017', '9966-9925-0-2', 'A GUIDE TO ACADEMIC WRITING', '', 'ZAPF CHANCERY', 'C.B. PETER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:29:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'UNIVERSITY ECONOMICS', '0027', '', 'ECONOMICS', '', 'SOUTH ATLANTIC QUARTERLY', 'ARMEN A. ALCHIAN67-15730', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:32:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'ECONOMICS', '1018', '0-395-355526-6', 'BUSINESS', '', 'HOUGHTON MIFFLIN COMPANY BOSTON', 'RICHARD B. MCKENZIE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:34:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'INFORMATION TECHNOLOGY PROJECT MANAGEMENT', '0028', '978-1-133-62722-7', 'INFORMATION TECHNOLOGY', '', 'WWW.CENGAGE.COM', 'KATHY SCHWALBE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:40:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'STRATEGIC MANAGEMENT COMPETITIVENESS AND GLOBALIZATION', '1019', '0-324-11482-6', 'BUSINESS', '', 'THOMSON SOUTH-WESTERN', 'MICHAEL A. HITT', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:39:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'MICROSOFT EXCEL 2003', '0029', '0-07-283418-8', 'INFORMATION TECHNOLOGY', '', 'BRANDON NPRDIN', 'GLEN J. COULTHARD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:40:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'EVERETT ANDERSON 1.2.3', '1020', '0-8050-2310-0', 'NOVEL', '', 'HENRY HOLT AND COMPANY,INC', 'LUCILLE CLIFTON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:43:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'ENGLISH AT HAND', '1021', '0-944210-25-2', 'ENGLISH AT HAND', '', 'TOWNSEND PRESS', 'CHISTOPHER G. HAYES', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:48:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'IS THIS A HOUSE FOR HERMIT CRAB?', '0030', '0-395-73219-0', 'NOVEL', '', 'HOUGHTON MIFFLIN', 'MEGAN MC DONALD', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:50:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'BLAST OFF', '0031', '0-7836 1676-7', 'NOVEL', '', 'BUCKLE DOWN PUBLISHING COMPANY', 'ROBERT LOUIS STEVENSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:54:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'HAR COURT', '0032', '0-15-306401-3', 'NOVEL', '', 'SEA HARBOR DRIVE', 'RICHARD F. ABRAHAMSON', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 06:59:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'GRADUATE SCHOOL GUIDE', '0033', '0-910635-39-0', 'GUIDE OF DOCTORAL,MASTERS,PROFESSIONALS DEGREES', '', 'MYLES RIDDER', 'MARI CASTROVILLA', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:05:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'MIRROR MASK', '1022', '0-7475-8111-8', 'NOVEL', '', 'HARPER COLLINS PUBLISHERS', 'NEIL GAIMAN $ DAVE MCKEAN', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:11:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'HOW THE EARTH WORKS', '0034', '0-89577-411-9', 'NOVEL', '', 'JOHN FARDON', 'READERS DIGEST', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:17:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'CELEBRATE STORIES OF THE JEWISH HOLIDAYS', '0035', '0-439-43052-6', 'RELIGION', '', 'MARIJKA', 'GILDA BERGER', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:21:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'SIX DINNER SID', '0036', '0-671-79613-5', 'NOVEL', '', 'SIMON & SCHUSTER INC', 'INGA MOORE', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:24:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'MANAGEMENT A COMPETENCE-BASED APPROACH', '0037', '81-315-0204', 'COMMUNICATION', '', 'THOMSON SOUTH--WESTERN', 'HELLRIEGEL JACKSON SLOCUM', 0, '0.00', '2025-02-04', '', 'yes', 'no', '2025-02-04 07:27:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'KENYA\'S ETHIC COMMUNITIES FOUNDATION OF THE NATION', '0038', '9966-97570-5', 'HISTORY', '', 'GATUNDU', 'WANNGUHU NGANGA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:40:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'AN INTRODUCTION OF PHONOLOGY', '0039', '0-582-29150-X', 'PHONOLOGY', '', 'LONGMAN', 'FRANCIS KATAMBA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:44:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'SHAKESPEAR LIVES', '0040', '13: 978-0-7607-7932-3', '', '', 'BARNES &NOBLE', 'S.SCHOENBAUM', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:46:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'FOUNDATION OF FINANCIAL MARKETS AND INSTITUTON', '0041', '978-81-317-0390-8', 'BUSSINESS', '', 'PEARSON EDUCATION & DORSING KINDERSLEY', 'FRANK J. FABOZZI', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:50:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'THE REAL WARN ON CRIME', '0042', '0-06-095165-6', 'NOVEL', '', 'HARPERCOLLINS PUBLISHERS', 'STEVEN R. DONZIGER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:53:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'DISABILITY DISCOURSE', '0043', '0-335-20222-5', 'NOVEL', '', 'BUCKINGHAM', 'MAIRIAN CORKER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 04:56:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'THE SOCIAL PSYCOLOGY OF DRUGS', '0044', '0-335-20618-2', 'NOVEL', '', 'RICHARD P. BAGOZZI', 'STEVE SUSSMAN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:04:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'MILLER ECONOMICS TODAY', '0045', '0-06-044494-0', 'ECONOMICS', '', 'HARPER,ROW,PUBLISHER,NEW YORK', 'DAVID FORGIONE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:11:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'STRATEGIC MANAGEMENT CONCEPTS,DECISONS,CASES', '0046', '0-256-03256-4', 'BUSSINESS', '', 'BUSINESS PUBLICATIONS', 'LESTER A. DIGMAN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:21:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'ENGLISH LANGUAGE TEACHING IN KENYA POLICY,TRAINING AND PRACTICE', '1023', '9966-854-40-1', 'LANGUAGE', '', 'MOI UNIVERSITY PRESS', 'PETER L.BARASA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:22:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'MICROECONOMICS', '0047', '13: 978-13-139263-2', 'ECONOMICS', '', 'COPYRIGHT', 'JEFFREY M.PERLOFF', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:25:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'TEACH ENGLISH', '1024', '0-521-49860-0', 'LANGUAGE', '', 'CAMBRIDGE UNIVERSITY PRESS', 'ADRIAN DOFF', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:25:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'TIMEWARP STORIES', '1025', '0-19-2781898', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'DENNIS PEPPER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:29:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'QUANTITATIVE METHODS FOR BUSINESS', '0048', '978-81-315-0308-9', 'BUSINESS', '', 'CENGAGE LEARNING PRODUCTS', 'DAVID R. ANDERSON', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:30:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'INSTRUCTIONAL LEADERSHIP', '1026', '0-205-35497-1', 'TEACHING', '', 'A PEARSON EDUCATION COMPANY', 'ANITA WOOLFOLK HOY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:32:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'BUSINESS STUDIES FOR SECONDARY SCHOOLS', '0049', '996625395-5', 'BUSINESS', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS LTD', 'GETTY WEKESA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:33:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'WRITE ON TARGET', '1027', '1-884183-39-5', 'NOVEL', '', 'ENGLEFIELD AND ARNOLD', 'YOLANDE F.GRIZINSKI,ED.D', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:36:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'INTRODUCTION TO INFORMATION SYSTEMS', '0050', '81-265-0866-3', 'COMPUER', '', 'COPYRIGHT 2007', 'R. KELLY RAINER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:37:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'BUILDING VOCABULARY SKILLS', '1028', '0-944210-12-0', 'BUILDING', '', 'TOWNSEND PRESS', 'SHERRIE L .NIST', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:39:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'THE WAR ON DRUGS', '0051', '0-87484-743-5', 'NOVEL', '', 'MAYFIELD COMPANY', 'DR. DAVE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:40:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'ADVANCING VOCABULARY SKILLS', '1029', '0-944210-14-7', 'LANGUANGE', '', 'TOWNSEND PRESS', 'SHERRIE L . NIST', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:42:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'THE PROFESSIONAL GEOGRAPHER', '0052', '0033-0124', 'NOVEL', '', 'DAVID ALEXANDER', 'JANET FRANKLIN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:42:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'ADVANCING VOCABULARY SKILLS', '1030', '0-944210-14-7', 'LANGUAGE', '', 'TOWNSEND PRESS', 'CAROLE MOHR', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:47:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'THE PROJECT PROPOSAL WRITING HANDBOOK', '0053', '9789966008510', 'PROJECT HAND BOOK', '', 'REPARED PUBLISHING DEPARTMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:49:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'STAYING SANE WHEN YOUR FAMILY COMES TO VISIT', '1031', '0-7382-1036-6', 'NOVEL', '', 'DA CAPO PRESS', 'PAM BRODOWSKY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:50:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'PRINCIPLES OF ECONOMICS', '1032', '978-0-07-128542', 'BUSINESS', '', 'MCGRAW-HILL', 'ROBERT H. FRANK', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:53:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'ESSENTIAL OF DEVELOPMENT PLANNING', '0054', '9966 47 165 0', 'GUIDE BOOK', '', 'PHOENIX PUBLISHED LTD', 'MOSES J. WEKESA ', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:54:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'FAMILY', '0055', '13: 978-0-7377-3742-2', 'FAMILY', '', 'ELIZABETH DES CHENES ', 'KAREN MILLER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:56:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'ACCOUNTING INFORMATION SYSTEMS', '1033', '978-0-07-122052-1', 'BUSINESS', '', 'MCGRAW-HILL', 'DR. ROBERT L.HURT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 05:58:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'MACROECONOMICS', '0056', '0-395-35527-3', 'ECONOMICS', '', 'HOUGHTON MIFFLIN COMPANY', 'FRANK STELLA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:00:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'ECONOMICS FOR EASTERN AFRICA', '1034', '0-05-97400-9', 'ECONOMICS', '', 'HEINEMANN', 'IAN LIVINGSTONE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:02:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'CORPORATE STRATEGY', '1035', '978-0-07-111107-2', 'BUSINESS', '', 'MCGRAW-HILL', 'DAVID J.COLLIS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:10:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'AMERICAN VIOLENCE$ PUBLIC POLICY', '1036', '0-300-03231-5', 'NOVEL', '', 'YALE UNIVERSITY PRESS', 'LYNN A.CURTIS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:13:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'DOING YOUR EARLY YEARS RESEARCH PROJECTS', '1037', '13:978-1-84920-520-7', 'RESEARCH', '', 'SAGE PUBLICATIONS', 'GUY ROBERTS-HOLMES', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 06:18:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'PRINCIPLES OF ECONOMICS', '0057', '978-0-07-17', 'ECONOMICS', '', 'FORDHAM UNIVERSITY', 'DOMINIC SALVATORE PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 07:57:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'HITT IRELAND HOSKISSON', '0058', '0-324-11482-6', 'ENTEPRENUERSHIP', '', 'COPYRIGHT BY SOUTH WESTERN THOMSON', 'MICHAEL A. HITT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:00:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'GUIDELINES FOR PREPARING PROPOSAL', '0059', '0-8191-3734-0', 'PROPOSAL GUIDE', '', 'UNIVERSITY PRESS OF AMERICA', 'JOHN H. BEHLING, PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:04:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'IMPROVING PERFORMANCE AND COMMITMENT IN THE WORKPLACE', '0060', '978-0-07-131811-2', 'ORGANIZATIONAL BEHAVIOR', '', 'MCGRAW-HILL/IRWIN', 'JASON A. CCOLQUIT', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:07:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'MICROECONOMICS', '0061', '0-201-08048-6', 'ECONOMICS', '', 'WESLEY PUBLISHING COMPANY', 'ALLEN R. THOMPSON', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:13:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'PROJECT INFORMATION MANAGEMENT SYSTEM', '0062', '978-9966-21-395-2', 'PROJECT MANAGEMENT', '', 'PSI CONSULTANTS', 'GITONGA B. A.', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:15:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'MGMT', '0063', '13: 978-1-111-22131-7', 'MANAGEMENT', '', 'SOUTH-WESTERN,CENGAGE', 'CHUCK WILLIAMS', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:18:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'CHILD DEVELOPMENT', '0064', '9966-01-045-0', 'NOVEL', '', 'FOCUS PUBLISHERS LTD', 'MARGARET KABIRU', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:30:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'NATIONAL DATA COLLECTION ON POLICE USE OF FORCE', '0065', '703-684-5300', 'NATIONAL DATA COLLECTION ON POLICE USE OF FORCE ', '', 'U.S DEPARTMEMT OF JUSTICE', 'JAN CHAIKEN', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:33:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'DANGER DUTY AND DISILLUSION', 'OO66', '1-57766-041', 'NOVEL', '', 'WAVELAND PRESS, INC', 'JOAN C. BARKER', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:35:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'PSYCHOLOGY OF CRIME & CRIMINAL JUSTICE', '0067', '0-88133-228-3', 'PSCHOLOGY OF CRIME AND CRIMINAL JUSTICE', '', 'WAVELAND PRESS', 'HANS TOCH', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:38:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'THE PRACTICE OF GROUP WORK', '0068', '0-231-03243-9', 'NOVEL', '', 'COLUMBIA UNIVERSITY PRESS', 'SERAPIO R. ZALBA', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:40:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'NEW HELP FOR THE WOMAN', '0069', '0-553-34860-4', 'NOVEL', '', 'UNITED STATES AND CANADA', 'JEAN KIRKPATRICK, PHD', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:43:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'RESILIENCY', '0070', '0-87101-350-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN -PUBLICATION DATA', 'ROBERTA R. GREENE', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:47:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'PROPHET OF DEATH', '0071', '0-688-10584-X', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-N-PUBLICATION DATA', 'PETE EARLEY', 0, '0.00', '2025-02-06', '', 'yes', 'no', '2025-02-06 08:50:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'JUVENILE DELINQUENCY', '0072', '0-13-514431-0', 'MEASURING DELINQUENCY', '', 'PRENTICE-HALL', 'CURT R. BARTOL', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:47:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'PROJECT MANAGEMENT BOOK', '0073', '13:978-1-59869-635-6', 'PROJECT MANAGEMENT', '', 'F+W PUBLICATIONS', 'RICK A. MORRIS, PMP', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:54:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'CASES IN FINANCIAL MNAGEMENT', '0074', '13: 978-0-463805-7', 'FINANCIAL ACCOUNTING', '', 'TATA MCGRAW-HILL PUBLISHING COMPANY LTD', 'RAMESH BHAT', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:57:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'MICROECONOMICS', '0075', '0-07-254936-X', 'ECONOMICS', '', 'MCGRAW-HILL/IRWIN', 'DAVID C. COLANDER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 00:59:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'HEART TO HEART CARE GIVING', '0076', '0-934140-59-6', 'NOVEL', '', 'REDLEAF PRESS', 'E SANDY POWEL ', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 01:04:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'NEW VENTURE CREATION', '0077', '13: 978-0-538-48197-7', 'ENTERPRENEUR', '', 'SOUTH-WESTERN, CENGAGE LEARNING', 'KATHLEEN R. ALLEN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:47:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'ORGANIZATIONAL BEHAVIOR', '0078', '0-07-293147-7', 'HISTORY', '', 'MCGRAW-HILL/IRWIN', 'MARY ANN VON GLINOW', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:50:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'JUVENILE DELINGUENCE', '0079', '13: 978-0-298731-8', 'JUVENILE DELINGUENCE', '', 'PEARSON EDUCATION LTD', 'CLEMENS BARTOLLAS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:55:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'COMPLETE JOB-SEARCH HANDBOOK', '0080', '0-8050-0525-0', 'NOVEL', '', 'HOWARD FIGLER', 'HENRY HORT AND COMPANY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 06:58:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'PURCHASING SUPPLY MANAGEMENT', '0081', '13: 978-0-07-070660-6', 'SUPPLY CHAIN', '', 'TATA MSCGAW HILL EDUCATION PRIVATE', 'HAROLD E FEARON, PHD, CPM', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:01:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'THE PHYSICAL UNIVERSE', '0082', '13: 978-0-07-250979-3', 'PHYSICAL UNIVERSE', '', 'THE MCGRAW-HILL COMPANIES', 'ARTHUR BEISER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:04:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'CORPORATE FINANCE', '0083', '0-07-255592-0', 'FINANCE', '', 'MCGRAW-HILL HIGHER EDUCATION', 'STEPHEN A. ROSS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:12:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'WOMEN A FEMINIST PERSPECTIVE', '0084', '0-87484-422-3', 'NOVEL', '', 'MAYFIELD PUBLISHING COMPANY  ', 'JO FREEMAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:20:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'POLICE TECHOLOGY', '0085', '0-13-114957-1', 'POLICE TECHOLOGY', '', 'PEARSON HALL', 'RAYMOND E. FOSTER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:22:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'MIND IN THE MAKING', '0086', '978-0-06-173232-4', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ELLEN GALINSKY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:26:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'INTRODUCTIORY MICROECONOMICS', '0087', '0-87626-661-8', 'ECONOMICS', '', 'WINTHROP PUBLISHERS,INC', 'LAWRENCE G, HINES', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:29:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'ESSENTIALS OF ENTREPRENEURSHIP AND SMALL BUSINESS MANAGEMENT', '0088', '10 0-273-77873-7', 'ENTREPRENUERSHIP', '', 'PEARSON HORIZON EDITIONS', 'NORMAN M. SCARBOROUGH', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:34:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'GREEN INFRASTRUCTURE', '0089', '1-55963-558-4', 'AGRICUTURE', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'MARK A. BENNEDICT', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:38:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'BUSSINESS FINANCE SIMPLIFIED', '0090', '9966-28-814-7', 'FINANCE', '', 'SALEEMI PUBLICATION LTD', 'N.A.SALEEMI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:45:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'RETHINKING CRIME DEVIANCE THEORY', '0091', '0-86598-073', 'RETHINKING CRIME DEVIANCE THEORY', '', 'ROWMAN &ALLANHELD PUBLISHERS', 'FRANCIS T. CULLEN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:51:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'GENDERED JUSTICE', '0092', '978-0-7425-6644-6', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'VENESSA GARCIAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 07:55:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'BE YOUR OWN STRATEGY CONSULTSANT', '0093', '10: 1-86152-980-5', 'NOVEL', '', 'BRITISH LIBRARY CATALOGUING-IN-PUBLISHING', 'GRUNDY&BROWN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:06:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'POVERTY', '0094', '13: 978-0-7377-3747-9', 'NOVEL', '', 'CHRISTINE NASSO PUBLISHER', 'VIQI WAGNER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:06:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'MANAGING STRATEGIC CHANGE', '0095', '0-471-86559-1', 'NOVEL', '', 'JOHN WILEY &SONS, INC', 'NOEL M. TICHY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:12:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'TAKINGSIDES', '0096', '0-697-39144-2', 'NOVEL', '', 'THE MCGRAW COMPANIES', 'M.ETHAN KATSH', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:16:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'MANAGEMENT ORGANISATIONAL BEHAVIOR', '0097', '978-0-273-72408-7', 'MANAGEMENT ORGANISATIONAL BEHAVIOR', '', 'PRENTICE HALL', 'LAURIE J. MULLINS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:19:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'MARKETING MANAGEMENT', '0098', '13:978-0-13-135797-6', 'MARKETING', '', 'PEARSON PRENTICE HALL', 'PHILIP KOTLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:24:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'PRINCIPLES OF INSURANCE: LIFE HEALTH AND ANNUITIES', '0099', '1-57974-275-0', 'PRINCIPLES OF INSURANCE: LIFE HEALTH AND ANNUITIES', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'HARRIETT E JONES', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:27:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'PRINCIPLES OF AUDITING', '0100', '0-256-02568-1', 'PRINCIPLES OF AUDITING', '', 'LIBRARY OF CONGRESS CATALOG CARD', 'WATER B. MEIGS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:37:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'NATURAL HAZARDS, UNNATURAL DISASTERS', '0101', '978-0-8213-8050', 'NATURAL HAZARDS, UNNATURAL DISASTERS', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'KENNETH J. ARROW', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:42:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'SUPPLY CHAIN DEVELOPMENT FOR THE LEAN ENTERPRISE', '0102', '1-56327-218-0', 'SUPPLY CHAIN', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ROBIN COOPER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:46:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'MICROECONOMICS', '0103', '0-07-287561-5', 'ECONOMICS', '', 'MCGRAW-HILL IRWIN', 'STANELY L. BRUE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:50:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'ACCOUNTING FOR GOVERNMENT & NONPROFIT ENTITIES', '0104', '13: 978-0-07-310095-1', 'ACCOUNTING', '', 'MCGRAW-HILL HIGHER EDUCATION', 'EARL R. WILSON, PHD.CPA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 08:57:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'QUANTITAVE METHODS FOR INVESTMENT ANALYSIS', '0105', '0-935015-69-8', 'QUANTITAVE METHODS FOR INVESTMENT ANALYSIS', '', 'AIMR PUBLICATIONS', 'RICHAR A. DEFUSCO CFA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:06:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'A GUIDE TO ACADEMIC WRITING', '0106', '9966-9925-02', 'A GUIDE TO ACADEMIC WRITING ', '', 'ZAPF CHACERY', 'C.B. PETER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:14:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'PATTERNS REFLECTIONS', '0107', '0-205-26715-7', 'NOVEL', '', 'MACMILLAN PUBLISHING COMPANY', 'DOROTHY U. SEYLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:19:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'STRAGEGIC PLANNING', '0109', '13: 978-9-966201-22-5', 'STRAGEGIC PLANNING', '', 'EVANGEL PUBLISHING HOUSE', 'GUY S. SAFFOLD', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:24:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'GOVERNMENT AND NOT-FOR-PROFIT ACCOUNTING', '1038', '0-471-23009-X', 'ACCOUNTING', '', 'JOHN WILEY$SONS,INC', 'MICHAEL H .GRANOF', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:27:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'VICTIMOLOGY', '1039', '0-13-437286-7', 'CRIME ', '', 'PEARSON EDUCAION', 'JUDITH M SGARZI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:29:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'THE PSYCHOLOGY OF CRIMINAL CONDUCT', '1040', '0-87084-712-0', 'PSYCHOLOGY', '', 'ARDESON PUBLISHING', 'D. A. ANDREWS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:33:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'GENDER ISSUES IN THE TEACHING OF ENGLISH', '0110', '0-86709-306-2', 'GENDER ISSUES IN THE TEACHING OF ENGLISH', '', 'BOYNTON/COOK PUBLISHERS', 'NANCY MELLIN MC CRACKEN ', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:34:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'ACCOUNTING', '1041', '0-395-44639-2', 'ACCOUNTING', '', 'HOUGHTON MIFFLIN COMPANY', 'DONALD J .GUERRIERI', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:35:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'TODAY\'S BEST NONFICTION', '0111', '0893-9373', 'NOVEL', '', 'SIMON AND SCHUSTER', 'JOE MCGINNISS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:37:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'ALCATRAZ\'46', '1042', '0-88339-296-8', 'NOVEL', '', 'LESWING PRESS', 'BERNARD PAUL COY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:38:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'RESEARCHING THEORIES OF CRIME AND DEVIANCE', '0112', '978-0-19-534086', 'RESEARCHING THEORIES OF CRIME AND DEVIANCE', '', 'OXFORD UNIVERSITY PRESS', 'CHARIS E KUBRIN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:40:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'RESEARCH METHODS IN CRIMINAL JUSTICE AND CRIMINOLOGY', '1043', '0-205-26313-5', 'RESEARCH METHODS', '', 'A VIACOM COMPANY', 'FRANK E. HAGAN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:44:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'CRIME IS NOT THE PROBLEM', '0113', '0-19-513105-3', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'FRANKLIN E. ZIMRING', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:46:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'CAREERS IN CRIMINAL JUSTICE', '1044', '0-205-26260-0', 'CRIMINOLOGY', '', 'PEARSON EDUCATION COMPANY', 'W. RICHARD STEPHEN,JR', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:53:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'CRIMINAL JUSTICE', '1045', '0-205-20043-5', 'CRIMINOLOGY', '', 'ALLYN AND BACON', 'JOHN R . FULLER', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:54:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'MANAGEMENT ACCOUNTING', '1046', '0-7872-0315-7', 'ACCOUNTING', '', 'KENDALL/HUNT PUBLISHING COMPANY', 'IBRAHIM M.ALY', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:57:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'THE ADOLESCENT DEVELOP AND CULTURE', '0114', '0-205-07304-2', 'NOVEL', '', 'COPYRIGHT', 'F. PHILIP RICE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 09:59:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'CORPORATE INFORMATION STRATEGY AND MANAGEMENT', '1047', '0-07-245665-5', 'INFORMATIONS', '', 'GEORGE  WERTHMAN', 'LYDA M.APPLEGATE', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:00:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'AN ECONOMIC HISTORY OF KENYA', '0115', '9966-46-963-X', 'HISTORY', '', 'EAST AFRICAN EDUCATION PUBLISHER LTD', 'W.R. OCHIENG\"', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:03:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'UNDERSTANDING SEPTEMBER 11TH', '1048', '0-670-03582-3', 'CRIMINOLOGY', '', '  PENGUIN GROUP', ' MITCH FRANK', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:03:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'ESSENTIALS OF ACCOUNTING FOR GOVERNMENTAL NOT FOR PROFIT ORGANIZATIONS', '0116', '13: 978 -0-07-313096-5', 'ACCOUNTIG', '', 'MCGRAW-HILL HIGHER EDUCATION', 'COPLEY ENGSTORM', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:06:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'QUANTITATIVE TECHNIQUES FOR MANAGERIAL DECISIONS', '1049', '978-81-203-3297-3', 'BUSINESS', '', 'ASOKE K.GHOSH                             ', 'R.B.KHANNA', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:07:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'COST ACCOUNTING', '0117', '13: 978-135558-3', 'ACCOUNTING', '', 'PEARSON INTERNATIONAL EDITION', 'CHARLES T. HORNGREN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:08:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'ESSENTIALS OF CORPORATE FINANCE', '1050', '0-07-251076-5', 'FINANCE', '', 'STEPHEN M.PATTERSON', 'STEPHEN A . ROSS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:11:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'JUVENILE DELINQUENCY', '0118', '0.471.89364.1', 'JUVENILE DELINQUENCY', '', 'JUVENILE DELINQUENCY', 'JOAN WILLENS', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:14:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'E-MAIL RULES', '1051', '0-8144-7188-9', 'BUSINESS', '', 'AMACON', 'NANCY FLYNN', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:14:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'CONTROLLER\'S GUIDE TO COSTING', '1052', '0-471-71394-5', 'BUSINESS', '', 'JOHN WILEY$SONS ,INC', 'STEVEN M.BRAGG', 0, '0.00', '2025-02-07', '', 'yes', 'no', '2025-02-07 10:21:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'ATTACK OF THE TAGGER', '0119', '0-375-82352-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION', 'BRIAN BIGGS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:44:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'WITCHES AND MAGIC MAKERS', '0120', '0-679-88544-7', 'WITCHES AND MAGIC MAKERS', '', 'ALEX WILSON', 'DOUGLAS HILL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:46:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'PETAIL BUSINESS MANAGEMENT', '0121', '0-07-023232-0', 'PETAIL BUSINESS MANAGEMENT', '', 'MCGRAW-HILL BOOK COMPANY', 'GILLESPIE.HECHT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:51:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'THE GLOBAL EXECUTIVE  RECRUITERS', '0122', '0-7879-4139-5', 'THE GLOBAL EXECUTIVE  RECRUITERS ', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATIN DATA', 'NANCY GARRISON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:56:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'ETHICS AND PUBLIC SERVICE IN AFRICA', '0123', '9966-925-12-0', 'NOVEL', '', 'QUEST&INSIGHT PUBLISHERS', 'ERIC E. OTENYO', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 03:58:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'THE WAR OF THE WORLDS', '0124', '0-679-81047-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'MARY ANN EVANS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:01:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'CONTEMPORARY STATES AND SOCIETIES', '0125', '0-333-71519-5', 'NOVEL', '', 'ANTHONY BUTLER', 'ANTHONY BUTLER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:05:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (180, 'CRIME AND COMMUNITY', '0126', '1-8891487-52-3', 'CRIME AND COMMUNITY', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION', 'G. DAVID CURRY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:11:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (181, 'THE INVISIBLE ISLAND', '0127', '0-679-89457-8', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'RON ROY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:15:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (182, 'A HOUSE CALLED AWFUL END', '0128', '0-439-56960-5', 'NOVEL', '', 'AWFUL END', 'PHILIP ARDAGH', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:19:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (183, 'JACOB TWO-TWO AND THE DINOSAUR', '0129', '0-679-87042-3', 'NOVEL', '', 'RANDOM HOUSE', 'MORDECAI RICHLER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:22:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (184, 'THOROUGHBRED', '0130', '0-06-106482-3', 'NOVEL', '', 'HARPERCOLLINS PUBLISHERS', 'JOANNA CAMPBELL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:26:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (185, 'WHAT IF EVERY KNEW YOUR NAME', '0131', '0-385-73296-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION OF DATA', 'SARA JAMES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:30:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (186, 'TEN GIRLS WHO MADE A DIFFERENCE', '0132', '1-85792-776-1', 'NOVEL', '', 'CHRISTIAN FOCUS PUBLICATIONS', 'IRENE HOWAT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:32:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (187, 'THE BABY SITTERS CLUE', '0133', '0-590-42500-5', 'NOVEL', '', 'SCHOLASTIC INC', 'ANN M. MARTIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:35:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (188, 'SURF UP', '0134', '0-307-15982-5', 'NOVEL', '', 'WESTERN PUBLISHING COMPANY', 'MERCER MAYERS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:37:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (189, 'HAUNTED HOUSEFUL', '0135', '0-394-87041-7', 'NOVELS', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA 0-', 'JOHN KENDRICK BANGS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:42:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (190, 'MUROGI WA KAGOGO', '0136', '996625162-6', 'NOVEL', '', 'EAST AFRICAN EDUCATIONAL PUBLICATION', 'NGUGI WA THIONG\'O ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:44:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (191, 'BESTY ZANE', '0137', '0-440-41834-8', 'NOVEL', '', 'HOUGHTON MIFFLIN COMPANY', 'LYNDA DURRANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:46:52', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (192, 'TREASURE ISLAND', '0139', '0-679-80402-1', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'ROBERT LOUIS STEVESON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:49:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (193, 'POTANT BLACK', '0140', '0-439-42084-9', 'NOVEL', '', 'SCHOLASTIC  INC.', 'ANTHONY HOROWITZ ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 04:55:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (194, 'FELICITY\'S SUPRISE', '0141', '1-56247-011-6', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'ALICE MARTIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:02:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (195, 'SARAH', '0142', '0-590-44744-0', 'NOVEL', '', 'SCHOLASTIC INC', 'ELINE MOORE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:04:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (196, 'NOW A MAJOR MOTION PICTURE', '0143', '0-06-0275510-3', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'GAIL CARSON LEVINE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:08:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (197, 'FINANCIAL MANAGEMENT', '0144', '9966-01-150-1', 'ACCOUNTING', '', 'FOCUS PUBLISHERS LTD', 'ROERT MUDIDA', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:25:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (198, 'MODERN ECONOMICS', '0145', '9966-882-74-2', 'ACCOUNTIING', '', 'FOCUS PUBLISHED', 'ROBERT MUDIDA', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:28:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (199, 'BUSINESS PLAN WRITING', '0146', '996696533-5', 'BUSINESS PLAN', '', 'REGINAL PARTNERSHIP FOR RESOURCE DEVELOPMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:31:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (200, 'ORGANIZTION THEORY AND DESIGN', '0147', '978-1-84480-990-5', 'HISTORY', '', 'LIBRARY CATALOGING IN PUBLICATION DATA', 'JONATHAN MURPHY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:34:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (201, 'MONITORING & EVALUATION HAND BOOK', '0148', '978-9966-008-12-1', 'MONITORING & EVALUATION HAND BOOK', '', 'PUBLISHING DEPARTMENT NAIROBI', 'JOHN CHIKATI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:36:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (202, 'CHILD RIGHTS AND CHILD PROTECTION', '0149', '978 9966 36 448 X', 'NOVEL', '', 'LONGHORN PUBLISHERS', 'MARY NDANI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:39:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (203, 'SMALL BUSINESS GROWTH', '0150', '0-471-70760-0', 'BUSINESS', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'STEVEN S. LITTLE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:42:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (204, 'MANAGEMENT INFORMATION SYSTEMS', '0151', '0-07-035823-0', 'MANAGEMENT INFORMATION SYSTEMS', '', 'LIBRARY OF CONGRESS CARD CARD CATALOG', 'DAVID KROENKE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:49:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (205, 'YOUR FORTUNE FORE CLOSURES', '0152', '0-89586-572-6', 'NOVEL', '', 'LIBRARY OF COGRESS CATALOGING IN PUBLICATION DATA', 'FREDY BUSH', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:55:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (206, 'HUMAN RESOURCE AND INDUSTRIAL RELATIONS', '0153', '9966-22-826-8', 'HUMAN RESOURCE', '', 'THE JOMO KENYATTA FOUNDATION', 'DR. BONIFACE M. SUBABU', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 05:58:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (207, 'CORRECTIONS A CONCISE INTRODUCTION', '0154', '1-57766-050-1', 'CORRECTIONS A CONCISE INTRODUCTION', '', 'WAVELAND PRESS,INC', 'JAMES F. QUIMN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:00:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (208, 'THE ECONOMICS OF REGULATION', '0155', '65-17686', 'ECONOMICS', '', 'LIBRARY OF THE CONGRESS CATALOGUE CARD', 'CHARLES F. PHILIPS, JR', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:04:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (209, 'PRINCIPLES OF ECONOMICS', '0156', '13: 978-0-07-319398-4', 'ECONOMICS', '', 'MCGRAW-HILL HIGHER EDUCATION', 'ROBERT H. FRANK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:08:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (210, 'FUNDAMENTALS OF CORPORATE FINANCE', '0157', '13:978-0-27377991-9', 'FINANCE', '', 'BRITISH LIBRARY CATALOGUING -IN-PUBLICATION DATA', 'JONATHAN BERK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:12:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (211, 'INTERNATIONAL BUSINESS', '0158', '13:978-0-273-77975-9', 'BUSINESS', '', 'PEARSON EDUCATION LIMITED', 'JOHN J. WILD', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:15:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (212, 'GLOBAL  ACTION FOR BLODIVERSITY', '0159', '1-85383-358-4', 'GLOBAL  ACTION FOR BLODIVERSITY', '', 'EARTHSCAN PUBLICATIONS LTD', 'TIMOTHY SWASON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:19:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (213, 'RESOLVING IDENTITY BASED CONFLICT', '0160', '0-7879-0996-3', 'RESOLVING IDENTITY BASED CONFLICT', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'JAY ROTHMAN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:22:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (214, 'A COMMUNITY OF WRITERS', '0161', '0-07-303181-X', 'A COMMUNITY OF WRITERS', '', 'MCGRAW HILL', 'PETER ELBOW', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:33:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (215, 'THE MILLY-MOLLY-MANDY', '0162', '0-7534-5332-0', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'JOYCE LANKESTR BRISLEY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:38:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (216, 'SADDLE CLUB HIGH HORSE', '0163', '0-553-48147-9', 'NOVEL', '', 'A BANTAM SKYLARK BOOK', 'BONNIE BRYANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:46:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (217, 'HOW MUCH IS THAT GUINEA PIG IN THE WINDOW', '0164', '0-590-90747-6', 'NOVEL', '', 'SCHOLASTIC INC.', 'JOANNE ROCKLIN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:49:38', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (218, 'SQUANTO FRIEND OF THE PILGRIMS', '0165', '0-590-44055-1', 'NOVEL', '', 'SCHOLASTIC INC.', 'ROBERT BULLA ', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 06:58:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (219, 'OUT OF THE DUST', '0166', '0-590-37125-8', 'NOVEL', '', 'SCHOLASTIC INC.', 'KAREN HESSE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:01:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (220, 'BUSINESS COMMUNICATION AND REPORT WRITING SIMPLIFIED', '0167', '9966-28-646-2', 'BUSINESS', '', 'SALEEMI PUBLICATION LTD', 'NISAR AHMAD SALEEMI', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:04:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (221, 'BRIAN JACQUES', '0168', '0-399-24549-9', 'NOVEL', '', 'LIBRAY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DAVID ELLIOT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:09:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (222, 'DRAGON BREATH', '0169', '0-439-7545-3', 'NOVEL', '', 'SCHOSTIC INC.', 'E.D. BAKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:11:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (223, 'THE MACRO ECONOMY TODAY', '0170', '0-07-056169-9', 'ECONOMY', '', 'MCGRAW HILL,INC', 'MICHAEL M TANSEY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:13:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (224, 'THE SADDLE CLUB', '0171', '0-553-48625-X', 'NOVEL', '', 'A BANTAM SKYLARK BOOK', 'BONNIE BRYANT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:16:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (225, 'ANIMORPHS', '0172', '0-590-76261-3', 'NOVEL', '', 'SCHOLASTIC INC', 'K.A.APPLEGATE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:20:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (226, 'HOW TO EAT FRIED WORMS', '0173', '0-440-44545-0', 'NOVEL', '', 'BANTAM DOUBLEDAY DELL BOOKS FOR YOUNG READERS', 'THOMAS ROCKWELL', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:23:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (227, 'WRITING FOR SOCIAL SCIENTISTS', '0174', '13: 978-0-226-04132-2', 'WRITING FOR SOCIAL SCIENTISTS', '', 'THE UNIVERSITY OF CHICAGO PRESS', 'HOWARD S. BECKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:26:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (228, 'THE SECRET IDENTITY OF DEVON DELAN', '0175', '13: 978-1-4169-3503-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CONTROL NUMBER', 'LAUREN BARN HOLDT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:29:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (229, 'WRITING FOR SOCIAL SCIENTISTS', '0176', '13: 978-0-226-04132-2', 'WRITING FOR SOCIAL SCIENTISTS', '', 'THE UNIVERSITY OF CHICAGO PRESS', 'HORWAD S. BECKER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:31:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (230, 'ONLY IN YOUR DREAMS', '0177', '0-316-01182-7', 'NOVEL', '', 'UNITED STATES OF AMERICA', 'CECILY VON ZIEGESTAR', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:34:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (231, 'PONY PALS', '0178', '0-439-21641-9', 'NOVEL', '', 'SCHOLASTIC INC.', 'JEANNE BETAN COURT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:36:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (232, 'ASTROSAURS BOOK ONE', '0179', '13: 978-0-689-87841-1', 'NOVEL', '', 'ALADDIN PAPERBACKS', 'STEVE COLE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:39:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (233, 'LETTERS FROM RIFKA', '0180', '0-14-036391-2', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'KAREN HESSE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 07:57:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (234, 'READER BEWARE YOU CHOOSE THE CHOOSE THE SCARE', '0181', '0-590-56645-8', 'NOVEL', '', 'SCHOLASTIC NC.', 'TICK TOCK', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:10:39', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (235, 'NEVER NEVER', '0182', '0-15-205210-0', 'NOVEL', '', 'MAGIC CAPERT BOOKS', 'SHETTERLY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:12:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (236, 'HARDY BOYS', '0183', '0-671-74665-0', 'NOVEL', '', 'POCKET BOOKS', 'FRANKLIN W. DIXON', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:14:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (237, 'TERTIUM ORGANUM', '0184', '0-671-74665-0-X', 'NOVEL', '', 'VINTAGE BOOK', 'P.D.OUSPENSIKY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:17:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (238, 'THE PRINCESS DIARIES', '0185', '0-380-81402-1', 'NOVEL', '', 'PRINCESS IN THE SPOTLIHGT', 'MEG CABOT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:20:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (239, 'I HEARD THE OWL CALL MY NAME', '0186', '0-440-34369-0', 'NOVEL', '', 'DELL PUBLISHING', 'MARGARET CRAVEN', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:23:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (240, 'MARCIA THORNTON JONES', '0187', '13: 978-0-545-00148-9', 'NOVEL', '', 'SCHOLASTIC', 'JONES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:25:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (241, 'POLAR BEARS PAST BEDTIME', '0187', '0-679-88341-X', 'NOVEL', '', 'LIBARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'MARY POPE OSBORNE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:27:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (242, 'ANIMAL ARK', '0188', '0-439-68758-6', 'NOVEL', '', 'SCHOLASTIC INC', 'BAGLIO', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:30:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (243, 'WHERE THE RED FERN GROWS', '0189', '0-553-25585-1', 'NOVEL', '', 'BANTAM BOOKS', 'WILSON RAWLS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:34:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (244, 'BABY SITTERS', '0190', '0-590-44828-5', 'NOVEL', '', 'SCHOLASTIC INC', 'KAREN\'S TEA PARTY', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:35:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (245, 'THE BABY SITTERS CLUB', '0191', '0-590-43660-0', 'NOVEL', '', 'SCHOLASTIC INC ', 'KRISTY AND THE SNOBS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:37:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (246, 'ON THE MARBLE CLIFFS', '0192', '0 14 00. 2985 0', 'NOVEL', '', 'PENGUIN BOOKS', 'ERNST JUNGER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:40:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (247, 'FOUNDING BROTHERS', '0193', '0-375-70524-4', 'NOVEL', '', 'VINTAGE', 'JOEPH J. ELLIS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:41:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (248, 'PASCAL', '0194', '0-439-16570-9', 'NOVEL', '', 'SCHOLASTIC INC', 'CHICAGO TRIBUNE', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:47:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (249, 'PONY PALS', '0195', '0-590-54338-5', 'NOVEL', '', 'SCHOLASTIC INC', 'JEANNE BETANCOURT', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:48:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (250, 'A SERIES OF UNFORTUNATE EVENTS', '0196', '0-06-44-768-3', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION', 'LEMONY SNICKET', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:52:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (251, 'ROBOTS', '0197', '0-439-43118-2', 'NOVEL', '', 'SCHOLASTIC INC', 'STEPHEN MUNZER', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:54:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (252, 'LBD', '0198', '0-14-240662-7', 'NOVEL', '', 'PENGUIN GROUP', 'BOB WATTS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:57:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (253, 'WORDS OF STONE', '0199', '0-14-036601', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOING IN PUBLICATION DATA', 'KEVIN HENKES', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 08:59:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (254, 'THE ADVENTURES OF UNCLE STINKY', '0200', '1-58246-145-7', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'CHLOE RAWLINS', 0, '0.00', '2025-02-13', '', 'yes', 'no', '2025-02-13 09:02:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (255, 'CASE STUDIES ON  EDUCATIONAL ADMINISTRATION', '0201', '1O:0-205-50907-X', 'EDUCATIONAL ADMINISTRATIONAL', '', 'PEARSON EDUCATIONAL INC.', 'THEODORE J. KOWALSKI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:18:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (256, 'EDUCATIONAL ADMINISTRATION', '1053', '0-13-352635-6', 'EDUCATION', '', 'MERRILL,AN IMPRINT OF PRENCTICE HALL', 'ROBERT E . KIRSCHMANN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:19:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (257, 'TOOLS FOR WRITING', '0202', '0-15-503800-1', 'TOOLS FOR WRITING', '', 'LIBRARY OF CONGRESS CATALOGUE', 'RITA SMILKSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:21:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (258, 'EDUCATIONAL LEADERSHIP AND MANAGEMENT', '1054', '978-0-7619-4052-4', 'EDUCATIONAL LEADERSHIP', '', 'SAGE PUBLICATIONS', 'TONY BUSH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:22:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (259, 'MIND BUILDER', '1055', '1-59158-376-4', 'NOVEL', '', 'TEACHER IDEAS PRESS', 'PAUL FLEISHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:26:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (260, 'THE PRINCIPALSHIP A REFLECTIVE PRACTICE PERSPECTIVE', '0203', '0-205-15585-5', 'THE PRINCIPALSHIP A REFLECTIVE PRACTICE PERSPECTIVE', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICTION DATA', 'THOMAS J. SEGIONVANNI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:27:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (261, 'DISTINCTION SCIENCE', '1056', '       978-9966-44-748-7', 'SCIENCE', '', 'KENYA LITERATURE BUREAU', 'CHARLES GICHUKI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:29:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (262, 'ESSENTIALS OF EDUCATIONAL STATISTICS', '0204', '9966-46-645-2', 'STATITICS', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS', 'HANIEL GATUMU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:30:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (263, 'FOUNDATIONS OF EARLY CHILDHOOD DEVELOPMENT AND EDUCATION AND CURRICUM DEVELOPMENT', '0205', '9966-01-131-5', 'FOUNDATIONS OF EARLY CHILDHOOD DEVELOPMENT AND EDUCATION AND CURRICUM DEVELOPMENT', '', 'FOCUS PUBLISHERS', 'MARGARET KABIRU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:35:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (264, 'THE PROJECT PROPOSAL WRITING HANDBOOK', '1057', '978-9966-00-851-0', 'PROJECT PROPOSAL', '', 'REPARED PUBLISHING DEPARTMENT', 'JOHN CHIKATI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:36:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (265, 'PRIMARY TEACHER TRAINING', '0206', '81-8342-057-5', 'PRIMARY TEACHER TRAINING', '', 'CRESCENT PUBLISHING CORPORATION', 'AJOY CHATTERJEE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:38:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (266, 'SKILLS IN PERSON -CENTRED COUNSELLINGAND PSYCHOTHERAPY', '1058', '978-0-7619-6118-5', 'PSYCHOLOGY COUNSELLING', '', 'SAGE PUBLICATIONS', 'JANET TOLAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:40:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (267, 'ETHICAL LEADERSHIP AND DECISION MAKING IN EDUCATION', '1059', '978-0-415-87459-5', 'LAW', '', 'ROUTLEDGE', 'JOAN POLINER SHAPIRO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:42:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (268, 'COMMUNITY DEVELOPMENT', '1060', '978-9966-36-449-8', 'COMMUNITY DEVELOPMENT', '', 'LONGHORN PUBLISHERS', 'HUDSON M .O. ONG\'ANG\'A', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:46:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (269, 'VIS-A-VIS BEGIGING FRENCH', '0207', '0-07-365512-0', 'FRENCH', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'JUDITH A. MUYSKENS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:50:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (270, 'SCIENCE ACTIVITES', '1061', '   978-9966-36-459-5  ', 'SCIENCE', '', 'LONGHORN PUBLISHER', 'JANE N. NJUGUNA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:51:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (271, 'PEOPLE TOGETHER ADVENTURES IN TIME AND PLACE', '0208', '0-02-146557-6', 'NOVEL', '', 'MCGRAW HILL', 'MACMILLAN ', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:52:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (272, 'GROUNDWORK FOR BETTER VOCABULARY', '0209', '0-944210-74-0', '0-944210-74-0', '', 'TOWNSEND PRESS', 'BETH JOHNSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:55:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (273, 'ADMINISTRATION AND MANAGEMENT OF ECDE PROGRAMMES', '1062', '978 9966 36 451 X', 'ADMINISTRATION AND MANAGEMENT', '', 'LOGHORN PUBLISHER', 'NYAKWARA BEGI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:55:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (274, 'COMMUNITY DEVELOPMENT', '1063', '978 9966  36 449 8', 'COMMUNITY DEVELOPMENT', '', 'LONGHORN PUBLISHER', 'HUDSON M. O. ONG\'ANG\'A', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 01:57:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (275, 'HARCOURT BRACE  SIGNATURES', '0210', '0-15-306413-7', 'NOVEL', '', 'WILLIAM B. EERDAMANS PUBLISHING COMPANY', 'HARCOURT BRACE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:00:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (276, 'PHILOSOPHICAL,SOCIOLOGICAL AND HISTORICAL FOUNDATIONS OF ECDE', '1064', '9966 36425 -0', 'HISTORICAL DEVELOPMENT OF ECDE', '', 'LONGHORN PUBLISHER', 'MICHAEL KARANJA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:01:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (277, 'SOCIOLOGY', '0211', '0-495-09344-0', 'SOCIOLOGY', '', 'LIRARY  OF CONGRESS IN PUBLICATION DATA', 'RODNEY STARK', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:07:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (278, 'FUNDAMENTAL OF FINANCIAL MANAGEMENT', '1065', '978-81-203-3897-5', 'FINACIAL MANAGEMENT', '', ' ASOKE K.GHOSH', 'JAMES C.VAN HORNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:07:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (279, 'PRINCIPLES OF RISK MANAGEMENT AND INSURANCE', '1066', '978-81-317-2584-9', 'MANAGEMENT AND INSURANCE', '', 'PEARSON', 'GEORGE E.REJDA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:12:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (280, 'SOCIAL PSYCHOLOGY', '0212', '0-321-02435-4', 'SOCIAL PSYCHOLOGY', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'ELLIOT ARONSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:12:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (281, 'CASE STUDIES IN FINANCE', '1067', '978-0-07-338245-6', 'MANAGING FOR CORPORATE VALUE CREATION', '', 'UNIVERSIY OF VIRGINIA', 'ROBERT F.BURNER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:17:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (282, 'SOCIOLOGY', '0213', '13: 978-0-495-76396-3', 'SOCIOLOGY', '', 'CENGAGE LEARNING', 'ROBERT J. BRYM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:19:35', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (283, 'FINANCIAL MANAGEMENT', '1068', '978-81--259-3714-2', 'BANKING FINANCE', '', 'VIKAS PUBLISHING HOUSE PVT LTD', 'I M PANDEY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:20:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (284, 'DIMENSIONS OF HUMAN BEHAVIOR', '0214', '978-1-4129-8879-7', 'DIMENSIONS OF HUMAN BEHAVIOR', '', 'LIBRARYOF CONGRESS CATALOGING IN PUBLICATION DATA', 'ELIZABETH D. HUTCHISON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:23:56', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (285, 'FUNDAMENTAL OF FINANCIAL MANAGEMENT', '1069', '978-81-315-0002-6', 'FINANCIAL MANAGEMENT', '', 'CENGAGE LEARNING', 'BRIGHAM $ HOUSTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:25:30', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (286, 'SOCIOLOGY', '0215', '978-81-265-2517-1', 'SOCIOLOGY', '', 'POLITY PRESS', 'PHILIP W. SUTTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:26:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (287, 'SOCIOLOGY', '1070', '978-81-317-0385-4', 'SOCIOLOGY', '', 'PEARSON', 'JOHN J. MACIONIS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:28:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (288, 'PUBLIC RELATIONS', '0216', '0-06-501106-6', 'PUBLIC RELATION', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION DATA', 'WILCOX NOLTE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:29:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (289, 'MANAGEMENT INFORMATION SYTEMS', '1071', '978-0-13-609368-8', 'INFORMATION SYSTEMS', '', 'PEARSON', 'KENNETH C. LAUDON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:34:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (290, 'TESOL QUATERLY', '0217', '0-939791-48-X', 'TESOL QUATERLY', '', 'TESOL PUBLICATIONS', 'SANDRA SIBERSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:37:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (291, 'GIDDENS SOCIOLOGY', '1072', '978-81-265-2517-1', 'SOCIOLOGY', '', 'WILEY', 'PHILIP W. SUTTON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:39:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (292, 'THEORY AND EXPERIENCE', '0218', '0-395-12658-4', 'THEORY AND EXPERIENCE ', '', 'LIBRARY OF CONGRESS CATALOG ', 'RODNEY W. NAPIER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:44:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (293, 'LABOR ECONOMICS', '1073', '978-0-393-97952-7', 'ECONOMICS', '', 'NORTONEBOOKS.COM', 'DEREK LAING', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:45:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (294, 'OLIVER NORTH', '0219', '080542551-9', 'NOVEL', '', 'BROADMAN& HOLMAN PUBLISHERS', 'JAMES BRADLY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:49:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (295, 'ORGANIZATIONAL BEHAVIOR', '1074', '0-07-287387-6', 'ORGANIZATIONAL BEHAVIOR', '', 'MCGRAW-HILL IRWIN', 'FRED LUTHANS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:49:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (296, 'DEVIANCE AND DEVIANTS', '0220', '1-891487-27-2', 'DEVIANCE AND DEVIANTS', '', 'LIBRARY OF CONGRESS IN PUBLICATION DATA', 'PATRICIA GAGNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:51:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (297, 'SERVICE MANAGEMENT FOR COMPETITIVE ADVANTAGE', '1075', '0-07-021217-1', 'SERVICE MANAGEMENT', '', 'MCGRAW -HILL,INC', 'JAMES A. FITZSIMMONS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:52:43', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (298, 'ORGANISATIONAL PSYCHOLOGY', '0221', '0-13-641332-3', 'PSYCHOLOGY', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'RICHARD S. LAZARUS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:53:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (299, 'MANAGEMENT INFORMATION SYSTEMS', '1076', '978-1-84480-172-5', 'INFORMATION MANAGEMENT', '', 'BOOKPOWER', 'TERRY LUCEY', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:56:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (300, 'GRAMMARTICALLY CORRECT', '0222', '13: 978 -1-58297-331-9', 'GRAMMARTICALLY CORRECT', '', 'CATALOGING IN PUBLICATION', 'CINCINNATI, OHIO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:58:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (301, 'FINANCIAL AND INSTITUTIONS', '1077', '978-81-315-0979-1', 'FINANCE', '', 'CENGAGE LEARNING', 'JEFF MADURA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 02:58:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (302, 'FINANCIAL MANAGEMENT', '0223', '13: 978-81-315-0491-8', 'FINANCIAL MANAGEMENT', '', 'CENGAGE LEARNING', 'EUGENE F. BRIGHAM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:00:58', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (303, 'THE ECONOMICS OF MICROFINANCE', '1078', '978 0262 513982', 'ECONOMICS', '', 'THE MIT PRESS', 'BEATRIZ ARMENDARIZ', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:02:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (304, 'ACADEMIC COMMUNICATION SKILLS', '0224', '999 846 10 8', 'COMMUNICATION SKILLS', '', 'NARIOBI UNIVERSITY PRESS', 'PETER BINT', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:03:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (305, 'LOSER', '1079', '978-0-06-054074-6', 'NOVEL', '', 'JOANNA COTLER BOOKS', 'JERRY SPINELLI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:05:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (306, 'ECHOES OF TIME', '0225', '0-02-136740-X', 'ECHOES OF TIME', '', 'MACMILLAN PUBLISHING COMPANY', 'CARL B. SMITH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:05:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (307, 'ISLAND BOUND', '1080', '0-380-73174-6', 'NOVEL', '', 'GREENWILLOW BOOK', 'BETTY LEVIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:08:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (308, 'ATTACK OF THE TAGGER', '1081', '0-375-82352-2', 'NOVEL', '', 'BRIAN BIGGS', 'WENDELIN VAN DRAANEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:11:16', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (309, 'GIGER BREAD', '0226', '0-689-86020-X', 'NOVEL', '', 'LIBRARY OF CONGRESS', 'RACHEAL COLN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:13:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (310, 'THE LONG WINTER', '1082', '0-590-30094-6', 'NOVEL', '', 'SCHOLASTIC INC', 'LAURA INGALLS WILDER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:13:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (311, 'THE DAYDREAM', '0227', '0-06-440576-1', 'NOVEL', '', 'A DIVISION OF HARPERCOLLINS PUBLISHES', 'ANTHONY BROWNE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:16:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (312, 'STEP-MOTHERHOOD HOW TO SURVIVE WITHOUT FEELING FRUSTRATED LEFT OUT,OR WICKED', '1083', '0-8129-1145-8', 'SOCIOLOGY', '', 'CIMES BOOKS', 'CHERIE BURNS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:21:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (313, 'BABU ALIPOFUFUKA', '1084', '9966-22-180-8', 'RIWAYA', '', 'JOMO KENYATTA FOUNDATION', 'SAID A. MOHAMED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:21:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (314, 'JICHO LA NDANI', '0228', '978 99666 49 752 8', 'KISWAHILI', '', 'SASA SEMA PUBLICATIONS', 'SAID A. MOHAMED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:20:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (315, 'THE CAMEL CLUB', '1085', '0-446-57738-3', 'NOVEL', '', 'COLUMBUS ROSE', 'DAVID BALDACCI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:22:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (316, 'DINOSAUR TIME', '0229', '0-0644037-0', 'NOVEL', '', 'LIBRARY OF CONGRESS PUBLICATION', 'PEGGY PARISH', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:24:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (317, 'TEACHERS PET', '1086', '0-590-47618-1', 'NOVEL', '', 'SCHOLASTIC INC', 'TERRANCE DICKS', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:24:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (318, 'BREAK THROUGH THE LANGUAGE BARRIER', '1087', '0039-8322', 'LITERACY', '', 'AMERICAN LANGUAGE ACADEMY', 'SANDRA SILBERSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:29:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (319, 'HENNER\'S LYDIA', '1088', '0-8361-9093', 'NOVEL', '', 'NEWBERY MEDAL WINNER', 'MARGUERITE DE ANGELI', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:32:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (320, 'WRITE ON TARGET', '1089', '1-884183-39-5', 'WRITING', '', 'ENGLEFIELD$ARNOLD PUBLISHING', 'YOLANDE F. GRIZINSIKI ED.D', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:35:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (321, 'THE BEADED MOCCASINS', '1090', '0-440-41591-8', 'NOVEL', '', 'A YEARLING BOOK', 'LYNDA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:37:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (322, 'PRAISE FOR EAGER', '1091', '0-553-48795-7', 'NOVEL', '', 'A YEARLING BOOK', 'HELEN FOX', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:39:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (323, 'AMNESTY', '1092', '1-55583-276-8', 'NOVEL', '', 'ALYSON PUBLICATIONS', 'LOUISE A. BLUM', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:42:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (324, 'GEORGE WASHINTON', '0230 ', '0-7660-5000-9', 'NOVEL', '', 'ENSSLOW PUBLISHERS INC', 'STEPHEN FEINSTEIN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:46:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (325, 'THE CELESTINE PROPHECY', '1093', '0-446-51862-X', 'THEOLOGY', '', 'AUDIOBOOKS', 'JAMES REDFIELD', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:46:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (326, 'MIDNIGHT FOR CHARLIE BONE', '0231', '0-439-48839-7', 'NOVEL', '', 'SCHOLASTIC INC.', 'JENNY NIMMO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:48:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (327, 'SPEAK WITH CONFIDENCE', '1094', '0-07-140805-3', 'LANGUAGE', '', 'MCGRAW-HILL CO', 'DIANNA BOOHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:49:47', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (328, 'JASON KYLA', '0232', '0-7868-3653-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING-IN-PUBLICATION DATA', 'DANA DAVIDSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:50:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (329, 'SONS OF THE DARK', '1095', '0-78688188133-1', 'NOVEL', '', 'HYPERRION', 'KYLE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:53:17', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (330, 'THE MASTERS', '0233', '684-71897-9', 'NOVEL', '', 'C.P. SHOW', 'C.P. SHOW', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:53:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (331, 'POCKET WRITER\'S COMPANION', '1096', '0-321-28826-2', 'NOVEL', '', 'PEARSON LONGMAN', 'CHRIS M. ANSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:56:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (332, 'LEARNING ANOTHER LNGUAGE THROUGH ACTIONS', '0234', '1-56018-494-9', 'LEARNING ANOTHER LNGUAGE THROUGH ACTIONS', '', 'SKY OAKS PRODUCTIONS', 'JAMES J. ASHER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:56:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (333, 'GIRLS ON FILM', '1097', '0-316-73475-6', 'NOVEL', '', 'LITTLE BROWN AND COMPANY', 'ZOEY DEAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:58:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (334, 'HOW TO SAVE YOUR TALL', '0235', '978-0-375-83755-5', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION OF DATA', 'MARY HANSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 03:59:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (335, 'GAIL CARSON LEVINE', '1098', '0-06-055886-5', '', '', 'AVONBOOKS', 'ELLA', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:01:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (336, 'PREP', '0236', '0-525-47135-9', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION IN DATA', 'JAKE COBURN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:02:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (337, 'MIRACLES ON MAPLE HILL', '1099', '0-590-43145-5', 'NOVEL', '', 'SCHOLASTIC', 'VIRGINIA SORENSEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:03:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (338, 'AFRICA DISCOVERS HER PAST', '0237', '19 412275 1', 'NOVEL', '', 'OXFORD UNIVERSITY PRESS', 'J.D. FAGE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:04:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (339, 'A COMMUNICATIVE APPROACH', '1100', '0-07-365516-3', 'COMMUNICATION', '', 'MCGRAW HILLS', 'TERRELL', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:09:40', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (340, 'WALT DISNEY WINNIE THE POOH AND HIS FREINDS', '0238', '1-57082-968-3', 'NOVEL', '', 'RANDOM HOUSE', 'RANDOM HOUSE', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:09:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (341, 'MIRACLE ON MAPLE HILL', '0239', '0-590-43145-5', 'NOVEL', '', 'SCHOLASTIC INC.', 'VIRGINIA SORENSEN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:41:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (342, 'GAIL CARSON LEVINE', '0240', '0-06-055886-5', 'NOVEL', '', 'LIBRARY OF CONRESS CATALOGING IN PUBLICATION DATA', 'ELLA ECHANTED', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:51:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (343, 'GIRLS ON FILM', '0241', '0-316-73475-6', 'NOVEL', '', 'STREET PRODUCTIONS', 'ZOEY DEAN', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:55:42', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (344, 'KONTAKTE A COMMUNICATIVE APPROACH', '0242', '0-07-365516-3', 'NOVEL', '', 'MCGRAW -HILL HIGHER EDUCATION', 'TERRELL TSCHIRNER', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:58:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (345, 'SONS OF THE DARK', '0243', '078688183-1', 'NOVEL', '', 'HYPERRION', 'LYNNE EWING', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 04:59:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (346, 'THE DARKNESS OF A LEAF', '0244', '0-312-14308-7', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING -IN-PUBLICATION DATA', 'CAROLINE STICKLAND', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:02:37', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (347, 'PHYSICAL EDUCATION FOR PRIMARY SCHOOLS', '0245', '978-9966-46-249-X', 'PHYSICAL EDUCATION', '', 'EAST AFRICA EDUCATIONA PUBLISHERS', 'JERIM OTIENO', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:04:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (348, 'PHYSICAL EDUCATION TEACHERS GUIDE FOR FORM FOUR', '0246', '9966-22-452-1', 'PHYSICAL EDUCATION', '', 'THE JOMO KENYATTA FOUNDATION', 'JANET KAMENJU', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:07:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (349, 'ZIGBY CAMPS OUT', '0247', '978-0-00-783805-9', 'NOVEL', '', 'HAPERCOLLINS PUBLISHERS LMD', 'BRIAN PATERSON', 0, '0.00', '2025-02-18', '', 'yes', 'no', '2025-02-18 05:09:24', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (350, 'FREEDOM AND AFTER', '1101', '9966 46 974 5', 'FREEDOM', '', 'EAST AFRICAN EDUCATIONAL PUBLISHER', 'TOM MBOYA', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:21:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (351, 'READING MASTERY', '1102', '0-07-569326-7', 'NOVEL', '', 'MC GRAW HILL', 'ELAINE C. BRUNER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:24:15', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (352, 'STUDYING THE NOVEL', '1103', '978-0-340-98513-7', 'NOVEL', '', 'BLOOMS BURRY', 'JEREMY HAWTHORN', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:26:31', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (353, 'THEMES IN KENYAN HISTORY', '1104', '9966-46-578-2', 'KENYAN HISTORY', '', 'EAST AFRICAN EDUCATIONAL PUBLISHER', 'WILLIAM R. OCHIENG', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:29:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (354, 'MICROSOFT VISUAL BASIC FOR APPLICATIONS', '1105', '0-07-283616-4', 'TECHNOLOGY MICROSOFT', '', 'TECHNOLOGY EDUCATION', 'ALAN I REA', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:32:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (355, 'WOMAN THOU ART LOOSED', '1106', '1-56043-100-8', 'NOVEL', '', 'TREASURE HOUSE', 'T.D . JAKES', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:34:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (356, 'CHILDREN\'S RIGHTS', '1107', '9966 34278-8', 'HUMAN RIGHTS', '', 'MACMILLAN KENYA', 'ISSA TOURE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:36:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (357, 'NELSON MANDELA', '1108', '978-1-86200-763-5', 'HISTORY', '', 'CHRISTINA SCOTT', 'CHRISTINA SCOTT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:39:34', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (358, 'A HISTORY OF AFRICA', '1109', '9966-25358-0', 'HISTORY', '', 'EAST AFRICAN EDUCATIONAL PUBLISHERS', 'ASSA OKOTH', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:42:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (359, 'SHAKESPEAR', '1110', '0-500-26021-4', 'HISTORY', '', 'THAMES AND HUDSON', 'F.E. HALLIDAY', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:45:22', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (360, 'THERE IS A GOD HOW THE WORLD\'S MOST NOTORIOUS ATHEIST CHANGED HIS MIND', '1111', '978-0-06-133529-7', 'THEOLOGY', '', 'HARPER COLLINS PUBLISHER', 'ATHONY FLEW', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:49:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (361, 'MY HOPE OF PEACE', '1112', '978-1-4165-9219-8', 'POLITICAL SCIENCE', '', 'FREE PRESS', 'JEHAN SADAT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:51:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (362, 'THE ARCHAELOGY WORKBOOK', '1113', '0-8122-6625-6', 'HISTORY', '', 'UNIVERSITY OF PENNSYLVANIA PRESS', 'STEVE DANIELS', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:54:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (363, 'PUBLICATION MANUAL', '1114', '1-55798-241-4', 'PSYCHOLOGY', '', 'AMERICAN PSYCHOLOGICAL ASSOCIATION', 'WASHINGTON DC', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 08:57:32', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (364, 'THE ARCHAEOLOGY WORKBOOK', '1115', '0-8622-6625-6', 'HISTORY', '', 'UNIVERSITY OF PEVVSYLVANIA PRESS', 'NICHOLAS DAVID', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:00:23', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (365, 'MAN FROM MACHAKOS', '1116', '9966-22-563-3', 'NOVEL', '', 'THE JOMO KENYATTA FOUNDATION', 'DAVID G. MAILLU', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:06:00', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (366, 'ROMAN PEOPLE', '1117', '0-7674-1707-0', 'HISTORY OF ROMAN PEOPLE', '', 'MAYFIELD PUBLISHING COMPANY', 'ROBERT B. KEBRIC', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:09:08', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (367, 'PICTURES FOR LANGUAGE LEARNING', '1118', '0-521-35800-0', 'LANGUAGE', '', 'CAMBRIDGE UNIVERSITY PRESS', 'ANDREW WRIGHT', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:11:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (368, 'GOING WITHIN', '1119', '0-553-05367-1', 'PSYCHOLOGY', '', 'BANTAM BOOKS', 'SHIRLEY MACLAINE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:14:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (369, 'THE BLACK AMERICANS', '1120', '0-690-04419-4', 'HISTORY OF BLACK AMERICAN', '', 'HARPERCOLLINS PUBLISHER', 'MILTON MELTZER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:16:49', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (370, 'THE PSALMS OF THE JERUSALEM BIBLE', '1121', '0-385-690-9', 'THEOLOGY', '', 'DISION OF DOUBLEDAY$COMPANY', 'ROB COBUZIO', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:22:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (371, 'KEEP IN STEP WITH THE SPIRIT', '1122', '0-8007-5235-X', 'THEOLOGY', '', 'POWER BOOKS', 'J.I.PACKER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:27:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (372, 'HOT FLASHES FROM HEAVEN', '1123', '978-0-7369-2031-5', 'SOCIOLOGY', '', 'HARVEST HOUSE PUBLISHERS', 'RONNA SNYDER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:30:50', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (373, 'PRAYER$EVANGELISM', '1124', '73-91552', 'THEOLOGY', '', 'CAMBRIDGE UNIVERSITY PRESS', 'HELEN S. SHOEMAKER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:34:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (374, 'ST.BENEDICT HERO OF THE HILLS', '1125', '0-89870-767-6', 'THEOLOGY', '', 'FARRAR STRAUS AND GIROUX', 'IGNATIUS', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:36:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (375, 'WORLD BOOK', '1126', '978-0-7166-0108-1', 'WORLD EXPLORE', '', 'WORLDBOOK INC', 'SCOTT FETZER', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:41:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (376, 'THE SURPRISE PARTY', '1127', '0671-73561-6', 'NOVEL', '', 'POCKET BOOKS', 'R. L.STINE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:44:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (377, 'THIS PRESENT DARKNESS', '1128', '0-89107-390-6', 'NOVEL', '', 'CROSSWAY BOOKS', 'FRANK E. PERETTI', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 09:46:45', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (378, 'SALEM WITCH', '1129', '978-0-7534-1327-2', 'NOVEL', '', 'KINGFISHER', 'PATRICIA HERMES', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 10:07:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (379, 'MILESTONES OF SCIENCE', '1130', '0-7922 7906-9', 'POLITICAL SCIENCE', '', 'NATIONAL GEOGRAPHIC', 'CURT SUPLEE', 0, '0.00', '2025-02-20', '', 'yes', 'no', '2025-02-20 10:10:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (380, 'DIAL L FOR LOSER', '0248', '978-0-316-11504-9', 'NOVEL', '', 'LITTLE BROWN COMPANY', 'LISI HARRISON', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:29:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (381, 'JERRY FALWELL', '0249', '0-8407-5172-9', 'NOVEL', '', 'THOMAS NELSON PUBLISHERS', 'GELARD STROBER', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:33:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (382, 'AN INTRODUCTION TO AFRICAN HISTORY', '0250', '10: 9966-846-15-8', 'HISTORY', '', 'UNIVERSITY OF NAIROBI PRESS', 'MATHIAS A OGUTU', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:37:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (383, 'RESPONSIVE HEART', '0251', '1-57683-181-7', 'NOVEL', '', 'NAV PRESS1', 'RYANN COOLEY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:40:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (384, 'AMERICAN INDIAN POLICY IN THE TWENTIETH CENTURY', '0252', '0-8061-1897-0', 'NOVEL ', '', 'UNIVERSITY OF OKLAHOMA PRESS', 'VINE DELORIA', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:45:37', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (385, 'BULLY FOR YOU TEDDY ROOSEVELT', '0253', '0-439-14913-4', 'NOVEL', '', 'SCHOLASTIC INC', 'MIKE WINNER', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:48:19', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (386, 'WORLD BOOK', '0254', '978-0-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:54:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (387, 'WORLD BOOK', '0255', '978-0-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY ', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 01:59:10', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (388, 'WORLD BOOK', '0256', '978-7166 -0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:02:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (389, 'WORLD BOOK', '0257', '978-7166-0108-1', 'HISTORY', '', 'LIBRARY OF CONGRESS CATALOGUING IN PUBLICATION', 'A SCOTT FETZER COMPANY', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:06:51', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (390, 'FUNDAMENTALS OF COUNSELING', '0258', '0-395-17580-1', 'FUNDAMENTALS OF COUNSELING', '', 'HOUNGTON MIFFLIN COMPANY', 'SHERTZER/STONE', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:06:25', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (391, 'HARCOUT BRACE SIGNATURES', '0259', '0-15-306401-3', 'NOVEL', '', 'HARCOUT BRACE COMPANY', 'ROGER C. FARR', 0, '0.00', '2025-02-28', '', 'yes', 'no', '2025-02-28 02:10:18', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (392, 'EARLY JUDAISM AND ITS MODERN INTERPRETERS', '0260', '0-89130-921', 'NOVEL', '', 'LIBRARY OF CONGRESS CATALOGING IN PUBLICATION DATA', 'SHAGE J. D. COHEN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:44:29', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (393, 'THE PHARAOHS OF ANCIENT EGYPT', '0261', '0-394-84699-0', 'NOVEL', '', 'LANDMARK BOOKS', 'ELIZABETH ANNE PAYNE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:50:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (394, 'H.NORMAN WRIGHT', '0262', '0-89081-816-9', 'NOVEL', '', 'HARVEST HOUSE PUBLISHERS', 'LLYOD OGILVILE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:53:28', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (395, 'BUSINESS LAW', '1131', '978-0-07-014685-3', 'BUSINESS', '', 'MCGRAW HILL', 'SATISH B MATHUR', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:54:04', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (396, 'THE ENDURING CHURCH', '0263', '0-377-00306-9', 'THE ENDURING CHURCH', '', 'FREIND PRESS', 'GAIL V. COULSON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:55:20', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (397, 'VISUAL ILLUSIONS', '1132', '978-0-7858-2173-1', 'NOVEL', '', 'CHARTWELL BOOKS', 'CHARTWELL BOOKS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 01:59:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (398, 'COMPANY LAW', '1133', '9966-01-137-4', 'LAW', '', 'FOCUS PUBISHERS', 'JOHN JOSEPH OGOLA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:01:06', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (399, 'DARUBINI YA KISWAHILI', '1134', '9966-47-246-0', 'EDUCATION', '', 'PHOENIX', 'J .HABWE ', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:03:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (400, 'EXPERIENCING THE WORLD RELIGIONS', '0264', '978-0-07-353564-7', 'EXPERIENCING THE WORLD RELIGIONS', '', 'MC GRAW HILL PUBLISHERS', 'MOLLOY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:03:44', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (401, 'BEDFORD BIBLIOGRAPHY FOR TEACHERS OF WRITING', '1135', '0-312-11556-3', 'TEACHING', '', 'BEDFORD BOOKS', 'PATRICIA BIZELL', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:05:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (402, 'INTRODUCTION TO COUNSELING', '0265', '0-697-06070-5', 'COUNSELING', '', 'BROWN COMPANY PUBLISHERS', 'GARY S. BELKIN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:06:46', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (403, 'THE PRACTICE OF WRITING', '1136', '0-312-63546-X', 'TEACHING', '', 'ST MARTINS PRESS', 'ROBERT SCHOLES', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:08:13', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (404, 'ESSAYS FROM CONTEMPORARY CULTURE', '0266', '0-15-505302-7', 'ESSAYS FROM CONTEMPORARY CULTURE', '', 'HARCOURT BRACE COLLEGE PUBLISHERS', 'KATHERINE ANNE ACKLEY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:09:27', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (405, 'THE NEXT ARCHAEOLOGY WORKBOOK', '0267', '0-8122-1293-2', 'ARCHAEOLOGY', '', 'UNIVERSITY OF PENNSYLYVANIA PRESS', 'STEVE DANIELS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:11:33', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (406, 'BORDERLINES', '1137', '0-415-91114-1', 'HISTORY', '', 'NEW FETER LANE', 'BILLIE MELMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:12:41', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (407, 'LEADERSHIP,LOVE,$AGGREGATION', '1138', '0-15-149348-0', 'PSYCHOLOGY', '', 'DAVIS ALLISON', 'ALLISON DAVIS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:15:57', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (408, 'GENERAL PSYCHOLOGY AND PERSONALITY DEVELOPMENT', '1139', '9966-01-119-6', 'PSYCHOLOGY', '', 'FOCUS', 'MARGARET KABIRU', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:17:55', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (409, 'VOICES FROM WOUNDED KNEE', '1140', '0-914838-02-4', 'HISTORY', '', 'AKWESASNE NOTES', 'VINE DELORIA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:19:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (410, 'CHRISTIANITY', '1141', '978-0-719-57526-6', 'THEOLOGY', '', 'HODDER EDUCATION', 'CLAIRE CLINTON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:22:14', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (411, 'AN INTERGRATED APPROACH TO PEER COUNSELING', '0268', '978-9966-20-266-6', 'COUNSELING', '', 'EVANGEL PUBLISHING HOUSE', 'LUCY W. KANG\'ORI', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:24:02', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (412, 'THE LAST OF THE GIANTS', '1142', '0-8007-9192-4', 'NOVEL', '', 'CHOOSEN  BOOOKS', 'GEORGE OTIS,JR', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:24:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (413, 'COMMON CULTURE', '1143', '0-13-182545-3', 'TEACHING', '', 'PEARSON', 'MICHAEL PETRACCA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:26:36', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (414, 'THE QUALITY OF LIFE VALUATION SOCIAL RESEARCH', '0269', '0-8039-9587-3', 'THE QUALITY OF LIFE VALUATION SOCIAL RESEARCH', '', 'SAGE PUBLICATIONS', 'RAMKRISHNA MUKHERJEE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:27:05', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (415, 'PRACTICAL DIVINITY', '1144', '0-637-33326-1', 'THEOLOGY', '', 'ABINGDON PRESS', 'THOMAS A.LANGFORD', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:29:12', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (416, 'THE KALAHARI TYPING SCHOOL FOR MEN', '0270', '1-4000-3180-X', 'NOVEL', '', 'A DIVISION OF RANDOM HOUSE INC', 'ALEXANDER MC CALL SMITH', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:31:26', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (417, 'THEOLOGY IN THE CONTEXT OF SCIENCE', '1145', '978-0-300-16456-5', 'THEOLOGY', '', 'YALE UNIVERSITY PRESS', 'JOHN POLKINGHORNE', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:31:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (418, 'THE MAKING OF MIND', '1146', '0-674-54327-7', 'PSYCHOLOGY', '', 'HARVARD UNIVERSITY PRESS', 'A.R. LURIA', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:33:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (419, 'COMMUNITY CAPACITY BUILDING AND EMPORMENT', '0271', '996606007-3', 'COMMUNITY CAPACITY BUILDING AND EMPORMENT', '', 'PSI CONSULTANTS', 'GITONGA .B.A', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:34:03', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (420, 'NEW MOVEMENTS', '1147', '0-281-02929-6', 'THEOLOGY', '', 'SPCK HOLY TRINITY CHURCH', 'ALAN THOMSON', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:35:59', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (421, 'INVESTIGATING THE SOCIAL WOLRD', '0272', '1-4129-2734', 'INVESTIGATING THE SOCIAL WOLRD', '', 'SAGE PUBLICATION', 'RUSSELL K. SCHUTT', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:37:53', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (422, 'THE BIRTH OF LIVING GOD', '1148', '0-226-72102-7', 'THEOLOGY', '', 'UNIVERSITY OF CHICAGO PRESS', 'ANA-MARIA RIZZUTO', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:38:48', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (423, 'CHRISTIAN ETHICS IN THE AFRICAN CONTEXT', '1149', '9966-768-62-9', 'THEOLOGY', '', 'UZIMA', 'HANS HASELBARTH', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:41:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (424, 'CHICKEN SOUP FOR THE COLLEGE SOUL', '1150', '1-55874-702-8', 'LIFE OF COLLEGE', '', 'HEALTH COMMUNICATIONS INC', 'JACK CANFIELD', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:44:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (425, 'THE COUNSELING PSYCHOLOGIST', '0273', '79409-2051', 'COUNSELING', '', 'SAGE PUBLICATION', 'P.PAUL HEPPNER', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:45:09', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (426, 'MOTHERLESS DAUGHTERS', '0274', '13 978-0-7382-1026-1', 'NOVEL', '', 'DA CAPO PRESS BOOKS', 'KIRKUS REVIEWS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:49:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (427, 'SYSTEM THEOORY AND MANAGEMENT INFORMATION SYSTEMS SIMPLIFIED', '0275', '9966-28-886-4', 'ICT', '', 'SALEEMI PUBLICATION LTD', 'N.A.SALEEMI', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 02:55:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (428, 'OBJECT-ORIENTED SYSTEMS ANALYSIS AND DESIGN', '0276', '978-007712536-3', 'ICT', '', 'MCGRAW-HILL EDUCATION', 'SIMON BENNETT STEVE MCROBB AND RAY FARMER', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:01:21', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (429, 'BETWEEN INNER SPACE AND OUTER SPACE', '0277', '0-19-850254-0', 'BETWEEN INNER SPACE AND OUTER SPACE', '', 'UNITED STATE BY OXFORD UNIVERSITY JOHN D.BARROW', 'JOHN D.BARROW', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:12:01', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (430, 'STUDY GUIDE TO ACCOMPANY THE PHYSICAL UNIVERSE', '0278', '0-07-228415-3', 'STUDY GUIDE TO ACCOMPANY THE PHYSICAL UNIVERSE', '', 'JP LENNEY', 'STEVEN D.CAREY', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:18:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (431, 'THEORY AND PRACTICE OF COUNSELLING AND PSYCHOTHERAPY', '0279', '978-1-4462-9556-4', 'THEORY AND PRACTICE OF COUNSELLING AND PSYCHOTHERAPY', '', 'RICHARD NELSON -JONES', 'RICHARD NELSON-JONES', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:28:07', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (432, 'BLACKS IN SCIENCE AND MEDICINE', '0280', '0-891-16-665-3', 'BLACKS IN SCIENCE AND MEDICINE', '', 'HEMISPHERE PUBLISHING CORPORATION', 'VIVIAN OVELTON SAMMONS', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 03:41:54', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (433, 'APPLYING UML AND PATTERNS', '0281', '0-13-148906-2', 'APPLYING UML AND PATTERNS', '', 'PRENTICE HALL PTR', 'CRAIG LAWARMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 05:33:11', NULL);
INSERT INTO `books` (`id`, `book_title`, `book_no`, `isbn_no`, `subject`, `rack_no`, `publish`, `author`, `qty`, `perunitcost`, `postdate`, `description`, `available`, `is_active`, `created_at`, `updated_at`) VALUES (434, 'THE BEDFORD BIBLIOGRAPHY', '0282', '0-312-40501-4', 'BIBLIOGRAPHY', '', 'BRUCE HERZBERG', 'DEAN G. PEERMAN', 0, '0.00', '2025-03-04', '', 'yes', 'no', '2025-03-04 05:51:26', NULL);


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-01-19 03:10:29');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-01-19 03:10:31');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'admission', 0, '2021-01-18 23:48:11');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (4, 'complain', 1, '2025-01-29 04:57:25');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (5, 'contact_us', 0, '2021-01-18 23:48:15');


#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'COMMUTER', 'no', '2025-01-10 02:05:44', NULL);
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'RESIDENT', 'no', '2025-01-10 02:05:54', NULL);


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>principal', '.................................<br>admin', 'sampletc121.png', 2, 1, 360, 400, 480, 810, 1, 230, '2019-12-21 10:14:34', '0000-00-00');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: class_section_times
#

DROP TABLE IF EXISTS `class_section_times`;

CREATE TABLE `class_section_times` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `class_section_times_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=367 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 8, 4, 'no', '2025-01-10 01:47:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (9, 9, 4, 'no', '2025-01-10 01:51:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 1, 5, 'no', '2025-01-10 01:52:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (11, 4, 4, 'no', '2025-01-10 03:30:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (12, 5, 4, 'no', '2025-01-10 03:32:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (13, 6, 4, 'no', '2025-01-10 03:33:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (14, 7, 4, 'no', '2025-01-10 03:33:49', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (15, 3, 4, 'no', '2025-01-10 03:34:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (16, 2, 4, 'no', '2025-01-10 03:34:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (17, 10, 4, 'no', '2025-01-10 03:35:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (18, 11, 4, 'no', '2025-01-10 03:36:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (19, 12, 4, 'no', '2025-01-10 03:36:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (20, 13, 5, 'no', '2025-01-10 03:36:52', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (21, 14, 5, 'no', '2025-01-10 03:37:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (22, 15, 5, 'no', '2025-01-10 03:37:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (23, 16, 5, 'no', '2025-01-10 03:37:49', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (24, 17, 5, 'no', '2025-01-10 03:38:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (25, 18, 5, 'no', '2025-01-10 03:39:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (26, 19, 6, 'no', '2025-01-10 03:41:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (27, 20, 6, 'no', '2025-01-10 03:41:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (28, 21, 6, 'no', '2025-01-10 03:41:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (29, 22, 6, 'no', '2025-01-10 03:42:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (30, 23, 6, 'no', '2025-01-10 03:42:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (31, 24, 6, 'no', '2025-01-10 03:43:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (32, 25, 6, 'no', '2025-01-10 03:43:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (33, 26, 6, 'no', '2025-01-10 03:43:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (34, 27, 6, 'no', '2025-01-10 03:43:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (35, 28, 6, 'no', '2025-01-10 03:44:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (36, 29, 6, 'no', '2025-01-10 03:44:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (37, 30, 6, 'no', '2025-01-10 03:44:38', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (38, 31, 6, 'no', '2025-01-10 06:20:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (39, 32, 6, 'no', '2025-01-10 06:21:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (40, 33, 6, 'no', '2025-01-10 06:21:13', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (41, 34, 6, 'no', '2025-01-10 06:21:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (42, 35, 6, 'no', '2025-01-10 06:21:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (43, 36, 6, 'no', '2025-01-10 06:22:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (44, 37, 6, 'no', '2025-01-10 06:22:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (45, 38, 6, 'no', '2025-01-10 06:22:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (46, 39, 6, 'no', '2025-01-10 06:23:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (47, 40, 6, 'no', '2025-01-10 06:23:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (48, 41, 6, 'no', '2025-01-10 06:23:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (49, 42, 6, 'no', '2025-01-10 06:23:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (50, 43, 6, 'no', '2025-01-10 06:23:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (51, 44, 6, 'no', '2025-01-10 06:24:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (52, 45, 6, 'no', '2025-01-10 06:24:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (53, 46, 13, 'no', '2025-01-10 06:26:12', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (54, 47, 13, 'no', '2025-01-10 06:26:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (55, 48, 13, 'no', '2025-01-10 06:26:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (56, 49, 13, 'no', '2025-01-10 06:26:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (57, 50, 13, 'no', '2025-01-10 06:27:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (58, 51, 13, 'no', '2025-01-10 06:27:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (59, 52, 13, 'no', '2025-01-10 06:27:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (60, 53, 13, 'no', '2025-01-10 06:27:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (61, 54, 13, 'no', '2025-01-10 06:28:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (62, 55, 13, 'no', '2025-01-10 06:29:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (63, 56, 13, 'no', '2025-01-10 06:29:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (64, 57, 13, 'no', '2025-01-10 08:01:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (65, 58, 13, 'no', '2025-01-10 08:01:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (66, 59, 13, 'no', '2025-01-10 08:01:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (67, 60, 13, 'no', '2025-01-10 08:02:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (68, 61, 13, 'no', '2025-01-10 08:02:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (69, 62, 13, 'no', '2025-01-10 08:02:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (70, 63, 13, 'no', '2025-01-10 08:03:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (71, 64, 13, 'no', '2025-01-10 08:03:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (72, 65, 9, 'no', '2025-01-10 08:04:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (73, 66, 9, 'no', '2025-01-10 08:04:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (74, 67, 9, 'no', '2025-01-10 08:05:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (75, 68, 9, 'no', '2025-01-10 08:05:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (76, 69, 9, 'no', '2025-01-10 08:05:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (77, 70, 9, 'no', '2025-01-10 08:05:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (78, 71, 9, 'no', '2025-01-10 08:06:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (79, 72, 9, 'no', '2025-01-10 08:06:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (80, 73, 9, 'no', '2025-01-10 08:06:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (81, 74, 9, 'no', '2025-01-10 08:06:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (82, 75, 9, 'no', '2025-01-10 08:07:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (83, 76, 9, 'no', '2025-01-10 08:07:31', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (84, 77, 9, 'no', '2025-01-10 08:07:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (85, 78, 9, 'no', '2025-01-10 08:08:05', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (86, 79, 9, 'no', '2025-01-10 08:08:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (87, 80, 9, 'no', '2025-01-10 08:09:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (88, 81, 9, 'no', '2025-01-10 08:09:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (89, 82, 9, 'no', '2025-01-10 08:09:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (90, 83, 9, 'no', '2025-01-10 08:10:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (91, 84, 9, 'no', '2025-01-10 08:10:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (92, 85, 11, 'no', '2025-01-10 08:11:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (93, 86, 11, 'no', '2025-01-10 08:11:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (94, 87, 11, 'no', '2025-01-10 08:11:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (95, 88, 11, 'no', '2025-01-10 08:12:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (96, 89, 11, 'no', '2025-01-10 08:12:13', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (97, 90, 11, 'no', '2025-01-10 08:12:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (98, 91, 11, 'no', '2025-01-10 08:12:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (99, 92, 11, 'no', '2025-01-10 08:13:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (100, 93, 11, 'no', '2025-01-10 08:13:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (101, 94, 11, 'no', '2025-01-10 08:13:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (102, 95, 11, 'no', '2025-01-10 08:13:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (103, 96, 11, 'no', '2025-01-10 08:14:12', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (104, 97, 11, 'no', '2025-01-10 08:14:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (105, 98, 11, 'no', '2025-01-10 08:14:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (106, 99, 11, 'no', '2025-01-10 08:14:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (107, 100, 11, 'no', '2025-01-10 08:16:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (108, 101, 11, 'no', '2025-01-10 08:17:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (109, 102, 11, 'no', '2025-01-10 08:17:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (110, 103, 11, 'no', '2025-01-10 08:19:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (111, 104, 11, 'no', '2025-01-10 08:19:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (112, 105, 8, 'no', '2025-01-10 08:32:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (113, 106, 8, 'no', '2025-01-10 08:32:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (114, 107, 8, 'no', '2025-01-10 08:32:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (115, 108, 8, 'no', '2025-01-10 08:35:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (116, 109, 8, 'no', '2025-01-10 08:35:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (117, 110, 8, 'no', '2025-01-10 08:35:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (118, 111, 8, 'no', '2025-01-10 08:35:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (119, 112, 8, 'no', '2025-01-10 08:36:05', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (120, 113, 8, 'no', '2025-01-10 08:36:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (121, 114, 8, 'no', '2025-01-10 08:36:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (122, 115, 8, 'no', '2025-01-10 08:36:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (123, 116, 8, 'no', '2025-01-10 08:37:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (124, 117, 8, 'no', '2025-01-10 08:37:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (125, 118, 8, 'no', '2025-01-10 08:37:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (126, 119, 8, 'no', '2025-01-10 08:37:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (127, 120, 8, 'no', '2025-01-10 08:38:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (128, 121, 8, 'no', '2025-01-10 08:38:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (129, 122, 8, 'no', '2025-01-10 08:38:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (130, 123, 8, 'no', '2025-01-10 08:44:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (131, 124, 8, 'no', '2025-01-10 08:44:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (132, 125, 8, 'no', '2025-01-10 08:44:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (133, 126, 8, 'no', '2025-01-10 08:44:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (134, 127, 8, 'no', '2025-01-10 08:44:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (135, 128, 8, 'no', '2025-01-10 08:45:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (136, 129, 8, 'no', '2025-01-10 08:45:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (137, 130, 8, 'no', '2025-01-10 08:46:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (138, 131, 8, 'no', '2025-01-10 08:46:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (139, 132, 8, 'no', '2025-01-10 08:46:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (140, 133, 8, 'no', '2025-01-10 08:46:38', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (141, 134, 8, 'no', '2025-01-10 08:46:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (142, 135, 8, 'no', '2025-01-10 08:48:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (143, 136, 8, 'no', '2025-01-10 08:49:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (144, 137, 8, 'no', '2025-01-10 09:00:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (145, 138, 8, 'no', '2025-01-10 09:00:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (146, 139, 8, 'no', '2025-01-10 09:01:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (147, 140, 8, 'no', '2025-01-10 09:01:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (148, 141, 8, 'no', '2025-01-10 09:01:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (149, 142, 8, 'no', '2025-01-10 09:02:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (150, 143, 8, 'no', '2025-01-10 09:02:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (151, 144, 8, 'no', '2025-01-10 09:02:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (152, 145, 8, 'no', '2025-01-10 09:02:52', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (153, 146, 8, 'no', '2025-01-10 09:03:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (154, 147, 8, 'no', '2025-01-10 09:04:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (155, 148, 8, 'no', '2025-01-10 09:04:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (156, 149, 8, 'no', '2025-01-10 09:04:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (157, 150, 8, 'no', '2025-01-10 09:05:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (158, 151, 8, 'no', '2025-01-10 09:05:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (159, 152, 8, 'no', '2025-01-10 09:05:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (160, 153, 8, 'no', '2025-01-10 09:05:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (161, 154, 8, 'no', '2025-01-10 09:05:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (162, 155, 8, 'no', '2025-01-10 09:06:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (163, 156, 8, 'no', '2025-01-10 09:06:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (164, 157, 8, 'no', '2025-01-10 09:08:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (165, 158, 8, 'no', '2025-01-10 09:08:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (166, 159, 8, 'no', '2025-01-10 09:08:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (167, 160, 8, 'no', '2025-01-10 09:09:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (168, 161, 8, 'no', '2025-01-10 09:10:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (169, 162, 8, 'no', '2025-01-10 09:10:31', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (170, 163, 8, 'no', '2025-01-10 09:10:52', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (171, 164, 8, 'no', '2025-01-10 09:11:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (172, 165, 8, 'no', '2025-01-10 09:11:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (173, 166, 8, 'no', '2025-01-10 09:11:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (174, 167, 8, 'no', '2025-01-10 09:12:13', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (175, 168, 8, 'no', '2025-01-10 09:12:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (176, 169, 8, 'no', '2025-01-10 09:12:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (177, 170, 8, 'no', '2025-01-10 09:13:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (178, 171, 8, 'no', '2025-01-10 09:13:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (179, 172, 8, 'no', '2025-01-10 09:14:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (180, 173, 8, 'no', '2025-01-10 09:15:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (181, 174, 8, 'no', '2025-01-10 09:15:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (182, 175, 8, 'no', '2025-01-10 09:15:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (183, 176, 8, 'no', '2025-01-10 09:16:13', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (184, 177, 8, 'no', '2025-01-10 09:16:33', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (185, 178, 8, 'no', '2025-01-10 09:24:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (186, 179, 12, 'no', '2025-01-10 09:27:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (187, 180, 12, 'no', '2025-01-10 09:27:20', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (188, 181, 12, 'no', '2025-01-10 09:27:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (189, 182, 12, 'no', '2025-01-10 09:27:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (190, 183, 12, 'no', '2025-01-10 09:28:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (191, 184, 12, 'no', '2025-01-10 09:28:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (192, 185, 8, 'no', '2025-01-10 09:29:31', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (193, 186, 8, 'no', '2025-01-10 09:29:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (194, 187, 8, 'no', '2025-01-10 09:29:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (195, 188, 8, 'no', '2025-01-10 09:30:22', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (196, 189, 8, 'no', '2025-01-10 09:30:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (197, 190, 8, 'no', '2025-01-10 09:30:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (198, 191, 12, 'no', '2025-01-10 09:33:21', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (199, 192, 12, 'no', '2025-01-10 09:33:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (200, 193, 12, 'no', '2025-01-10 09:33:46', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (201, 194, 12, 'no', '2025-01-10 09:34:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (202, 195, 12, 'no', '2025-01-10 09:34:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (203, 196, 12, 'no', '2025-01-10 09:34:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (204, 197, 12, 'no', '2025-01-10 09:35:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (205, 198, 12, 'no', '2025-01-10 09:35:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (206, 199, 12, 'no', '2025-01-10 09:35:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (207, 200, 12, 'no', '2025-01-10 09:36:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (208, 201, 12, 'no', '2025-01-10 09:36:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (209, 202, 12, 'no', '2025-01-10 09:36:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (210, 203, 12, 'no', '2025-01-10 09:36:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (211, 204, 12, 'no', '2025-01-10 09:37:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (212, 205, 12, 'no', '2025-01-10 09:37:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (213, 206, 12, 'no', '2025-01-10 09:38:49', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (214, 207, 12, 'no', '2025-01-10 09:39:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (215, 208, 12, 'no', '2025-01-10 09:39:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (216, 209, 12, 'no', '2025-01-10 09:39:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (217, 210, 12, 'no', '2025-01-10 09:40:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (218, 211, 12, 'no', '2025-01-10 09:42:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (219, 212, 12, 'no', '2025-01-10 09:43:12', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (220, 213, 12, 'no', '2025-01-10 09:43:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (221, 214, 12, 'no', '2025-01-10 09:44:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (222, 215, 12, 'no', '2025-01-10 09:44:08', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (223, 216, 12, 'no', '2025-01-10 09:44:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (224, 217, 12, 'no', '2025-01-10 09:44:24', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (225, 218, 12, 'no', '2025-01-10 09:44:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (226, 219, 12, 'no', '2025-01-10 09:44:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (227, 220, 12, 'no', '2025-01-10 09:45:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (228, 221, 10, 'no', '2025-01-10 09:45:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (229, 222, 10, 'no', '2025-01-10 09:45:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (230, 223, 10, 'no', '2025-01-10 09:46:12', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (231, 224, 10, 'no', '2025-01-10 09:46:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (232, 225, 10, 'no', '2025-01-10 09:46:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (233, 226, 10, 'no', '2025-01-10 09:46:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (234, 227, 10, 'no', '2025-01-10 09:47:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (235, 228, 12, 'no', '2025-01-10 09:47:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (236, 229, 10, 'no', '2025-01-10 09:48:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (237, 230, 10, 'no', '2025-01-10 09:48:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (238, 231, 10, 'no', '2025-01-10 09:48:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (239, 232, 10, 'no', '2025-01-10 09:48:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (240, 233, 10, 'no', '2025-01-10 09:49:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (241, 234, 10, 'no', '2025-01-10 09:51:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (242, 235, 10, 'no', '2025-01-10 09:51:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (243, 236, 10, 'no', '2025-01-10 09:52:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (244, 237, 10, 'no', '2025-01-10 09:52:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (245, 238, 10, 'no', '2025-01-10 09:52:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (246, 239, 10, 'no', '2025-01-10 09:52:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (247, 240, 10, 'no', '2025-01-10 09:53:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (248, 241, 10, 'no', '2025-01-10 09:53:31', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (249, 242, 4, 'no', '2025-01-10 09:55:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (250, 243, 4, 'no', '2025-01-10 09:55:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (251, 244, 4, 'no', '2025-01-10 09:55:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (252, 245, 4, 'no', '2025-01-10 09:57:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (253, 246, 4, 'no', '2025-01-10 09:57:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (254, 247, 4, 'no', '2025-01-10 09:57:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (255, 248, 4, 'no', '2025-01-10 09:57:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (256, 249, 4, 'no', '2025-01-10 09:57:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (257, 250, 5, 'no', '2025-01-10 10:36:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (258, 251, 5, 'no', '2025-01-10 10:36:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (259, 252, 5, 'no', '2025-01-10 10:36:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (260, 253, 5, 'no', '2025-01-10 10:37:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (261, 254, 5, 'no', '2025-01-10 10:37:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (262, 255, 5, 'no', '2025-01-10 10:37:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (263, 256, 5, 'no', '2025-01-10 10:38:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (264, 257, 5, 'no', '2025-01-10 10:39:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (265, 258, 5, 'no', '2025-01-10 10:39:50', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (266, 259, 5, 'no', '2025-01-10 10:40:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (267, 260, 5, 'no', '2025-01-10 10:40:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (268, 261, 5, 'no', '2025-01-10 10:40:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (269, 262, 5, 'no', '2025-01-10 10:41:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (270, 263, 5, 'no', '2025-01-10 10:41:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (271, 264, 5, 'no', '2025-01-10 10:41:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (272, 265, 5, 'no', '2025-01-10 10:41:59', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (273, 266, 5, 'no', '2025-01-10 10:42:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (274, 267, 5, 'no', '2025-01-10 10:42:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (275, 268, 5, 'no', '2025-01-10 10:42:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (276, 269, 5, 'no', '2025-01-10 10:43:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (277, 270, 5, 'no', '2025-01-10 10:43:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (278, 271, 5, 'no', '2025-01-10 10:43:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (279, 272, 6, 'no', '2025-01-10 10:54:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (280, 273, 6, 'no', '2025-01-10 10:54:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (281, 274, 6, 'no', '2025-01-10 10:55:14', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (282, 275, 6, 'no', '2025-01-10 10:58:38', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (283, 276, 6, 'no', '2025-01-10 10:58:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (284, 277, 6, 'no', '2025-01-10 10:59:20', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (285, 278, 6, 'no', '2025-01-10 10:59:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (286, 279, 6, 'no', '2025-01-10 10:59:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (287, 280, 5, 'no', '2025-01-10 11:01:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (288, 281, 5, 'no', '2025-01-10 11:01:11', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (289, 282, 5, 'no', '2025-01-10 11:01:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (290, 283, 5, 'no', '2025-01-10 11:01:30', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (291, 284, 5, 'no', '2025-01-10 11:01:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (292, 285, 5, 'no', '2025-01-10 11:01:52', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (293, 286, 5, 'no', '2025-01-10 11:02:04', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (294, 287, 5, 'no', '2025-01-10 11:02:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (295, 288, 5, 'no', '2025-01-10 11:03:05', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (296, 289, 5, 'no', '2025-01-10 11:03:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (297, 290, 5, 'no', '2025-01-10 11:03:37', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (298, 291, 5, 'no', '2025-01-10 11:03:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (299, 292, 6, 'no', '2025-01-10 11:04:38', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (300, 293, 6, 'no', '2025-01-10 11:04:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (301, 294, 6, 'no', '2025-01-10 11:04:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (302, 295, 4, 'no', '2025-01-10 11:13:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (303, 296, 5, 'no', '2025-01-11 04:55:00', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (304, 297, 5, 'no', '2025-01-11 04:55:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (305, 298, 5, 'no', '2025-01-11 04:55:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (306, 299, 5, 'no', '2025-01-11 04:55:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (307, 300, 5, 'no', '2025-01-11 04:55:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (308, 301, 5, 'no', '2025-01-11 04:55:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (309, 302, 5, 'no', '2025-01-11 04:56:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (310, 303, 4, 'no', '2025-01-11 04:56:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (311, 304, 4, 'no', '2025-01-11 04:57:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (312, 305, 4, 'no', '2025-01-11 04:57:19', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (313, 306, 9, 'no', '2025-01-11 04:57:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (314, 307, 4, 'no', '2025-01-11 04:58:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (315, 308, 8, 'no', '2025-01-11 04:58:29', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (316, 309, 6, 'no', '2025-01-11 04:58:48', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (317, 310, 4, 'no', '2025-01-11 04:59:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (318, 311, 4, 'no', '2025-01-11 04:59:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (319, 312, 6, 'no', '2025-01-11 05:01:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (320, 313, 6, 'no', '2025-01-11 05:02:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (321, 314, 6, 'no', '2025-01-11 05:02:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (322, 315, 6, 'no', '2025-01-11 05:02:39', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (323, 316, 6, 'no', '2025-01-11 05:02:57', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (324, 317, 6, 'no', '2025-01-11 05:03:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (325, 318, 6, 'no', '2025-01-11 05:03:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (326, 319, 5, 'no', '2025-01-11 05:11:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (327, 320, 5, 'no', '2025-01-11 05:11:45', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (328, 321, 5, 'no', '2025-01-11 05:11:54', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (329, 322, 5, 'no', '2025-01-11 05:24:36', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (330, 323, 5, 'no', '2025-01-11 05:25:05', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (331, 324, 5, 'no', '2025-01-11 05:26:16', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (332, 325, 13, 'no', '2025-01-11 06:18:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (333, 326, 6, 'no', '2025-01-13 08:54:23', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (334, 327, 6, 'no', '2025-01-13 08:54:35', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (335, 328, 6, 'no', '2025-01-13 08:54:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (336, 329, 6, 'no', '2025-01-13 08:54:58', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (337, 330, 6, 'no', '2025-01-13 08:55:15', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (338, 331, 13, 'no', '2025-01-13 09:05:07', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (339, 332, 13, 'no', '2025-01-13 09:05:18', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (340, 333, 13, 'no', '2025-01-13 09:05:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (341, 334, 13, 'no', '2025-01-13 09:05:34', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (342, 335, 13, 'no', '2025-01-13 09:05:44', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (343, 336, 11, 'no', '2025-01-13 09:13:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (344, 337, 11, 'no', '2025-01-13 09:13:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (345, 338, 11, 'no', '2025-01-13 09:14:01', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (346, 339, 11, 'no', '2025-01-13 09:14:10', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (347, 340, 11, 'no', '2025-01-13 09:14:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (348, 341, 5, 'no', '2025-01-13 09:31:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (349, 342, 5, 'no', '2025-01-13 09:31:42', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (350, 343, 5, 'no', '2025-01-13 09:31:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (351, 344, 5, 'no', '2025-01-13 09:32:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (352, 345, 5, 'no', '2025-01-13 09:32:26', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (353, 346, 5, 'no', '2025-01-13 09:32:41', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (354, 347, 5, 'no', '2025-01-13 09:32:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (355, 348, 4, 'no', '2025-01-13 09:39:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (356, 349, 4, 'no', '2025-01-13 09:39:55', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (357, 350, 4, 'no', '2025-01-13 09:40:05', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (358, 351, 5, 'no', '2025-01-14 02:57:43', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (359, 352, 5, 'no', '2025-01-14 02:58:06', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (360, 353, 5, 'no', '2025-01-14 02:58:17', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (361, 354, 5, 'no', '2025-01-14 02:58:27', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (362, 355, 5, 'no', '2025-01-14 02:58:40', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (363, 356, 8, 'no', '2025-01-15 04:31:03', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (364, 357, 8, 'no', '2025-01-15 04:31:47', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (365, 358, 14, 'no', '2025-01-27 06:09:28', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (366, 359, 6, 'no', '2025-02-28 08:28:15', NULL);


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `class_teacher_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_4` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=360 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'BANKING AND FINANCE LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 03:26:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'ICT TECHNICIAN LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 03:34:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'ICT TECHNICIAN LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 03:34:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'ICT TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 03:30:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'ICT TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 03:32:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'ICT TECHNICIAN LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 03:33:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'ICT TECHNICIAN LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 03:33:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'ICT TECHNICIAN LEVEL 5 YEAR 1 SEMESTER1', 'no', '2025-01-10 01:47:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'ICT TECHNICIAN LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 01:51:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'ICT TECHNICIAN LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 03:35:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'ICT TECHNICIAN LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 03:36:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'ICT TECHNICIAN LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 03:36:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'BANKING AND FINANCE LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 03:36:52', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'BANKING AND FINANCE LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 03:37:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'BANKING AND FINANCE LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 03:37:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'BANKING AND FINANCE LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 03:37:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'BANKING AND FINANCE LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 03:38:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'BANKING AND FINANCE LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 03:39:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'CERTIFICATE IN BUILDING TECHNOLOGY YEAR 1 SEMESTER 1', 'no', '2025-01-10 03:41:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'CERTIFICATE IN BUILDING TECHNOLOGY YEAR 1 SEMESTER 2', 'no', '2025-01-10 03:41:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'CERTIFICATE IN BUILDING TECHNOLOGY YEAR 1 SEMESTER 3', 'no', '2025-01-10 03:41:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'CERTIFICATE IN BUILDING TECHNOLOGY YEAR 2 SEMESTER 1', 'no', '2025-01-10 03:42:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'CERTIFICATE IN BUILDING TECHNOLOGY YEAR  2B SEMESTER 2', 'no', '2025-01-10 03:45:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'DIPLOMA IN CIVIL ENGINEERING YEAR 1 SEMESTER 1', 'no', '2025-01-10 03:43:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'DIPLOMA IN CIVIL ENGINEERING YEAR 1 SEMESTER 2', 'no', '2025-01-10 03:43:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'DIPLOMA IN CIVIL ENGINEERING YEAR 1 SEMESTER 3', 'no', '2025-01-10 03:43:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'DIPLOMA IN CIVIL ENGINEERING YEAR 2 SEMESTER 1', 'no', '2025-01-10 03:43:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'DIPLOMA IN CIVIL ENGINEERING YEAR 2 SEMESTER 2', 'no', '2025-01-10 03:44:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'DIPLOMA IN CIVIL ENGINEERING YEAR 3 SEMESTER 1', 'no', '2025-01-10 03:44:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'DIPLOMA IN CIVIL ENGINEERING YEAR 3 SEMESTER  2', 'no', '2025-01-10 03:44:38', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'PLUMBING LEVEL 4 YEAR 1SEMESTER 1', 'no', '2025-01-10 06:20:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'PLUMBING LEVEL 4 YEAR 1SEMESTER 2', 'no', '2025-01-10 06:21:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'PLUMBING LEVEL 4 YEAR 1SEMESTER 3', 'no', '2025-01-10 06:21:13', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'PLUMBING LEVEL 5 YEAR 1SEMESTER 1', 'no', '2025-01-10 06:21:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'PLUMBING LEVEL 5 YEAR 1SEMESTER 2', 'no', '2025-01-10 06:21:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'PLUMBING LEVEL 5 YEAR 1SEMESTER 3', 'no', '2025-01-10 06:22:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'PLUMBING LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 06:22:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'PLUMBING LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 06:22:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'PLUMBING LEVEL 6 YEAR 1SEMESTER 1', 'no', '2025-01-10 06:23:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'PLUMBING LEVEL 6 YEAR 1SEMESTER 2', 'no', '2025-01-10 06:23:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'PLUMBING LEVEL 6 YEAR 1SEMESTER 3', 'no', '2025-01-10 06:23:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'PLUMBING LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 06:23:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'PLUMBING LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 06:23:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'PLUMBING LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 06:24:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'PLUMBING LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 06:24:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 1SEMESTER 1', 'no', '2025-01-10 06:26:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 1SEMESTER 2', 'no', '2025-01-10 06:26:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 1SEMESTER 3', 'no', '2025-01-10 06:26:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 06:26:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 06:27:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 06:27:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 06:27:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 5 YEAR 1SEMESTER 1', 'no', '2025-01-10 06:27:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 5 YEAR 1SEMESTER 2', 'no', '2025-01-10 06:28:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 06:29:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 06:29:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:01:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:01:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:01:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:02:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:02:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:02:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:03:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'CERTIFICATE IN AUTOMOTIVE ENGINEERING YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:03:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:04:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:04:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:05:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:05:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:05:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 08:05:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'ELECTRICAL INSTALLATION LEVEL 6 YEAR 3 SEMESTER 3', 'no', '2025-01-10 08:06:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'ELECTRICAL INSTALLATION LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:06:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'ELECTRICAL INSTALLATION LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:06:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'ELECTRICAL INSTALLATION LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:06:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'ELECTRICAL INSTALLATION LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:07:10', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'ELECTRICAL INSTALLATION LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:07:31', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'ELECTRICAL INSTALLATION LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:07:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'ELECTRICAL INSTALLATION LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:08:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'ELECTRICAL INSTALLATION LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:08:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'CERTIFICATE IN ELECTRICAL ENGINEERING YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:09:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'CERTIFICATE IN ELECTRICAL ENGINEERING YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:09:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'CERTIFICATE IN ELECTRICAL ENGINEERING YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:09:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'CERTIFICATE IN ELECTRICAL ENGINEERING YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:10:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'CERTIFICATE IN ELECTRICAL ENGINEERING YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:10:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:11:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:11:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:11:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:12:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:12:13', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 08:12:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'AGRICULTURAL EXTENSION LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 08:12:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'AGRICULTURAL EXTENSION LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:13:10', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'AGRICULTURAL EXTENSION LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:13:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'AGRICULTURAL EXTENSION LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:13:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'AGRICULTURAL EXTENSION LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:13:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'AGRICULTURAL EXTENSION LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:14:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'AGRICULTURAL EXTENSION LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:14:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'AGRICULTURAL EXTENSION LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:14:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'AGRICULTURAL EXTENSION LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:14:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'SUSTAINABLE AGRICULTURE FOR RURAL DEVELOPMENT YEAR 1 SEM 1', 'no', '2025-01-10 08:16:53', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'SUSTAINABLE AGRICULTURE FOR RURAL DEVELOPMENT YEAR 1 SEM 2', 'no', '2025-01-10 08:17:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'SUSTAINABLE AGRICULTURE FOR RURAL DEVELOPMENT YEAR 1 SEM 3', 'no', '2025-01-10 08:17:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'SUSTAINABLE AGRICULTURE FOR RURAL DEVELOPMENT YEAR 2 SEM 1', 'no', '2025-01-10 08:19:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'SUSTAINABLE AGRICULTURE FOR RURAL DEVELOPMENT YEAR 2 SEM 2', 'no', '2025-01-10 08:19:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'FOOD AND BEVERAGE LEVEL 4 SALES AND SERVICE YEAR 1 SEM 3', 'no', '2025-01-10 08:34:44', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'FOOD AND BEVERAGE LEVEL 4 SALES AND SERVICE YEAR 1 SEM 2', 'no', '2025-01-10 08:34:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'FOOD AND BEVERAGE LEVEL 4 SALES AND SERVICE YEAR 1 SEM 1', 'no', '2025-01-10 08:34:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'FOOD AND BEVERAGE LEVEL 5 SALES AND SERVICE YEAR 1 SEM 1', 'no', '2025-01-10 08:35:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'FOOD AND BEVERAGE LEVEL 5 SALES AND SERVICE YEAR 1 SEM 2', 'no', '2025-01-10 08:35:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'FOOD AND BEVERAGE LEVEL 5 SALES AND SERVICE YEAR 1 SEM 3', 'no', '2025-01-10 08:35:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'FOOD AND BEVERAGE LEVEL 5 SALES AND SERVICE YEAR 2 SEM 1', 'no', '2025-01-10 08:35:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'FOOD AND BEVERAGE LEVEL 5 SALES AND SERVICE YEAR 2 SEM 2', 'no', '2025-01-10 08:36:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 1 SEM 1', 'no', '2025-01-10 08:36:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 1 SEM 2', 'no', '2025-01-10 08:36:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 1 SEM 3', 'no', '2025-01-10 08:36:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 2 SEM 1', 'no', '2025-01-10 08:37:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 2 SEM 2', 'no', '2025-01-10 08:37:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 3 SEM 1', 'no', '2025-01-10 08:37:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'FOOD AND BEVERAGE LEVEL 6 SALES AND SERVICE YEAR 3 SEM 2', 'no', '2025-01-10 08:37:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'FOOD TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:38:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'FOOD TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:38:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'FOOD TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:38:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'FOOD TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:44:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'FOOD TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:44:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'FOOD TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:44:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'FOOD TECHNOLOGY LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:44:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'FOOD TECHNOLOGY LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:44:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'FOOD TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:45:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'FOOD TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:45:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'FOOD TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 08:46:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'FOOD TECHNOLOGY LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 08:46:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'FOOD TECHNOLOGY LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 08:46:28', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'FOOD TECHNOLOGY LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 08:46:38', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'FOOD TECHNOLOGY LEVEL 6 YEAR 3 SEMESTER 3', 'no', '2025-01-10 08:46:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'FOOD PRODUCTION LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 08:48:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'FOOD PRODUCTION LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 08:49:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'FOOD PRODUCTION LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:00:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'FOOD PRODUCTION LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:00:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'FOOD PRODUCTION LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:01:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'FOOD PRODUCTION LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:01:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'FOOD PRODUCTION LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:01:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'FOOD PRODUCTION LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:02:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'FOOD PRODUCTION LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:02:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'FOOD PRODUCTION LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:02:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'FOOD PRODUCTION LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:02:52', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'FOOD PRODUCTION LEVEL 4YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:03:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'FOOD PRODUCTION LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:04:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'FOOD PRODUCTION LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:04:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'FOOD AND BEVERAGE SERVICES LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:04:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'FOOD AND BEVERAGE SERVICES LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:05:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'FOOD AND BEVERAGE SERVICES LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:05:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'FOOD AND BEVERAGE SERVICES LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:05:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'FOOD AND BEVERAGE SERVICES LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:05:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'FOOD AND BEVERAGE SERVICES LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:05:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'FOOD AND BEVERAGE SERVICES LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:06:02', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'FOOD AND BEVERAGE SERVICES LEVEL 5 YEAR 2 SEMESTER 2 ', 'no', '2025-01-10 09:07:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:08:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (158, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:08:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:08:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:09:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:10:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:10:31', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'FOOD AND BEVERAGE SERVICES LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:10:52', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'BAKING TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:11:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'BAKING TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:11:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'BAKING TECHNOLOGY LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:11:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'BAKING TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:12:13', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'BAKING TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:12:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'BAKING TECHNOLOGY LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:12:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'BAKING TECHNOLOGY LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:13:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'BAKING TECHNOLOGY LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:13:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'BAKING TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:14:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'BAKING TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:15:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'BAKING TECHNOLOGY LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:15:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'BAKING TECHNOLOGY LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:15:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'BAKING TECHNOLOGY LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:18:33', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'BAKING TECHNOLOGY LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:23:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'BAKING TECHNOLOGY LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:24:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'HAIR AND BEAUTY THERAPHY YEAR 1 SEMESTER 1 NITA', 'no', '2025-01-10 09:32:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (180, 'HAIR AND BEAUTY THERAPHY YEAR 1 SEMESTER 2 NITA', 'no', '2025-01-10 09:32:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (181, 'HAIR AND BEAUTY THERAPHY YEAR 1 SEMESTER 3 NITA', 'no', '2025-01-10 09:31:53', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (182, 'HAIR AND BEAUTY THERAPHY YEAR 2 SEMESTER 1 NITA', 'no', '2025-01-10 09:31:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (183, 'HAIR AND BEAUTY THERAPHY YEAR 2 SEMESTER 2 NITA', 'no', '2025-01-10 09:31:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (184, 'HAIR AND BEAUTY THERAPHY YEAR 3 SEMESTER 1 NITA', 'no', '2025-01-10 09:31:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (185, 'FOOD AND BEVERAGE YEAR 1SEMESTER 1 NITA', 'no', '2025-01-10 09:29:31', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (186, 'FOOD AND BEVERAGE YEAR 1SEMESTER 2 NITA', 'no', '2025-01-10 09:29:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (187, 'FOOD AND BEVERAGE YEAR 1SEMESTER 3 NITA', 'no', '2025-01-10 09:29:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (188, 'FOOD AND BEVERAGE YEAR 2 SEMESTER 1 NITA', 'no', '2025-01-10 09:30:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (189, 'FOOD AND BEVERAGE YEAR 2 SEMESTER 2 NITA', 'no', '2025-01-10 09:30:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (190, 'FOOD AND BEVERAGE YEAR 3 SEMESTER 1 NITA', 'no', '2025-01-10 09:30:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (191, 'BEAUTY THERAPY  LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:33:21', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (192, 'BEAUTY THERAPY  LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:33:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (193, 'BEAUTY THERAPY  LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:33:46', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (194, 'BEAUTY THERAPY  LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:34:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (195, 'BEAUTY THERAPY  LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:34:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (196, 'BEAUTY THERAPY  LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:34:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (197, 'BEAUTY THERAPY  LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:35:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (198, 'BEAUTY THERAPY  LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:35:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (199, 'BEAUTY THERAPY  LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:35:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (200, 'BEAUTY THERAPY  LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:36:02', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (201, 'BEAUTY THERAPY  LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:36:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (202, 'BEAUTY THERAPY  LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:36:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (203, 'BEAUTY THERAPY  LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:36:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (204, 'BEAUTY THERAPY  LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:37:18', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (205, 'BEAUTY THERAPY  LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:37:28', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (206, 'HAIRDRESSING  LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:38:49', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (207, 'HAIRDRESSING LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:39:01', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (208, 'HAIRDRESSING LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:39:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (209, 'HAIRDRESSING LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:39:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (210, 'HAIRDRESSING LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:40:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (211, 'HAIRDRESSING LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:42:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (212, 'HAIRDRESSING LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:43:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (213, 'HAIRDRESSING LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:43:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (214, 'HAIRDRESSING LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:44:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (215, 'HAIRDRESSING LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:44:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (216, 'HAIRDRESSING LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:44:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (217, 'HAIRDRESSING LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:44:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (218, 'HAIRDRESSING LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:44:34', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (219, 'HAIRDRESSING LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:44:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (220, 'HAIRDRESSING LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:45:10', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (221, 'FASHION DESIGN LEVEL 4 YEAR 1SEMESTER 1', 'no', '2025-01-10 09:45:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (222, 'FASHION DESIGN LEVEL 4 YEAR 1SEMESTER 2', 'no', '2025-01-10 09:45:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (223, 'FASHION DESIGN LEVEL 4 YEAR 1SEMESTER 3', 'no', '2025-01-10 09:46:12', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (224, 'FASHION DESIGN LEVEL 5 YEAR 1SEMESTER 1', 'no', '2025-01-10 09:46:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (225, 'FASHION DESIGN LEVEL 5 YEAR 1SEMESTER 2', 'no', '2025-01-10 09:46:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (226, 'FASHION DESIGN LEVEL 5 YEAR 1SEMESTER 3', 'no', '2025-01-10 09:46:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (227, 'FASHION DESIGN LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:47:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (228, 'FASHION DESIGN LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:47:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (229, 'FASHION DESIGN LEVEL 6 YEAR 1SEMESTER 1', 'no', '2025-01-10 09:48:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (230, 'FASHION DESIGN LEVEL 6 YEAR 1SEMESTER 2', 'no', '2025-01-10 09:48:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (231, 'FASHION DESIGN LEVEL 6 YEAR 1SEMESTER 3', 'no', '2025-01-10 09:48:28', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (232, 'FASHION DESIGN LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:48:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (233, 'FASHION DESIGN LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:49:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (234, 'FASHION DESIGN LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 09:51:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (235, 'FASHION DESIGN LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 09:51:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (236, 'FASHION DESIGN  YEAR 1SEMESTER 1 NITA', 'no', '2025-01-10 09:52:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (237, 'FASHION DESIGN  YEAR 1SEMESTER 2 NITA', 'no', '2025-01-10 09:52:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (238, 'FASHION DESIGN  YEAR 1SEMESTER 3 NITA', 'no', '2025-01-10 09:52:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (239, 'FASHION DESIGN  YEAR 2 SEMESTER 1 NITA', 'no', '2025-01-10 09:52:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (240, 'FASHION DESIGN  YEAR 2 SEMESTER 2 NITA', 'no', '2025-01-10 09:53:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (241, 'FASHION DESIGN  YEAR 3 SEMESTER 1 NITA', 'no', '2025-01-10 09:53:31', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (242, 'ICT TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:55:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (243, 'ICT TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:55:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (244, 'ICT TECHNICIAN LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:55:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (245, 'CERTIFICATE IN ICT YEAR 1 SEMESTER 1', 'no', '2025-01-10 09:57:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (246, 'CERTIFICATE IN ICT YEAR 1 SEMESTER 2', 'no', '2025-01-10 09:57:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (247, 'CERTIFICATE IN ICT YEAR 1 SEMESTER 3', 'no', '2025-01-10 09:57:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (248, 'CERTIFICATE IN ICT YEAR 2 SEMESTER 2', 'no', '2025-01-10 09:57:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (249, 'CERTIFICATE IN ICT YEAR 2 SEMESTER 1', 'no', '2025-01-10 09:57:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (250, 'DIPLOMA IN BANKING AND FINANCE YEAR 1 SEMESTER 1', 'no', '2025-01-10 10:36:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (251, 'DIPLOMA IN BANKING AND FINANCE YEAR 1 SEMESTER 2', 'no', '2025-01-10 10:36:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (252, 'DIPLOMA IN BANKING AND FINANCE YEAR 1 SEMESTER 3', 'no', '2025-01-10 10:36:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (253, 'DIPLOMA IN BANKING AND FINANCE YEAR 2 SEMESTER 2', 'no', '2025-01-10 10:37:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (254, 'DIPLOMA IN BANKING AND FINANCE YEAR 2 SEMESTER 1', 'no', '2025-01-10 10:37:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (255, 'DIPLOMA IN BANKING AND FINANCE YEAR 3 SEMESTER 1', 'no', '2025-01-10 10:37:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (256, 'DIPLOMA IN BANKING AND FINANCE YEAR 3 SEMESTER 2', 'no', '2025-01-10 10:38:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (257, 'OFFICE ADMINISTRATOR LEVEL 4 YEAR 1 SEMESTER  1', 'no', '2025-01-10 10:39:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (258, 'OFFICE ADMINISTRATOR LEVEL 4 YEAR 1 SEMESTER  2', 'no', '2025-01-10 10:39:50', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (259, 'OFFICE ADMINISTRATOR LEVEL 4 YEAR 1 SEMESTER  3', 'no', '2025-01-10 10:40:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (260, 'OFFICE ADMINISTRATOR LEVEL 5 YEAR 1 SEMESTER  1', 'no', '2025-01-10 10:40:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (261, 'OFFICE ADMINISTRATOR LEVEL 5 YEAR 1 SEMESTER  2', 'no', '2025-01-10 10:40:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (262, 'OFFICE ADMINISTRATOR LEVEL 5 YEAR 1 SEMESTER  3', 'no', '2025-01-10 10:41:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (263, 'OFFICE ADMINISTRATOR LEVEL 5 YEAR 2 SEMESTER  1', 'no', '2025-01-10 10:41:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (264, 'OFFICE ADMINISTRATOR LEVEL 5 YEAR 2 SEMESTER  2', 'no', '2025-01-10 10:41:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (265, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 1 SEMESTER  1', 'no', '2025-01-10 10:41:59', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (266, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 10:42:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (267, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 10:42:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (268, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 10:42:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (269, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 10:43:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (270, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 10:43:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (271, 'OFFICE ADMINISTRATOR LEVEL 6 YEAR 3 SEMESTER 3', 'no', '2025-01-10 10:43:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (272, 'CARPENTRY AND JOINERY  LEVEL 5 YEAR 1 SEMESTER 1 ', 'no', '2025-01-10 10:54:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (273, 'CARPENTRY AND JOINERY  LEVEL 5  YEAR 1 SEMESTER 2', 'no', '2025-01-10 10:58:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (274, 'CARPENTRY AND JOINERY LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 10:55:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (275, 'CARPENTRY AND JOINERY LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 10:58:38', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (276, 'CARPENTRY AND JOINERY LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 10:58:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (277, 'CARPENTRY AND JOINERY LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 10:59:20', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (278, 'CARPENTRY AND JOINERY LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 10:59:28', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (279, 'CARPENTRY AND JOINERY LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 10:59:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (280, 'MARKETING MANAGER    LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-10 11:01:02', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (281, 'MARKETING MANAGER    LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-10 11:01:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (282, 'MARKETING MANAGER    LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-10 11:01:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (283, 'MARKETING MANAGER    LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-10 11:01:30', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (284, 'MARKETING MANAGER    LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-10 11:01:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (285, 'MARKETING MANAGER    LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-10 11:01:52', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (286, 'MARKETING MANAGER    LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-10 11:02:04', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (287, 'MARKETING OFFICER   LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-10 11:02:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (288, 'MARKETING OFFICER   LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-10 11:03:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (289, 'MARKETING OFFICER   LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-10 11:03:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (290, 'MARKETING OFFICER   LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-10 11:03:37', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (291, 'MARKETING OFFICER   LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-10 11:03:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (292, 'MASONRY LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-10 11:04:38', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (293, 'MASONRY LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-10 11:04:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (294, 'MASONRY LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-10 11:04:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (295, 'COMPUTER PACKAGES', 'no', '2025-01-10 11:13:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (296, 'ACCOUNTANCY LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-11 04:55:00', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (297, 'ACCOUNTANCY LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-11 04:55:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (298, 'ACCOUNTANCY LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-11 04:55:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (299, 'ACCOUNTANCY LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-11 04:55:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (300, 'ACCOUNTANCY LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-11 04:55:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (301, 'ACCOUNTANCY LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-11 04:55:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (302, 'ACCOUNTANCY LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-11 04:56:07', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (303, 'COMPUTER AND MOBILE REPAIR LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-11 04:56:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (304, 'COMPUTER AND MOBILE REPAIR LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-11 04:57:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (305, 'COMPUTER AND MOBILE REPAIR LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-11 04:57:19', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (306, 'MOBILE PHONE REPAIR', 'no', '2025-01-11 04:57:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (307, 'PHOTOGRAPHY AND VIDEO EDITING', 'no', '2025-01-11 04:58:10', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (308, 'CAKE BAKING AND DECORATION', 'no', '2025-01-11 04:58:29', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (309, 'COMPUTER AIDED DESIGN AND DRAFTING', 'no', '2025-01-11 04:58:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (310, 'CCTV INSTALLATION AND MANAGEMENT', 'no', '2025-01-11 04:59:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (311, 'GRAPHIC DESIGN', 'no', '2025-01-11 04:59:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (312, 'QUANTITY SURVEYING LEVEL 6 YEAR 1 SEMESTER 1', 'no', '2025-01-11 05:01:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (313, 'QUANTITY SURVEYING LEVEL 6 YEAR 1 SEMESTER 2', 'no', '2025-01-11 05:02:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (314, 'QUANTITY SURVEYING LEVEL 6 YEAR 1 SEMESTER 3', 'no', '2025-01-11 05:02:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (315, 'QUANTITY SURVEYING LEVEL 6 YEAR 2 SEMESTER 1', 'no', '2025-01-11 05:02:39', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (316, 'QUANTITY SURVEYING LEVEL 6 YEAR 2 SEMESTER 2', 'no', '2025-01-11 05:02:57', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (317, 'QUANTITY SURVEYING LEVEL 6 YEAR 3 SEMESTER 1', 'no', '2025-01-11 05:03:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (318, 'QUANTITY SURVEYING LEVEL 6 YEAR 3 SEMESTER 2', 'no', '2025-01-11 05:03:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (319, 'Accounting Technicians Diploma (ATD) level 1', 'no', '2025-01-11 05:11:36', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (320, 'Accounting Technicians Diploma (ATD) level 2', 'no', '2025-01-11 05:11:45', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (321, 'Accounting Technicians Diploma (ATD) level 3', 'no', '2025-01-11 05:11:54', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (322, 'Certified Public Accountants (CPA) FOUNDATION LEVEL', 'no', '2025-01-11 05:25:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (323, 'Certified Public Accountants (CPA) INTERMEDIATE LEVEL', 'no', '2025-01-11 05:25:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (324, 'Certified Public Accountants (CPA) ADVANCED LEVEL', 'no', '2025-01-11 05:26:16', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (325, 'AUTOMOTIVE ENG TECHNICIAN LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-11 06:18:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (326, 'BUILDING TECHNICIAN LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-13 08:54:23', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (327, 'BUILDING TECHNICIAN LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-13 08:54:35', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (328, 'BUILDING TECHNICIAN LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-13 08:54:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (329, 'BUILDING TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-13 08:54:58', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (330, 'BUILDING TECHNICIAN LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-13 08:55:15', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (331, 'WELDING AND FAB LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-15 08:10:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (332, 'WELDING AND FAB LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-15 08:09:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (333, 'WELDING AND FAB LEVEL 4  YEAR 1 SEMESTER 3', 'no', '2025-01-15 08:09:24', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (334, 'WELDING AND FAB LEVEL 4  YEAR 2 SEMESTER 1', 'no', '2025-01-15 08:09:08', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (335, 'WELDING AND FAB  LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-13 09:07:13', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (336, 'AGRIPRENEURSHIP LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-15 07:15:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (337, 'SUSTAINABLE AGRICULTURE LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-26 06:26:48', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (338, 'AGRIPRENEURSHIPLEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-15 07:14:14', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (339, 'AGRIPRENEURSHIP LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-15 07:14:03', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (340, 'AGRIPRENEURSHIP LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-15 07:13:22', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (341, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 1 SEMESTER 1', 'no', '2025-01-13 09:31:32', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (342, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 1 SEMESTER 2', 'no', '2025-01-13 09:31:42', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (343, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 1 SEMESTER 3', 'no', '2025-01-13 09:31:51', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (344, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 2 SEMESTER 1', 'no', '2025-01-13 09:32:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (345, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 2 SEMESTER 2', 'no', '2025-01-13 09:32:26', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (346, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 3 SEMESTER 1', 'no', '2025-01-13 09:32:41', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (347, 'DIPLOMAIN PROJECT MANAGEMENT YEAR 3 SEMESTER 2', 'no', '2025-01-13 09:32:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (348, 'COMPUTER AND MOBILE PHONE R  LEVEL 4 YEAR 1 SEMESTER 1', 'no', '2025-01-13 09:39:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (349, 'COMPUTER AND MOBILE PHONE R LEVEL 4 YEAR 1 SEMESTER 2', 'no', '2025-01-13 09:39:55', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (350, 'COMPUTER AND MOBILE PHONE R LEVEL 4 YEAR 1 SEMESTER 3', 'no', '2025-01-13 09:40:05', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (351, 'BUSINESS MANAGEMENT LEVEL 5 YEAR 1 SEMESTER 1', 'no', '2025-01-14 02:57:43', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (352, 'BUSINESS MANAGEMENT LEVEL 5 YEAR 1 SEMESTER 2', 'no', '2025-01-14 02:58:06', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (353, 'BUSINESS MANAGEMENT LEVEL 5 YEAR 1 SEMESTER 3', 'no', '2025-01-14 02:58:17', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (354, 'BUSINESS MANAGEMENT LEVEL 5 YEAR 2 SEMESTER 1', 'no', '2025-01-14 02:58:27', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (355, 'BUSINESS MANAGEMENT LEVEL 5 YEAR 2 SEMESTER 2', 'no', '2025-01-14 02:58:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (356, 'CERTIFICATE IN CATERING YEAR 2 SEMESTER 1', 'no', '2025-01-15 04:31:40', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (357, 'CERTIFICATE IN CATERING YEAR 2 SEMESTER 2', 'no', '2025-01-15 04:31:47', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (358, 'INDUSTRIAL ATTACHMENT JANUARY-APRIL 2025', 'no', '2025-01-27 06:15:11', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (359, 'BUILDING TECHNICIAN LEVEL6 YEAR 1SEMESTER1', 'no', '2025-02-28 08:30:12', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(255) NOT NULL,
  `source` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, 'Academic', 'PUBLIC', 'ERICK', '', '', '2025-01-10', 'NOISE FROM THE CHRISTIAN UNION INSTRUMENTS', 'REDUCTION OF THE INSTRUMENTS VOLUMES', 'KEN', '', NULL);


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Academic', '', '2025-01-10 02:21:06');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (2, 'Finance', '', '2025-01-10 02:21:16');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (3, 'External', '', '2025-01-10 02:21:26');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (4, 'Environment', '', '2025-01-10 02:21:47');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (5, 'Security', '', '2025-01-10 02:21:56');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (6, 'Staff', '', '2025-01-10 02:22:06');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (7, 'Other', '', '2025-01-10 02:22:18');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) DEFAULT NULL,
  `file` varchar(250) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `class_id` (`class_id`),
  KEY `cls_sec_id` (`cls_sec_id`),
  CONSTRAINT `contents_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_3` FOREIGN KEY (`cls_sec_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `base_price` varchar(10) NOT NULL DEFAULT '1',
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (1, 'AED', 'AED', 'AEDf', '1', 0, '2022-12-30 01:19:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (2, 'AFN', 'AFN', '؋', '1', 0, '2022-12-30 01:19:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (3, 'ALL', 'ALL', 'ALL', '1', 0, '2022-12-30 01:19:22');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (4, 'AMD', 'AMD', 'AMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (5, 'ANG', 'ANG', 'ANG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (6, 'AOA', 'AOA', 'AOA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (7, 'ARS', 'ARS', 'ARS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (8, 'AUD', 'AUD', 'AUD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (9, 'AWG', 'AWG', 'AWG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (10, 'AZN', 'AZN', 'AZN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (11, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (12, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (13, 'BDT', 'BDT', 'BDT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (14, 'BGN', 'BGN', 'BGN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (15, 'BHD', 'BHD', 'BHD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (16, 'BIF', 'BIF', 'BIF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (17, 'BMD', 'BMD', 'BMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (18, 'BND', 'BND', 'BND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (19, 'BOB', 'BOB', 'BOB', '1', 0, '2022-12-30 01:19:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (20, 'BOV', 'BOV', 'BOV', '1', 0, '2022-12-30 01:19:38');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (21, 'BRL', 'BRL', 'BRL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (22, 'BSD', 'BSD', 'BSD', '1', 0, '2022-12-30 01:19:40');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (23, 'BTN', 'BTN', 'BTN', '1', 0, '2022-12-30 01:19:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (24, 'BWP', 'BWP', 'BWP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (25, 'BYN', 'BYN', 'BYN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (26, 'BYR', 'BYR', 'BYR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (27, 'BZD', 'BZD', 'BZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (28, 'CAD', 'CAD', 'CAD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (29, 'CDF', 'CDF', 'CDF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (30, 'CHE', 'CHE', 'CHE', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (31, 'CHF', 'CHF', 'CHF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (32, 'CHW', 'CHW', 'CHW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (33, 'CLF', 'CLF', 'CLF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (34, 'CLP', 'CLP', 'CLP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (35, 'CNY', 'CNY', 'CNY', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (36, 'COP', 'COP', 'COP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (37, 'COU', 'COU', 'COU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (38, 'CRC', 'CRC', 'CRC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (39, 'CUC', 'CUC', 'CUC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (40, 'CUP', 'CUP', 'CUP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (41, 'CVE', 'CVE', 'CVE', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (42, 'CZK', 'CZK', 'CZK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (43, 'DJF', 'DJF', 'DJF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (44, 'DKK', 'DKK', 'DKK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (45, 'DOP', 'DOP', 'DOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (46, 'DZD', 'DZD', 'DZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (47, 'EGP', 'EGP', 'EGP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (48, 'ERN', 'ERN', 'ERN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (49, 'ETB', 'ETB', 'ETB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (50, 'EUR', 'EUR', '€', '1', 0, '2022-12-30 01:20:25');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (51, 'FJD', 'FJD', 'FJD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (52, 'FKP', 'FKP', 'FKP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (53, 'GBP', 'GBP', '£', '1', 0, '2022-12-30 01:20:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (54, 'GEL', 'GEL', 'GEL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (55, 'GHS', 'GHS', 'GHS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (56, 'GIP', 'GIP', 'GIP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (57, 'GMD', 'GMD', 'GMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (58, 'GNF', 'GNF', 'GNF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (59, 'GTQ', 'GTQ', 'GTQ', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (60, 'GYD', 'GYD', 'GYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (61, 'HKD', 'HKD', 'HKD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (62, 'HNL', 'HNL', 'HNL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (63, 'HRK', 'HRK', 'HRK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (64, 'HTG', 'HTG', 'HTG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (65, 'HUF', 'HUF', 'HUF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (66, 'IDR', 'IDR', 'IDR', '1', 0, '2022-12-30 01:20:34');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (67, 'ILS', 'ILS', 'ILS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (68, 'INR', 'INR', '₹', '1', 0, '2022-12-30 01:20:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (69, 'IQD', 'IQD', 'IQD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (70, 'IRR', 'IRR', 'IRR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (71, 'ISK', 'ISK', 'ISK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (72, 'JMD', 'JMD', 'JMD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (73, 'JOD', 'JOD', 'JOD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (74, 'JPY', 'JPY', 'JPY', '1', 0, '2022-12-30 01:19:56');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (75, 'KES', 'KES', 'KES', '1', 1, '2025-01-09 06:19:03');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (76, 'KGS', 'KGS', 'KGS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (77, 'KHR', 'KHR', 'KHR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (78, 'KMF', 'KMF', 'KMF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (79, 'KPW', 'KPW', 'KPW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (80, 'KRW', 'KRW', 'KRW', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (81, 'KWD', 'KWD', 'KWD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (82, 'KYD', 'KYD', 'KYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (83, 'KZT', 'KZT', 'KZT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (84, 'LAK', 'LAK', 'LAK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (85, 'LBP', 'LBP', 'LBP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (86, 'LKR', 'LKR', 'LKR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (87, 'LRD', 'LRD', 'LRD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (88, 'LSL', 'LSL', 'LSL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (89, 'LYD', 'LYD', 'LYD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (90, 'MAD', 'MAD', 'MAD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (91, 'MDL', 'MDL', 'MDL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (92, 'MGA', 'MGA', 'MGA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (93, 'MKD', 'MKD', 'MKD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (94, 'MMK', 'MMK', 'MMK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (95, 'MNT', 'MNT', 'MNT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (96, 'MOP', 'MOP', 'MOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (97, 'MRO', 'MRO', 'MRO', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (98, 'MUR', 'MUR', 'MUR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (99, 'MVR', 'MVR', 'MVR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (100, 'MWK', 'MWK', 'MWK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (101, 'MXN', 'MXN', 'MXN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (102, 'MXV', 'MXV', 'MXV', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (103, 'MYR', 'MYR', 'MYR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (104, 'MZN', 'MZN', 'MZN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (105, 'NAD', 'NAD', 'NAD', '1', 0, '2022-07-30 05:32:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (106, 'NGN', 'NGN', 'NGN', '1', 0, '2022-12-30 01:20:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (107, 'NIO', 'NIO', 'NIO', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (108, 'NOK', 'NOK', 'NOK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (109, 'NPR', 'NPR', 'NPR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (110, 'NZD', 'NZD', 'NZD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (111, 'OMR', 'OMR', 'OMR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (112, 'PAB', 'PAB', 'PAB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (113, 'PEN', 'PEN', 'PEN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (114, 'PGK', 'PGK', 'PGK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (115, 'PHP', 'PHP', 'PHP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (116, 'PKR', 'PKR', 'PKR', '1', 0, '2022-12-30 01:20:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (117, 'PLN', 'PLN', 'PLN', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (118, 'PYG', 'PYG', 'PYG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (119, 'QAR', 'QAR', 'QAR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (120, 'RON', 'RON', 'RON', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (121, 'RSD', 'RSD', 'RSD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (122, 'RUB', 'RUB', 'RUB', '1', 0, '2022-12-30 01:20:16');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (123, 'RWF', 'RWF', 'RWF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (124, 'SAR', 'SAR', 'SAR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (125, 'SBD', 'SBD', 'SBD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (126, 'SCR', 'SCR', 'SCR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (127, 'SDG', 'SDG', 'SDG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (128, 'SEK', 'SEK', 'SEK', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (129, 'SGD', 'SGD', 'SGD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (130, 'SHP', 'SHP', 'SHP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (131, 'SLL', 'SLL', 'SLL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (132, 'SOS', 'SOS', 'SOS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (133, 'SRD', 'SRD', 'SRD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (134, 'SSP', 'SSP', 'SSP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (135, 'STD', 'STD', 'STD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (136, 'SVC', 'SVC', 'SVC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (137, 'SYP', 'SYP', 'SYP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (138, 'SZL', 'SZL', 'SZL', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (139, 'THB', 'THB', 'THB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (140, 'TJS', 'TJS', 'TJS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (141, 'TMT', 'TMT', 'TMT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (142, 'TND', 'TND', 'TND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (143, 'TOP', 'TOP', 'TOP', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (144, 'TRY', 'TRY', 'TRY', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (145, 'TTD', 'TTD', 'TTD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (146, 'TWD', 'TWD', 'TWD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (147, 'TZS', 'TZS', 'TZS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (148, 'UAH', 'UAH', 'UAH', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (149, 'UGX', 'UGX', 'UGX', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (150, 'USD', 'USD', '$', '1', 1, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (151, 'USN', 'USN', 'USN', '1', 0, '2022-12-30 01:20:03');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (152, 'UYI', 'UYI', 'UYI', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (153, 'UYU', 'UYU', 'UYU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (154, 'UZS', 'UZS', 'UZS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (155, 'VEF', 'VEF', 'VEF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (156, 'VND', 'VND', 'VND', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (157, 'VUV', 'VUV', 'VUV', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (158, 'WST', 'WST', 'WST', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (159, 'XAF', 'XAF', 'XAF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (160, 'XAG', 'XAG', 'XAG', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (161, 'XAU', 'XAU', 'XAU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (162, 'XBA', 'XBA', 'XBA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (163, 'XBB', 'XBB', 'XBB', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (164, 'XBC', 'XBC', 'XBC', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (165, 'XBD', 'XBD', 'XBD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (166, 'XCD', 'XCD', 'XCD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (167, 'XDR', 'XDR', 'XDR', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (168, 'XOF', 'XOF', 'XOF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (169, 'XPD', 'XPD', 'XPD', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (170, 'XPF', 'XPF', 'XPF', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (171, 'XPT', 'XPT', 'XPT', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (172, 'XSU', 'XSU', 'XSU', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (173, 'XTS', 'XTS', 'XTS', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (174, 'XUA', 'XUA', 'XUA', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (175, 'XXX', 'XXX', 'XXX', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (176, 'YER', 'YER', 'YER', '1', 0, '2022-07-22 06:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (177, 'ZAR', 'ZAR', 'ZAR', '1', 0, '2022-12-30 01:20:07');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (178, 'ZMW', 'ZMW', 'ZMW', '1', 0, '2022-07-30 03:34:00');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (179, 'ZWL', 'ZWL', 'ZWL', '1', 0, '2022-07-22 06:55:15');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` text DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_belong_to` (`belong_to`),
  KEY `idx_type` (`type`),
  KEY `idx_visible_on_table` (`visible_on_table`),
  KEY `idx_weight` (`weight`),
  FULLTEXT KEY `idx_field_values` (`field_values`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: daily_assignment
#

DROP TABLE IF EXISTS `daily_assignment`;

CREATE TABLE `daily_assignment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `evaluation_date` date DEFAULT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  CONSTRAINT `daily_assignment_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_2` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_3` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'ADMINISTRATION', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'FINANCE', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'SECURITY', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (4, 'SUPPORT ', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (5, 'ACADEMIC', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (6, 'HOSTEL', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (7, 'ICT', 'yes');


#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: email_attachments
#

DROP TABLE IF EXISTS `email_attachments`;

CREATE TABLE `email_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `directory` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `attachment_name` varchar(200) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `api_key`, `api_secret`, `region`, `is_active`, `created_at`) VALUES (1, 'sendmail', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, 'yes', '2020-02-28 08:46:03');


#
# TABLE STRUCTURE FOR: email_template
#

DROP TABLE IF EXISTS `email_template`;

CREATE TABLE `email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: email_template_attachment
#

DROP TABLE IF EXISTS `email_template_attachment`;

CREATE TABLE `email_template_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_template_id` int(11) NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `attachment_name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` text NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `assigned` (`assigned`),
  KEY `enquiry_ibfk_4` (`class_id`),
  CONSTRAINT `enquiry_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_3` FOREIGN KEY (`assigned`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_4` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (2, 'mary kinanu', '0711617763', '', '', '2025-01-11', 'course not selected', '2025-01-30', '', 'PERSONAL', '', 6, 123, '', 'active', 6, '2025-01-11 03:48:01');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (3, 'matidah gakii mugambi', '0712833217', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 9, '', 'active', 6, '2025-01-11 03:52:19');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (4, 'jane mbae', '0726323992', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 03:54:20');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (5, 'kelvin mwenda', '0736400322', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', NULL, 44, '', 'active', 6, '2025-01-11 04:20:30');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (6, 'Dickson Mwangi', '0700905700', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 77, '', 'active', 6, '2025-01-11 04:23:06');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (7, 'peninah kimene', '0714783492', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 164, '', 'active', 6, '2025-01-11 04:25:16');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (8, 'peninah chebet', '0719676424', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 167, '', 'active', 6, '2025-01-11 04:56:45');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (9, 'hellen kanana', '0710288873', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 38, '', 'active', 6, '2025-01-11 05:12:37');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (10, 'martin riungu', '0754318630', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 05:13:57');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (11, 'kenneth mutethia', '0745383720', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 309, '', 'active', 6, '2025-01-11 05:15:16');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (12, 'betty', '0743312204', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 10, '', 'active', 6, '2025-01-11 05:16:31');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (13, 'emmy kathure', '0705906887', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 05:17:36');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (14, 'moreen makena', '0704963348', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 194, '', 'active', 6, '2025-01-11 05:22:10');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (15, 'timothy muriuki', '0702780761', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 287, '', 'active', 6, '2025-01-11 05:24:31');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (16, 'sharon mukiri', '0796787644', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 182, '', 'active', 6, '2025-01-11 05:25:47');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (17, 'mugambi ashley', '0706687467', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 5, '', 'active', 6, '2025-01-11 05:31:52');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (18, 'dorcas mugambi', '0722499002', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 109, '', 'active', 6, '2025-01-11 05:32:54');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (19, 'titus murithi', '0723639785', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 68, '', 'active', 6, '2025-01-11 05:33:40');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (20, 'faith kanyiri', '0703238390', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 05:34:36');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (21, 'irene nabwoba', '0758461954', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 181, '', 'active', 6, '2025-01-11 05:35:51');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (22, 'sophy kainyu', '0113573998', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 05:37:06');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (23, 'peerline kangai', '0746622140', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 127, '', 'active', 6, '2025-01-11 05:38:23');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (24, 'joy gasheri', '0769800783', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 197, '', 'active', 6, '2025-01-11 05:39:55');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (25, 'anita wamuyu', '0114744423', '', '', '2025-01-11', '', '2025-03-06', '', 'PERSONAL', '', 6, 195, '', 'active', 6, '2025-01-11 05:40:53');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (26, 'ann makena', '0115729197', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 4, 108, '', 'active', 6, '2025-01-11 05:42:31');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (27, 'elosy kanana', '0115729197', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 182, '', 'active', 6, '2025-01-11 05:44:21');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (28, 'agnes muthoni', '0741539949', '', '', '2025-01-11', '', '2025-03-06', '', 'PERSONAL', '', 6, 180, '', 'active', 6, '2025-01-11 05:47:03');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (29, 'newton kimathi', '0758361856', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 277, '', 'active', 6, '2025-01-11 05:48:35');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (30, 'evans mutuma', '0793540053', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 38, '', 'active', 6, '2025-01-11 06:11:31');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (31, 'moreen karambu', '0741740445', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 181, '', 'active', 6, '2025-01-11 06:12:42');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (32, 'enedy gatwiri', '0792118156', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 198, '', 'active', 6, '2025-01-11 06:13:52');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (33, 'eric kithinji', '0739195113', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 310, '', 'active', 6, '2025-01-11 06:16:27');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (34, 'lisper kinya', '0798626733', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 96, '', 'active', 6, '2025-01-11 06:19:42');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (35, 'rhoda ndani', '0748871883', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 164, '', 'active', 6, '2025-01-11 06:22:21');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (36, 'joshua munene', '0769320832', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 80, '', 'active', 6, '2025-01-11 06:24:07');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (37, 'faith kanyiri', '0703232390', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 06:31:52');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (38, 'evaline gakii', '0115960790', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 194, '', 'active', 6, '2025-01-11 06:34:01');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (39, 'morris kiogora', '0740149754', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 81, '', 'active', 6, '2025-01-11 06:36:40');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (40, 'esther nyawira', '0706266353', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 191, '', 'active', 6, '2025-01-11 07:20:24');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (41, 'getrude nkatha', '0721758823', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 07:21:31');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (42, 'sebastian mutugi', '0711928748', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 07:24:12');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (43, 'dorothy kiambi', '0791062247', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 07:27:08');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (44, 'antony mugambi', '0704207300', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 31, '', 'active', 6, '2025-01-11 07:28:49');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (45, 'lewis bundi', '0111404012', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 94, '', 'active', 6, '2025-01-11 07:31:02');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (46, 'ruth makena', '0715019712', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 111, '', 'active', 6, '2025-01-11 07:32:13');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (47, 'susan mukami', '0746601110', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 194, '', 'active', 6, '2025-01-11 07:33:12');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (48, 'boniface mwiti', '0701318829', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 310, '', 'active', 6, '2025-01-11 07:34:26');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (49, 'edwin mugendi', '0798020757', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 257, '', 'active', 6, '2025-01-11 07:37:15');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (50, 'desy muthoni', '0703328493', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 8, '', 'active', 6, '2025-01-11 07:38:37');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (51, 'dennis m mwiti', '0111611977', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 36, '', 'active', 6, '2025-01-11 07:39:26');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (52, 'nelly makena', '0799817803', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 13, '', 'active', 6, '2025-01-11 07:40:47');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (53, 'doreen karambu', '0745976433', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 191, '', 'active', 6, '2025-01-11 07:41:42');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (54, 'elosy kanana', '0112011047', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 193, '', 'active', 6, '2025-01-11 07:42:28');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (55, 'patrick njue', '0790570692', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 312, '', 'active', 6, '2025-01-11 07:49:02');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (56, 'gregory koome', '0708255333', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 33, '', 'active', 6, '2025-01-11 07:51:23');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (57, 'ann njeri maina', '0714788095', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 07:52:48');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (58, 'fridah kathure', '0729528242', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 126, '', 'active', 6, '2025-01-11 07:54:00');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (59, 'samuel mbugua', '0708198332', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 53, '', 'active', 6, '2025-01-11 07:54:58');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (60, 'sarah kianira', '0758768114', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 36, '', 'active', 6, '2025-01-11 07:55:53');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (61, 'brenda gatwiri', '0110953632', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 262, '', 'active', 6, '2025-01-11 07:59:21');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (62, 'danson gitonga', '0741811295', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 17, '', 'active', 6, '2025-01-11 08:01:19');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (63, 'betty kendi', '0740201262', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 306, '', 'active', 6, '2025-01-11 08:02:24');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (64, 'nicholus kiogora', '0702268991', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 08:03:29');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (65, 'linet kanana', '0703374315', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 195, '', 'active', 6, '2025-01-11 08:04:46');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (66, 'edward simiyu', '0742590415', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 246, '', 'active', 6, '2025-01-11 08:05:52');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (67, 'adam kinyua', '0721830161', '', '', '2025-01-11', '', '2025-02-06', '', 'PERSONAL', '', 6, 296, '', 'active', 6, '2025-01-11 08:06:47');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (68, 'ruth gakii', '0797952661', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 296, '', 'active', 6, '2025-01-11 08:08:45');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (69, 'doris gitonga', '0715254228', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 320, '', 'active', 6, '2025-01-11 08:09:59');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (70, 'lemmy murithi', '0714636828', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 64, '', 'active', 6, '2025-01-11 08:11:01');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (71, 'elosy kagendo', '0704566822', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 221, '', 'active', 6, '2025-01-11 08:11:49');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (72, 'grace kagendo ntoogo', '0715695524', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 13, '', 'active', 6, '2025-01-11 08:13:02');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (73, 'nancy kathure', '0726803563', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 296, '', 'active', 6, '2025-01-11 08:14:42');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (74, 'brian mutugi', '0742472733', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 08:15:50');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (75, 'eliezer munene', '0707671306', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 296, '', 'active', 6, '2025-01-11 08:16:55');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (76, 'munene mbaabu', '0799493431', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', NULL, 296, '', 'active', 6, '2025-01-11 08:17:56');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (77, 'edna kendi gitonga', '0704247221', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 08:19:12');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (78, 'sharon mwendwa', '0743827693', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 14, '', 'active', 6, '2025-01-11 08:20:22');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (79, 'loddy kathini', '0745561129', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 4, '', 'active', 6, '2025-01-11 08:21:07');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (80, 'eric murimi', '0792300445', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 306, '', 'active', 6, '2025-01-11 08:22:09');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (81, 'winfred mutwiri', '0717015534', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 5, '', 'active', 6, '2025-01-11 08:23:21');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (82, 'bobson muthuri', '0105459594', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 08:24:11');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (83, 'joshua kibiti', '0716450271', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 5, '', 'active', 6, '2025-01-11 08:24:58');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (84, 'winfine makena', '0757212730', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 224, '', 'active', 6, '2025-01-11 08:26:02');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (85, 'Isabella kiruja', '0795691260', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 201, '', 'active', 6, '2025-01-11 08:27:12');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (86, 'donald mwendia', '0758838220', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 310, '', 'active', 6, '2025-01-11 08:28:19');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (87, 'wincate muthoni', '0790321875', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 201, '', 'active', 6, '2025-01-11 08:29:25');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (88, 'Stephen murangiri', '0797595181', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 250, '', 'active', 6, '2025-01-11 08:31:37');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (89, 'jot kathambi', '0794381063', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 207, '', 'active', 6, '2025-01-11 08:33:23');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (90, 'jackson marete', '0714440366', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 5, '', 'active', 6, '2025-01-11 08:34:49');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (91, 'moses kirema', '0759652529', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 53, '', 'active', 6, '2025-01-11 08:36:02');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (92, 'pectony murigu', '0718930418', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 82, '', 'active', 6, '2025-01-11 08:38:56');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (93, 'weddy kawira', '0794062395', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 4, '', 'active', 6, '2025-01-11 08:39:53');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (94, 'frankline mwirigi', '0724751220', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 231, '', 'active', 6, '2025-01-11 08:41:23');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (95, 'dianah peace', '0790367046', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 191, '', 'active', 6, '2025-01-11 08:43:52');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (96, 'sister teresa', '0740541540', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 239, '', 'active', 6, '2025-01-11 08:45:32');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (97, 'doreen mworia', '0710476833', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 62, '', 'active', 6, '2025-01-11 08:47:12');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (98, 'ireen kinya', '0720082841', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 08:49:30');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (99, 'dennis munene', '0799493431', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 319, '', 'active', 6, '2025-01-11 08:51:27');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (100, 'elosy mwendwa mwiti', '0723931060', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 311, '', 'active', 6, '2025-01-11 08:52:54');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (101, 'purity makena', '0791518333', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 198, '', 'active', 6, '2025-01-11 08:57:07');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (102, 'jackline kinanu', '0708153920', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 08:58:00');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (103, 'dinah kanana', '0725597034', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 217, '', 'active', 6, '2025-01-11 08:58:56');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (104, 'linah mwendwa', '0790670493', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 276, '', 'active', 6, '2025-01-11 09:00:06');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (105, 'immaculate ndanu', '0799776953', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 194, '', 'active', 6, '2025-01-11 09:01:17');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (106, 'celine kimathi', '0768172589', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 191, '', 'active', 6, '2025-01-11 09:02:20');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (107, 'winjoy kagwiria', '0714903370', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 09:03:15');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (108, 'jackline murugi', '0793937667', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 1, '', 'active', 6, '2025-01-11 09:04:10');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (109, 'muchai kimathi john', '0727563868', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 24, '', 'active', 6, '2025-01-11 09:06:22');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (110, 'johab thuranira', '0742027480', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 19, '', 'active', 6, '2025-01-11 09:07:45');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (111, 'aron mugendi', '0798525741', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 19, '', 'active', 6, '2025-01-11 09:09:22');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (112, 'jane karambu', '0799983324', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 38, '', 'active', 6, '2025-01-11 09:14:05');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (113, 'joanina nkirote', '0724024938', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 83, '', 'active', 6, '2025-01-11 09:17:50');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (114, 'brenda kinya', '0701083740', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 4, '', 'active', 6, '2025-01-11 09:24:46');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (115, 'mwenda samson', '0719527270', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 4, '', 'active', 6, '2025-01-11 09:36:35');
INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`) VALUES (116, 'david kihiu', '0797360875', '', '', '2025-01-11', '', '2025-01-30', '', 'PERSONAL', '', 6, 77, '', 'active', 6, '2025-01-11 09:39:34');


#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (1, 'STUDENTS ORIENTATION', '', '2025-02-14 00:00:00', '2025-02-14 00:00:00', 'task', '#000', '1', 7, 'no');


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_students`;

CREATE TABLE `exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` int(6) DEFAULT NULL,
  `teacher_remark` text DEFAULT NULL,
  `rank` int(20) NOT NULL DEFAULT 0,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=347 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 254, 254, 100001, 'Done', 1, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 229, 229, 100002, NULL, 7, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (8, 1, 248, 248, 100003, NULL, 8, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (9, 1, 261, 261, 100004, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (11, 4, 188, 188, NULL, '', 0, 0, '2025-04-01 06:12:55', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (12, 1, 257, 257, 100005, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (13, 1, 258, 258, 100006, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (14, 1, 243, 243, 100007, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (15, 1, 259, 259, 100008, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (16, 1, 274, 274, 100009, NULL, 0, 0, '2025-02-27 04:23:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (17, 6, 246, 246, NULL, NULL, 0, 0, '2025-02-21 07:34:41', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (18, 6, 237, 237, NULL, NULL, 0, 0, '2025-02-21 07:34:41', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (19, 9, 23, 23, NULL, NULL, 0, 0, '2025-02-21 13:02:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (20, 9, 24, 24, NULL, NULL, 0, 0, '2025-02-21 13:02:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (21, 9, 52, 52, NULL, NULL, 0, 0, '2025-02-21 13:02:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (22, 9, 105, 105, NULL, NULL, 0, 0, '2025-02-21 13:02:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (23, 9, 54, 54, NULL, NULL, 0, 0, '2025-02-21 13:02:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (24, 9, 254, 254, NULL, NULL, 0, 0, '2025-02-21 13:06:55', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (25, 10, 23, 23, NULL, NULL, 5, 0, '2025-02-21 15:04:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (26, 10, 24, 24, NULL, NULL, 6, 0, '2025-02-21 15:04:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (27, 10, 52, 52, NULL, NULL, 4, 0, '2025-02-21 15:04:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (28, 10, 105, 105, NULL, NULL, 2, 0, '2025-02-21 14:45:39', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (29, 10, 54, 54, NULL, NULL, 1, 0, '2025-02-21 14:45:39', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (30, 11, 23, 23, NULL, NULL, 0, 0, '2025-02-21 14:20:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (31, 11, 24, 24, NULL, NULL, 0, 0, '2025-02-21 14:20:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (32, 11, 52, 52, NULL, NULL, 0, 0, '2025-02-21 14:20:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (33, 11, 105, 105, NULL, NULL, 0, 0, '2025-02-21 14:20:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (34, 11, 54, 54, NULL, NULL, 0, 0, '2025-02-21 14:20:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (35, 10, 254, 254, NULL, NULL, 3, 0, '2025-02-21 15:04:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (36, 2, 254, 254, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (37, 2, 257, 257, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (38, 2, 258, 258, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (39, 2, 243, 243, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (40, 2, 259, 259, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (41, 2, 274, 274, NULL, NULL, 0, 0, '2025-02-24 06:25:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (42, 3, 254, 254, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (43, 3, 257, 257, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (44, 3, 258, 258, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (45, 3, 243, 243, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (46, 3, 259, 259, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (47, 3, 274, 274, NULL, NULL, 0, 0, '2025-02-24 06:26:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (48, 15, 275, 275, NULL, NULL, 0, 0, '2025-02-24 06:31:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (49, 15, 164, 164, NULL, NULL, 0, 0, '2025-02-24 06:31:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (50, 15, 244, 244, NULL, NULL, 0, 0, '2025-02-24 06:31:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (51, 15, 269, 269, NULL, NULL, 0, 0, '2025-02-24 06:31:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (52, 16, 275, 275, NULL, NULL, 0, 0, '2025-02-24 06:45:21', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (53, 16, 164, 164, NULL, NULL, 0, 0, '2025-02-24 06:45:21', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (54, 16, 244, 244, NULL, NULL, 0, 0, '2025-02-24 06:45:21', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (55, 16, 269, 269, NULL, NULL, 0, 0, '2025-02-24 06:45:21', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (56, 17, 275, 275, NULL, NULL, 0, 0, '2025-02-24 06:45:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (57, 17, 164, 164, NULL, NULL, 0, 0, '2025-02-24 06:45:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (58, 17, 244, 244, NULL, NULL, 0, 0, '2025-02-24 06:45:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (59, 17, 269, 269, NULL, NULL, 0, 0, '2025-02-24 06:45:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (60, 24, 231, 231, NULL, NULL, 0, 0, '2025-02-24 06:49:50', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (61, 24, 230, 230, NULL, NULL, 0, 0, '2025-02-24 07:17:22', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (62, 24, 272, 272, NULL, NULL, 0, 0, '2025-02-24 07:17:22', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (63, 36, 236, 236, NULL, NULL, 0, 0, '2025-02-24 07:35:57', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (64, 33, 284, 284, NULL, NULL, 0, 0, '2025-02-24 08:00:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (65, 33, 234, 234, NULL, NULL, 0, 0, '2025-02-24 08:00:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (66, 45, 241, 241, NULL, NULL, 0, 0, '2025-02-25 03:01:42', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (67, 45, 235, 235, NULL, NULL, 0, 0, '2025-02-25 03:01:42', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (68, 39, 226, 226, NULL, NULL, 0, 0, '2025-02-25 03:02:57', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (69, 69, 222, 222, NULL, NULL, 0, 0, '2025-02-27 07:12:15', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (70, 70, 222, 222, NULL, NULL, 0, 0, '2025-02-27 07:15:16', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (71, 78, 233, 233, NULL, NULL, 0, 0, '2025-02-27 07:17:14', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (72, 78, 271, 271, NULL, NULL, 0, 0, '2025-02-27 07:17:14', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (73, 75, 240, 240, NULL, NULL, 0, 0, '2025-02-27 07:17:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (74, 66, 238, 238, NULL, NULL, 0, 0, '2025-02-27 07:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (75, 63, 262, 262, NULL, NULL, 0, 0, '2025-02-27 07:36:40', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (76, 60, 250, 250, NULL, NULL, 0, 0, '2025-02-27 07:37:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (77, 60, 263, 263, NULL, NULL, 0, 0, '2025-02-27 07:37:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (78, 54, 223, 223, NULL, NULL, 0, 0, '2025-02-27 07:38:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (79, 48, 249, 249, NULL, NULL, 0, 0, '2025-02-27 07:41:19', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (80, 84, 233, 233, NULL, NULL, 0, 0, '2025-02-27 07:46:24', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (81, 84, 271, 271, NULL, NULL, 0, 0, '2025-02-27 07:46:24', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (82, 72, 240, 240, NULL, NULL, 0, 0, '2025-02-27 08:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (84, 18, 248, 248, NULL, NULL, 0, 0, '2025-02-28 01:35:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (85, 81, 246, 246, NULL, NULL, 0, 0, '2025-02-28 04:14:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (86, 81, 237, 237, NULL, NULL, 0, 0, '2025-02-28 04:14:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (87, 69, 255, 255, NULL, NULL, 0, 0, '2025-02-28 05:53:14', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (89, 5, 188, 188, NULL, NULL, 0, 0, '2025-02-28 06:10:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (90, 87, 154, 154, NULL, NULL, 0, 0, '2025-02-28 06:11:15', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (91, 87, 245, 245, NULL, NULL, 0, 0, '2025-02-28 06:11:15', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (92, 88, 154, 154, NULL, '', 0, 0, '2025-03-04 23:26:02', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (93, 88, 245, 245, NULL, '', 0, 0, '2025-03-04 23:26:02', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (94, 89, 143, 143, NULL, NULL, 0, 0, '2025-02-28 06:12:29', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (95, 89, 156, 156, NULL, NULL, 0, 0, '2025-02-28 06:12:29', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (96, 90, 143, 143, NULL, NULL, 0, 0, '2025-02-28 06:13:27', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (97, 90, 156, 156, NULL, NULL, 0, 0, '2025-02-28 06:13:27', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (98, 91, 146, 146, NULL, NULL, 0, 0, '2025-02-28 06:15:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (99, 91, 224, 224, NULL, NULL, 0, 0, '2025-02-28 06:15:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (100, 92, 146, 146, NULL, NULL, 0, 0, '2025-02-28 06:15:44', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (101, 92, 224, 224, NULL, NULL, 0, 0, '2025-02-28 06:15:44', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (102, 9, 22, 22, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (103, 9, 82, 82, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (104, 9, 102, 102, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (105, 9, 131, 131, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (106, 9, 76, 76, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (107, 9, 2, 2, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (108, 9, 5, 5, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (109, 9, 30, 30, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (110, 9, 32, 32, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (111, 9, 35, 35, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (112, 9, 39, 39, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (113, 9, 40, 40, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (114, 9, 42, 42, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (115, 9, 45, 45, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (116, 9, 48, 48, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (117, 9, 53, 53, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (118, 9, 50, 50, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (119, 9, 56, 56, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (120, 9, 60, 60, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (121, 9, 62, 62, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (122, 9, 65, 65, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (123, 9, 67, 67, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (124, 9, 96, 96, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (125, 9, 97, 97, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (126, 9, 98, 98, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (127, 9, 103, 103, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (128, 9, 104, 104, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (129, 9, 106, 106, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (130, 9, 107, 107, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (131, 9, 20, 20, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (132, 9, 21, 21, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (133, 9, 25, 25, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (134, 9, 26, 26, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (135, 9, 27, 27, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (136, 9, 28, 28, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (137, 9, 29, 29, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (138, 9, 31, 31, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (139, 9, 33, 33, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (140, 9, 34, 34, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (141, 9, 37, 37, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (142, 9, 38, 38, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (143, 9, 41, 41, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (144, 9, 43, 43, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (145, 9, 44, 44, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (146, 9, 46, 46, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (147, 9, 47, 47, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (148, 9, 49, 49, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (149, 9, 51, 51, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (150, 9, 36, 36, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (151, 9, 183, 183, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (152, 9, 181, 181, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (153, 9, 182, 182, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (154, 9, 184, 184, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (155, 9, 187, 187, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (156, 9, 194, 194, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (157, 9, 195, 195, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (158, 9, 196, 196, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (159, 9, 198, 198, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (160, 9, 200, 200, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (161, 9, 204, 204, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (162, 9, 207, 207, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (163, 9, 208, 208, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (164, 9, 209, 209, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (165, 9, 117, 117, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (166, 9, 94, 94, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (167, 9, 111, 111, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (168, 9, 4, 4, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (169, 9, 7, 7, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (170, 9, 9, 9, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (171, 9, 11, 11, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (172, 9, 12, 12, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (173, 9, 16, 16, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (174, 9, 17, 17, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (175, 9, 18, 18, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (176, 9, 13, 13, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (177, 9, 14, 14, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (178, 9, 15, 15, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (179, 9, 81, 81, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (180, 9, 83, 83, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (181, 9, 84, 84, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (182, 9, 85, 85, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (183, 9, 86, 86, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (184, 9, 87, 87, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (185, 9, 88, 88, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (186, 9, 89, 89, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (187, 9, 90, 90, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (188, 9, 91, 91, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (189, 9, 92, 92, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (190, 9, 93, 93, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (191, 9, 95, 95, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (192, 9, 108, 108, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (193, 9, 109, 109, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (194, 9, 110, 110, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (195, 9, 112, 112, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (196, 9, 113, 113, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (197, 9, 114, 114, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (198, 9, 115, 115, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (199, 9, 116, 116, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (200, 9, 118, 118, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (201, 9, 119, 119, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (202, 9, 19, 19, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (203, 9, 126, 126, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (204, 9, 120, 120, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (205, 9, 121, 121, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (206, 9, 122, 122, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (207, 9, 123, 123, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (208, 9, 124, 124, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (209, 9, 125, 125, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (210, 9, 127, 127, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (211, 9, 128, 128, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (212, 9, 129, 129, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (213, 9, 130, 130, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (214, 9, 132, 132, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (215, 9, 170, 170, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (216, 9, 177, 177, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (217, 9, 178, 178, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (218, 9, 179, 179, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (219, 9, 180, 180, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (220, 9, 186, 186, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (221, 9, 268, 268, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (222, 9, 282, 282, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (223, 9, 273, 273, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (224, 9, 277, 277, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (225, 9, 278, 278, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (226, 9, 280, 280, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (227, 9, 281, 281, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (228, 9, 286, 286, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (229, 9, 287, 287, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (230, 9, 288, 288, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (231, 9, 289, 289, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (232, 9, 55, 55, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (233, 9, 57, 57, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (234, 9, 58, 58, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (235, 9, 61, 61, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (236, 9, 63, 63, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (237, 9, 64, 64, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (238, 9, 66, 66, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (239, 9, 68, 68, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (240, 9, 69, 69, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (241, 9, 70, 70, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (242, 9, 71, 71, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (243, 9, 72, 72, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (244, 9, 73, 73, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (245, 9, 74, 74, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (246, 9, 75, 75, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (247, 9, 77, 77, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (248, 9, 78, 78, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (249, 9, 79, 79, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (250, 9, 80, 80, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (251, 9, 59, 59, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (252, 9, 216, 216, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (253, 9, 210, 210, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (254, 9, 214, 214, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (255, 9, 217, 217, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (256, 9, 218, 218, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (257, 9, 219, 219, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (258, 9, 220, 220, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (259, 9, 228, 228, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (260, 9, 99, 99, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (261, 9, 100, 100, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (262, 9, 101, 101, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (263, 9, 10, 10, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (264, 9, 3, 3, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (265, 9, 6, 6, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (266, 9, 8, 8, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (267, 9, 185, 185, NULL, NULL, 0, 0, '2025-02-28 06:21:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (268, 27, 231, 231, NULL, NULL, 0, 0, '2025-02-28 06:56:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (269, 30, 248, 248, NULL, NULL, 0, 0, '2025-02-28 07:20:33', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (270, 42, 251, 251, NULL, NULL, 0, 0, '2025-02-28 07:58:41', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (271, 42, 201, 201, NULL, NULL, 0, 0, '2025-02-28 07:58:41', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (272, 42, 203, 203, NULL, NULL, 0, 0, '2025-02-28 07:58:41', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (273, 33, 225, 225, NULL, NULL, 0, 0, '2025-02-28 08:00:25', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (274, 33, 192, 192, NULL, NULL, 0, 0, '2025-02-28 08:00:25', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (275, 81, 248, 248, NULL, NULL, 0, 0, '2025-02-28 08:02:44', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (276, 45, 254, 254, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (277, 45, 257, 257, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (278, 45, 258, 258, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (279, 45, 243, 243, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (280, 45, 259, 259, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (281, 45, 274, 274, NULL, NULL, 0, 0, '2025-02-28 08:06:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (282, 21, 229, 229, NULL, NULL, 0, 0, '2025-02-28 08:08:27', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (283, 55, 223, 223, NULL, NULL, 0, 0, '2025-02-28 08:21:12', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (284, 30, 260, 260, NULL, NULL, 0, 0, '2025-02-28 08:27:30', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (285, 6, 290, 290, NULL, NULL, 0, 0, '2025-02-28 08:54:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (286, 4, 159, 159, NULL, '', 0, 0, '2025-04-01 06:12:55', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (287, 34, 246, 246, NULL, NULL, 0, 0, '2025-03-03 05:30:23', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (288, 34, 237, 237, NULL, NULL, 0, 0, '2025-03-03 05:30:23', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (289, 58, 232, 232, NULL, NULL, 0, 0, '2025-03-03 06:39:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (290, 58, 253, 253, NULL, NULL, 0, 0, '2025-03-03 06:39:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (291, 58, 256, 256, NULL, NULL, 0, 0, '2025-03-03 06:39:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (292, 57, 232, 232, NULL, NULL, 0, 0, '2025-03-03 06:40:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (293, 57, 253, 253, NULL, NULL, 0, 0, '2025-03-03 06:40:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (294, 57, 256, 256, NULL, NULL, 0, 0, '2025-03-03 06:40:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (295, 93, 252, 252, NULL, NULL, 0, 0, '2025-03-03 07:19:10', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (296, 18, 270, 270, NULL, NULL, 0, 0, '2025-03-04 02:38:08', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (297, 20, 248, 248, NULL, NULL, 0, 0, '2025-03-04 02:38:37', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (298, 82, 246, 246, NULL, NULL, 0, 0, '2025-03-24 06:03:00', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (299, 82, 237, 237, NULL, NULL, 0, 0, '2025-03-24 06:03:00', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (300, 76, 247, 247, NULL, NULL, 0, 0, '2025-03-24 06:14:51', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (301, 73, 240, 240, NULL, NULL, 0, 0, '2025-03-24 06:41:24', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (302, 46, 241, 241, NULL, NULL, 0, 0, '2025-03-24 07:38:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (303, 46, 235, 235, NULL, NULL, 0, 0, '2025-03-24 07:38:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (304, 94, 252, 252, NULL, NULL, 0, 0, '2025-03-24 07:43:19', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (305, 44, 251, 251, NULL, NULL, 0, 0, '2025-03-24 07:49:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (306, 44, 201, 201, NULL, NULL, 0, 0, '2025-03-24 07:49:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (307, 44, 203, 203, NULL, NULL, 0, 0, '2025-03-24 07:49:34', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (308, 37, 236, 236, NULL, NULL, 0, 0, '2025-03-24 08:21:02', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (309, 25, 231, 231, NULL, NULL, 0, 0, '2025-03-24 08:50:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (310, 25, 163, 163, NULL, NULL, 0, 0, '2025-03-24 08:50:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (311, 25, 167, 167, NULL, NULL, 0, 0, '2025-03-24 08:50:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (312, 25, 161, 161, NULL, NULL, 0, 0, '2025-03-24 08:50:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (313, 25, 193, 193, NULL, NULL, 0, 0, '2025-03-24 08:50:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (314, 19, 248, 248, NULL, NULL, 0, 0, '2025-03-24 09:07:47', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (315, 64, 262, 262, NULL, NULL, 0, 0, '2025-03-24 09:28:24', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (316, 51, 264, 264, NULL, NULL, 0, 0, '2025-03-24 09:46:49', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (317, 100, 141, 141, NULL, NULL, 0, 0, '2025-03-24 09:51:05', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (318, 101, 141, 141, NULL, NULL, 0, 0, '2025-03-24 09:51:38', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (319, 102, 265, 265, NULL, NULL, 0, 0, '2025-03-24 09:56:09', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (320, 102, 276, 276, NULL, NULL, 0, 0, '2025-03-24 09:56:09', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (321, 85, 233, 233, NULL, NULL, 0, 0, '2025-03-24 09:58:56', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (322, 85, 271, 271, NULL, NULL, 0, 0, '2025-03-24 09:58:56', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (323, 34, 284, 284, NULL, NULL, 0, 0, '2025-03-24 10:05:16', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (324, 34, 234, 234, NULL, NULL, 0, 0, '2025-03-24 10:05:16', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (325, 49, 249, 249, NULL, NULL, 0, 0, '2025-03-24 10:11:52', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (326, 28, 230, 230, NULL, NULL, 0, 0, '2025-03-24 10:20:31', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (327, 28, 272, 272, NULL, NULL, 0, 0, '2025-03-24 10:20:31', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (328, 31, 265, 265, NULL, NULL, 0, 0, '2025-03-24 10:33:02', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (329, 61, 250, 250, NULL, NULL, 0, 0, '2025-03-25 04:53:20', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (330, 61, 263, 263, NULL, NULL, 0, 0, '2025-03-25 04:53:20', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (331, 104, 290, 290, NULL, NULL, 0, 0, '2025-03-27 04:13:45', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (332, 105, 290, 290, NULL, NULL, 0, 0, '2025-03-27 04:14:03', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (333, 72, 247, 247, NULL, NULL, 0, 0, '2025-03-27 04:46:55', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (334, 75, 247, 247, NULL, NULL, 0, 0, '2025-03-27 04:47:57', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (335, 78, 261, 261, NULL, NULL, 0, 0, '2025-03-27 04:50:36', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (336, 52, 264, 264, NULL, NULL, 0, 0, '2025-03-27 05:05:16', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (337, 106, 279, 279, NULL, NULL, 0, 0, '2025-03-27 05:07:20', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (338, 106, 283, 283, NULL, NULL, 0, 0, '2025-03-27 05:07:20', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (339, 7, 290, 290, NULL, NULL, 0, 0, '2025-04-04 04:18:06', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (340, 16, 308, 308, NULL, NULL, 0, 0, '2025-05-06 06:17:13', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (341, 108, 255, 255, NULL, NULL, 0, 0, '2025-05-06 08:09:45', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (342, 67, 211, 211, NULL, NULL, 0, 0, '2025-05-06 08:10:56', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (343, 67, 238, 238, NULL, NULL, 0, 0, '2025-05-06 08:10:56', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (344, 107, 279, 279, NULL, NULL, 0, 0, '2025-05-08 03:36:32', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (345, 107, 283, 283, NULL, NULL, 0, 0, '2025-05-08 03:36:32', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (346, 107, 260, 260, NULL, NULL, 0, 0, '2025-05-08 03:36:32', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_subjects`;

CREATE TABLE `exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(10) NOT NULL,
  `date_from` date NOT NULL,
  `time_from` time NOT NULL,
  `duration` varchar(50) NOT NULL,
  `room_no` varchar(100) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT 0.00,
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=455 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 10, '2025-02-12', '08:00:00', '1', '2F H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 9, '2025-02-11', '10:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 823, '2025-02-11', '11:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (4, 1, 8, '2025-02-13', '08:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (5, 1, 7, '2025-02-13', '09:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (6, 1, 15, '2025-02-14', '09:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 824, '2025-02-13', '09:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (8, 1, 825, '2025-02-13', '12:00:00', '1', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-20 06:07:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (9, 9, 14, '2025-02-21', '08:00:00', '2', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-21 13:09:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (10, 10, 499, '2025-02-20', '08:00:00', '3', 'H6', '30.00', '1.00', '1.00', NULL, 0, '2025-02-21 13:52:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (11, 15, 10, '2025-02-10', '08:00:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:35:26', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (12, 27, 826, '2025-02-10', '01:30:00', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (13, 27, 828, '2025-02-12', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (14, 27, 827, '2025-02-12', '10:00:00', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 06:54:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (15, 27, 468, '2025-02-24', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:06:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (16, 24, 806, '2025-02-10', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (17, 24, 807, '2025-02-14', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (18, 24, 812, '2025-02-10', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:16:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (19, 36, 466, '2025-02-12', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:50:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (20, 36, 387, '2025-02-13', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:50:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (21, 36, 442, '2025-02-14', '08:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:50:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (23, 36, 359, '2025-02-10', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:54:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (24, 36, 367, '2025-02-10', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:54:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (25, 36, 392, '2025-02-10', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 07:54:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (26, 33, 439, '2025-02-13', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (27, 33, 362, '2025-02-10', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (28, 33, 397, '2025-02-14', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (29, 33, 359, '2025-02-11', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (30, 33, 390, '2025-02-10', '03:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (31, 33, 381, '2025-02-12', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (32, 33, 375, '2025-02-13', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:14:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (33, 42, 439, '2025-02-13', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (34, 42, 359, '2025-02-11', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (35, 42, 360, '2025-02-14', '03:35:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (36, 42, 362, '2025-02-10', '08:00:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (37, 42, 364, '2025-02-12', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (38, 42, 397, '2025-02-21', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (39, 42, 445, '2025-02-12', '10:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (40, 42, 444, '2025-02-20', '01:30:00', '01', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-24 08:35:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (41, 39, 403, '2025-02-12', '01:30:00', '01', 'C-WASH', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:00:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (42, 45, 520, '2025-02-12', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (43, 45, 538, '2025-02-13', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (44, 45, 543, '2025-02-11', '01:30:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (45, 45, 530, '2025-02-10', '03:35:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (46, 45, 532, '2025-02-12', '01:30:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (47, 45, 558, '2025-02-14', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 03:13:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (48, 48, 507, '2025-02-10', '08:00:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (49, 48, 522, '2025-02-13', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (50, 48, 509, '2025-02-10', '03:35:00', '01', '2FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (51, 48, 520, '2025-02-12', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (52, 48, 525, '2025-02-21', '10:30:00', '01', 'F-WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:01:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (53, 51, 92, '2025-02-10', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (54, 51, 17, '2025-02-14', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (55, 51, 83, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (56, 51, 30, '2025-02-10', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (57, 51, 36, '2025-02-10', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (58, 51, 79, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:45:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (59, 54, 335, '2025-02-13', '10:30:00', '01', 'KI', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (60, 54, 331, '2025-02-11', '08:00:00', '01', 'KI', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (61, 54, 324, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (62, 54, 321, '2025-02-10', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (63, 54, 318, '2025-02-11', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (64, 54, 322, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 04:58:13', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (65, 57, 405, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (66, 57, 417, '2025-02-14', '03:35:00', '01', 'TD R', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (67, 57, 419, '2025-02-14', '08:00:00', '01', 'E WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (68, 57, 407, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (69, 57, 406, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (70, 57, 410, '2025-02-13', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 05:16:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (71, 60, 28, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (72, 60, 15, '2025-02-13', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (73, 60, 31, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (74, 60, 49, '2025-02-21', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (75, 60, 53, '2025-02-14', '01:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (76, 60, 30, '2025-02-10', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:03:23', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (77, 63, 127, '2025-02-11', '03:35:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (78, 63, 32, '2025-02-11', '01:35:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (79, 63, 33, '2025-02-10', '08:00:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (80, 63, 38, '2025-02-13', '08:00:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (81, 63, 42, '2025-02-14', '03:35:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (82, 66, 469, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (83, 66, 472, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (84, 66, 490, '2025-02-12', '08:00:00', '01', 'E WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (85, 66, 488, '2025-02-14', '03:35:00', '01', 'TD RM', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (86, 66, 470, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 06:38:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (87, 75, 51, '2025-02-13', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (88, 75, 42, '2025-02-13', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (89, 75, 32, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (90, 75, 37, '2025-02-10', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (91, 75, 33, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (92, 75, 34, '2025-02-10', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (93, 75, 35, '2025-02-13', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (94, 75, 45, '2025-02-11', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:46:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (95, 78, 32, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (96, 78, 33, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (97, 78, 76, '2025-02-13', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (98, 78, 34, '2025-02-12', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (99, 78, 38, '2025-02-13', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (100, 78, 45, '2025-02-11', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (101, 78, 42, '2025-02-14', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-25 07:51:24', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (102, 70, 42, '2025-02-27', '14:00:00', '01', 'TDR', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (103, 69, 42, '2025-02-20', '15:10:15', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 07:10:41', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (104, 70, 297, '2025-02-14', '01:30:00', '01', 'AUT WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (105, 70, 264, '2025-02-13', '10:30:00', '01', '2FL H4', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (107, 70, 313, '2025-02-12', '03:35:00', '01', 'AUT WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (108, 70, 259, '2025-02-10', '08:00:00', '01', '2FL H4', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (109, 84, 50, '2025-02-11', '08:00:00', '01', 'PL WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (110, 84, 36, '2025-02-12', '01:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (111, 84, 76, '2025-02-13', '01:35:00', '01', 'PL WSP', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (112, 84, 79, '2025-02-11', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (113, 84, 63, '2025-02-14', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (114, 84, 54, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (115, 84, 60, '2025-02-13', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (116, 84, 188, '2025-02-10', '03:35:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:00:47', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (117, 72, 205, '2025-02-10', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (118, 72, 257, '2025-02-12', '08:00:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (119, 72, 261, '2025-02-10', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (120, 72, 264, '2025-02-13', '10:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (121, 72, 266, '2025-02-14', '01:30:00', '01', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 07:57:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (122, 72, 220, '2025-02-13', '03:35:00', '01', 'TD RM', '30.00', '1.00', '1.00', NULL, 0, '2025-02-27 08:38:30', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (123, 63, 781, '2025-02-06', '10:19:00', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (124, 63, 782, '2025-02-08', '10:19:05', '1', '2FL H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 02:19:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (125, 81, 10, '2025-02-06', '12:15:58', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (126, 81, 13, '2025-02-07', '12:16:38', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (127, 81, 9, '2025-02-06', '12:21:44', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (128, 81, 104, '2025-02-06', '12:26:48', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (129, 81, 11, '2025-02-28', '12:31:04', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (130, 81, 107, '2025-02-06', '12:35:07', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (131, 81, 15, '2025-02-06', '12:35:58', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (132, 81, 12, '2025-02-06', '12:36:37', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (133, 81, 42, '2025-02-28', '12:38:20', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (134, 81, 108, '2025-02-28', '12:44:35', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 05:03:56', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (135, 81, 8, '2025-02-28', '12:45:34', '1', 'H5', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 04:45:46', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (136, 69, 240, '2025-02-06', '13:55:19', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (137, 69, 205, '2025-02-28', '14:05:27', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (138, 69, 837, '2025-02-28', '14:14:53', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (139, 69, 10, '2025-02-28', '14:15:37', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (140, 69, 12, '2025-02-28', '14:15:40', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (141, 69, 41, '2025-02-28', '14:15:43', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (142, 69, 834, '2025-02-28', '14:15:45', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (143, 69, 174, '2025-02-28', '14:21:03', '1', 'TDR', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 06:21:19', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (144, 27, 10, '2025-02-19', '15:06:51', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:02:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (145, 27, 14, '2025-02-28', '15:09:04', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:02:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (146, 27, 15, '2025-02-28', '15:10:14', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:02:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (147, 24, 10, '2025-02-28', '15:16:31', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:11:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (148, 24, 9, '2025-02-28', '15:17:21', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:11:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (149, 24, 8, '2025-02-28', '15:18:03', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:11:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (150, 24, 11, '2025-02-28', '15:18:45', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:11:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (151, 24, 15, '2025-02-28', '15:19:32', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:11:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (152, 18, 10, '2025-02-28', '15:23:13', '1', 'LAB1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (153, 18, 30, '2025-02-28', '15:25:49', '1', 'LAB1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (154, 18, 8, '2025-02-28', '15:26:33', '1', 'LAB1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (155, 18, 11, '2025-02-28', '15:37:58', '1', 'LAB 1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (156, 18, 620, '2025-02-28', '15:38:25', '1', 'LAB1', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:40:27', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (157, 15, 521, '2025-02-28', '15:51:33', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (158, 15, 9, '2025-02-28', '15:52:15', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (159, 15, 8, '2025-02-28', '15:52:45', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (160, 15, 523, '2025-02-28', '15:54:11', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (161, 15, 11, '2025-02-28', '15:54:47', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (162, 15, 15, '2025-02-28', '15:55:20', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (163, 15, 625, '2025-02-28', '15:57:54', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 07:55:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (164, 30, 10, '2025-02-28', '16:38:22', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (165, 30, 14, '2025-02-28', '16:39:03', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (166, 30, 375, '2025-02-28', '16:41:51', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (167, 30, 397, '2025-02-28', '16:43:33', '1', '2FL H2B', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 08:55:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (168, 6, 31, '2025-02-28', '16:59:26', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (169, 6, 8, '2025-02-28', '16:59:28', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (170, 6, 84, '2025-02-28', '16:59:31', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (171, 6, 104, '2025-02-28', '16:59:33', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (172, 6, 107, '2025-02-28', '16:59:35', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (173, 6, 182, '2025-02-28', '16:59:37', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (174, 6, 319, '2025-02-28', '16:59:39', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (175, 6, 15, '2025-02-28', '16:59:41', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:01:01', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (176, 4, 771, '2025-02-28', '17:13:38', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (177, 4, 750, '2025-02-28', '17:13:40', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (178, 4, 748, '2025-02-28', '17:13:42', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (179, 4, 747, '2025-02-28', '17:13:44', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (180, 4, 744, '2025-02-28', '17:13:46', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (181, 4, 753, '2025-02-28', '17:13:49', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (182, 4, 745, '2025-02-28', '17:13:51', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (183, 4, 746, '2025-02-28', '17:13:53', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (184, 4, 752, '2025-02-28', '17:14:00', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (185, 4, 749, '2025-02-28', '17:14:03', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (186, 4, 742, '2025-02-28', '17:14:06', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (187, 4, 741, '2025-02-28', '17:14:09', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (188, 4, 743, '2025-02-28', '17:14:13', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:15:53', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (189, 87, 8, '2025-02-28', '17:21:51', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (190, 87, 763, '2025-02-28', '17:21:53', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (191, 87, 754, '2025-02-28', '17:21:56', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (192, 87, 756, '2025-02-28', '17:21:58', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (193, 87, 762, '2025-02-28', '17:22:00', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (194, 87, 741, '2025-02-28', '17:22:03', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (195, 87, 758, '2025-02-28', '17:22:05', '1', 'H2', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:23:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (196, 89, 793, '2025-02-28', '17:40:43', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (197, 89, 790, '2025-02-28', '17:40:45', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (198, 89, 8, '2025-02-28', '17:40:47', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (199, 89, 792, '2025-02-28', '17:40:49', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (200, 89, 791, '2025-02-28', '17:40:56', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (201, 89, 789, '2025-02-28', '17:40:58', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (202, 89, 787, '2025-02-28', '17:41:02', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (203, 89, 788, '2025-02-28', '17:41:06', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (204, 89, 838, '2025-02-28', '17:41:08', '1', 'H4', '30.00', '1.00', '1.00', NULL, 0, '2025-02-28 09:42:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (205, 93, 818, '2025-03-03', '15:20:41', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (206, 93, 817, '2025-03-03', '15:20:45', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (207, 93, 815, '2025-03-05', '15:20:49', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (208, 93, 819, '2025-03-06', '15:20:53', '1', 'H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-03 07:21:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (209, 66, 313, '2025-02-12', '03:35:00', '01', '2fl h4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 02:36:41', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (210, 72, 849, '2025-02-14', '01:30:00', '01', 'AUT WSH', '30.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:01:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (211, 72, 240, '2025-02-11', '08:00:00', '01', 'AUT WSH', '30.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:01:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (212, 57, 415, '2025-02-12', '03:30:00', '1', '2\\FL H3', '30.00', '1.00', '1.00', NULL, 0, '2025-03-04 08:02:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (213, 2, 10, '2025-03-18', '11:35:38', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (214, 2, 9, '2025-03-17', '11:41:13', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (215, 2, 389, '2025-03-15', '11:42:27', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (216, 2, 823, '2025-03-20', '11:45:08', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (217, 2, 11, '2025-03-19', '11:45:52', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (218, 2, 15, '2025-03-21', '11:46:33', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (219, 2, 825, '2025-03-20', '11:47:24', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (220, 2, 824, '2025-03-13', '11:48:25', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 04:48:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (221, 5, 751, '2025-03-12', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (222, 5, 741, '2025-03-13', '09:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (223, 5, 748, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (224, 5, 744, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (225, 5, 753, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (226, 5, 745, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (227, 5, 746, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (228, 5, 752, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (229, 5, 749, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (230, 5, 750, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (231, 5, 743, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (232, 5, 747, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (233, 5, 742, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:06:05', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (234, 16, 9, '2025-03-18', '11:52:19', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (235, 16, 8, '2025-03-12', '15:00:12', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (236, 16, 20, '2025-03-11', '11:54:15', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (237, 16, 11, '2025-03-19', '11:54:17', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (238, 16, 15, '2025-03-13', '11:30:19', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (239, 16, 620, '2025-03-14', '11:54:21', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (240, 16, 524, '2025-03-21', '11:00:23', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (241, 16, 523, '2025-03-17', '08:30:27', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (242, 16, 740, '2025-03-19', '13:54:30', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:41:06', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (243, 88, 756, '2025-03-12', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (244, 88, 758, '2025-03-13', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (245, 88, 759, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (246, 88, 754, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (247, 88, 755, '2025-03-18', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (248, 88, 757, '2025-03-19', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 05:43:38', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (249, 82, 10, '2025-03-17', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (250, 82, 9, '2025-03-18', '10:30:25', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (251, 82, 8, '2025-03-19', '08:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (252, 82, 11, '2025-03-20', '08:30:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (253, 82, 107, '2025-03-21', '08:30:00', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (254, 82, 15, '2025-03-18', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (255, 82, 12, '2025-03-17', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (256, 82, 108, '2025-03-18', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (257, 82, 42, '2025-03-20', '10:30:25', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (258, 82, 237, '2025-03-21', '10:30:25', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 06:48:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (259, 82, 13, '2025-03-20', '10:30:25', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:13:15', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (260, 76, 8, '2025-03-17', '13:30:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (261, 76, 31, '2025-03-18', '15:30:16', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (262, 76, 69, '2025-03-19', '08:30:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:30:02', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (263, 76, 12, '2025-03-20', '08:30:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (264, 76, 42, '2025-03-21', '13:38:15', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (265, 76, 51, '2025-03-19', '13:38:15', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (266, 76, 11, '2025-03-18', '13:38:15', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (267, 76, 13, '2025-03-21', '13:38:15', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 06:39:45', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (268, 73, 14, '2025-03-18', '14:30:00', '2', 'H1', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (269, 73, 10, '2025-03-19', '14:30:00', '2', 'H1', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (270, 73, 12, '2025-03-18', '08:00:00', '2', 'H1', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (271, 73, 42, '2025-03-19', '08:00:00', '2', 'H2', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (272, 73, 11, '2025-03-20', '14:30:00', '2', 'H3', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (273, 73, 13, '2025-03-21', '08:00:00', '2', 'H3', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (274, 73, 837, '2025-03-21', '14:30:00', '2', 'H4', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (275, 46, 10, '2025-03-17', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (276, 46, 9, '2025-03-18', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (277, 46, 8, '2025-03-19', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (278, 46, 520, '2025-03-20', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (279, 46, 11, '2025-03-21', '15:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (280, 46, 522, '2025-03-19', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (281, 46, 525, '2025-03-20', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 07:44:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (282, 94, 818, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (283, 94, 819, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (284, 94, 817, '2025-03-14', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:00:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (285, 44, 10, '2025-03-17', '08:00:00', '2', 'LAB1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (286, 44, 9, '2025-03-18', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (287, 44, 8, '2025-03-19', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (288, 44, 832, '2025-03-20', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (289, 44, 11, '2025-03-21', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (290, 44, 15, '2025-03-18', '10:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (291, 44, 399, '2025-03-18', '02:00:00', '2', 'MASSAGE ROOM', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (292, 44, 375, '2025-03-19', '10:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (293, 44, 397, '2025-03-19', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:04:14', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (294, 37, 766, '2025-03-17', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (295, 37, 8, '2025-03-17', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (296, 37, 10, '2025-03-18', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (297, 37, 399, '2025-03-18', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (298, 37, 12, '2025-03-19', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (299, 37, 398, '2025-03-19', '03:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (300, 37, 13, '2025-03-20', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (301, 37, 7, '2025-03-20', '03:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (302, 37, 375, '2025-03-21', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:38:55', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (303, 90, 790, '2025-03-13', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (304, 90, 793, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (305, 90, 788, '2025-03-14', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (306, 90, 787, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (307, 90, 789, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (308, 90, 791, '2025-03-17', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (309, 90, 792, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (310, 90, 786, '2025-03-18', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 08:53:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (311, 25, 10, '2025-03-17', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (312, 25, 14, '2025-03-18', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (313, 25, 11, '2025-03-19', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (314, 25, 15, '2025-03-19', '02:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (315, 25, 484, '2025-03-20', '02:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (316, 25, 482, '2025-03-21', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (317, 25, 826, '2025-03-20', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:05:28', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (318, 19, 10, '2025-03-18', '08:30:11', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (319, 19, 9, '2025-03-17', '08:30:11', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (320, 19, 8, '2025-03-19', '08:30:11', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (321, 19, 623, '2025-03-20', '08:30:11', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (322, 19, 11, '2025-03-21', '08:30:11', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (323, 19, 15, '2025-03-21', '02:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (324, 19, 2, '2025-03-21', '08:30:11', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (325, 19, 620, '2025-03-21', '10:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:20:36', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (326, 7, 391, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (327, 7, 85, '2025-03-13', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (328, 7, 107, '2025-03-14', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (329, 7, 23, '2025-03-17', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (330, 7, 38, '2025-03-17', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (331, 7, 108, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (332, 7, 96, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (333, 7, 104, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:25:10', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (334, 58, 208, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (335, 58, 14, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (336, 58, 127, '2025-03-14', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (337, 58, 23, '2025-03-17', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (338, 58, 38, '2025-03-18', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (339, 58, 90, '2025-03-18', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (340, 58, 42, '2025-03-19', '08:00:47', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:44:32', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (341, 79, 624, '2025-03-18', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (342, 79, 50, '2025-03-18', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (343, 79, 14, '2025-03-18', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (344, 79, 34, '2025-03-18', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (345, 79, 38, '2025-03-20', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (346, 79, 51, '2025-03-20', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (347, 79, 82, '2025-03-20', '08:00:47', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:50', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (348, 64, 10, '2025-03-11', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (349, 64, 8, '2025-03-12', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (350, 64, 15, '2025-03-13', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (351, 64, 42, '2025-03-14', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (352, 64, 781, '2025-03-15', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (353, 64, 771, '2025-03-17', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (354, 64, 782, '2025-03-19', '08:30:11', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 09:56:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (355, 73, 849, '2025-03-18', '10:00:00', '2', 'WSHP', '50.00', '1.00', '2.00', NULL, 0, '2025-05-06 08:13:18', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (356, 34, 10, '2025-03-11', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (357, 34, 9, '2025-03-10', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (358, 34, 8, '2025-03-12', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (359, 34, 381, '2025-03-13', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (360, 34, 11, '2025-03-14', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (361, 34, 15, '2025-03-17', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (362, 34, 375, '2025-03-18', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (363, 34, 832, '2025-03-19', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (364, 34, 397, '2025-03-19', '09:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:10:17', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (365, 49, 10, '2025-03-18', '08:00:00', '2', 'LAB1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (366, 49, 9, '2025-03-19', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (367, 49, 520, '2025-03-20', '08:00:00', '2', 'WKSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (368, 49, 522, '2025-03-21', '08:00:00', '2', 'WSPHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (369, 49, 525, '2025-03-17', '08:00:00', '2', 'WSHP', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:18:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (370, 85, 551, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (371, 85, 530, '2025-03-18', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (372, 85, 187, '2025-03-31', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (373, 85, 141, '2025-03-19', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (374, 85, 167, '2025-03-19', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (375, 85, 182, '2025-03-20', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (376, 85, 51, '2025-03-20', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (377, 85, 45, '2025-03-20', '08:00:47', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:20:08', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (378, 28, 10, '2025-03-11', '02:00:00', '2', 'HF1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (379, 28, 9, '2025-03-12', '02:00:00', '2', 'HF2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (380, 28, 14, '2025-03-13', '02:00:00', '2', 'HF1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (381, 28, 11, '2025-03-14', '02:00:00', '2', 'HF3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (382, 28, 15, '2025-03-15', '02:00:00', '2', 'HF4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (383, 28, 807, '2025-03-17', '02:00:00', '2', 'HF1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (384, 28, 806, '2025-03-20', '02:00:00', '2', 'GF', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (385, 28, 812, '2025-03-21', '02:00:00', '2', 'GF', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:25:42', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (386, 19, 651, '2025-03-18', '10:00:00', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:27:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (387, 101, 800, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (388, 101, 801, '2025-03-19', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (389, 101, 803, '2025-03-20', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (390, 101, 802, '2025-03-21', '08:00:47', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:35:48', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (391, 31, 10, '2025-03-17', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (392, 31, 8, '2025-03-18', '10:30:00', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (393, 31, 381, '2025-03-19', '12:30:00', '2', 'BODY MASSAGE', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (394, 31, 375, '2025-03-20', '01:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (395, 31, 397, '2025-03-21', '03:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (396, 31, 832, '2025-03-21', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-24 10:37:33', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (397, 61, 10, '2025-03-11', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (398, 61, 9, '2025-03-12', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (399, 61, 14, '2025-03-13', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (400, 61, 11, '2025-03-14', '08:00:00', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (401, 61, 15, '2025-03-10', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (402, 61, 53, '2025-03-18', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (403, 61, 49, '2025-03-20', '02:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-25 05:52:40', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (404, 104, 10, '2025-03-27', '11:17:12', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (405, 104, 28, '2025-03-27', '11:17:14', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (406, 104, 350, '2025-03-27', '11:17:17', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (407, 104, 11, '2025-03-27', '11:17:19', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (408, 104, 107, '2025-03-27', '11:17:21', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (409, 104, 15, '2025-03-27', '11:17:23', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (410, 104, 108, '2025-03-27', '11:17:25', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (411, 104, 42, '2025-03-27', '11:17:27', '1', 'GH1', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 04:18:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (412, 105, 10, '2025-03-27', '11:21:38', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (413, 105, 11, '2025-03-27', '11:21:40', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (414, 105, 8, '2025-03-27', '11:21:41', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (415, 105, 15, '2025-03-27', '11:21:41', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (416, 105, 107, '2025-03-27', '11:21:42', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (417, 105, 108, '2025-03-27', '11:21:42', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (418, 105, 104, '2025-03-27', '11:21:43', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (419, 105, 63, '2025-03-27', '11:21:43', '2', 'GH2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 04:22:51', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (420, 52, 8, '2025-03-11', '08:00:00', '2', 'H1', '70.00', '1.00', '0.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (421, 52, 9, '2025-03-12', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (422, 52, 20, '2025-03-13', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (423, 52, 12, '2025-03-14', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (424, 52, 17, '2025-03-18', '08:00:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (425, 52, 820, '2025-03-19', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (426, 52, 11, '2025-03-20', '08:00:00', '2', 'H4', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (427, 52, 13, '2025-03-21', '08:00:00', '2', 'H5', '70.00', '1.00', '2.00', NULL, 0, '2025-03-27 05:15:52', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (428, 106, 381, '2025-02-10', '08:00:00', '01', 'BEATY WORKSHOP', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (429, 106, 397, '2025-03-11', '08:00:00', '01', 'BEATU WORKSHOP', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (430, 106, 590, '2025-03-12', '08:00:00', '01', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (431, 106, 23, '2025-03-12', '08:00:00', '01', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (432, 106, 38, '2025-03-13', '10:00:00', '01', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (433, 106, 28, '2025-03-14', '08:00:00', '01', '2F H4', '30.00', '1.00', '1.00', NULL, 0, '2025-03-27 05:22:58', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (434, 70, 769, '2025-02-10', '14:00:00', '01', 'WSP', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (435, 70, 295, '2025-02-11', '14:30:00', '01', 'TDR', '70.00', '1.00', '1.00', NULL, 0, '2025-05-06 04:26:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (436, 67, 41, '2025-03-11', '08:00:00', '2.0', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (437, 58, 41, '2025-03-14', '14:00:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 04:34:03', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (438, 67, 707, '2025-03-11', '08:00:00', '2.0', 'TDR', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (439, 67, 329, '2025-03-11', '10:30:00', '2.0', 'E.WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (440, 67, 90, '2025-03-11', '01:30:00', '2.0', 'E.WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 05:54:43', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (441, 82, 768, '2025-03-21', '14:00:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 06:48:34', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (442, 108, 165, '2025-03-11', '08:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (443, 108, 174, '2025-03-14', '10:30:00', '2', 'WSP', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (444, 108, 171, '2025-03-15', '01:30:00', '2', 'H2', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (445, 108, 240, '2025-03-17', '08:00:00', '2', 'H3', '70.00', '1.00', '2.00', NULL, 0, '2025-05-06 07:38:07', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (446, 107, 10, '2025-03-11', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (447, 107, 9, '2025-03-12', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (448, 107, 8, '2025-03-13', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (449, 107, 58, '2025-03-14', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (450, 107, 15, '2025-03-17', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (451, 107, 832, '2025-03-18', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (452, 107, 397, '2025-03-19', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (453, 107, 377, '2025-03-20', '08:30:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (454, 107, 375, '2025-03-20', '14:00:00', '2', 'H1', '70.00', '1.00', '2.00', NULL, 0, '2025-05-08 04:25:20', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `exam_group_class_batch_exams`;

CREATE TABLE `exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(250) DEFAULT NULL,
  `passing_percentage` float(10,2) DEFAULT NULL,
  `session_id` int(10) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `exam_group_id` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(1) NOT NULL DEFAULT 1,
  `is_publish` int(1) DEFAULT 0,
  `is_rank_generated` int(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_ibfk_2` (`session_id`),
  CONSTRAINT `exam_group_class_batch_exams_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exams_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'CDACC FORMATIVE EXAM BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 1, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-22 06:23:20', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'CDACC SUMMATIVE EXAM BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:11:12', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'CDACC PRACTICAL ASSESSMENT BF6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:11:22', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'CAT-DCE/S/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:04', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'END TERM-DCE/S/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:50:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'CDACC FORMATIVE EXAM BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 17:21:28', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'CDACC SUMATTIVE  EXAM BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 17:21:44', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'CDACC PRACTICAL ASSESSMENT BTECH6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 17:22:00', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'MS WORD', NULL, 20, NULL, NULL, 3, 1, 0, 0, 'Microsoft Word Examination', 1, '2025-02-21 12:59:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'COMMUNICATION SKILLS', NULL, 20, NULL, NULL, 3, 1, 1, 1, 'COMM SKILLS', 1, '2025-02-21 14:45:39', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'MS EXCEL', NULL, 20, NULL, NULL, 3, 1, 1, 0, 'Microsoft Excel', 1, '2025-02-21 14:17:40', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'CDACC FORMATIVE EXAM CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:13:54', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'CDACC SUMMATIVE EXAM CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam\r\n', 1, '2025-02-28 01:14:38', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'CDACC PRACTICAL ASSESSMENT CMR4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:23:38', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'CDACC FORMATIVE EXAM ITECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:14:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'CDACC SUMMATIVE EXAM ITECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:15:31', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'CDACC PRACTICAL ASSESSMENT ITECH 5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:23:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'CDACC FORMATIVE EXAM ITECH6 /S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:37:32', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'CDACC SUMMATIVE EXAM ITECH6/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:37:47', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'CDACC PRACTICAL ASSESSMENT ITECH6 /S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-28 01:38:06', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'CDACC FORMATIVE EXAM ADM5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:16:13', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'CDACC SUMMATIVE EXAM BM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:16:29', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'CDACC PRACTICAL ASSESSMENTBM5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:21:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'CDACC FORMATIVE EXAM BM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 17:20:31', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'CDACC SUMMATIVE EXAM ADM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:19:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'CDACC PRACTICAL ASSESSMENT ADM5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:21:17', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'CDACC FORMATIVE EXAM BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:16:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CDACC SUMMATIVE EXAM BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-03-24 09:46:02', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'CDACC PRACTICAL ASSESSMENT BTG3/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:20:54', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'CDACC FORMATIVE EXAM BT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:17:04', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'CDACC SUMMATIVE EXAM BT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam\r\n', 1, '2025-02-28 01:17:42', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'CDACC PRACTICAL ASSESSMENT BT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 07:55:12', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'CDAAC FORMATIVE EXAM BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-24 06:20:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'CDACC SUMMATIVE EXAm BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:17:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'CDACC PRACTICAL ASSESSMENT BT4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units\r\n', 1, '2025-02-24 06:20:03', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'CDACC FORMATIVE EXAM HBT M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:17:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'CDAAC SUMMATIVE EXAM HBT/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:19:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'CDACC PRACTICAL ASSESSMENT HBT/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:19:42', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'CDACC FORMATIVE EXAM BT6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:11', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'CDACC PRACTICAL ASSESSMENT BT6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:19:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'CDACC SUMMATIVE EXAM BT6/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-28 01:18:45', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'CDACC FORMATIVE EXAM FDT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'CDACC SUMMATIVE EXAM FDT5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:19', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'CDACC PRACTICAL ASSESSMENT FDT5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'CDACC FORMATIVE EXAM FDT4/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:18:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'CDACC SUMMATIVE EXAM FDT4 /25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:27:18', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'CDACC PRACTICAL ASSESSMENT FDT4 /J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'CDACC FORMATIVE EXAM SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:19:53', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'CDACC SUMMATIVE EXAM SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:34', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'CDACC PRACTICAL ASSESSMENT SARD5/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:16:23', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'CDACC FORMATIVE EXAM BAKE4/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:03', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'CDACC FORMATIVE EXAM BAKE4/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:20:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'CDACC PRACTICAL ASSESSMENT BAKE4/ M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:09', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'CDACC FORMATIVE EXAM EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:27:04', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'CDACC SUMMATIVE EXAM EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:21:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'CDACC PRACTICAL ASSESSMENT EL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:18:16', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'CDACC FORMATIVE EXAM AGR.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:21:49', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'CDACC SUMMATIVE EXAM AGRI.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:26:16', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'CDACC PRACTICAL ASSESSMENT AGRI.E6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:17:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'CDACC FORMATIVE EXAM WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:17', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'CDACC SUMMATIVE EXAM WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:23:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'CDACC PRACTICAL ASSESSMENT WLD4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:10', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'CDACC FORMATIVE EXAM EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:22:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'CDACC SUMMATIVE EXAM EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:22:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'CDACC PRACTICAL ASSESSMENT EL6/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:15:05', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'CDACC FORMATIVE EXAM AUTO6/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:02', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'CDACC SUMMATIVE EXAM AUTO6/M24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:24:08', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'CDACC PRACTICAL ASSESSMENT AUTO6/MS24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:17:21', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'CDACC FORMATIVE EXAM AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'CDACC SUMMATIVE EXAM AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:26:45', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'CDACC PRACTICAL ASSESSMENT AUTO4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:40', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'CDACC FORMATIVE EXAM PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:23:26', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'CDACC SUMMATIVE EXAM PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:23:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'CDACC PRACTICAL ASSESSMENT PL4/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'CDACC FORMATIVE EXAM PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:24:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'CDACC SUMMATIVE EXAM PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:24:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'CDACC PRACTICAL ASSESSMENT PL4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:12:58', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'CDACC FORMATIVE EXAM BTECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:25:19', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'CDACC SUMMATIVE EXAM BTECH5/ J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-28 01:25:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'CDACC PRACTICAL ASSESSMENT BTECH5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:13:07', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'CDACC FORMATIVE EXAM PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-02-28 01:25:59', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'CDACC SUMMATIVE EXAM PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-02-24 06:15:56', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'CDACC PRACTICAL ASSESSMENT PL5/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Students should at least four practical assessments for all core units', 1, '2025-02-24 06:13:21', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'CAT-CBTS23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:20', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'END TERM-CBTS23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:52', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'CAT-CEEM23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:30', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'END TERM-CEEM23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:41', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'CAT CAE-J-23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 06:06:53', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'END TERM CAE-J-23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:50:15', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'CAT-CCA/S/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 07:13:06', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'END TERM EXAM-CCA/S23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-03 07:13:24', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'CDACC FORMATIVE EXAM AUTO 6/S24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:34:46', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'CDACC SUMMATIVE EXAM BAKE4/M/24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:35:57', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'CDACC SUMMATIVE EXAM ADM5/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:36:51', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'CDACC FORMATIVE EXAM- HD4/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:39:52', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'CDACC SUMMATIVE EXAM-HD4/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-24 09:39:36', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'CAT-DPM/M/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:22', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'ENDTERM-DPM/M/23', NULL, 20, NULL, NULL, 2, 1, 1, 0, '', 1, '2025-03-24 09:49:13', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'END TERM- BTG3/J/25', NULL, 20, NULL, NULL, 4, 1, 1, 0, '', 1, '2025-03-24 09:54:37', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'END TERM- BTG3/J/25', NULL, 20, NULL, NULL, 4, 1, 1, 0, '', 1, '2025-03-24 09:54:48', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'CDACC FORMATIVE EXAM- BTECH6/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-27 04:12:01', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'CDACC SUMMATIVE-BTECH6/J/25', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-03-27 04:12:35', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'CDAAC FORMATIVE EXAM BT4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'CAT exam is set out of 30 marks. Student should sit for at least 3 formative exam before doing final exam. ', 1, '2025-03-27 05:06:33', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'CDAAC SUMMATIVE EXAM BT4/J25', NULL, 20, NULL, NULL, 1, 1, 1, 0, 'Done at the end of semester. Student should do at least 3 summative exam', 1, '2025-03-27 05:06:14', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'AUTO6\\S\\24', NULL, 20, NULL, NULL, 1, 1, 1, 0, '', 1, '2025-05-06 07:00:16', NULL);


#
# TABLE STRUCTURE FOR: exam_group_exam_connections
#

DROP TABLE IF EXISTS `exam_group_exam_connections`;

CREATE TABLE `exam_group_exam_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `exam_weightage` float(10,2) DEFAULT 0.00,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  CONSTRAINT `exam_group_exam_connections_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_connections_ibfk_2` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_exam_results
#

DROP TABLE IF EXISTS `exam_group_exam_results`;

CREATE TABLE `exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) DEFAULT NULL,
  `exam_group_student_id` int(11) DEFAULT NULL,
  `attendence` varchar(10) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  CONSTRAINT `exam_group_exam_results_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_subject_id`) REFERENCES `exam_group_class_batch_exam_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_2` FOREIGN KEY (`exam_group_student_id`) REFERENCES `exam_group_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_3` FOREIGN KEY (`exam_group_class_batch_exam_student_id`) REFERENCES `exam_group_class_batch_exam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=562 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1, 25, 10, NULL, 'present', '20.00', '', 0, '2025-02-21 13:55:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2, 26, 10, NULL, 'present', '15.00', '', 0, '2025-02-21 13:55:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (3, 27, 10, NULL, 'present', '22.00', '', 0, '2025-02-21 13:55:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (4, 29, 10, NULL, 'present', '26.00', '', 0, '2025-02-21 13:55:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (5, 28, 10, NULL, 'present', '24.00', '', 0, '2025-02-21 13:55:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (6, 35, 10, NULL, 'present', '24.00', 'Well done', 0, '2025-02-21 15:04:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (7, 69, 103, NULL, 'present', '26.00', 'MASTERY', 0, '2025-02-27 07:57:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (8, 75, 79, NULL, 'present', '16.00', '', 0, '2025-02-27 13:32:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (9, 63, 19, NULL, 'present', '17.00', 'PASS', 0, '2025-02-28 02:37:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (10, 63, 20, NULL, 'present', '18.00', 'Pass', 0, '2025-02-28 02:35:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (12, 65, 31, NULL, 'present', '27.00', 'PASS ', 0, '2025-02-28 02:40:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (13, 64, 31, NULL, 'absent', NULL, '', 0, '2025-02-28 02:30:29', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (14, 75, 123, NULL, 'present', '21.00', 'COMPETENT', 0, '2025-02-28 02:21:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (15, 75, 124, NULL, 'present', '23.00', 'COMPETENT', 0, '2025-02-28 02:22:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (16, 65, 28, NULL, 'present', '18.00', 'PASS', 0, '2025-02-28 02:45:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (17, 64, 28, NULL, 'absent', NULL, '', 0, '2025-02-28 02:28:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (18, 14, 3, NULL, 'present', '21.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (19, 1, 3, NULL, 'present', '24.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (20, 12, 3, NULL, 'present', '28.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (21, 13, 3, NULL, 'present', '12.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (22, 15, 3, NULL, 'present', '20.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (23, 16, 3, NULL, 'present', '18.00', '', 0, '2025-02-28 02:35:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (24, 65, 32, NULL, 'present', '27.00', 'PASS', 0, '2025-02-28 02:43:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (25, 64, 32, NULL, 'absent', NULL, '', 0, '2025-02-28 02:43:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (26, 14, 7, NULL, 'present', '22.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (27, 1, 7, NULL, 'present', '21.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (28, 12, 7, NULL, 'present', '23.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (29, 13, 7, NULL, 'present', '21.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (30, 15, 7, NULL, 'present', '17.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (31, 16, 7, NULL, 'present', '21.00', '', 0, '2025-02-28 02:56:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (32, 78, 60, NULL, 'present', '21.00', '', 0, '2025-02-28 05:22:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (33, 78, 59, NULL, 'present', '21.00', '', 0, '2025-02-28 05:23:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (34, 63, 23, NULL, 'present', '5.00', '', 0, '2025-02-28 06:56:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (35, 69, 136, NULL, 'present', '14.00', 'COMPETITITVE STEDENTS', 0, '2025-02-28 06:57:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (36, 87, 143, NULL, 'present', '13.00', 'AVERAGE STUDENT', 0, '2025-02-28 07:15:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (37, 87, 141, NULL, 'present', '23.00', 'COMPITENT STUDENT', 0, '2025-02-28 07:07:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (38, 69, 141, NULL, 'present', '23.00', 'VERY COMPETITIVE STUDENT', 0, '2025-02-28 07:07:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (39, 87, 138, NULL, 'present', '16.00', 'COMPETITIVE STUDENT', 0, '2025-02-28 07:09:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (40, 87, 137, NULL, 'present', '14.00', '', 0, '2025-03-30 02:25:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (41, 69, 138, NULL, 'present', '25.00', 'VERY COMPETITIVE STUDENT', 0, '2025-02-28 07:10:34', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (42, 82, 117, NULL, 'present', '8.00', '', 0, '2025-02-28 07:13:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (43, 69, 143, NULL, 'present', '22.00', 'VERY COMPETITVE STUDENT', 0, '2025-02-28 07:14:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (44, 63, 24, NULL, 'present', '15.00', '', 0, '2025-02-28 07:22:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (45, 74, 84, NULL, 'present', '22.00', '', 0, '2025-02-28 07:37:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (46, 286, 188, NULL, 'absent', NULL, '', 0, '2025-02-28 09:19:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (47, 11, 188, NULL, 'present', '20.00', '', 0, '2025-02-28 09:19:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (48, 286, 180, NULL, 'absent', NULL, '', 0, '2025-02-28 09:21:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (49, 11, 180, NULL, 'present', '19.00', '', 0, '2025-02-28 09:21:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (50, 286, 186, NULL, 'absent', NULL, '', 0, '2025-02-28 09:22:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (51, 11, 186, NULL, 'present', '19.00', '', 0, '2025-02-28 09:22:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (52, 286, 187, NULL, 'absent', NULL, '', 0, '2025-02-28 09:24:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (53, 11, 187, NULL, 'present', '20.00', '', 0, '2025-02-28 09:24:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (54, 286, 178, NULL, 'absent', NULL, '', 0, '2025-02-28 09:24:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (55, 11, 178, NULL, 'present', '26.00', '', 0, '2025-02-28 09:24:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (56, 90, 194, NULL, 'present', '18.00', '', 0, '2025-02-28 09:26:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (57, 91, 194, NULL, 'present', '21.00', '', 0, '2025-02-28 09:26:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (58, 90, 192, NULL, 'present', '17.00', '', 0, '2025-02-28 09:27:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (59, 91, 192, NULL, 'present', '20.00', '', 0, '2025-02-28 09:27:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (60, 90, 193, NULL, 'present', '29.00', '', 0, '2025-02-28 11:54:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (61, 91, 193, NULL, 'present', '28.50', '', 0, '2025-02-28 11:54:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (62, 90, 195, NULL, 'present', '30.00', '', 0, '2025-02-28 11:56:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (63, 91, 195, NULL, 'present', '30.00', '', 0, '2025-02-28 11:56:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (64, 286, 177, NULL, 'absent', NULL, '', 0, '2025-03-02 06:27:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (65, 11, 177, NULL, 'present', '13.00', '', 0, '2025-03-02 06:27:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (66, 286, 179, NULL, 'absent', NULL, '', 0, '2025-03-02 06:28:06', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (67, 11, 179, NULL, 'present', '16.00', '', 0, '2025-03-02 06:28:06', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (68, 286, 183, NULL, 'absent', NULL, '', 0, '2025-03-02 06:28:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (69, 11, 183, NULL, 'present', '18.00', '', 0, '2025-03-02 06:28:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (70, 90, 191, NULL, 'present', '17.00', '', 0, '2025-03-02 06:30:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (71, 91, 191, NULL, 'present', '15.00', '', 0, '2025-03-02 06:30:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (72, 94, 201, NULL, 'present', '18.00', '', 0, '2025-03-02 06:32:11', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (73, 95, 201, NULL, 'present', '16.00', '', 0, '2025-03-02 06:32:11', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (74, 14, 2, NULL, 'present', '23.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (75, 1, 2, NULL, 'present', '22.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (76, 12, 2, NULL, 'present', '24.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (77, 13, 2, NULL, 'present', '24.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (78, 15, 2, NULL, 'present', '21.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (79, 16, 2, NULL, 'present', '18.00', 'COMPETENT', 0, '2025-03-30 06:56:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (80, 18, 172, NULL, 'present', '18.00', '', 0, '2025-03-02 06:41:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (81, 17, 172, NULL, 'present', '20.00', '', 0, '2025-03-02 06:41:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (82, 18, 171, NULL, 'present', '23.00', '', 0, '2025-03-02 06:42:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (83, 17, 171, NULL, 'present', '15.00', '', 0, '2025-03-02 06:42:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (84, 86, 134, NULL, 'present', '20.00', 'COMPETENT', 0, '2025-03-03 05:32:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (85, 85, 134, NULL, 'present', '16.00', 'COMPETENT', 0, '2025-03-03 05:32:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (86, 286, 181, NULL, 'absent', NULL, '', 0, '2025-03-03 05:40:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (87, 11, 181, NULL, 'present', '26.00', 'V.GOOD', 0, '2025-03-03 05:40:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (88, 286, 184, NULL, 'absent', NULL, '', 0, '2025-03-03 07:10:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (89, 11, 184, NULL, 'present', '21.00', 'GOOD', 0, '2025-03-03 07:10:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (90, 76, 74, NULL, 'present', '24.00', '', 0, '2025-03-03 10:44:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (91, 77, 74, NULL, 'present', '24.00', '', 0, '2025-03-03 10:44:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (92, 76, 75, NULL, 'present', '26.00', '', 0, '2025-03-03 10:45:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (93, 77, 75, NULL, 'present', '24.00', '', 0, '2025-03-03 10:45:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (94, 295, 205, NULL, 'present', '19.00', '', 0, '2025-03-04 00:32:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (95, 295, 207, NULL, 'present', '27.00', '', 0, '2025-03-04 00:33:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (96, 295, 208, NULL, 'present', '24.00', '', 0, '2025-03-04 00:33:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (97, 94, 196, NULL, 'present', '19.00', '', 0, '2025-03-04 07:09:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (98, 95, 196, NULL, 'present', '14.00', '', 0, '2025-03-04 07:09:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (99, 94, 197, NULL, 'present', '22.00', '', 0, '2025-03-04 07:22:27', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (100, 95, 197, NULL, 'present', '19.00', '', 0, '2025-03-04 07:22:27', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (101, 94, 199, NULL, 'present', '21.00', '', 0, '2025-03-04 07:23:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (102, 95, 199, NULL, 'present', '23.00', '', 0, '2025-03-04 07:23:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (103, 94, 202, NULL, 'present', '16.00', '', 0, '2025-03-04 07:24:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (104, 95, 202, NULL, 'present', '17.00', '', 0, '2025-03-04 07:24:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (105, 94, 203, NULL, 'present', '24.00', '', 0, '2025-03-04 07:25:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (106, 95, 203, NULL, 'present', '4.00', '', 0, '2025-03-04 07:25:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (107, 94, 204, NULL, 'present', '24.00', '', 0, '2025-03-04 07:26:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (108, 95, 204, NULL, 'present', '24.00', '', 0, '2025-03-04 07:26:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (109, 286, 176, NULL, 'absent', NULL, '', 0, '2025-03-04 07:30:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (110, 11, 176, NULL, 'present', '14.00', '', 0, '2025-03-04 07:30:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (111, 286, 182, NULL, 'absent', NULL, '', 0, '2025-03-04 07:33:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (112, 11, 182, NULL, 'present', '23.00', '', 0, '2025-03-04 07:33:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (113, 74, 209, NULL, 'present', '29.00', 'VERY COMPETENT STUDENT', 0, '2025-03-04 07:40:06', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (114, 82, 210, NULL, 'present', '14.00', 'THE STUDENTS IS COMPETITIVETI', 0, '2025-03-04 08:09:01', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (115, 82, 211, NULL, 'present', '13.00', 'THE STUDENT IS COMPETIVE', 0, '2025-03-04 08:10:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (116, 292, 212, NULL, 'present', '13.00', 'COMPETITIVE ', 0, '2025-03-04 08:14:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (117, 293, 212, NULL, 'present', '12.00', 'COMPETITIVE ', 0, '2025-03-04 08:14:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (118, 294, 212, NULL, 'present', '19.00', 'COMPETITIVE ', 0, '2025-03-04 08:14:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (119, 76, 73, NULL, 'present', '19.00', '', 0, '2025-03-05 13:00:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (120, 77, 73, NULL, 'present', '0.00', 'not done', 0, '2025-03-05 13:00:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (121, 74, 86, NULL, 'present', '22.00', '', 0, '2025-03-05 13:10:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (122, 84, 152, NULL, 'present', '21.00', '', 0, '2025-03-05 13:12:29', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (123, 80, 114, NULL, 'present', '24.00', '', 0, '2025-03-05 13:16:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (124, 81, 114, NULL, 'absent', NULL, '', 0, '2025-03-05 13:16:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (125, 49, 11, NULL, 'absent', NULL, '', 0, '2025-03-05 13:59:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (126, 50, 11, NULL, 'present', '23.00', '', 0, '2025-03-05 13:59:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (127, 51, 11, NULL, 'absent', NULL, '', 0, '2025-03-05 13:59:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (128, 48, 11, NULL, 'absent', NULL, '', 0, '2025-03-05 13:59:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (129, 292, 69, NULL, 'present', '13.00', '', 0, '2025-03-05 14:06:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (130, 293, 69, NULL, 'present', '16.00', '', 0, '2025-03-05 14:06:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (131, 294, 69, NULL, 'present', '20.00', '', 0, '2025-03-05 14:06:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (132, 268, 144, NULL, 'present', '24.00', '', 0, '2025-03-05 14:10:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (133, 61, 18, NULL, 'present', '28.00', '', 0, '2025-03-06 01:46:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (134, 62, 18, NULL, 'present', '28.00', '', 0, '2025-03-06 01:46:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (135, 61, 16, NULL, 'present', '26.00', '', 0, '2025-03-06 01:48:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (136, 62, 16, NULL, 'present', '28.00', '', 0, '2025-03-06 01:48:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (137, 14, 5, NULL, 'present', '25.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (138, 1, 5, NULL, 'present', '21.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (139, 12, 5, NULL, 'present', '29.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (140, 13, 5, NULL, 'present', '22.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (141, 15, 5, NULL, 'present', '21.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (142, 16, 5, NULL, 'present', '24.00', '', 0, '2025-03-17 03:23:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (143, 14, 8, NULL, 'present', '26.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (144, 1, 8, NULL, 'present', '26.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (145, 12, 8, NULL, 'present', '27.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (146, 13, 8, NULL, 'present', '25.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (147, 15, 8, NULL, 'present', '26.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (148, 16, 8, NULL, 'present', '26.00', '', 0, '2025-03-17 03:25:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (149, 49, 161, NULL, 'present', '20.00', '', 0, '2025-03-17 07:58:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (150, 50, 161, NULL, 'present', '15.00', '', 0, '2025-03-17 07:58:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (151, 51, 161, NULL, 'present', '24.00', '', 0, '2025-03-17 07:58:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (152, 48, 161, NULL, 'present', '19.00', '', 0, '2025-03-17 07:58:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (153, 84, 155, NULL, 'present', '18.00', '', 0, '2025-03-17 08:00:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (154, 61, 150, NULL, 'present', '29.00', '', 0, '2025-03-17 08:04:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (155, 62, 150, NULL, 'present', '20.00', '', 0, '2025-03-17 08:04:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (156, 268, 145, NULL, 'present', '15.00', '', 0, '2025-03-30 15:45:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (157, 301, 274, NULL, 'present', '28.00', 'COMPETENT', 0, '2025-05-06 07:48:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (158, 301, 355, NULL, 'present', '28.00', 'IDEAL AND HARD WORKING STUDENT', 0, '2025-03-27 03:24:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (159, 78, 61, NULL, 'present', '20.00', '', 0, '2025-03-27 04:20:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (160, 268, 13, NULL, 'present', '23.00', '', 0, '2025-03-27 04:28:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (161, 268, 12, NULL, 'present', '21.00', '', 0, '2025-03-27 04:28:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (162, 268, 15, NULL, 'present', '27.00', '', 0, '2025-03-27 04:30:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (163, 324, 359, NULL, 'present', '51.00', 'PASS', 0, '2025-05-09 07:07:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (164, 323, 359, NULL, 'present', '40.00', 'PASS', 0, '2025-05-09 07:07:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (165, 324, 363, NULL, 'present', '66.00', 'PASS', 0, '2025-03-27 04:35:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (166, 323, 363, NULL, 'present', '69.00', 'PASS', 0, '2025-03-27 04:35:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (167, 324, 364, NULL, 'present', '50.00', 'PASS', 0, '2025-05-09 07:10:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (168, 323, 364, NULL, 'present', '53.00', 'PASS', 0, '2025-05-09 07:10:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (169, 306, 291, NULL, 'absent', NULL, '', 0, '2025-03-27 04:41:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (170, 307, 291, NULL, 'absent', NULL, '', 0, '2025-03-27 04:41:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (171, 305, 291, NULL, 'present', '70.00', 'PASS', 0, '2025-03-27 04:41:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (172, 306, 292, NULL, 'absent', NULL, '', 0, '2025-03-27 04:42:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (173, 307, 292, NULL, 'absent', NULL, '', 0, '2025-03-27 04:42:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (174, 305, 292, NULL, 'present', '70.00', 'PASS', 0, '2025-03-27 04:42:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (175, 306, 293, NULL, 'absent', NULL, '', 0, '2025-03-27 04:43:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (176, 307, 293, NULL, 'absent', NULL, '', 0, '2025-03-27 04:43:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (177, 305, 293, NULL, 'present', '51.00', 'PASS', 0, '2025-03-27 04:43:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (178, 308, 297, NULL, 'present', '38.00', 'PASS', 0, '2025-05-09 07:28:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (179, 308, 302, NULL, 'present', '27.00', 'PASS', 0, '2025-05-09 07:30:37', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (180, 308, 299, NULL, 'present', '18.00', 'PASS', 0, '2025-05-09 07:29:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (181, 68, 41, NULL, 'present', '28.00', 'PASS', 0, '2025-03-27 05:02:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (182, 80, 110, NULL, 'present', '22.00', '', 0, '2025-03-27 05:38:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (183, 81, 110, NULL, 'absent', NULL, '', 0, '2025-03-27 05:38:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (184, 74, 83, NULL, 'present', '17.00', '', 0, '2025-03-27 06:13:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (185, 292, 68, NULL, 'present', '7.00', '', 0, '2025-03-27 06:42:21', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (186, 293, 68, NULL, 'present', '15.00', '', 0, '2025-03-27 06:42:21', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (187, 294, 68, NULL, 'present', '19.00', '', 0, '2025-03-27 06:42:21', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (188, 334, 92, NULL, 'present', '14.00', '', 0, '2025-03-27 06:46:36', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (189, 334, 93, NULL, 'present', '18.00', '', 0, '2025-03-27 06:47:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (190, 292, 67, NULL, 'present', '6.00', '', 0, '2025-03-27 07:48:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (191, 293, 67, NULL, 'present', '12.00', '', 0, '2025-03-27 07:48:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (192, 294, 67, NULL, 'present', '25.00', '', 0, '2025-03-27 07:48:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (193, 96, 305, NULL, 'present', '50.00', '', 0, '2025-03-27 09:09:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (194, 97, 305, NULL, 'present', '34.00', '', 0, '2025-03-27 09:09:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (195, 96, 304, NULL, 'present', '46.00', '', 0, '2025-03-27 09:10:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (196, 97, 304, NULL, 'present', '39.00', '', 0, '2025-03-27 09:10:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (197, 96, 303, NULL, 'present', '58.00', '', 0, '2025-03-27 09:22:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (198, 97, 303, NULL, 'present', '34.00', '', 0, '2025-03-27 09:22:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (200, 89, 221, NULL, 'present', '47.00', '', 0, '2025-03-27 09:44:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (202, 89, 226, NULL, 'present', '37.00', '', 0, '2025-03-27 09:47:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (203, 94, 198, NULL, 'present', '18.00', '', 0, '2025-03-28 05:27:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (204, 95, 198, NULL, 'present', '23.00', '', 0, '2025-03-28 05:27:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (205, 94, 200, NULL, 'present', '18.00', '', 0, '2025-03-28 05:28:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (206, 95, 200, NULL, 'present', '12.00', '', 0, '2025-03-28 05:28:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (207, 90, 189, NULL, 'present', '21.00', '', 0, '2025-03-28 05:32:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (208, 91, 189, NULL, 'present', '21.00', '', 0, '2025-03-28 05:32:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (209, 304, 282, NULL, 'present', '59.00', '', 0, '2025-03-28 07:51:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (210, 304, 283, NULL, 'present', '43.00', '', 0, '2025-03-28 07:52:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (211, 84, 154, NULL, 'present', '15.00', '', 0, '2025-03-29 04:53:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (212, 316, 58, NULL, 'present', '15.00', '', 0, '2025-03-30 02:15:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (213, 316, 53, NULL, 'present', '22.00', '', 0, '2025-03-30 02:17:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (214, 14, 4, NULL, 'present', '16.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (215, 1, 4, NULL, 'present', '14.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (216, 12, 4, NULL, 'present', '20.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (217, 13, 4, NULL, 'present', '15.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (218, 15, 4, NULL, 'present', '25.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (219, 16, 4, NULL, 'present', '22.00', '', 0, '2025-03-30 13:57:25', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (220, 14, 6, NULL, 'present', '23.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (221, 1, 6, NULL, 'present', '19.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (222, 12, 6, NULL, 'present', '20.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (223, 13, 6, NULL, 'present', '19.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (224, 15, 6, NULL, 'present', '26.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (225, 16, 6, NULL, 'present', '22.00', '', 0, '2025-03-30 14:03:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (226, 76, 71, NULL, 'present', '24.00', '', 0, '2025-03-30 14:07:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (227, 77, 71, NULL, 'present', '21.00', '', 0, '2025-03-30 14:07:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (228, 76, 72, NULL, 'present', '22.00', '', 0, '2025-03-30 14:10:13', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (229, 77, 72, NULL, 'present', '18.00', '', 0, '2025-03-30 14:10:13', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (230, 86, 135, NULL, 'present', '29.00', '', 0, '2025-03-30 14:19:06', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (231, 85, 135, NULL, 'present', '5.00', '', 0, '2025-03-30 14:19:06', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (232, 86, 126, NULL, 'present', '28.00', '', 0, '2025-03-30 14:21:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (233, 85, 126, NULL, 'present', '7.00', '', 0, '2025-03-30 14:21:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (234, 86, 131, NULL, 'present', '20.00', '', 0, '2025-03-30 14:24:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (235, 85, 131, NULL, 'present', '9.00', '', 0, '2025-03-30 14:24:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (236, 292, 65, NULL, 'present', '3.00', '', 0, '2025-03-30 14:34:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (237, 293, 65, NULL, 'present', '4.00', '', 0, '2025-03-30 14:34:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (238, 294, 65, NULL, 'present', '17.00', '', 0, '2025-03-30 14:34:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (239, 292, 70, NULL, 'present', '14.00', '', 0, '2025-03-30 14:35:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (240, 293, 70, NULL, 'present', '12.00', '', 0, '2025-03-30 14:35:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (241, 294, 70, NULL, 'present', '20.00', '', 0, '2025-03-30 14:35:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (242, 74, 82, NULL, 'present', '9.00', '', 0, '2025-03-30 14:39:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (243, 271, 33, NULL, 'absent', NULL, '', 0, '2025-03-30 14:45:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (244, 272, 33, NULL, 'absent', NULL, '', 0, '2025-03-30 14:45:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (245, 270, 33, NULL, 'present', '11.00', '', 0, '2025-03-30 14:45:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (246, 271, 34, NULL, 'absent', NULL, '', 0, '2025-03-30 14:47:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (247, 272, 34, NULL, 'absent', NULL, '', 0, '2025-03-30 14:47:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (248, 270, 34, NULL, 'present', '20.00', '', 0, '2025-03-30 14:47:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (249, 274, 29, NULL, 'absent', NULL, '', 0, '2025-03-30 14:52:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (250, 273, 29, NULL, 'absent', NULL, '', 0, '2025-03-30 14:52:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (251, 65, 29, NULL, 'present', '13.00', '', 0, '2025-03-30 14:52:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (252, 64, 29, NULL, 'absent', NULL, '', 0, '2025-03-30 14:52:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (253, 274, 26, NULL, 'absent', NULL, '', 0, '2025-03-30 14:56:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (254, 273, 26, NULL, 'absent', NULL, '', 0, '2025-03-30 14:56:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (255, 65, 26, NULL, 'present', '18.00', '', 0, '2025-03-30 14:56:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (256, 64, 26, NULL, 'absent', NULL, '', 0, '2025-03-30 14:56:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (257, 337, 432, NULL, 'present', '21.00', '', 0, '2025-03-30 15:00:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (258, 338, 432, NULL, 'present', '19.00', '', 0, '2025-03-30 15:00:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (259, 61, 149, NULL, 'present', '13.00', '', 0, '2025-03-30 15:15:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (260, 62, 149, NULL, 'absent', NULL, '', 0, '2025-03-30 15:15:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (261, 61, 151, NULL, 'present', '17.00', '', 0, '2025-03-30 15:19:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (262, 62, 151, NULL, 'present', '18.00', '', 0, '2025-03-30 15:39:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (263, 75, 80, NULL, 'present', '16.00', '', 0, '2025-03-30 15:22:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (264, 75, 78, NULL, 'present', '6.00', '', 0, '2025-03-30 15:24:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (265, 80, 112, NULL, 'present', '12.00', '', 0, '2025-03-30 15:29:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (266, 81, 112, NULL, 'absent', NULL, '', 0, '2025-03-30 15:29:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (267, 80, 115, NULL, 'present', '9.00', '', 0, '2025-03-30 15:31:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (268, 81, 115, NULL, 'present', '17.00', '', 0, '2025-03-30 15:31:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (269, 67, 44, NULL, 'present', '8.00', '', 0, '2025-03-30 15:36:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (270, 66, 44, NULL, 'present', '14.00', '', 0, '2025-03-30 15:36:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (271, 268, 146, NULL, 'present', '19.00', '', 0, '2025-03-30 15:43:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (272, 268, 14, NULL, 'present', '13.00', '', 0, '2025-03-30 15:57:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (273, 315, 348, NULL, 'present', '47.00', '', 0, '2025-03-31 15:30:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (274, 285, 168, NULL, 'present', '30.00', '', 0, '2025-03-31 15:35:36', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (275, 289, 334, NULL, 'present', '21.00', '', 0, '2025-05-06 08:34:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (276, 290, 334, NULL, 'present', '34.00', '', 0, '2025-03-31 15:49:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (277, 291, 334, NULL, 'present', '35.00', '', 0, '2025-05-06 08:34:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (278, 314, 321, NULL, 'present', '45.00', '', 0, '2025-03-31 15:54:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (279, 86, 125, NULL, 'present', '26.00', '', 0, '2025-03-31 15:57:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (280, 85, 125, NULL, 'present', '20.00', '', 0, '2025-03-31 15:57:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (281, 299, 249, NULL, 'present', '59.00', '', 0, '2025-03-31 16:08:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (282, 298, 249, NULL, 'present', '30.00', '', 0, '2025-03-31 16:08:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (283, 89, 222, NULL, 'present', '40.00', 'work hard', 0, '2025-04-01 05:57:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (284, 89, 223, NULL, 'present', '35.00', 'can do better', 0, '2025-04-01 05:59:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (285, 89, 224, NULL, 'present', '40.00', 'can do better', 0, '2025-04-01 06:01:40', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (286, 89, 231, NULL, 'present', '35.00', 'work more harder', 0, '2025-04-01 06:02:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (287, 89, 233, NULL, 'present', '50.00', 'well done', 0, '2025-04-01 06:03:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (288, 92, 247, NULL, 'present', '37.00', 'fair', 0, '2025-04-01 06:06:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (289, 93, 247, NULL, 'present', '43.00', 'good', 0, '2025-04-01 06:06:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (290, 92, 243, NULL, 'present', '48.00', 'good work', 0, '2025-04-01 06:07:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (291, 93, 243, NULL, 'present', '62.00', 'very good', 0, '2025-04-01 06:07:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (292, 339, 328, NULL, 'present', '38.00', '', 0, '2025-04-04 05:57:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (293, 339, 333, NULL, 'present', '45.00', 'pass', 0, '2025-04-04 05:58:27', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (294, 39, 214, NULL, 'present', '38.00', '', 0, '2025-04-04 05:54:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (295, 36, 214, NULL, 'present', '40.00', '', 0, '2025-04-04 05:54:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (296, 37, 214, NULL, 'present', '55.00', '', 0, '2025-04-04 05:54:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (297, 38, 214, NULL, 'present', '37.00', '', 0, '2025-04-04 05:54:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (298, 40, 214, NULL, 'absent', NULL, '', 0, '2025-04-04 04:26:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (299, 41, 214, NULL, 'present', '40.00', '', 0, '2025-04-04 05:54:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (300, 49, 158, NULL, 'absent', NULL, '', 0, '2025-04-04 04:30:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (301, 50, 158, NULL, 'present', '15.00', '', 0, '2025-04-04 04:30:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (302, 51, 158, NULL, 'present', '17.00', '', 0, '2025-04-04 04:30:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (303, 48, 158, NULL, 'present', '18.00', '', 0, '2025-04-04 04:30:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (304, 53, 234, NULL, 'absent', NULL, '', 0, '2025-04-04 04:36:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (305, 54, 234, NULL, 'present', '38.00', '', 0, '2025-04-04 04:36:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (306, 55, 234, NULL, 'present', '45.00', '', 0, '2025-04-04 04:36:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (307, 52, 234, NULL, 'present', '20.00', '', 0, '2025-04-04 04:36:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (308, 86, 128, NULL, 'present', '20.00', '', 0, '2025-04-04 06:07:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (309, 85, 128, NULL, 'present', '18.00', '', 0, '2025-04-04 06:07:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (310, 86, 127, NULL, 'present', '21.00', '', 0, '2025-04-04 06:08:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (311, 85, 127, NULL, 'present', '10.00', '', 0, '2025-04-04 06:08:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (312, 86, 130, NULL, 'present', '23.00', '', 0, '2025-04-04 06:10:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (313, 85, 130, NULL, 'present', '14.00', '', 0, '2025-04-04 06:10:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (314, 299, 250, NULL, 'present', '31.00', '', 0, '2025-04-04 06:11:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (315, 298, 250, NULL, 'present', '16.00', '', 0, '2025-04-04 06:11:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (316, 299, 253, NULL, 'present', '44.00', '', 0, '2025-04-04 06:14:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (317, 298, 253, NULL, 'present', '35.00', '', 0, '2025-04-04 06:14:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (318, 299, 258, NULL, 'present', '49.00', '', 0, '2025-04-04 06:23:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (319, 298, 258, NULL, 'present', '37.00', '', 0, '2025-04-04 06:23:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (320, 334, 94, NULL, 'present', '14.00', '', 0, '2025-04-04 06:24:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (321, 334, 87, NULL, 'present', '10.00', '', 0, '2025-04-04 06:25:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (322, 300, 265, NULL, 'present', '42.00', '', 0, '2025-04-04 06:26:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (323, 300, 262, NULL, 'present', '46.00', '', 0, '2025-04-04 06:27:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (324, 80, 116, NULL, 'present', '10.00', '', 0, '2025-04-04 06:28:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (325, 81, 116, NULL, 'present', '19.00', '', 0, '2025-04-04 06:28:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (326, 80, 109, NULL, 'present', '19.00', '', 0, '2025-04-04 06:29:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (327, 81, 109, NULL, 'present', '21.00', '', 0, '2025-04-04 06:29:47', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (328, 80, 111, NULL, 'present', '16.00', '', 0, '2025-04-04 06:30:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (329, 81, 111, NULL, 'present', '20.00', '', 0, '2025-04-04 06:30:28', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (330, 321, 371, NULL, 'present', '33.00', '', 0, '2025-04-04 06:31:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (331, 322, 371, NULL, 'present', '33.00', '', 0, '2025-04-04 06:31:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (332, 321, 376, NULL, 'present', '53.00', '', 0, '2025-04-04 06:33:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (333, 322, 376, NULL, 'present', '33.00', '', 0, '2025-04-04 06:33:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (334, 321, 377, NULL, 'present', '46.00', '', 0, '2025-04-04 06:38:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (335, 322, 377, NULL, 'present', '46.00', '', 0, '2025-04-04 06:38:31', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (336, 78, 62, NULL, 'present', '12.00', '', 0, '2025-04-04 07:03:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (337, 67, 42, NULL, 'present', '14.00', '', 0, '2025-04-05 04:49:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (338, 66, 42, NULL, 'present', '11.00', '', 0, '2025-04-05 04:49:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (339, 303, 278, NULL, 'present', '65.00', '', 0, '2025-04-05 04:56:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (340, 302, 278, NULL, 'present', '45.00', '', 0, '2025-04-05 04:56:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (341, 303, 280, NULL, 'present', '63.00', '', 0, '2025-04-05 04:59:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (342, 302, 280, NULL, 'present', '45.00', '', 0, '2025-04-05 04:59:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (343, 303, 281, NULL, 'present', '50.00', '', 0, '2025-04-05 05:01:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (344, 302, 281, NULL, 'present', '42.00', '', 0, '2025-04-05 05:01:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (345, 67, 43, NULL, 'present', '22.00', '', 0, '2025-04-05 05:09:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (346, 66, 43, NULL, 'present', '26.00', '', 0, '2025-04-05 05:09:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (347, 67, 47, NULL, 'present', '23.00', '', 0, '2025-04-05 05:11:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (348, 66, 47, NULL, 'present', '21.00', '', 0, '2025-04-05 05:11:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (349, 325, 367, NULL, 'present', '61.00', '', 0, '2025-04-05 05:14:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (350, 325, 369, NULL, 'present', '45.00', '', 0, '2025-04-05 05:15:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (351, 325, 368, NULL, 'present', '70.00', '', 0, '2025-04-05 05:17:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (352, 79, 51, NULL, 'present', '23.00', '', 0, '2025-04-05 05:19:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (353, 79, 49, NULL, 'present', '25.00', '', 0, '2025-04-05 05:20:24', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (354, 79, 52, NULL, 'present', '28.00', '', 0, '2025-04-05 05:21:29', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (355, 326, 385, NULL, 'present', '64.00', '', 0, '2025-04-05 05:26:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (356, 327, 385, NULL, 'present', '62.00', '', 0, '2025-04-05 05:26:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (357, 326, 383, NULL, 'present', '50.00', '', 0, '2025-04-05 05:33:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (358, 327, 383, NULL, 'absent', NULL, '', 0, '2025-04-05 05:33:35', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (359, 74, 85, NULL, 'present', '24.00', 'very good', 0, '2025-04-24 05:24:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (360, 75, 81, NULL, 'present', '20.00', 'good', 0, '2025-04-24 05:41:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (361, 292, 66, NULL, 'present', '24.00', 'good', 0, '2025-04-24 05:44:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (362, 293, 66, NULL, 'present', '20.00', 'good', 0, '2025-04-24 05:44:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (363, 294, 66, NULL, 'present', '27.00', 'very good', 0, '2025-04-24 05:44:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (364, 285, 173, NULL, 'present', '24.00', 'good', 0, '2025-04-24 07:54:02', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (365, 86, 133, NULL, 'present', '21.00', 'Good', 0, '2025-04-24 07:59:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (366, 85, 133, NULL, 'present', '0.00', '', 0, '2025-04-24 07:59:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (368, 289, 335, NULL, 'present', '30.00', '', 0, '2025-04-29 09:17:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (369, 290, 335, NULL, 'present', '23.00', '', 0, '2025-04-29 09:17:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (370, 291, 335, NULL, 'present', '39.00', '', 0, '2025-04-29 09:17:50', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (371, 289, 338, NULL, 'present', '30.00', '', 0, '2025-04-29 09:20:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (372, 290, 338, NULL, 'present', '35.00', '', 0, '2025-04-29 09:20:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (373, 291, 338, NULL, 'present', '25.00', '', 0, '2025-04-29 09:20:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (374, 289, 339, NULL, 'present', '16.00', '', 0, '2025-04-29 09:23:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (375, 290, 339, NULL, 'present', '34.00', '', 0, '2025-04-29 09:23:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (376, 291, 339, NULL, 'present', '46.00', '', 0, '2025-04-29 09:23:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (377, 39, 220, NULL, 'present', '58.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (378, 36, 220, NULL, 'present', '63.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (379, 37, 220, NULL, 'present', '63.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (380, 38, 220, NULL, 'present', '61.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (381, 40, 220, NULL, 'present', '0.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (382, 41, 220, NULL, 'present', '68.00', '', 0, '2025-04-29 09:37:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (383, 39, 216, NULL, 'present', '61.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (384, 36, 216, NULL, 'present', '67.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (385, 37, 216, NULL, 'present', '60.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (386, 38, 216, NULL, 'present', '52.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (387, 40, 216, NULL, 'present', '0.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (388, 41, 216, NULL, 'present', '70.00', '', 0, '2025-04-29 09:37:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (389, 39, 218, NULL, 'present', '69.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (390, 36, 218, NULL, 'present', '50.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (391, 37, 218, NULL, 'present', '50.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (392, 38, 218, NULL, 'present', '59.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (393, 40, 218, NULL, 'present', '0.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (394, 41, 218, NULL, 'present', '66.00', '', 0, '2025-04-29 09:40:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (395, 39, 215, NULL, 'present', '66.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (396, 36, 215, NULL, 'present', '59.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (397, 37, 215, NULL, 'present', '60.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (398, 38, 215, NULL, 'present', '49.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (399, 40, 215, NULL, 'present', '1.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (400, 41, 215, NULL, 'present', '70.00', '', 0, '2025-04-29 09:54:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (401, 300, 267, NULL, 'present', '35.00', '', 0, '2025-04-29 10:03:24', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (402, 96, 306, NULL, 'present', '47.00', '', 0, '2025-04-29 10:23:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (403, 97, 306, NULL, 'present', '26.00', '', 0, '2025-04-29 10:23:17', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (404, 96, 309, NULL, 'present', '48.00', '', 0, '2025-04-29 10:25:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (405, 97, 309, NULL, 'present', '54.00', '', 0, '2025-04-29 10:25:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (406, 96, 310, NULL, 'present', '61.00', '', 0, '2025-04-29 10:27:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (407, 97, 310, NULL, 'present', '57.00', '', 0, '2025-04-29 10:27:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (408, 318, 389, NULL, 'present', '34.00', '', 0, '2025-04-29 10:30:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (409, 92, 245, NULL, 'present', '48.00', '', 0, '2025-04-29 10:33:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (410, 93, 245, NULL, 'present', '53.00', '', 0, '2025-04-29 10:33:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (411, 318, 390, NULL, 'present', '40.00', '', 0, '2025-04-29 10:35:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (412, 312, 317, NULL, 'present', '0.00', '', 0, '2025-04-29 10:41:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (413, 310, 317, NULL, 'present', '0.00', '', 0, '2025-04-29 10:41:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (414, 311, 317, NULL, 'present', '0.00', '', 0, '2025-04-29 10:41:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (415, 313, 317, NULL, 'present', '0.00', '', 0, '2025-04-29 10:41:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (416, 309, 317, NULL, 'present', '42.00', '', 0, '2025-04-29 10:41:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (417, 312, 316, NULL, 'present', '0.00', '', 0, '2025-04-29 10:42:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (418, 310, 316, NULL, 'present', '0.00', '', 0, '2025-04-29 10:42:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (419, 311, 316, NULL, 'present', '0.00', '', 0, '2025-04-29 10:42:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (420, 313, 316, NULL, 'present', '0.00', '', 0, '2025-04-29 10:42:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (421, 309, 316, NULL, 'present', '46.00', '', 0, '2025-04-29 10:42:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (422, 312, 315, NULL, 'present', '0.00', '', 0, '2025-04-29 10:44:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (423, 310, 315, NULL, 'present', '0.00', '', 0, '2025-04-29 10:44:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (424, 311, 315, NULL, 'present', '0.00', '', 0, '2025-04-29 10:44:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (425, 313, 315, NULL, 'present', '0.00', '', 0, '2025-04-29 10:44:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (426, 309, 315, NULL, 'present', '41.00', '', 0, '2025-04-29 10:44:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (427, 329, 402, NULL, 'present', '53.00', '', 0, '2025-04-30 05:18:29', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (428, 330, 402, NULL, 'present', '56.00', '', 0, '2025-04-30 05:18:29', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (429, 329, 403, NULL, 'present', '65.00', '', 0, '2025-04-30 05:19:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (430, 330, 403, NULL, 'present', '62.00', '', 0, '2025-04-30 05:19:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (431, 336, 425, NULL, 'present', '57.00', '', 0, '2025-04-30 05:22:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (432, 336, 424, NULL, 'present', '53.00', '', 0, '2025-04-30 05:22:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (433, 316, 54, NULL, 'present', '30.00', '', 0, '2025-04-30 05:23:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (434, 288, 358, NULL, 'present', '70.00', '', 0, '2025-04-30 07:07:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (435, 287, 358, NULL, 'present', '30.00', '', 0, '2025-04-30 07:07:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (436, 288, 361, NULL, 'present', '60.00', '', 0, '2025-04-30 07:11:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (437, 287, 361, NULL, 'present', '30.00', '', 0, '2025-04-30 07:11:05', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (438, 306, 287, NULL, 'present', '0.00', '', 0, '2025-04-30 07:14:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (439, 307, 287, NULL, 'present', '0.00', '', 0, '2025-04-30 07:14:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (440, 305, 287, NULL, 'present', '70.00', '', 0, '2025-04-30 07:14:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (441, 306, 290, NULL, 'present', '0.00', '', 0, '2025-04-30 07:15:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (442, 307, 290, NULL, 'present', '0.00', '', 0, '2025-04-30 07:15:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (443, 305, 290, NULL, 'present', '65.00', '', 0, '2025-04-30 07:15:52', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (444, 324, 358, NULL, 'present', '40.00', '', 0, '2025-04-30 07:23:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (445, 323, 358, NULL, 'present', '32.00', '', 0, '2025-04-30 07:23:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (446, 324, 361, NULL, 'present', '45.00', '', 0, '2025-04-30 07:24:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (447, 323, 361, NULL, 'present', '30.00', '', 0, '2025-04-30 07:24:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (448, 303, 277, NULL, 'present', '51.00', '', 0, '2025-04-30 07:27:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (449, 302, 277, NULL, 'present', '40.00', '', 0, '2025-04-30 07:27:14', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (450, 321, 372, NULL, 'present', '50.00', '', 0, '2025-04-30 07:29:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (451, 322, 372, NULL, 'present', '40.00', '', 0, '2025-04-30 07:29:18', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (452, 321, 374, NULL, 'present', '50.00', '', 0, '2025-04-30 07:30:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (453, 322, 374, NULL, 'present', '43.00', '', 0, '2025-04-30 07:30:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (454, 314, 320, NULL, 'present', '50.00', '', 0, '2025-04-30 07:33:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (455, 314, 323, NULL, 'present', '30.00', '', 0, '2025-04-30 07:34:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (456, 312, 314, NULL, 'present', '0.00', '', 0, '2025-04-30 07:36:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (457, 310, 314, NULL, 'present', '0.00', '', 0, '2025-04-30 07:36:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (458, 311, 314, NULL, 'present', '0.00', '', 0, '2025-04-30 07:36:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (459, 313, 314, NULL, 'present', '0.00', '', 0, '2025-04-30 07:36:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (460, 309, 314, NULL, 'present', '55.00', '', 0, '2025-04-30 07:38:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (461, 312, 312, NULL, 'present', '0.00', '', 0, '2025-04-30 07:37:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (462, 310, 312, NULL, 'present', '0.00', '', 0, '2025-04-30 07:37:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (463, 311, 312, NULL, 'present', '0.00', '', 0, '2025-04-30 07:37:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (464, 313, 312, NULL, 'present', '0.00', '', 0, '2025-04-30 07:37:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (465, 309, 312, NULL, 'present', '60.00', '', 0, '2025-04-30 07:37:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (466, 315, 350, NULL, 'present', '19.00', '', 0, '2025-04-30 08:17:56', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (467, 315, 349, NULL, 'present', '25.00', '', 0, '2025-04-30 08:18:41', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (468, 301, 273, NULL, 'present', '34.00', '', 0, '2025-04-30 08:20:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (469, 300, 260, NULL, 'present', '35.00', '', 0, '2025-04-30 08:24:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (470, 329, 401, NULL, 'present', '70.00', '', 0, '2025-04-30 08:27:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (471, 330, 401, NULL, 'present', '70.00', '', 0, '2025-04-30 08:27:53', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (472, 329, 399, NULL, 'present', '60.00', '', 0, '2025-04-30 08:28:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (473, 330, 399, NULL, 'present', '66.00', '', 0, '2025-04-30 08:28:54', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (474, 339, 330, NULL, 'present', '15.00', '', 0, '2025-04-30 08:31:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (475, 339, 327, NULL, 'present', '25.00', '', 0, '2025-04-30 08:31:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (476, 334, 89, NULL, 'present', '30.00', '', 0, '2025-05-01 11:32:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (477, 301, 268, NULL, 'present', '25.00', '', 0, '2025-05-01 11:36:11', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (478, 336, 420, NULL, 'present', '65.00', '', 0, '2025-05-01 11:38:33', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (479, 308, 295, NULL, 'present', '27.00', '', 0, '2025-05-01 11:40:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (480, 289, 336, NULL, 'present', '22.00', '', 0, '2025-05-05 05:08:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (481, 290, 336, NULL, 'present', '30.00', '', 0, '2025-05-05 05:08:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (482, 291, 336, NULL, 'present', '61.00', '', 0, '2025-05-05 05:08:22', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (483, 75, 77, NULL, 'present', '4.00', '', 0, '2025-05-05 05:18:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (484, 315, 353, NULL, 'present', '13.00', '', 0, '2025-05-05 05:19:26', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (485, 84, 153, NULL, 'present', '17.00', '', 0, '2025-05-06 03:47:49', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (486, 314, 319, NULL, 'present', '30.00', '', 0, '2025-05-06 03:49:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (487, 70, 435, NULL, 'present', '47.00', 'COMPETENT', 0, '2025-05-06 06:58:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (488, 70, 104, NULL, 'present', '54.00', 'COMPETENT', 0, '2025-05-06 07:51:21', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (489, 70, 434, NULL, 'present', '65.00', 'COMPETENT', 0, '2025-05-06 07:50:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (490, 70, 107, NULL, 'present', '58.00', 'ABOVE COMPETENT', 0, '2025-05-06 07:52:34', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (491, 341, 442, NULL, 'present', '51.00', 'competent', 0, '2025-05-06 08:15:38', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (492, 341, 443, NULL, 'present', '43.00', 'competent', 0, '2025-05-06 08:16:46', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (493, 341, 444, NULL, 'present', '45.00', 'competent', 0, '2025-05-06 08:20:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (494, 341, 445, NULL, 'present', '51.00', 'competent', 0, '2025-05-06 08:22:00', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (495, 342, 436, NULL, 'present', '1.00', '', 0, '2025-05-06 08:25:34', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (496, 343, 436, NULL, 'present', '55.00', 'competent', 0, '2025-05-06 08:25:34', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (497, 315, 354, NULL, 'present', '46.00', 'good effort', 0, '2025-05-07 01:59:39', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (498, 315, 352, NULL, 'present', '50.00', 'well done', 0, '2025-05-07 01:56:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (499, 329, 397, NULL, 'present', '42.00', '', 0, '2025-05-08 02:37:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (500, 330, 397, NULL, 'absent', NULL, '', 0, '2025-05-08 02:37:23', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (501, 325, 365, NULL, 'present', '35.00', '', 0, '2025-05-08 02:44:04', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (502, 79, 50, NULL, 'present', '16.00', '', 0, '2025-05-08 02:45:44', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (503, 303, 275, NULL, 'present', '37.00', '', 0, '2025-05-08 02:49:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (504, 302, 275, NULL, 'present', '35.00', '', 0, '2025-05-08 02:49:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (505, 314, 318, NULL, 'present', '54.00', '', 0, '2025-05-08 02:52:20', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (506, 61, 147, NULL, 'present', '13.00', '', 0, '2025-05-08 03:08:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (507, 62, 147, NULL, 'absent', NULL, '', 0, '2025-05-08 03:08:32', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (508, 337, 430, NULL, 'present', '16.00', '', 0, '2025-05-08 03:26:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (509, 338, 430, NULL, 'present', '21.00', '', 0, '2025-05-08 03:26:12', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (510, 340, 234, NULL, 'present', '52.00', '', 0, '2025-05-09 06:03:27', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (511, 271, 35, NULL, 'absent', NULL, '', 0, '2025-05-09 06:12:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (512, 272, 35, NULL, 'absent', NULL, '', 0, '2025-05-09 06:12:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (513, 270, 35, NULL, 'present', '25.00', 'pass', 0, '2025-05-09 06:12:10', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (514, 306, 286, NULL, 'absent', NULL, '', 0, '2025-05-09 06:16:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (515, 307, 286, NULL, 'absent', NULL, '', 0, '2025-05-09 06:16:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (516, 305, 286, NULL, 'present', '46.00', 'pass', 0, '2025-05-09 06:16:30', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (517, 324, 357, NULL, 'present', '35.00', 'pass', 0, '2025-05-09 06:19:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (518, 323, 357, NULL, 'present', '45.00', 'pass', 0, '2025-05-09 06:19:15', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (519, 274, 30, NULL, 'absent', NULL, '', 0, '2025-05-09 06:20:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (520, 273, 30, NULL, 'absent', NULL, '', 0, '2025-05-09 06:20:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (521, 65, 30, NULL, 'present', '17.00', 'pass', 0, '2025-05-09 06:20:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (522, 64, 30, NULL, 'present', '16.00', 'pass', 0, '2025-05-09 06:20:59', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (523, 61, 148, NULL, 'present', '18.00', '', 0, '2025-05-09 06:46:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (524, 62, 148, NULL, 'present', '20.00', '', 0, '2025-05-09 06:46:19', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (525, 326, 379, NULL, 'present', '33.00', 'pass', 0, '2025-05-09 06:48:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (526, 327, 379, NULL, 'present', '35.00', 'pass', 0, '2025-05-09 06:48:16', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (527, 76, 76, NULL, 'present', '17.00', '', 0, '2025-05-09 06:51:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (528, 77, 76, NULL, 'absent', NULL, '', 0, '2025-05-09 06:51:55', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (529, 329, 398, NULL, 'present', '41.00', '', 0, '2025-05-09 06:52:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (530, 330, 398, NULL, 'absent', NULL, '', 0, '2025-05-09 06:52:57', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (531, 67, 45, NULL, 'absent', NULL, '', 0, '2025-05-09 06:54:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (532, 66, 45, NULL, 'present', '12.00', '', 0, '2025-05-09 06:54:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (533, 325, 366, NULL, 'present', '37.00', 'pass', 0, '2025-05-09 06:57:21', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (534, 79, 48, NULL, 'present', '20.00', 'pass', 0, '2025-05-09 06:58:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (535, 303, 276, NULL, 'present', '18.00', '', 0, '2025-05-09 07:00:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (536, 302, 276, NULL, 'present', '30.00', '', 0, '2025-05-09 07:00:43', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (537, 63, 21, NULL, 'present', '17.00', '', 0, '2025-05-09 07:03:48', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (538, 324, 362, NULL, 'present', '50.00', 'pass', 0, '2025-05-09 07:08:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (539, 323, 362, NULL, 'present', '45.00', 'pass', 0, '2025-05-09 07:08:51', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (540, 271, 39, NULL, 'absent', NULL, '', 0, '2025-05-09 07:12:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (541, 272, 39, NULL, 'absent', NULL, '', 0, '2025-05-09 07:12:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (542, 270, 39, NULL, 'present', '28.00', 'pass', 0, '2025-05-09 07:12:07', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (543, 271, 40, NULL, 'absent', NULL, '', 0, '2025-05-09 07:13:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (544, 272, 40, NULL, 'absent', NULL, '', 0, '2025-05-09 07:13:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (545, 270, 40, NULL, 'present', '27.00', 'pass', 0, '2025-05-09 07:13:08', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (546, 271, 38, NULL, 'absent', NULL, '', 0, '2025-05-09 07:13:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (547, 272, 38, NULL, 'absent', NULL, '', 0, '2025-05-09 07:13:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (548, 270, 38, NULL, 'present', '18.00', '', 0, '2025-05-09 07:13:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (549, 337, 428, NULL, 'present', '15.00', '', 0, '2025-05-09 07:17:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (550, 338, 428, NULL, 'present', '18.00', '', 0, '2025-05-09 07:17:09', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (551, 337, 429, NULL, 'absent', NULL, '', 0, '2025-05-09 07:18:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (552, 338, 429, NULL, 'absent', NULL, '', 0, '2025-05-09 07:18:03', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (553, 346, 452, NULL, 'present', '25.00', '', 0, '2025-05-09 07:20:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (554, 344, 452, NULL, 'present', '20.00', '', 0, '2025-05-09 07:20:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (555, 345, 452, NULL, 'present', '21.00', '', 0, '2025-05-09 07:20:58', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (556, 346, 453, NULL, 'present', '33.00', '', 0, '2025-05-09 07:22:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (557, 344, 453, NULL, 'present', '25.00', '', 0, '2025-05-09 07:22:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (558, 345, 453, NULL, 'present', '38.00', '', 0, '2025-05-09 07:22:42', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (559, 346, 454, NULL, 'present', '26.00', '', 0, '2025-05-09 07:23:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (560, 344, 454, NULL, 'present', '23.00', '', 0, '2025-05-09 07:23:45', NULL);
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (561, 345, 454, NULL, 'present', '25.00', '', 0, '2025-05-09 07:23:45', NULL);


#
# TABLE STRUCTURE FOR: exam_group_students
#

DROP TABLE IF EXISTS `exam_group_students`;

CREATE TABLE `exam_group_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `student_session_id` int(10) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_students_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exam_groups
#

DROP TABLE IF EXISTS `exam_groups`;

CREATE TABLE `exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `exam_type` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'CDACC INTERNAL EXAMINATION JANUARY-APRIL 2025', 'coll_grade_system', 'The student is either Master, Competent or not yet competent.', 0, '2025-02-20 06:19:00', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'KNEC GROUP INTERNAL EXAM JAN-APRIL 2025', 'school_grade_system', 'Exam results used for the registration of KNEC exam', 0, '2025-03-03 06:09:13', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'COMPUTER PACKAGES', 'coll_grade_system', 'College Based', 0, '2025-02-28 06:20:22', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'NITA EXAMS', 'coll_grade_system', '', 0, '2025-03-24 09:54:07', NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `teacher_subject_id` int(11) DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int(11) DEFAULT NULL,
  `passing_marks` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`),
  KEY `session_id` (`session_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `exam_schedules_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_schedules_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sesion_id` (`sesion_id`),
  CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`sesion_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'LECTURERS SALARIES', 'PTTC/F/E/SA/001', 'yes', 'no', '2025-01-27 06:37:23', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'MONTHLY OPERATIONS', 'PTTC/F/E/MO/001', 'yes', 'no', '2025-02-19 04:16:07', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'WAGES', 'PTTC/F/E/WAG/001', 'yes', 'no', '2025-01-27 06:40:19', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'STAFF SUBSITIARY AND TRAVEL', 'PTTC/F/E/SST/001', 'yes', 'no', '2025-01-27 06:41:12', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 'GENERATOR FUEL', 'PTTC/F/E/FU/001', 'yes', 'no', '2025-01-27 06:41:56', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 'REPAIRS', 'PTTC/F/E/R/001\r\n', 'yes', 'no', '2025-01-27 06:45:42', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 'SECURITY', 'PTTC/F/E/SEC/001', 'yes', 'no', '2025-01-27 06:45:56', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 'CONSULTANCY', 'PTTC/F/E/CO/001', 'yes', 'no', '2025-01-27 06:46:50', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 'LEGAL FEES', 'PTTC/F/E/LE/001', 'yes', 'no', '2025-01-27 06:47:06', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (10, 'BANK CHARGES', 'PTTC/F/E/BK/001', 'yes', 'no', '2025-01-27 06:47:19', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (11, 'LICENCES', 'PTTC/F/E/LC/001', 'yes', 'no', '2025-01-27 06:47:36', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (12, 'STATIONERY', 'PTTC/F/E/STA/001', 'yes', 'no', '2025-01-27 06:47:54', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (13, 'TELEPHONE AND POSTAGE', 'PTTC/F/E/TP/001', 'yes', 'no', '2025-01-27 06:48:18', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (14, 'RENT AND RATES PROVISION', 'PTTC/F/E/RR/001', 'yes', 'no', '2025-01-27 06:48:36', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (15, 'ADVERTISEMENT', 'PTTC/F/E/ADV/001', 'yes', 'no', '2025-01-27 06:48:53', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (16, 'TAXATION', 'PTTC/F/E/TAX/001', 'yes', 'no', '2025-01-27 06:49:08', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (17, 'STUDENT WELFARE', 'PTTC/F/E/SW/001', 'yes', 'no', '2025-02-19 04:16:43', NULL);


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 1, 'LECTURERS SALARIES', '', '2025-01-31', '149500.00', NULL, '', 'yes', 'no', '2025-02-19 04:14:58', NULL);


#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (2, 'TUITION FEE', 0, 'Payable every semester for all long courses.', 'no', '2025-01-26 10:40:28');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (3, 'ADMISSION FEE', 0, 'Payable once for all long courses', 'no', '2025-01-26 10:39:46');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (4, 'JANUARY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:28');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (5, 'COMPUTER PACKAGES', 0, 'Applicable to all computer students', 'no', '2025-01-26 03:29:52');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (6, 'CCTV MANAGEMENT COURSE', 0, 'Payment for the short course ', 'no', '2025-01-26 10:41:15');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (7, 'MOBILE PHONE REPAIR', 0, 'Payment for the short course ', 'no', '2025-01-26 10:41:33');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (8, 'CAKE BAKING  ', 0, 'Payment for the short course', 'no', '2025-01-26 10:43:57');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (9, 'GRAPHIC DESIGN', 0, 'Payment for the short course ', 'no', '2025-01-26 10:42:07');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (10, 'PHOTOGRAPHY', 0, 'Payment for the short course ', 'no', '2025-01-26 10:42:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (11, 'ELECTRONIC REPAIR (RADIO AND TV)', 0, 'Payment for the short course ', 'no', '2025-01-26 10:43:00');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (12, 'COMPUTER AIDED DESIGN', 0, 'Payment for the short course ', 'no', '2025-01-26 10:43:26');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (13, 'FEBRUARY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (14, 'MARCH HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:49:56');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (15, 'APRIL HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:11');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (16, 'MAY HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (17, 'JUNE HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:50:34');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (18, 'JULY HOSTEL FEEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:00');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (19, 'AUGUST HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:18');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (20, 'SEPTEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:31');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (21, 'OCTOBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (22, 'NOVEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:51:58');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (23, 'DECEMBER HOSTEL FEE', 0, 'Applicable to all resident students', 'no', '2025-01-27 07:52:14');


#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `fee_groups_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `fine_type` varchar(50) NOT NULL DEFAULT 'none',
  `due_date` date DEFAULT NULL,
  `fine_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `fine_amount` float(10,2) NOT NULL DEFAULT 0.00,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_groups_feetype_ibfk_1` FOREIGN KEY (`fee_session_group_id`) REFERENCES `fee_session_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_2` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_3` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (1, 1, 3, 1, 20, '1500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-23 02:14:46');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (2, 2, 2, 2, 20, '16000.00', 'none', '2025-03-13', '0.00', '0.00', 'no', '2025-01-23 02:15:11');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (3, 3, 5, 3, 20, '3500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-27 06:30:50');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (4, 4, 4, 12, 20, '3500.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:44:39');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (5, 5, 6, 4, 20, '25000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:45:07');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (6, 6, 7, 6, 20, '30000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:45:41');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (7, 7, 8, 7, 20, '20000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:46:09');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (8, 8, 10, 9, 20, '25000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:46:37');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (9, 9, 11, 10, 20, '30000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:47:20');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (10, 10, 12, 11, 20, '20000.00', 'none', NULL, '0.00', '0.00', 'no', '2025-01-26 10:48:18');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (23, 11, 13, 13, 20, '3500.00', 'none', '2025-02-10', '0.00', '0.00', 'no', '2025-01-27 07:54:00');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (24, 12, 14, 15, 20, '3500.00', 'none', '2025-03-10', '0.00', '0.00', 'no', '2025-01-27 07:54:21');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (25, 13, 15, 15, 20, '3500.00', 'none', '2025-04-10', '0.00', '0.00', 'no', '2025-01-27 07:54:46');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (26, 14, 16, 16, 20, '3500.00', 'none', '2025-05-10', '0.00', '0.00', 'no', '2025-01-27 07:55:17');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (27, 15, 17, 17, 20, '3500.00', 'none', '2025-06-10', '0.00', '0.00', 'no', '2025-01-27 07:55:52');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (28, 16, 18, 18, 20, '3500.00', 'none', '2025-07-10', '0.00', '0.00', 'no', '2025-01-27 07:56:18');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (29, 17, 19, 19, 20, '3500.00', 'none', '2025-08-10', '0.00', '0.00', 'no', '2025-01-27 07:56:44');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (30, 18, 20, 20, 20, '3500.00', 'none', '2025-09-10', '0.00', '0.00', 'no', '2025-01-27 07:57:15');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (31, 19, 21, 21, 20, '3500.00', 'none', '2025-10-10', '0.00', '0.00', 'no', '2025-01-27 07:58:00');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (32, 20, 22, 22, 20, '3500.00', 'none', '2025-11-10', '0.00', '0.00', 'no', '2025-01-27 07:58:31');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (33, 21, 23, 23, 20, '3500.00', 'none', '2025-12-10', '0.00', '0.00', 'no', '2025-01-27 07:58:59');


#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_session_groups_ibfk_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_session_groups_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (1, 3, 20, 'no', '2025-01-23 02:14:46');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (2, 2, 20, 'no', '2025-01-23 02:15:11');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (3, 5, 20, 'no', '2025-01-26 03:32:09');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (4, 4, 20, 'no', '2025-01-26 10:44:39');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (5, 6, 20, 'no', '2025-01-26 10:45:07');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (6, 7, 20, 'no', '2025-01-26 10:45:41');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (7, 8, 20, 'no', '2025-01-26 10:46:09');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (8, 10, 20, 'no', '2025-01-26 10:46:37');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (9, 11, 20, 'no', '2025-01-26 10:47:20');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (10, 12, 20, 'no', '2025-01-26 10:48:18');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (11, 13, 20, 'no', '2025-01-27 07:54:00');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (12, 14, 20, 'no', '2025-01-27 07:54:21');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (13, 15, 20, 'no', '2025-01-27 07:54:46');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (14, 16, 20, 'no', '2025-01-27 07:55:17');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (15, 17, 20, 'no', '2025-01-27 07:55:52');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (16, 18, 20, 'no', '2025-01-27 07:56:18');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (17, 19, 20, 'no', '2025-01-27 07:56:44');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (18, 20, 20, 'no', '2025-01-27 07:57:15');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (19, 21, 20, 'no', '2025-01-27 07:58:00');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (20, 22, 20, 'no', '2025-01-27 07:58:31');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (21, 23, 20, 'no', '2025-01-27 07:58:59');


#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `feemasters_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_2` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `percentage` float(10,2) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fees_discounts_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reminder_type` varchar(10) DEFAULT NULL,
  `day` int(2) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'before', 2, 1, '2025-01-10 12:56:19', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'before', 5, 0, '2020-02-28 08:38:36', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'after', 2, 1, '2025-01-10 12:55:48', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'after', 5, 0, '2020-02-28 08:38:44', NULL);


#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `feecategory_id` int(11) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (1, 0, NULL, 'ADMISSION FEE', 'PTTC/F/ADM/001', 'no', 'Payable once by students taking long courses.', '2025-01-23 02:11:56', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 0, NULL, 'TUITION FEE', 'PTTC/F/TF/001', 'no', 'Payable per semester by students taking long courses.', '2025-01-23 02:13:08', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (3, 0, NULL, 'COMPUTER PACKAGES', 'PTTC/F/CP/001', 'no', 'All computer packages students', '2025-01-26 10:28:55', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (4, 0, NULL, 'CCTV MANAGEMENT FEE', 'PTTC/F/CCTV/001', 'no', 'Payment for the short course', '2025-01-26 10:30:01', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (6, 0, NULL, 'MOBILE PHONE REPAIR', 'PTTC/F/MPR/001', 'no', 'Payment for a short course ', '2025-01-26 10:32:09', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (7, 0, NULL, 'CAKE BAKING', 'PTTC/F/CB/001', 'no', 'Payment for the short course ', '2025-01-26 10:33:09', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (8, 0, NULL, 'GRAPHIC DESIGN', 'PTTC/F/GD/001', 'no', 'Payment for the short course ', '2025-01-26 10:34:30', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (9, 0, NULL, 'PHOTOGRAPHY', 'PTTC/F/P/001', 'no', 'Payment for the short course ', '2025-01-26 10:34:58', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (10, 0, NULL, 'ELECTRONIC REPAIR (TV & RADIO)', 'PTTC/F/ER/001', 'no', 'Payment for the short course ', '2025-01-26 10:35:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (11, 0, NULL, 'COMPUTER AIDED DESIGN ', 'PTTC/F/CADD/001', 'no', 'Payment for the short course ', '2025-01-26 10:36:34', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (12, 0, NULL, 'JANUARY HOSTEL FEE', 'PTTC/F/H/001', 'no', 'Payment for hostel rooms', '2025-01-27 06:19:20', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (13, 0, NULL, 'FEBRUARY HOSTEL FEE', 'PTTC/F/H/002', 'no', '', '2025-01-27 06:19:47', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (14, 0, NULL, 'MARCH HOSTEL FEE', 'PTTC/F/H/003', 'no', '', '2025-01-27 06:20:39', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (15, 0, NULL, 'APRIL HOSTEL FEE', 'PTTC/F/H/004', 'no', '', '2025-01-27 06:20:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (16, 0, NULL, 'MAY HOSTEL FEE', 'PTTC/F/H/005', 'no', '', '2025-01-27 06:21:12', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (17, 0, NULL, 'JUNE HOSTEL FEE', 'PTTC/F/H/006', 'no', '', '2025-01-27 06:21:31', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (18, 0, NULL, 'JULY HOSTEL FEE', 'PTTC/F/H/007', 'no', '', '2025-01-27 06:21:54', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (19, 0, NULL, 'AUGUST HOSTEL FEE', 'PTTC/F/H/008', 'no', '', '2025-01-27 06:22:10', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (20, 0, NULL, 'SEPTEMBER HOSTEL FEE', 'PTTC/F/H/009', 'no', '', '2025-01-27 06:22:34', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (21, 0, NULL, 'OCTOBER HOSTEL FEE', 'PTTC/F/H/010', 'no', '', '2025-01-27 06:22:59', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (22, 0, NULL, 'NOVEMBER HOSTEL FEE', 'PTTC/F/H/011', 'no', '', '2025-01-27 06:23:19', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (23, 0, NULL, 'DECEMBER HOSTEL FEE', 'PTTC/F/H/012', 'no', '', '2025-01-27 06:23:42', NULL);


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text DEFAULT NULL,
  `file_mime` text DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_mime` text DEFAULT NULL,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `filetypes` (`id`, `file_extension`, `file_mime`, `file_size`, `image_extension`, `image_mime`, `image_size`, `created_at`) VALUES (1, 'pdf, zip, jpg, jpeg, png, txt, 7z, gif, csv, docx, mp3, mp4, accdb, odt, ods, ppt, pptx, xlsx, wmv, jfif, apk, ppt, bmp, jpe, mdb, rar, xls, svg', 'application/pdf, image/zip, image/jpg, image/png, image/jpeg, text/plain, application/x-zip-compressed, application/zip, image/gif, text/csv, application/vnd.openxmlformats-officedocument.wordprocessingml.document, audio/mpeg, application/msaccess, application/vnd.oasis.opendocument.text, application/vnd.oasis.opendocument.spreadsheet, application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, video/x-ms-wmv, video/mp4, image/jpeg, application/vnd.android.package-archive, application/x-msdownload, application/vnd.ms-powerpoint, image/bmp, image/jpeg, application/msaccess, application/vnd.ms-excel, image/svg+xml', 100048576, 'jfif, png, jpe, jpeg, jpg, bmp, gif, svg', 'image/jpeg, image/png, image/jpeg, image/jpeg, image/bmp, image/gif, image/x-ms-bmp, image/svg+xml', 10048576, '2021-01-30 08:03:03');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `followup_by` (`followup_by`),
  CONSTRAINT `follow_up_ibfk_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follow_up_ibfk_2` FOREIGN KEY (`followup_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` text NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` text DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` text DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `front_cms_menu_items_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `front_cms_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2019-12-02 17:11:50');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 4, 0, NULL, 'no', '2019-12-02 17:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Complain', 2, 0, NULL, NULL, NULL, 'complain', 3, 0, NULL, 'no', '2019-12-02 17:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 1, 'Online Admission', 0, 0, '1', NULL, 'https://school.wmsender.org/online_admission', 'admssion', 2, 0, NULL, 'no', '2019-12-21 10:33:00');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` text NOT NULL,
  `ext_url_link` text NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 10:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 10:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` text DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keyword` text DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>home page</p>', '0000-00-00', 1, NULL, 'no', '2019-12-02 10:23:47');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>[form-builder:complain]</p>', '0000-00-00', 1, NULL, 'no', '2019-11-13 05:16:36');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 10:46:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<section class=\"contact\">\r\n<div class=\"container\">\r\n<div class=\"row\">\r\n<h2 class=\"col-md-12 col-sm-12\">Send In Your Query</h2>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/pin.svg\" />\r\n<h3>Our Location</h3>\r\n\r\n<p>350 Fifth Avenue, 34th floor New York NY 10118-3299 USA</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/phone.svg\" />\r\n<h3>CALL US</h3>\r\n\r\n<p>E-mail : info@abcschool.com</p>\r\n\r\n<p>Mobile : +91-9009987654</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/clock.svg\" />\r\n<h3>Working Hours</h3>\r\n\r\n<p>Mon-Fri : 9 am to 5 pm</p>\r\n\r\n<p>Sat : 9 am to 3 pm</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-12 col-sm-12\">\r\n<div class=\"mapWrapper fullwidth\"><iframe frameborder=\"0\" height=\"500\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://maps.google.com/maps?f=q&source=s_q&hl=EN&q=time+square&aq=&sll=40.716558,-73.931122&sspn=0.40438,1.056747&ie=UTF8&rq=1&ev=p&split=1&radius=33.22&hq=time+square&hnear=&ll=37.061753,-95.677185&spn=0.438347,0.769043&z=9&output=embed\" width=\"100%\"></iframe></div>\r\n</div>', '0000-00-00', 0, NULL, 'no', '2019-05-04 11:46:41');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` text DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `feature_image` text NOT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` text NOT NULL,
  `whatsapp_url` varchar(255) NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` text DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `cookie_consent` varchar(255) NOT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `whatsapp_url`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `cookie_consent`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, NULL, NULL, './uploads/school_content/logo/1672900975-128524590063b6716fc26ed!front_logo-608ff44a5f8f07.35255544.png', '', '', '[]', '', '', '', '', '', '', '', '', '', '', '', './uploads/school_content/logo/1672900975-63781378463b6716fc2886!front_fav_icon-608ff44a5fdb33.94953981.png', '2025-01-11 06:34:08');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_admission_id` int(11) DEFAULT NULL,
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `online_admission_id` (`online_admission_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_admission_id`) REFERENCES `online_admissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int(11) DEFAULT NULL,
  `posted_data` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: grades
#

DROP TABLE IF EXISTS `grades`;

CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_type` varchar(250) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'coll_grade_system', 'MASTERY', '1.0', '100.00', '80.00', 'A student is competent if the score is 80% -100%', 'no', '2025-02-13 04:05:48', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'coll_grade_system', 'COMPETENT', '2.0', '79.00', '50.00', 'A student is competent if the score is between 50%-79%', 'no', '2025-02-13 04:07:28', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'coll_grade_system', 'NOT YET COMPETENT', '3.0', '49.00', '1.00', 'The student is not yet competent if the score is 1%-49%', 'no', '2025-02-13 04:08:45', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'school_grade_system', 'DISTINTION', '1.0', '100.00', '80.00', 'DISTINCTION', 'no', '2025-02-20 06:35:12', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'school_grade_system', 'CREDIT', '3.0', '79.00', '60.00', 'CREDIT', 'no', '2025-03-03 06:10:52', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'school_grade_system', 'PASS', '5.0', '59.00', '40.00', 'PASS', 'no', '2025-02-20 06:36:01', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'school_grade_system', 'FAIL', '8.0', '39.00', '1.00', 'FAIL', 'no', '2025-02-20 06:36:28', NULL);


#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(10) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `create_date` date NOT NULL,
  `evaluation_date` date DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  KEY `subject_id` (`subject_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `homework_ibfk_1` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_5` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_6` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_7` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_8` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `homework_id` (`homework_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `homework_evaluation_ibfk_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `intake` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, '5TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:17:29', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, '4TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:18:11', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, '5TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:18:10', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, '5TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:18:28', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, '4TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:18:37', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, '4TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:18:57', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, '6TH FLOOR SOUTH', 'Girls', '', 0, '', 'no', '2025-01-10 10:19:07', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, '6TH FLOOR EAST', 'Combine', '', 0, '', 'no', '2025-01-10 10:19:30', NULL);
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (12, '6TH FLOOR NORTH', 'Boys', '', 0, '', 'no', '2025-01-10 10:19:56', NULL);


#
# TABLE STRUCTURE FOR: hostel_rooms
#

DROP TABLE IF EXISTS `hostel_rooms`;

CREATE TABLE `hostel_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_id` int(11) DEFAULT NULL,
  `room_type_id` int(11) DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int(11) DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hostel_id` (`hostel_id`),
  KEY `room_type_id` (`room_type_id`),
  CONSTRAINT `hostel_rooms_ibfk_1` FOREIGN KEY (`hostel_id`) REFERENCES `hostel` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hostel_rooms_ibfk_2` FOREIGN KEY (`room_type_id`) REFERENCES `room_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (2, 5, 1, '401NORTH', 1, '3500.00', NULL, 'Self contained with washroom and sink.', '2025-01-10 10:28:05');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (3, 4, 1, '501NORTH', 1, '3500.00', NULL, 'WATER,SOCKETS,WASHROOM,SINK', '2025-01-10 10:28:15');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (4, 12, 1, '601NORTH', 1, '3500.00', NULL, 'WATER,SANITATION,SINK', '2025-01-10 10:28:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (5, 5, 1, '402NORTH', 1, '3500.00', NULL, 'SINK, HOTSHOWER,WIFI.WASHROOM', '2025-01-10 10:29:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (6, 5, 1, '403NORTH', 1, '3500.00', NULL, 'SINK,WIFI,WASHROOM,HOTSHOWER', '2025-01-10 10:31:48');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (7, 5, 1, '404NORTH', 1, '3500.00', NULL, 'SINK,WIFI,WASHROOM,HOTSHOWER', '2025-01-10 10:32:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (8, 5, 1, '405NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:58');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (9, 5, 1, '406NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:37');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (10, 5, 1, '407NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:46');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (11, 5, 1, '408 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:42:57');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (12, 5, 1, '409 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:44:09');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (13, 5, 1, '410NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:57:13');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (14, 5, 1, '411NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:12:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (15, 5, 1, '412 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:49:55');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (16, 9, 1, '413EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:56:53');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (17, 9, 1, '414 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:54:10');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (18, 9, 1, '415 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 10:59:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (19, 9, 1, '416 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:01:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (20, 9, 1, '417 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:02:49');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (21, 9, 1, '418 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:03:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (22, 9, 1, '418 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:05:00');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (23, 8, 1, '419SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:13:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (24, 8, 1, '420 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:13:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (25, 8, 1, '421SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:14:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (26, 8, 1, '422 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:15:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (27, 8, 1, '423 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:16:11');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (28, 8, 1, '424 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:17:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (29, 8, 1, '425 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:18:36');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (30, 8, 1, '426 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hot shower', '2025-01-10 11:19:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (31, 8, 1, '427 SOUTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:27:08');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (32, 4, 1, '501 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:31:41');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (33, 4, 1, '502 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:34:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (34, 4, 1, '503 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:35:08');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (35, 4, 1, '504 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:37:29');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (36, 4, 1, '505 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:38:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (37, 4, 1, '506 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:42:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (38, 4, 1, '507 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:43:20');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (39, 4, 1, '508 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:44:54');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (40, 4, 1, '509 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:46:33');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (41, 4, 1, '510 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:49:36');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (42, 4, 1, '511 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:51:09');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (44, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (45, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (46, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (47, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:31');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (48, 4, 1, '512 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:53:31');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (49, 4, 1, '513 NORTH', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:56:19');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (50, 7, 1, '514 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:57:17');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (51, 7, 1, '515 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 11:58:53');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (52, 7, 1, '516 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:00:27');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (53, 7, 1, '517 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:01:14');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (54, 7, 1, '518 EAST', 1, '3500.00', NULL, 'Wifi,hotshower,washroom', '2025-01-10 12:03:14');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (55, 6, 1, '519 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 13:59:38');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (56, 6, 1, '520 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:01:55');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (57, 6, 1, '521 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:02:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (58, 6, 1, '522 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:03:47');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (59, 6, 1, '523 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:05:06');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (60, 6, 1, '524 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:06:01');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (61, 6, 1, '525 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:06:42');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (62, 6, 1, '526 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:07:40');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (63, 6, 1, '527 SOUTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-10 14:08:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (64, 12, 1, '602 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:01:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (65, 12, 1, '603 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom ', '2025-01-11 03:02:46');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (66, 12, 1, '604 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:03:43');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (67, 12, 1, '605 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:04:48');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (68, 12, 1, '606 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:06:10');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (69, 12, 1, '607 NORTH', 1, '3500.00', NULL, 'Wifi,hot shower,washroom', '2025-01-11 03:07:39');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (70, 12, 1, '608 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:16:41');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (71, 12, 1, '609 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:18:24');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (72, 12, 1, '610 NORTH', 1, '3500.00', NULL, '0710310404', '2025-01-11 03:19:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (73, 12, 1, '611 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:28:37');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (74, 12, 1, '612 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:33:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (75, 12, 1, '613 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:35:20');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (76, 12, 1, '614 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:36:34');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (77, 12, 1, '615 NORTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:37:12');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (78, 11, 1, '616 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:38:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (79, 11, 1, '616 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:43:01');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (80, 11, 1, '617 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:44:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (81, 11, 1, '618 EAST', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:45:23');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (82, 10, 1, '619 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:46:25');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (83, 10, 1, '620 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:47:21');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (84, 10, 1, '621 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:48:03');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (85, 10, 1, '622 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:49:07');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (86, 10, 1, '623 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:50:11');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (87, 10, 1, '624 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:50:45');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (88, 10, 1, '625 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:51:27');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (89, 10, 1, '626 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:52:30');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`) VALUES (90, 10, 1, '627 SOUTH', 1, '3500.00', NULL, 'Wifi,washroom,hotshower', '2025-01-11 03:53:20');


#
# TABLE STRUCTURE FOR: id_card
#

DROP TABLE IF EXISTS `id_card`;

CREATE TABLE `id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `enable_vertical_card` int(11) NOT NULL DEFAULT 0,
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_barcode` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (1, 'Sample Student Identity Card Horizontal', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 0, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);
INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (2, 'Sample Student Identity Card Vertical', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 1, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `documents` varchar(255) DEFAULT NULL,
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `income_head_id` (`income_head_id`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`income_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'DINING', '', 'yes', 'no', '2025-01-30 02:59:04', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'MAWINGU MAST', 'Monthly rent payment', 'yes', 'no', '2025-01-30 02:59:38', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'MTANDAO MAST', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:00:17', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'WAVEX OFFICE', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:00:45', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 'SAFARICOM K LTD', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:01:35', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 'A TO Z GRAHICS', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:02:16', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 'SUNDRY INCOME', 'Seasonal income', 'yes', 'no', '2025-01-30 03:02:50', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 'MARTIN MARK', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:03:21', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 'JITEGEMEA', 'Monthly rent payment', 'yes', 'no', '2025-01-30 03:03:57', NULL);


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `item_store_id` (`item_store_id`),
  KEY `item_supplier_id` (`item_supplier_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_2` FOREIGN KEY (`item_store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_3` FOREIGN KEY (`item_supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (1, 1, NULL, NULL, 'NAIL POLISH', '150', NULL, '', 0, NULL, '2025-02-11 03:54:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (2, 1, NULL, NULL, 'TOP COAT POLISH 1', '150', NULL, '', 0, NULL, '2025-02-11 03:58:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (3, 1, NULL, NULL, 'BASE COAT POLISH 1', '500', NULL, '', 0, NULL, '2025-02-11 04:08:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (4, 1, NULL, NULL, 'NAIL ART 1', '150', NULL, '', 0, NULL, '2025-02-11 04:10:45', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (5, 1, NULL, NULL, 'GEL POLISH 4 COLOURS', '500', NULL, '', 0, NULL, '2025-02-11 04:14:34', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (6, 1, NULL, NULL, 'BASE GEL 1 COLOUR', '500', NULL, '', 0, NULL, '2025-02-11 04:16:45', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (7, 1, NULL, NULL, 'TOP JEL 1 COLOUR', '500', NULL, '', 0, NULL, '2025-02-11 04:21:13', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (8, 1, NULL, NULL, 'PRIMER GEL 1', '500', NULL, '', 0, NULL, '2025-02-11 04:25:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (9, 1, NULL, NULL, 'NAIL ART BRUSHES 1 SET', '500', NULL, '', 0, NULL, '2025-02-11 04:26:17', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (10, 1, NULL, NULL, 'HENNAH 1 TUBE', '200', NULL, '', 0, NULL, '2025-02-11 04:26:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (11, 1, NULL, NULL, 'EAR DOTS 6 PCS', '600', NULL, '', 0, NULL, '2025-02-11 04:28:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (12, 1, NULL, NULL, 'NAIL TIPS 6 PCS', '600', NULL, '', 0, NULL, '2025-02-11 04:28:37', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (13, 1, NULL, NULL, 'WAX AND WAX STRIPS', '1500', NULL, '', 0, NULL, '2025-02-11 04:29:16', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (14, 1, NULL, NULL, 'APRICAT SCRUB 500 GMS', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:43:35', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (15, 1, NULL, NULL, 'ACETONE REMOVER 1L', '500', NULL, '', 0, NULL, '2025-02-11 04:44:35', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (16, 1, NULL, NULL, 'COTTON WOOL', '200', NULL, '', 0, NULL, '2025-02-11 04:45:10', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (17, 1, NULL, NULL, 'YDD NAIL GLUE', '400', NULL, '', 0, NULL, '2025-02-11 04:45:41', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (18, 1, NULL, NULL, 'NAIL FILE', '100', NULL, '', 0, NULL, '2025-02-11 04:46:05', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (19, 1, NULL, NULL, 'NAIL BUFFER', '100', NULL, '', 0, NULL, '2025-02-11 04:46:52', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (20, 1, NULL, NULL, 'HAIR FOOD', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:47:42', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (21, 1, NULL, NULL, 'STYLISHING GEL', '500GMS', NULL, '', 0, NULL, '2025-02-11 04:48:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (22, 1, NULL, NULL, 'BRAIDS', '5 SHORT', NULL, '', 0, NULL, '2025-02-11 04:49:25', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (23, 1, NULL, NULL, 'NEUTROLIZING SHAMPOO', '500ML', NULL, '', 0, NULL, '2025-02-11 04:50:24', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (24, 1, NULL, NULL, 'CHEMICAL RELAX', '500GM', NULL, '', 0, NULL, '2025-02-11 04:51:12', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (25, 1, NULL, NULL, 'ROLYS TREATMENT', '500ML', NULL, '', 0, NULL, '2025-02-11 04:52:16', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (26, 1, NULL, NULL, 'THREAD AND NEDDLE', '100', NULL, '', 0, NULL, '2025-02-11 04:57:06', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (27, 2, NULL, NULL, 'EXUK USB MOUSE', '10', NULL, '', 0, NULL, '2025-02-11 07:52:21', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (28, 2, NULL, NULL, 'EXUK USB KEYBOARDS', '10', NULL, '', 0, NULL, '2025-02-11 07:54:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (29, 2, NULL, NULL, 'POWER EXTENSION', '3', NULL, '', 0, NULL, '2025-02-11 07:56:50', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (30, 2, NULL, NULL, 'DUSTING MINI TOWELS', '10', NULL, '', 0, NULL, '2025-02-11 07:57:42', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (31, 2, NULL, NULL, 'WHITEBOARD', '1', NULL, '', 0, NULL, '2025-02-11 07:58:50', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (32, 2, NULL, NULL, 'RAM MEMORIES PC3 4GB', '10', NULL, '', 0, NULL, '2025-02-11 07:59:48', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (33, 2, NULL, NULL, 'LASERPOINTER PEN', '1', NULL, '', 0, NULL, '2025-02-11 08:00:31', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (34, 3, NULL, NULL, 'SOCKETS 2DOUBLE AND 3 SINGLE', '450', NULL, '', 0, NULL, '2025-02-11 08:13:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (35, 3, NULL, NULL, 'SWITCHES', '350', NULL, '', 0, NULL, '2025-02-11 08:14:12', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (36, 3, NULL, NULL, 'CABLE CLIPS', '150', NULL, '', 0, NULL, '2025-02-11 08:14:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (37, 3, NULL, NULL, 'TAPE', '150', NULL, '', 0, NULL, '2025-02-11 08:15:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (38, 3, NULL, NULL, 'MCB', '900', NULL, '', 0, NULL, '2025-02-11 08:15:24', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (39, 3, NULL, NULL, 'BULBS', '1000', NULL, '', 0, NULL, '2025-02-11 08:17:33', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (40, 3, NULL, NULL, 'BULBHOLDERS', '10PCS', NULL, '', 0, NULL, '2025-02-11 08:26:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (41, 3, NULL, NULL, 'PATRICES BOX 3DOUBLE AND 10 SINGLES', '13', NULL, '', 0, NULL, '2025-02-11 08:27:56', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (42, 3, NULL, NULL, 'PLIERS', '4', NULL, '', 0, NULL, '2025-02-11 08:28:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (43, 3, NULL, NULL, 'LONGNOSE', '2', NULL, '', 0, NULL, '2025-02-11 08:29:01', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (44, 3, NULL, NULL, 'SCREWDRIVER', '4', NULL, '', 0, NULL, '2025-02-11 08:29:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (45, 3, NULL, NULL, 'SPARE PHONES', '2', NULL, '', 0, NULL, '2025-02-11 08:30:22', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (46, 3, NULL, NULL, 'THINNER', '1', NULL, '', 0, NULL, '2025-02-11 08:31:03', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (47, 3, NULL, NULL, 'TESTER', '5', NULL, '', 0, NULL, '2025-02-11 08:31:23', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (48, 7, NULL, NULL, 'EPOXY STEEL GLUE', '2', NULL, '', 0, NULL, '2025-02-11 08:55:11', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (49, 7, NULL, NULL, 'ANTI VIBRATIONG GLOVES', '2', NULL, '', 0, NULL, '2025-02-11 08:55:49', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (50, 7, NULL, NULL, 'WORKSHOP SAFETY BOOTS', '1', NULL, '', 0, NULL, '2025-02-11 08:58:46', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (51, 7, NULL, NULL, 'HELMET(HARD HAT)', '1', NULL, '', 0, NULL, '2025-02-11 08:59:28', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (52, 4, NULL, NULL, 'DOUBLE JOINTS YT', '100', NULL, '', 0, NULL, '2025-02-12 00:07:54', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (53, 4, NULL, NULL, 'UNION', '100', NULL, '', 0, NULL, '2025-02-12 00:08:15', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (54, 4, NULL, NULL, 'ELBOW', '100', NULL, '', 0, NULL, '2025-02-12 00:08:33', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (55, 4, NULL, NULL, 'COLD WATER PPR PIPES', '350', NULL, '', 0, NULL, '2025-02-12 00:09:29', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (56, 4, NULL, NULL, 'G.I PIPE', '350', NULL, '', 0, NULL, '2025-02-12 00:13:04', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (57, 4, NULL, NULL, 'THREADED JOINTS', '100', NULL, '', 0, NULL, '2025-02-12 00:17:00', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (58, 5, NULL, NULL, 'TAPE MEASURE', '300', NULL, '', 0, NULL, '2025-02-12 00:38:11', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (59, 5, NULL, NULL, 'ROPES', '80', NULL, '', 0, NULL, '2025-02-12 00:38:51', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `creat